/*
 * Decompiled with CFR 0.152.
 */
package cn.anecansaitin.cameraanim.client.gui.screen;

import cn.anecansaitin.cameraanim.client.CameraAnimIdeCache;
import cn.anecansaitin.cameraanim.client.gui.screen.InterpolationSettingScreen;
import cn.anecansaitin.cameraanim.client.gui.widget.NumberEditBox;
import cn.anecansaitin.cameraanim.common.animation.CameraKeyframe;
import cn.anecansaitin.cameraanim.common.animation.GlobalCameraPath;
import cn.anecansaitin.cameraanim.common.animation.PathInterpolator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import org.joml.Vector3f;

public class PointSettingScreen
extends Screen {
    private final NumberEditBox[] numbers = new NumberEditBox[5];
    private CycleButton<PathInterpolator> type;
    private static final Component POS = Component.m_237115_((String)"gui.camera_anim.point_setting.pos");
    private static final Component ROT = Component.m_237115_((String)"gui.camera_anim.point_setting.rot");
    private static final Component ZOOM = Component.m_237115_((String)"gui.camera_anim.point_setting.zoom");
    private static final Component TIME = Component.m_237115_((String)"gui.camera_anim.point_setting.time");
    private static final Component SAVE = Component.m_237115_((String)"gui.camera_anim.point_setting.save");
    private static final Component TYPE = Component.m_237115_((String)"gui.camera_anim.point_setting.type");
    private static final Component POS_ERROR = Component.m_237115_((String)"gui.camera_anim.point_setting.pos_error");
    private static final Component ROT_ERROR = Component.m_237115_((String)"gui.camera_anim.point_setting.rot_error");
    private static final Component ZOOM_ERROR = Component.m_237115_((String)"gui.camera_anim.point_setting.zoom_error");
    private static final Component TIME_ERROR = Component.m_237115_((String)"gui.camera_anim.point_setting.time_error");
    private static final Component TIP = Component.m_237115_((String)"gui.camera_anim.point_setting.tip");
    private static final Component INTERPOLATION = Component.m_237115_((String)"gui.camera_anim.point_setting.interpolation");

    public PointSettingScreen() {
        super((Component)Component.m_237113_((String)"Point Setting"));
    }

    protected void m_7856_() {
        CameraAnimIdeCache.SelectedPoint selectedPoint = CameraAnimIdeCache.getSelectedPoint();
        GlobalCameraPath track = CameraAnimIdeCache.getPath();
        int time = selectedPoint.getPointTime();
        Vector3f pos = selectedPoint.getPosition();
        if (pos == null) {
            return;
        }
        int x = 20;
        int y = 20;
        this.m_169394_((Renderable)new StringWidget(x + 1, y + 2, 30, 10, POS, this.f_96547_));
        NumberEditBox[] xyz = new NumberEditBox[]{new NumberEditBox(this.f_96547_, x + 37, y + 2, 50, 10, pos.x, (Component)Component.m_237113_((String)"x")), new NumberEditBox(this.f_96547_, x + 92, y + 2, 50, 10, pos.y, (Component)Component.m_237113_((String)"y")), new NumberEditBox(this.f_96547_, x + 147, y + 2, 50, 10, pos.z, (Component)Component.m_237113_((String)"z"))};
        this.m_142416_((GuiEventListener)xyz[0]);
        this.m_142416_((GuiEventListener)xyz[1]);
        this.m_142416_((GuiEventListener)xyz[2]);
        if (selectedPoint.getControl() == CameraAnimIdeCache.ControlType.NONE) {
            this.m_142416_((GuiEventListener)new ExtendedButton(x + 202, y + 2, 90, 10, INTERPOLATION, b -> Minecraft.m_91087_().pushGuiLayer((Screen)new InterpolationSettingScreen(1))));
            CameraKeyframe point = track.getPoint(time);
            assert (point != null);
            float fov = point.getFov();
            Vector3f rot = point.getRot();
            this.m_169394_((Renderable)new StringWidget(x + 1, y + 2 + 10, 30, 10, ROT, this.f_96547_));
            this.numbers[0] = new NumberEditBox(this.f_96547_, x + 37, y + 2 + 10, 50, 10, rot.x, (Component)Component.m_237113_((String)"xRot"));
            this.m_142416_((GuiEventListener)this.numbers[0]);
            this.numbers[1] = new NumberEditBox(this.f_96547_, x + 92, y + 2 + 10, 50, 10, rot.y, (Component)Component.m_237113_((String)"yRot"));
            this.m_142416_((GuiEventListener)this.numbers[1]);
            this.numbers[2] = new NumberEditBox(this.f_96547_, x + 147, y + 2 + 10, 50, 10, rot.z, (Component)Component.m_237113_((String)"zRot"));
            this.m_142416_((GuiEventListener)this.numbers[2]);
            this.m_142416_((GuiEventListener)new ExtendedButton(x + 202, y + 2 + 10, 90, 10, INTERPOLATION, b -> Minecraft.m_91087_().pushGuiLayer((Screen)new InterpolationSettingScreen(2))));
            this.m_169394_((Renderable)new StringWidget(x + 1, y + 2 + 10 + 10, 30, 10, ZOOM, this.f_96547_));
            this.numbers[3] = new NumberEditBox(this.f_96547_, x + 37, y + 2 + 10 + 10, 50, 10, fov, (Component)Component.m_237113_((String)"zoom"));
            this.m_142416_((GuiEventListener)this.numbers[3]);
            this.m_142416_((GuiEventListener)new ExtendedButton(x + 92, y + 2 + 10 + 10, 90, 10, INTERPOLATION, b -> Minecraft.m_91087_().pushGuiLayer((Screen)new InterpolationSettingScreen(3))));
            this.type = CycleButton.m_168894_(PathInterpolator::getDisplayName).m_168961_((Object[])PathInterpolator.values()).m_168948_((Object)point.getPathInterpolator()).m_168936_(x + 37, y + 2 + 10 + 10 + 10, 65, 11, TYPE, (b, t) -> {});
            this.m_142416_((GuiEventListener)this.type);
            this.m_169394_((Renderable)new StringWidget(x + 1, y + 2 + 10 + 10 + 10 + 11, 30, 10, TIME, this.f_96547_));
            this.numbers[4] = new NumberEditBox(this.f_96547_, x + 37, y + 2 + 10 + 10 + 10 + 11, 50, 10, time, (Component)Component.m_237113_((String)"time"));
            this.m_142416_((GuiEventListener)this.numbers[4]);
        }
        StringWidget info = new StringWidget(x + 1, y + 2 + 10 + 10 + 40, 100, 10, (Component)Component.m_237113_((String)""), this.f_96547_);
        this.m_169394_((Renderable)info);
        this.m_169394_((Renderable)new StringWidget(x, y + 2 + 10 + 10 + 60, 300, 10, TIP, this.f_96547_));
        Button button = Button.m_253074_((Component)SAVE, b -> {
            float zn;
            float yn;
            float xn;
            try {
                xn = Float.parseFloat(xyz[0].m_94155_());
                yn = Float.parseFloat(xyz[1].m_94155_());
                zn = Float.parseFloat(xyz[2].m_94155_());
            }
            catch (NumberFormatException e) {
                info.m_93666_(POS_ERROR);
                return;
            }
            switch (selectedPoint.getControl()) {
                case LEFT: 
                case RIGHT: {
                    pos.set(xn, yn, zn);
                    this.m_7379_();
                    break;
                }
                case NONE: {
                    CameraKeyframe point = track.getPoint(time);
                    assert (point != null);
                    pos.set(xn, yn, zn);
                    try {
                        float xRot = Float.parseFloat(this.numbers[0].m_94155_());
                        float yRot = Float.parseFloat(this.numbers[1].m_94155_());
                        float zRot = Float.parseFloat(this.numbers[2].m_94155_());
                        point.getRot().set(xRot, yRot, zRot);
                    }
                    catch (NumberFormatException e) {
                        info.m_93666_(ROT_ERROR);
                        return;
                    }
                    try {
                        point.setFov(Float.parseFloat(this.numbers[3].m_94155_()));
                    }
                    catch (NumberFormatException e) {
                        info.m_93666_(ZOOM_ERROR);
                        return;
                    }
                    if (point.getPathInterpolator() != this.type.m_168883_()) {
                        point.setPathInterpolator((PathInterpolator)((Object)((Object)this.type.m_168883_())));
                        track.updateBezier(time);
                    }
                    try {
                        int newTime = Integer.parseInt(this.numbers[4].m_94155_());
                        track.setTime(time, newTime);
                        this.m_7379_();
                        break;
                    }
                    catch (NumberFormatException e) {
                        info.m_93666_(TIME_ERROR);
                    }
                }
            }
        }).m_252794_(x + 202, y + 30).m_252780_(50).m_253136_();
        this.m_142416_((GuiEventListener)button);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        int x = 20;
        int y = 20;
        guiGraphics.m_280656_(x, x + 300, y, -6954541);
        guiGraphics.m_280656_(x, x + 300, y + 54, -6954541);
        guiGraphics.m_280315_(x + 300, y, y + 54, -6954541);
        guiGraphics.m_280315_(x, y, y + 54, -6954541);
    }
}

