/*
 * Decompiled with CFR 0.152.
 */
package cn.anecansaitin.cameraanim.client.gui.screen;

import cn.anecansaitin.cameraanim.client.CameraAnimIdeCache;
import cn.anecansaitin.cameraanim.client.gui.screen.LocalPathSearchScreen;
import cn.anecansaitin.cameraanim.client.gui.widget.NumberEditBox;
import cn.anecansaitin.cameraanim.client.network.ClientPayloadSender;
import cn.anecansaitin.cameraanim.common.animation.GlobalCameraPath;
import cn.anecansaitin.cameraanim.common.data_entity.GlobalCameraPathInfo;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import oshi.util.tuples.Triplet;

public class RemotePathSearchScreen
extends Screen {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
    private static final ZoneId ZONE_ID = ZoneId.systemDefault();
    private static final Component PAGE = Component.m_237115_((String)"gui.camera_anim.remote_path_search.page");
    private static final Component SEARCH = Component.m_237115_((String)"gui.camera_anim.remote_path_search.search");
    private static final Component LOAD = Component.m_237115_((String)"gui.camera_anim.remote_path_search.load");
    private static final Component LOAD_ID = Component.m_237115_((String)"gui.camera_anim.remote_path_search.load_id");
    private static final Component SAVE = Component.m_237115_((String)"gui.camera_anim.remote_path_search.save");
    private static final Component SAVE_ID = Component.m_237115_((String)"gui.camera_anim.remote_path_search.save_id");
    private static final Component DELETE = Component.m_237115_((String)"gui.camera_anim.remote_path_search.delete");
    private static final Component DELETE_ID = Component.m_237115_((String)"gui.camera_anim.remote_path_search.delete_id");
    private static final Component LOCAL_MODE = Component.m_237115_((String)"gui.camera_anim.remote_path_search.local_mode");
    private static final Component PATH_ID = Component.m_237115_((String)"gui.camera_anim.remote_path_search.path_id");
    private static final Component MODIFIER = Component.m_237115_((String)"gui.camera_anim.remote_path_search.modifier");
    private static final Component TIME = Component.m_237115_((String)"gui.camera_anim.remote_path_search.time");
    private static final Component NO_SERVER = Component.m_237115_((String)"gui.camera_anim.remote_path_search.no_server");
    private static final Component TIP = Component.m_237115_((String)"gui.camera_anim.remote_path_search.tip");
    public static boolean REMOTE;
    private final List<Triplet<Component, Component, Component>> list = new ArrayList<Triplet<Component, Component, Component>>();

    public RemotePathSearchScreen() {
        super((Component)Component.m_237113_((String)"remote path search"));
    }

    protected void m_7856_() {
        NumberEditBox page = (NumberEditBox)this.m_142416_((GuiEventListener)new NumberEditBox(this.f_96547_, 20, 20, 20, 20, 1, (Component)Component.m_237113_((String)"page")));
        EditBox path = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, 205, 20, 50, 20, (Component)Component.m_237113_((String)"path id")));
        EditBox newId = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, 315, 20, 50, 20, (Component)Component.m_237113_((String)"new id")));
        EditBox removeId = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, 315, 60, 50, 20, (Component)Component.m_237113_((String)"remove id")));
        newId.m_94144_(CameraAnimIdeCache.getPath().getId());
        this.m_142416_((GuiEventListener)new ExtendedButton(45, 20, 100, 20, SEARCH, b -> {
            if (REMOTE) {
                ClientPayloadSender.checkGlobalPath(Integer.parseInt(page.m_94155_()), 16);
            }
        }));
        this.m_142416_((GuiEventListener)new ExtendedButton(150, 20, 50, 20, LOAD, b -> {
            if (REMOTE) {
                ClientPayloadSender.getGlobalPath(path.m_94155_(), 0);
            }
        }));
        this.m_142416_((GuiEventListener)new ExtendedButton(260, 20, 50, 20, SAVE, b -> {
            if (REMOTE) {
                GlobalCameraPath track = CameraAnimIdeCache.getPath();
                if (!track.getId().equals(newId.m_94155_())) {
                    track = track.resetID(newId.m_94155_());
                }
                if (track.isNativeMode()) {
                    track = track.toNative(CameraAnimIdeCache.getNativePos(), CameraAnimIdeCache.getNativeRot().y);
                }
                ClientPayloadSender.putGlobalPath(track);
            }
        }));
        this.m_142416_((GuiEventListener)new ExtendedButton(260, 60, 50, 20, DELETE, b -> {
            if (REMOTE) {
                ClientPayloadSender.removeGlobalPath(removeId.m_94155_());
            }
        }));
        this.m_142416_((GuiEventListener)new ExtendedButton(260, 80, 70, 20, LOCAL_MODE, b -> Minecraft.m_91087_().m_91152_((Screen)new LocalPathSearchScreen())));
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280430_(this.f_96547_, PAGE, 25, 10, -1);
        guiGraphics.m_280430_(this.f_96547_, LOAD_ID, 215, 10, -1);
        guiGraphics.m_280430_(this.f_96547_, SAVE_ID, 325, 10, -1);
        guiGraphics.m_280430_(this.f_96547_, DELETE_ID, 325, 50, -1);
        guiGraphics.m_280430_(this.f_96547_, PATH_ID, 20, 49, -1);
        guiGraphics.m_280430_(this.f_96547_, MODIFIER, 60, 49, -1);
        guiGraphics.m_280430_(this.f_96547_, TIME, 100, 49, -1);
        if (!this.list.isEmpty()) {
            int listSize = this.list.size();
            for (int i = 0; i < listSize; ++i) {
                Triplet<Component, Component, Component> info = this.list.get(i);
                guiGraphics.m_280430_(this.f_96547_, (Component)info.getA(), 20, 60 + i * 11, -1);
                guiGraphics.m_280430_(this.f_96547_, (Component)info.getB(), 60, 60 + i * 11, -1);
                guiGraphics.m_280430_(this.f_96547_, (Component)info.getC(), 100, 60 + i * 11, -1);
            }
        } else {
            guiGraphics.m_280653_(this.f_96547_, TIP, 180, 200, -1);
        }
        if (!REMOTE) {
            guiGraphics.m_280653_(this.f_96547_, NO_SERVER, 100, 100, -2026476);
        }
    }

    public void setInfo(List<GlobalCameraPathInfo> list) {
        this.list.clear();
        for (GlobalCameraPathInfo info : list) {
            MutableComponent id = Component.m_237113_((String)info.id());
            Player player = Minecraft.m_91087_().f_91073_.m_46003_(info.lastModifier());
            Object playerName = player == null ? Component.m_237113_((String)"\u672a\u77e5") : player.m_5446_();
            LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(info.version()), ZONE_ID);
            MutableComponent time = Component.m_237113_((String)FORMATTER.format(localDateTime));
            this.list.add((Triplet<Component, Component, Component>)new Triplet((Object)id, playerName, (Object)time));
        }
    }
}

