/*
 * Decompiled with CFR 0.152.
 */
package cn.anecansaitin.cameraanim.client.listener;

import cn.anecansaitin.cameraanim.InterpolationMath;
import cn.anecansaitin.cameraanim.client.Animator;
import cn.anecansaitin.cameraanim.client.CameraAnimIdeCache;
import cn.anecansaitin.cameraanim.client.ClientUtil;
import cn.anecansaitin.cameraanim.client.PreviewAnimator;
import cn.anecansaitin.cameraanim.common.animation.CameraKeyframe;
import cn.anecansaitin.cameraanim.common.animation.GlobalCameraPath;
import cn.anecansaitin.cameraanim.common.animation.PathInterpolator;
import cn.anecansaitin.cameraanim.common.animation.Vec3BezierController;
import cn.anecansaitin.freecameraapi.CameraModifierManager;
import cn.anecansaitin.freecameraapi.ICameraModifier;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Mod.EventBusSubscriber(modid="camera_anim", value={Dist.CLIENT})
public class OnLevelRender {
    private static final int X_COLOR = -60862;
    private static final int Y_COLOR = -14226363;
    private static final int Z_COLOR = -16214803;
    private static final int X_COLOR_TRANSPARENT = 2147422786;
    private static final int Y_COLOR_TRANSPARENT = 2133257285;
    private static final int Z_COLOR_TRANSPARENT = 2131268845;
    private static final int SELECTED_COLOR = -12676865;
    private static final int SELECTED_COLOR_TRANSPARENT = 2134806783;
    private static final Vector3f V_CACHE_1 = new Vector3f();
    private static final Vector3f V_CACHE_2 = new Vector3f();
    private static final Vector3f V_CACHE_3 = new Vector3f();
    private static final Vector3f V_CACHE_4 = new Vector3f();
    private static final Vector3f V_CACHE_5 = new Vector3f();
    private static final Vector3f V_CACHE_6 = new Vector3f();
    private static final Vector3f V_CACHE_7 = new Vector3f();
    private static final Vector3f CAMERA_CACHE = new Vector3f();
    private static final Quaternionf Q_CACHE = new Quaternionf();
    private static final ICameraModifier IDE_MODIFIER = CameraModifierManager.createModifier((String)"camera_anim_ide", (boolean)false).enableFov().enablePos().enableRotation().enableGlobalMode();
    private static final Vector3f IDE_POS = new Vector3f();
    private static final Vector3f IDE_ROT = new Vector3f();
    private static final float[] IDE_FOV = new float[1];
    private static final ICameraModifier PLAYER_MODIFIER = CameraModifierManager.createModifier((String)"camera_anim_player", (boolean)true).enableFov().enablePos().enableRotation().enableGlobalMode();
    private static final Vector3f PLAYER_POS = new Vector3f();
    private static final Vector3f PLAYER_ROT = new Vector3f();
    private static final float[] PLAYER_FOV = new float[1];

    @SubscribeEvent
    public static void onRender(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            return;
        }
        OnLevelRender.setupPlayerCamera();
        OnLevelRender.renderCameraAnimIde(event);
    }

    private static void renderCameraAnimIde(RenderLevelStageEvent event) {
        if (Animator.INSTANCE.isPlaying()) {
            return;
        }
        if ((CameraAnimIdeCache.VIEW || CameraAnimIdeCache.EDIT) && !CameraAnimIdeCache.getPath().getPoints().isEmpty()) {
            if (!ClientUtil.gamePaused()) {
                OnLevelRender.setupCameraAnimIdeCamera();
            }
            if (!ClientUtil.hideGui()) {
                OnLevelRender.renderCameraAnimIdePath(event);
            }
        }
    }

    private static void renderCameraAnimIdePath(RenderLevelStageEvent event) {
        CameraAnimIdeCache.tick();
        PoseStack poseStack = event.getPoseStack();
        PoseStack.Pose last = poseStack.m_85850_();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.enableDepthTest();
        Vec3 p = event.getCamera().m_90583_();
        CAMERA_CACHE.set(p.f_82479_, p.f_82480_, p.f_82481_);
        CameraAnimIdeCache.SelectedPoint selected = CameraAnimIdeCache.getSelectedPoint();
        OnLevelRender.renderLines(selected, bufferSource, last);
        OnLevelRender.renderFilledBox(selected, bufferSource, last);
        OnLevelRender.renderQuads(selected, bufferSource, last);
        RenderSystem.disableDepthTest();
    }

    private static void setupCameraAnimIdeCamera() {
        PreviewAnimator animator = PreviewAnimator.INSTANCE;
        if (!CameraAnimIdeCache.PREVIEW) {
            IDE_MODIFIER.disable();
            return;
        }
        if (!animator.prepareCameraInfo(IDE_POS, IDE_ROT, IDE_FOV)) {
            return;
        }
        IDE_MODIFIER.enable().setPos((double)OnLevelRender.IDE_POS.x, (double)OnLevelRender.IDE_POS.y, (double)OnLevelRender.IDE_POS.z).setRotationYXZ(IDE_ROT).setFov((double)IDE_FOV[0]);
    }

    private static void setupPlayerCamera() {
        Animator animator = Animator.INSTANCE;
        if (!animator.isPlaying()) {
            PLAYER_MODIFIER.disable();
            return;
        }
        if (!animator.prepareCameraInfo(PLAYER_POS, PLAYER_ROT, PLAYER_FOV)) {
            PLAYER_MODIFIER.disable();
            return;
        }
        PLAYER_MODIFIER.enable().setPos((double)OnLevelRender.PLAYER_POS.x, (double)OnLevelRender.PLAYER_POS.y, (double)OnLevelRender.PLAYER_POS.z).setRotationYXZ(PLAYER_ROT).setFov((double)PLAYER_FOV[0]);
    }

    private static void renderLines(CameraAnimIdeCache.SelectedPoint selected, MultiBufferSource.BufferSource bufferSource, PoseStack.Pose pose) {
        VertexConsumer buffer = bufferSource.m_6299_((RenderType)RenderType.f_110371_);
        OnLevelRender.renderTrackLine(selected, buffer, pose);
        OnLevelRender.renderBezierLine(selected, buffer, pose);
        switch (CameraAnimIdeCache.getMode()) {
            case MOVE: {
                OnLevelRender.renderMoveLine(selected, buffer, pose);
            }
        }
        OnLevelRender.renderCamera(pose, buffer);
        OnLevelRender.renderNativeCenter(pose, buffer);
        bufferSource.m_109912_((RenderType)RenderType.f_110371_);
    }

    private static void renderNativeCenter(PoseStack.Pose pose, VertexConsumer buffer) {
        if (CameraAnimIdeCache.getPath().isNativeMode()) {
            OnLevelRender.addLine(buffer, pose, CameraAnimIdeCache.getNativePos().add(0.5f, 0.1f, 0.5f, V_CACHE_3).sub((Vector3fc)CAMERA_CACHE), CameraAnimIdeCache.getNativePos().add(-0.5f, 0.1f, 0.5f, V_CACHE_2).sub((Vector3fc)CAMERA_CACHE), -1611929);
            OnLevelRender.addLine(buffer, pose, CameraAnimIdeCache.getNativePos().add(-0.5f, 0.1f, 0.5f, V_CACHE_3).sub((Vector3fc)CAMERA_CACHE), CameraAnimIdeCache.getNativePos().add(-0.5f, 0.1f, -0.5f, V_CACHE_2).sub((Vector3fc)CAMERA_CACHE), -1611929);
            OnLevelRender.addLine(buffer, pose, CameraAnimIdeCache.getNativePos().add(-0.5f, 0.1f, -0.5f, V_CACHE_3).sub((Vector3fc)CAMERA_CACHE), CameraAnimIdeCache.getNativePos().add(0.5f, 0.1f, -0.5f, V_CACHE_2).sub((Vector3fc)CAMERA_CACHE), -1611929);
            OnLevelRender.addLine(buffer, pose, CameraAnimIdeCache.getNativePos().add(0.5f, 0.1f, -0.5f, V_CACHE_3).sub((Vector3fc)CAMERA_CACHE), CameraAnimIdeCache.getNativePos().add(0.5f, 0.1f, 0.5f, V_CACHE_2).sub((Vector3fc)CAMERA_CACHE), -1611929);
            OnLevelRender.addLine(buffer, pose, CameraAnimIdeCache.getNativePos().add(0.5f, 0.1f, 0.5f, V_CACHE_3).sub((Vector3fc)CAMERA_CACHE), CameraAnimIdeCache.getNativePos().add(-0.5f, 0.1f, -0.5f, V_CACHE_2).sub((Vector3fc)CAMERA_CACHE), -1611929);
            OnLevelRender.addLine(buffer, pose, CameraAnimIdeCache.getNativePos().add(0.5f, 0.1f, -0.5f, V_CACHE_3).sub((Vector3fc)CAMERA_CACHE), CameraAnimIdeCache.getNativePos().add(-0.5f, 0.1f, 0.5f, V_CACHE_2).sub((Vector3fc)CAMERA_CACHE), -1611929);
            Vector3f rot = V_CACHE_4.set(0.0f, 0.1f, -2.0f).rotateY((180.0f - CameraAnimIdeCache.getNativeRot().y) * ((float)Math.PI / 180));
            OnLevelRender.addLine(buffer, pose, CameraAnimIdeCache.getNativePos().add(0.0f, 0.1f, 0.0f, V_CACHE_3).sub((Vector3fc)CAMERA_CACHE), CameraAnimIdeCache.getNativePos().add((Vector3fc)rot, V_CACHE_2).sub((Vector3fc)CAMERA_CACHE), -16711936);
        }
    }

    private static void renderCamera(PoseStack.Pose pose, VertexConsumer buffer) {
        PreviewAnimator animator = PreviewAnimator.INSTANCE;
        Q_CACHE.set(0.0f, 0.0f, 0.0f, 1.0f).rotationYXZ(OnLevelRender.IDE_ROT.y, OnLevelRender.IDE_ROT.x, OnLevelRender.IDE_ROT.z);
        if (!CameraAnimIdeCache.PREVIEW && animator.prepareCameraInfo(IDE_POS, IDE_ROT, IDE_FOV)) {
            OnLevelRender.IDE_ROT.y *= -1.0f;
            IDE_ROT.mul((float)Math.PI / 180);
            OnLevelRender.addLine(buffer, pose, V_CACHE_1.set(-0.15f, -0.1f, -0.1f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), V_CACHE_2.set(0.15f, -0.1f, -0.1f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), -16777216);
            OnLevelRender.addLine(buffer, pose, V_CACHE_1.set(-0.15f, -0.1f, 0.0f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), V_CACHE_2.set(0.15f, -0.1f, 0.0f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), -16777216);
            OnLevelRender.addLine(buffer, pose, V_CACHE_1.set(-0.15f, -0.1f, -0.1f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), V_CACHE_2.set(-0.15f, -0.1f, 0.0f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), -16777216);
            OnLevelRender.addLine(buffer, pose, V_CACHE_1.set(0.15f, -0.1f, -0.1f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), V_CACHE_2.set(0.15f, -0.1f, 0.0f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), -16777216);
            OnLevelRender.addLine(buffer, pose, V_CACHE_1.set(-0.15f, 0.1f, -0.1f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), V_CACHE_2.set(0.15f, 0.1f, -0.1f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), -16777216);
            OnLevelRender.addLine(buffer, pose, V_CACHE_1.set(-0.15f, 0.1f, 0.0f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), V_CACHE_2.set(0.15f, 0.1f, 0.0f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), -16777216);
            OnLevelRender.addLine(buffer, pose, V_CACHE_1.set(-0.15f, 0.1f, -0.1f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), V_CACHE_2.set(-0.15f, 0.1f, 0.0f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), -16777216);
            OnLevelRender.addLine(buffer, pose, V_CACHE_1.set(0.15f, 0.1f, -0.1f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), V_CACHE_2.set(0.15f, 0.1f, 0.0f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), -16777216);
            OnLevelRender.addLine(buffer, pose, V_CACHE_1.set(0.15f, -0.1f, -0.1f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), V_CACHE_2.set(0.15f, 0.1f, -0.1f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), -16777216);
            OnLevelRender.addLine(buffer, pose, V_CACHE_1.set(-0.15f, -0.1f, -0.1f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), V_CACHE_2.set(-0.15f, 0.1f, -0.1f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), -16777216);
            OnLevelRender.addLine(buffer, pose, V_CACHE_1.set(-0.15f, -0.1f, 0.0f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), V_CACHE_2.set(-0.15f, 0.1f, 0.0f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), -16777216);
            OnLevelRender.addLine(buffer, pose, V_CACHE_1.set(0.15f, -0.1f, 0.0f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), V_CACHE_2.set(0.15f, 0.1f, 0.0f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), -16777216);
            OnLevelRender.addLine(buffer, pose, V_CACHE_1.set(0.5f, 0.28125f, 0.3f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), V_CACHE_2.set(-0.5f, 0.28125f, 0.3f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), -16777216);
            OnLevelRender.addLine(buffer, pose, V_CACHE_1.set(-0.5f, -0.28125f, 0.3f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), V_CACHE_2.set(-0.5f, 0.28125f, 0.3f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), -16777216);
            OnLevelRender.addLine(buffer, pose, V_CACHE_1.set(0.5f, -0.28125f, 0.3f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), V_CACHE_2.set(0.5f, 0.28125f, 0.3f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), -16777216);
            OnLevelRender.addLine(buffer, pose, V_CACHE_1.set(0.5f, -0.28125f, 0.3f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), V_CACHE_2.set(-0.5f, -0.28125f, 0.3f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), -16777216);
            OnLevelRender.addLine(buffer, pose, V_CACHE_1.set(0.5f, 0.28125f, 0.3f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), V_CACHE_2.set(0.15f, 0.1f, 0.0f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), -16777216);
            OnLevelRender.addLine(buffer, pose, V_CACHE_1.set(0.5f, -0.28125f, 0.3f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), V_CACHE_2.set(0.15f, -0.1f, 0.0f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), -16777216);
            OnLevelRender.addLine(buffer, pose, V_CACHE_1.set(-0.5f, 0.28125f, 0.3f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), V_CACHE_2.set(-0.15f, 0.1f, 0.0f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), -16777216);
            OnLevelRender.addLine(buffer, pose, V_CACHE_1.set(-0.5f, -0.28125f, 0.3f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), V_CACHE_2.set(-0.15f, -0.1f, 0.0f).rotate((Quaternionfc)Q_CACHE).add((Vector3fc)IDE_POS).sub((Vector3fc)CAMERA_CACHE), -16777216);
        }
    }

    private static void renderTrackLine(CameraAnimIdeCache.SelectedPoint selected, VertexConsumer buffer, PoseStack.Pose last) {
        GlobalCameraPath track = CameraAnimIdeCache.getPath();
        ArrayList<CameraKeyframe> points = track.getPoints();
        if (points.size() < 2) {
            return;
        }
        int c = points.size();
        block6: for (int i = 1; i < c; ++i) {
            CameraKeyframe p1 = points.get(i - 1);
            CameraKeyframe p2 = points.get(i);
            Vector3f v1 = V_CACHE_1.set((Vector3fc)p1.getPos()).sub((Vector3fc)CAMERA_CACHE);
            Vector3f v2 = V_CACHE_2.set((Vector3fc)p2.getPos()).sub((Vector3fc)CAMERA_CACHE);
            switch (p2.getPathInterpolator()) {
                case LINEAR: {
                    OnLevelRender.addLine(buffer, last, v1, v2, -1);
                    continue block6;
                }
                case SMOOTH: {
                    Vector3f v3;
                    Vector3f v0;
                    CameraKeyframe p;
                    if (i > 1) {
                        p = points.get(i - 2);
                        v0 = V_CACHE_3.set((Vector3fc)p.getPos()).sub((Vector3fc)CAMERA_CACHE);
                    } else {
                        v0 = v1;
                    }
                    if (i < c - 1) {
                        p = points.get(i + 1);
                        v3 = V_CACHE_4.set((Vector3fc)p.getPos()).sub((Vector3fc)CAMERA_CACHE);
                    } else {
                        v3 = v2;
                    }
                    OnLevelRender.addSmoothLine(buffer, last, v0, v1, v2, v3, -1);
                    continue block6;
                }
                case BEZIER: {
                    Vec3BezierController controller = p2.getPathBezier();
                    OnLevelRender.addBezierLine(buffer, last, v1, V_CACHE_3.set((Vector3fc)controller.getLeft()).sub((Vector3fc)CAMERA_CACHE), V_CACHE_4.set((Vector3fc)controller.getRight()).sub((Vector3fc)CAMERA_CACHE), v2, -1);
                    continue block6;
                }
                case STEP: {
                    OnLevelRender.addLine(buffer, last, v1, v2, -8421505);
                }
            }
        }
    }

    private static void renderMoveLine(CameraAnimIdeCache.SelectedPoint selected, VertexConsumer buffer, PoseStack.Pose last) {
        int selectedTime = selected.getPointTime();
        if (selectedTime < 0) {
            return;
        }
        Vector3f p = selected.getPosition();
        if (p == null) {
            return;
        }
        Vector3f pos = V_CACHE_1.set((Vector3fc)p);
        pos.sub((Vector3fc)CAMERA_CACHE);
        int xColor = -60862;
        int yColor = -14226363;
        int zColor = -16214803;
        switch (CameraAnimIdeCache.getMoveMode().getMoveType()) {
            case X: {
                xColor = -12676865;
                break;
            }
            case Y: {
                yColor = -12676865;
                break;
            }
            case Z: {
                zColor = -12676865;
            }
        }
        Vector3f axis = V_CACHE_2.set((Vector3fc)pos).add(1.0f, 0.0f, 0.0f);
        OnLevelRender.addLine(buffer, last, pos, axis, xColor);
        axis.add(-1.0f, 1.0f, 0.0f);
        OnLevelRender.addLine(buffer, last, pos, axis, yColor);
        axis.add(0.0f, -1.0f, 1.0f);
        OnLevelRender.addLine(buffer, last, pos, axis, zColor);
    }

    private static void renderBezierLine(CameraAnimIdeCache.SelectedPoint selected, VertexConsumer buffer, PoseStack.Pose last) {
        int selectedTime = selected.getPointTime();
        GlobalCameraPath track = CameraAnimIdeCache.getPath();
        if (selectedTime <= 0) {
            return;
        }
        CameraKeyframe selectedPoint = track.getPoint(selectedTime);
        if (selectedPoint == null || selectedPoint.getPathInterpolator() != PathInterpolator.BEZIER) {
            return;
        }
        Vec3BezierController controller = selectedPoint.getPathBezier();
        Vector3f selectedPos = V_CACHE_1.set((Vector3fc)selectedPoint.getPos()).sub((Vector3fc)CAMERA_CACHE);
        Vector3f right = V_CACHE_2.set((Vector3fc)controller.getRight()).sub((Vector3fc)CAMERA_CACHE);
        OnLevelRender.addLine(buffer, last, selectedPos, right, 2140732312);
        CameraKeyframe pre = track.getPrePoint(selectedTime);
        if (pre == null) {
            return;
        }
        Vector3f prePos = V_CACHE_1.set((Vector3fc)pre.getPos()).sub((Vector3fc)CAMERA_CACHE);
        Vector3f left = V_CACHE_2.set((Vector3fc)controller.getLeft()).sub((Vector3fc)CAMERA_CACHE);
        OnLevelRender.addLine(buffer, last, prePos, left, 2140732312);
    }

    private static void renderFilledBox(CameraAnimIdeCache.SelectedPoint selected, MultiBufferSource.BufferSource bufferSource, PoseStack.Pose last) {
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_269313_());
        OnLevelRender.renderPoint(buffer, last);
        OnLevelRender.renderBezierPoint(selected, buffer, last);
        OnLevelRender.renderSelectedPoint(selected, buffer, last);
        switch (CameraAnimIdeCache.getMode()) {
            case MOVE: {
                OnLevelRender.renderArrowhead(selected, buffer, last);
            }
        }
        bufferSource.m_109912_(RenderType.m_269313_());
    }

    private static void renderPoint(VertexConsumer buffer, PoseStack.Pose last) {
        GlobalCameraPath track = CameraAnimIdeCache.getPath();
        for (CameraKeyframe point : track.getPoints()) {
            OnLevelRender.addPoint(buffer, last, V_CACHE_1.set((Vector3fc)point.getPos()).sub((Vector3fc)CAMERA_CACHE), 0.1f, -16777216);
        }
    }

    private static void renderBezierPoint(CameraAnimIdeCache.SelectedPoint selected, VertexConsumer buffer, PoseStack.Pose last) {
        int selectedTime = selected.getPointTime();
        if (selectedTime < 1) {
            return;
        }
        GlobalCameraPath track = CameraAnimIdeCache.getPath();
        CameraKeyframe selectedPoint = track.getPoint(selectedTime);
        if (selectedPoint == null || selectedPoint.getPathInterpolator() != PathInterpolator.BEZIER) {
            return;
        }
        CameraKeyframe prePoint = track.getPrePoint(selectedTime);
        if (prePoint == null) {
            return;
        }
        Vec3BezierController controller = selectedPoint.getPathBezier();
        OnLevelRender.addPoint(buffer, last, V_CACHE_1.set((Vector3fc)controller.getLeft()).sub((Vector3fc)CAMERA_CACHE), 0.05f, 2140732312);
        OnLevelRender.addPoint(buffer, last, V_CACHE_1.set((Vector3fc)controller.getRight()).sub((Vector3fc)CAMERA_CACHE), 0.05f, 2140732312);
    }

    private static void renderSelectedPoint(CameraAnimIdeCache.SelectedPoint selected, VertexConsumer buffer, PoseStack.Pose last) {
        Vector3f pos = selected.getPosition();
        if (pos == null) {
            return;
        }
        switch (selected.getControl()) {
            case LEFT: 
            case RIGHT: {
                OnLevelRender.addPoint(buffer, last, V_CACHE_1.set((Vector3fc)pos).sub((Vector3fc)CAMERA_CACHE), 0.07f, 2134806783);
                break;
            }
            case NONE: {
                OnLevelRender.addPoint(buffer, last, V_CACHE_1.set((Vector3fc)pos).sub((Vector3fc)CAMERA_CACHE), 0.12f, 2134806783);
            }
        }
    }

    private static void renderArrowhead(CameraAnimIdeCache.SelectedPoint selected, VertexConsumer buffer, PoseStack.Pose last) {
        Vector3f pos = selected.getPosition();
        if (pos == null) {
            return;
        }
        pos = V_CACHE_1.set((Vector3fc)pos).sub((Vector3fc)CAMERA_CACHE);
        int xColor = -60862;
        int yColor = -14226363;
        int zColor = -16214803;
        switch (CameraAnimIdeCache.getMoveMode().getMoveType()) {
            case X: {
                xColor = -12676865;
                break;
            }
            case Y: {
                yColor = -12676865;
                break;
            }
            case Z: {
                zColor = -12676865;
            }
        }
        OnLevelRender.addArrowhead(buffer, last, pos, xColor, yColor, zColor);
    }

    private static void renderQuads(CameraAnimIdeCache.SelectedPoint selected, MultiBufferSource.BufferSource bufferSource, PoseStack.Pose last) {
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_269166_());
        switch (CameraAnimIdeCache.getMode()) {
            case NONE: {
                break;
            }
            case MOVE: {
                OnLevelRender.renderMoveSlice(selected, buffer, last);
            }
        }
        bufferSource.m_109912_(RenderType.m_269166_());
    }

    private static void renderMoveSlice(CameraAnimIdeCache.SelectedPoint selected, VertexConsumer buffer, PoseStack.Pose last) {
        Vector3f pos = selected.getPosition();
        if (pos == null) {
            return;
        }
        pos = V_CACHE_1.set((Vector3fc)pos).sub((Vector3fc)CAMERA_CACHE);
        int xyColor = 2131268845;
        int yzColor = 2147422786;
        int xzColor = 2133257285;
        switch (CameraAnimIdeCache.getMoveMode().getMoveType()) {
            case XY: {
                xyColor = 2134806783;
                break;
            }
            case YZ: {
                yzColor = 2134806783;
                break;
            }
            case XZ: {
                xzColor = 2134806783;
            }
        }
        OnLevelRender.addSlice(buffer, last, pos, xyColor, yzColor, xzColor);
    }

    private static void addLine(VertexConsumer buffer, PoseStack.Pose pose, Vector3f pos1, Vector3f pos2, int color) {
        Vector3f normalize = V_CACHE_5.set((Vector3fc)pos2).sub((Vector3fc)pos1).normalize();
        Matrix3f matrix3f = pose.m_252943_();
        Matrix4f matrix4f = pose.m_252922_();
        buffer.m_252986_(matrix4f, pos1.x, pos1.y, pos1.z).m_193479_(color).m_252939_(matrix3f, normalize.x, normalize.y, normalize.z).m_5752_();
        buffer.m_252986_(matrix4f, pos2.x, pos2.y, pos2.z).m_193479_(color).m_252939_(matrix3f, normalize.x, normalize.y, normalize.z).m_5752_();
    }

    private static void addSmoothLine(VertexConsumer buffer, PoseStack.Pose pose, Vector3f pre, Vector3f p1, Vector3f p2, Vector3f after, int color) {
        Vector3f pos1 = V_CACHE_6.set((Vector3fc)p1);
        Vector3f pos2 = V_CACHE_7.zero();
        for (float i = 1.0f; i <= 20.0f; i += 1.0f) {
            float f = 0.05f * i;
            InterpolationMath.catmullRom(f, pre, p1, p2, after, pos2);
            OnLevelRender.addLine(buffer, pose, pos1, pos2, color);
            pos1.set((Vector3fc)pos2);
        }
        OnLevelRender.addLine(buffer, pose, pos2, p2, color);
    }

    private static void addBezierLine(VertexConsumer buffer, PoseStack.Pose pose, Vector3f p1, Vector3f c1, Vector3f c2, Vector3f p2, int color) {
        Vector3f pos1 = V_CACHE_6.set((Vector3fc)p1);
        Vector3f pos2 = V_CACHE_7.zero();
        for (int i = 0; i < 20; ++i) {
            float t = 0.05f * (float)i;
            InterpolationMath.bezier(t, p1, c1, c2, p2, pos2);
            OnLevelRender.addLine(buffer, pose, pos1, pos2, color);
            pos1.set((Vector3fc)pos2);
        }
        OnLevelRender.addLine(buffer, pose, pos2, p2, color);
    }

    private static void addPoint(VertexConsumer buffer, PoseStack.Pose pose, Vector3f pos, float size, int color) {
        Vector3f vec = V_CACHE_5;
        Matrix4f matrix4f = pose.m_252922_();
        vec.set((Vector3fc)pos).add(size, -size, -size);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z).m_193479_(color).m_5752_();
        vec.set((Vector3fc)pos).add(size, -size, -size);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z).m_193479_(color).m_5752_();
        vec.set((Vector3fc)pos).add(size, -size, -size);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z).m_193479_(color).m_5752_();
        vec.set((Vector3fc)pos).add(-size, size, -size);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z).m_193479_(color).m_5752_();
        vec.set((Vector3fc)pos).add(size, size, -size);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z).m_193479_(color).m_5752_();
        vec.set((Vector3fc)pos).add(size, size, size);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z).m_193479_(color).m_5752_();
        vec.set((Vector3fc)pos).add(size, -size, -size);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z).m_193479_(color).m_5752_();
        vec.set((Vector3fc)pos).add(size, -size, size);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z).m_193479_(color).m_5752_();
        vec.set((Vector3fc)pos).add(-size, -size, size);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z).m_193479_(color).m_5752_();
        vec.set((Vector3fc)pos).add(size, size, size);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z).m_193479_(color).m_5752_();
        vec.set((Vector3fc)pos).add(-size, size, size);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z).m_193479_(color).m_5752_();
        vec.set((Vector3fc)pos).add(-size, size, -size);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z).m_193479_(color).m_5752_();
        vec.set((Vector3fc)pos).add(-size, -size, size);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z).m_193479_(color).m_5752_();
        vec.set((Vector3fc)pos).add(-size, -size, -size);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z).m_193479_(color).m_5752_();
        vec.set((Vector3fc)pos).add(size, -size, -size);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z).m_193479_(color).m_5752_();
        vec.set((Vector3fc)pos).add(-size, size, -size);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z).m_193479_(color).m_5752_();
        vec.set((Vector3fc)pos).add(-size, size, -size);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z).m_193479_(color).m_5752_();
        vec.set((Vector3fc)pos).add(-size, size, -size);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z).m_193479_(color).m_5752_();
    }

    private static void addSlice(VertexConsumer buffer, PoseStack.Pose pose, Vector3f pos, int xyColor, int yzColor, int xzColor) {
        float spacing = 0.2f;
        float half = 0.3f + spacing;
        Vector3f vec = V_CACHE_5;
        Matrix4f matrix4f = pose.m_252922_();
        vec.set((Vector3fc)pos).add(0.0f, spacing, spacing);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z).m_193479_(yzColor).m_5752_();
        vec.set((Vector3fc)pos).add(0.0f, spacing, half);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z).m_193479_(yzColor).m_5752_();
        vec.set((Vector3fc)pos).add(0.0f, half, half);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z).m_193479_(yzColor).m_5752_();
        vec.set((Vector3fc)pos).add(0.0f, half, spacing);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z).m_193479_(yzColor).m_5752_();
        vec.set((Vector3fc)pos).add(half, half, 0.0f);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z).m_193479_(xyColor).m_5752_();
        vec.set((Vector3fc)pos).add(half, spacing, 0.0f);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z).m_193479_(xyColor).m_5752_();
        vec.set((Vector3fc)pos).add(spacing, spacing, 0.0f);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z).m_193479_(xyColor).m_5752_();
        vec.set((Vector3fc)pos).add(spacing, half, 0.0f);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z).m_193479_(xyColor).m_5752_();
        vec.set((Vector3fc)pos).add(spacing, 0.0f, spacing);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z).m_193479_(xzColor).m_5752_();
        vec.set((Vector3fc)pos).add(spacing, 0.0f, half);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z).m_193479_(xzColor).m_5752_();
        vec.set((Vector3fc)pos).add(half, 0.0f, half);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z).m_193479_(xzColor).m_5752_();
        vec.set((Vector3fc)pos).add(half, 0.0f, spacing);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z).m_193479_(xzColor).m_5752_();
    }

    private static void addArrowhead(VertexConsumer buffer, PoseStack.Pose pose, Vector3f pos, int xColor, int yColor, int zColor) {
        Vector3f vec = V_CACHE_5.set((Vector3fc)pos);
        float size = 0.1f;
        float height = 0.35f;
        float spacing = 1.0f;
        Matrix4f matrix4f = pose.m_252922_();
        vec.add(0.0f, spacing, 0.0f);
        buffer.m_252986_(matrix4f, vec.x - size, vec.y, vec.z - size).m_193479_(yColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x - size, vec.y, vec.z - size).m_193479_(yColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x - size, vec.y, vec.z - size).m_193479_(yColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x + size, vec.y, vec.z - size).m_193479_(yColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x - size, vec.y, vec.z + size).m_193479_(yColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x + size, vec.y, vec.z + size).m_193479_(yColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x, vec.y + height, vec.z).m_193479_(yColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x + size, vec.y, vec.z - size).m_193479_(yColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x - size, vec.y, vec.z - size).m_193479_(yColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x - size, vec.y, vec.z + size).m_193479_(yColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x, vec.y + height, vec.z).m_193479_(yColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x, vec.y + height, vec.z).m_193479_(yColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x, vec.y + height, vec.z).m_193479_(yColor).m_5752_();
        vec.add(spacing, -spacing, 0.0f);
        buffer.m_252986_(matrix4f, vec.x, vec.y - size, vec.z - size).m_193479_(xColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x, vec.y - size, vec.z - size).m_193479_(xColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x, vec.y - size, vec.z - size).m_193479_(xColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x, vec.y + size, vec.z - size).m_193479_(xColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x, vec.y - size, vec.z + size).m_193479_(xColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x, vec.y + size, vec.z + size).m_193479_(xColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x + height, vec.y, vec.z).m_193479_(xColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x, vec.y + size, vec.z - size).m_193479_(xColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x, vec.y - size, vec.z - size).m_193479_(xColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x, vec.y - size, vec.z + size).m_193479_(xColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x + height, vec.y, vec.z).m_193479_(xColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x + height, vec.y, vec.z).m_193479_(xColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x + height, vec.y, vec.z).m_193479_(xColor).m_5752_();
        vec.add(-spacing, 0.0f, spacing);
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z + height).m_193479_(zColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z + height).m_193479_(zColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z + height).m_193479_(zColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x - size, vec.y + size, vec.z).m_193479_(zColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x - size, vec.y - size, vec.z).m_193479_(zColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x + size, vec.y - size, vec.z).m_193479_(zColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x, vec.y, vec.z + height).m_193479_(zColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x + size, vec.y + size, vec.z).m_193479_(zColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x - size, vec.y + size, vec.z).m_193479_(zColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x + size, vec.y - size, vec.z).m_193479_(zColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x - size, vec.y - size, vec.z).m_193479_(zColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x - size, vec.y - size, vec.z).m_193479_(zColor).m_5752_();
        buffer.m_252986_(matrix4f, vec.x - size, vec.y - size, vec.z).m_193479_(zColor).m_5752_();
    }
}

