/*
 * Decompiled with CFR 0.152.
 */
package cn.anecansaitin.cameraanim.common.animation;

import cn.anecansaitin.cameraanim.common.animation.CameraKeyframe;
import cn.anecansaitin.cameraanim.common.animation.PathInterpolator;
import com.google.gson.Gson;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class GlobalCameraPath {
    private final TreeMap<Integer, CameraKeyframe> keyframes;
    private final Int2ObjectOpenHashMap<CameraKeyframe> keyframeMapCache;
    private final ArrayList<CameraKeyframe> keyframeListCache;
    private boolean dirty;
    private final String id;
    private long version;
    private UUID lastModifier;
    private boolean nativeMode;

    public GlobalCameraPath(String id, @Nullable Player lastModifier) {
        this.keyframes = new TreeMap();
        this.keyframeMapCache = new Int2ObjectOpenHashMap();
        this.keyframeListCache = new ArrayList();
        this.id = id;
        this.version = System.currentTimeMillis();
        this.lastModifier = lastModifier == null ? UUID.fromString("00000000-0000-0000-0000-000000000000") : lastModifier.m_20148_();
    }

    public GlobalCameraPath(String id) {
        this(id, null);
    }

    public GlobalCameraPath(TreeMap<Integer, CameraKeyframe> keyframes, String id) {
        this(keyframes, id, 0L, UUID.fromString("00000000-0000-0000-0000-000000000000"));
    }

    private GlobalCameraPath(TreeMap<Integer, CameraKeyframe> keyframes, String id, long version, UUID lastModifier) {
        this.keyframes = keyframes;
        this.id = id;
        this.keyframeMapCache = new Int2ObjectOpenHashMap(keyframes);
        this.keyframeListCache = new ArrayList<CameraKeyframe>(keyframes.values());
        this.version = version;
        this.lastModifier = lastModifier;
    }

    private GlobalCameraPath(TreeMap<Integer, CameraKeyframe> keyframes, String id, long version, UUID lastModifier, boolean nativeMode) {
        this.keyframes = keyframes;
        this.id = id;
        this.keyframeMapCache = new Int2ObjectOpenHashMap(keyframes);
        this.keyframeListCache = new ArrayList<CameraKeyframe>(keyframes.values());
        this.version = version;
        this.lastModifier = lastModifier;
        this.nativeMode = nativeMode;
    }

    public void add(int time, CameraKeyframe point) {
        Integer i = this.keyframes.lastKey();
        if (i != null && i < time) {
            this.keyframeListCache.add(point);
        } else {
            this.dirty = true;
        }
        this.keyframes.put(time, point);
        this.keyframeMapCache.put(time, (Object)point);
        this.updateBezier(time);
    }

    public void add(CameraKeyframe point) {
        if (this.keyframes.isEmpty()) {
            this.keyframes.put(0, point);
            this.keyframeMapCache.put(0, (Object)point);
        } else {
            int time = this.keyframes.lastKey() + 20;
            this.keyframes.put(time, point);
            this.keyframeMapCache.put(time, (Object)point);
            this.updateBezier(time);
        }
        this.keyframeListCache.add(point);
    }

    public Int2ObjectMap.FastEntrySet<CameraKeyframe> getEntries() {
        return this.keyframeMapCache.int2ObjectEntrySet();
    }

    public ArrayList<CameraKeyframe> getPoints() {
        this.updateList();
        return this.keyframeListCache;
    }

    private void updateList() {
        if (!this.dirty) {
            return;
        }
        this.keyframeListCache.clear();
        this.keyframeListCache.addAll(this.keyframes.values());
        this.dirty = false;
    }

    public void updateBezier(int time) {
        Map.Entry<Integer, CameraKeyframe> next;
        Map.Entry<Integer, CameraKeyframe> pre;
        if (!this.keyframeMapCache.containsKey(time)) {
            return;
        }
        CameraKeyframe point = (CameraKeyframe)this.keyframeMapCache.get(time);
        if (point.getPathInterpolator() == PathInterpolator.BEZIER && (pre = this.keyframes.lowerEntry(time)) != null) {
            CameraKeyframe prePoint = pre.getValue();
            point.getPathBezier().reset(prePoint.getPos(), point.getPos());
        }
        if ((next = this.keyframes.higherEntry(time)) != null) {
            CameraKeyframe nextPoint = next.getValue();
            if (nextPoint.getPathInterpolator() != PathInterpolator.BEZIER) {
                return;
            }
            nextPoint.getPathBezier().reset(nextPoint.getPos(), point.getPos());
        }
    }

    public void remove(int time) {
        if (!this.keyframeMapCache.containsKey(time)) {
            return;
        }
        Map.Entry<Integer, CameraKeyframe> pre = this.keyframes.lowerEntry(time);
        Map.Entry<Integer, CameraKeyframe> next = this.keyframes.higherEntry(time);
        this.keyframes.remove(time);
        this.keyframeMapCache.remove(time);
        this.dirty = true;
        if (next == null || pre == null) {
            return;
        }
        CameraKeyframe nextPoint = next.getValue();
        if (nextPoint.getPathInterpolator() != PathInterpolator.BEZIER) {
            return;
        }
        CameraKeyframe prePoint = pre.getValue();
        nextPoint.getPathBezier().reset(prePoint.getPos(), nextPoint.getPos());
    }

    @Nullable
    public CameraKeyframe getPoint(int time) {
        return (CameraKeyframe)this.keyframeMapCache.get(time);
    }

    @Nullable
    public CameraKeyframe getPrePoint(int time) {
        Map.Entry<Integer, CameraKeyframe> entry = this.getPreEntry(time);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    @Nullable
    public Map.Entry<Integer, CameraKeyframe> getPreEntry(int time) {
        return this.keyframes.lowerEntry(time);
    }

    @Nullable
    public CameraKeyframe getNextPoint(int time) {
        Map.Entry<Integer, CameraKeyframe> next = this.getNextEntry(time);
        if (next == null) {
            return null;
        }
        return this.keyframes.higherEntry(time).getValue();
    }

    @Nullable
    public Map.Entry<Integer, CameraKeyframe> getNextEntry(int time) {
        return this.keyframes.higherEntry(time);
    }

    @Nullable
    public Map.Entry<Integer, CameraKeyframe> getEntry(int time) {
        return this.keyframes.floorEntry(time);
    }

    public int getLength() {
        return this.keyframes.lastKey();
    }

    public void setTime(int oldTime, int newTime) {
        if (!this.keyframeMapCache.containsKey(oldTime)) {
            return;
        }
        CameraKeyframe point = (CameraKeyframe)this.keyframeMapCache.remove(oldTime);
        this.keyframeMapCache.put(newTime, (Object)point);
        Integer pre = this.keyframes.lowerKey(oldTime);
        Integer next = this.keyframes.higherKey(oldTime);
        this.keyframes.remove(oldTime);
        this.keyframes.put(newTime, point);
        if (pre != null && newTime < pre || next != null && newTime > next) {
            this.updateBezier(newTime);
        }
        this.dirty = true;
    }

    public String getId() {
        return this.id;
    }

    public GlobalCameraPath resetID(String id) {
        return new GlobalCameraPath(this.keyframes, id, this.version, this.lastModifier, this.nativeMode);
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public UUID getLastModifier() {
        return this.lastModifier;
    }

    public void setLastModifier(UUID lastModifier) {
        this.lastModifier = lastModifier;
    }

    public boolean isNativeMode() {
        return this.nativeMode;
    }

    public void setNativeMode(boolean nativeMode) {
        this.nativeMode = nativeMode;
    }

    public GlobalCameraPath toNative(Vector3f pos, float yRot) {
        TreeMap<Integer, CameraKeyframe> map = new TreeMap<Integer, CameraKeyframe>();
        for (Map.Entry<Integer, CameraKeyframe> entry : this.keyframes.entrySet()) {
            map.put(entry.getKey(), entry.getValue().copy());
        }
        Matrix3f matrix3f = new Matrix3f();
        matrix3f.rotateY(yRot * ((float)Math.PI / 180));
        for (CameraKeyframe keyframe : map.values()) {
            Vector3f pos1 = keyframe.getPos().sub((Vector3fc)pos);
            matrix3f.transform(pos1);
            keyframe.getRot().sub(0.0f, yRot, 0.0f);
            if (keyframe.getPathInterpolator() != PathInterpolator.BEZIER) continue;
            Vector3f left = keyframe.getPathBezier().getLeft();
            Vector3f right = keyframe.getPathBezier().getRight();
            left.sub((Vector3fc)pos);
            matrix3f.transform(left);
            right.sub((Vector3fc)pos);
            matrix3f.transform(right);
        }
        return new GlobalCameraPath(map, this.id, this.version, this.lastModifier, true);
    }

    public GlobalCameraPath fromNative(Vector3f pos, float yRot) {
        TreeMap<Integer, CameraKeyframe> map = new TreeMap<Integer, CameraKeyframe>((SortedMap<Integer, CameraKeyframe>)this.keyframes);
        Matrix3f matrix3f = new Matrix3f();
        matrix3f.rotateY((360.0f - yRot) * ((float)Math.PI / 180));
        for (CameraKeyframe keyframe : map.values()) {
            Vector3f pos1 = matrix3f.transform(keyframe.getPos());
            pos1.add((Vector3fc)pos);
            keyframe.getRot().add(0.0f, yRot, 0.0f);
            if (keyframe.getPathInterpolator() != PathInterpolator.BEZIER) continue;
            Vector3f left = matrix3f.transform(keyframe.getPathBezier().getLeft());
            Vector3f right = matrix3f.transform(keyframe.getPathBezier().getRight());
            left.add((Vector3fc)pos);
            right.add((Vector3fc)pos);
        }
        return new GlobalCameraPath(map, this.id, this.version, this.lastModifier, true);
    }

    public String toJsonString(Gson gson) {
        return gson.toJson(this.keyframes);
    }

    public static CompoundTag toNBT(GlobalCameraPath path) {
        CompoundTag root = new CompoundTag();
        root.m_128359_("id", path.id);
        root.m_128356_("version", path.version);
        root.m_128362_("lastModifier", path.lastModifier);
        root.m_128379_("native", path.nativeMode);
        ListTag keyframes = new ListTag();
        for (Map.Entry<Integer, CameraKeyframe> entry : path.keyframes.entrySet()) {
            CompoundTag point = new CompoundTag();
            point.m_128405_("time", entry.getKey().intValue());
            point.m_128365_("keyframe", (Tag)CameraKeyframe.toNBT(entry.getValue()));
            keyframes.add((Object)point);
        }
        root.m_128365_("keyframes", (Tag)keyframes);
        return root;
    }

    public static GlobalCameraPath fromNBT(CompoundTag root) {
        ListTag list = root.m_128437_("keyframes", 10);
        TreeMap<Integer, CameraKeyframe> map = new TreeMap<Integer, CameraKeyframe>();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag keyframe = list.m_128728_(i);
            map.put(keyframe.m_128451_("time"), CameraKeyframe.fromNBT(keyframe.m_128469_("keyframe")));
        }
        String id = root.m_128461_("id");
        long version = root.m_128454_("version");
        UUID lastModifier = root.m_128342_("lastModifier");
        boolean nativeMode = root.m_128471_("native");
        return new GlobalCameraPath(map, id, version, lastModifier, nativeMode);
    }
}

