/*
 * Decompiled with CFR 0.152.
 */
package cn.anecansaitin.cameraanim.common.animation;

import cn.anecansaitin.cameraanim.InterpolationMath;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Vec3BezierController {
    private final Vector3f left;
    private final Vector3f right;

    public Vec3BezierController(Vector3f left, Vector3f right) {
        this.left = left;
        this.right = right;
    }

    public Vec3BezierController() {
        this(new Vector3f(), new Vector3f());
    }

    public Vector3f getLeft() {
        return this.left;
    }

    public void setLeft(float x, float y, float z) {
        this.left.set(x, y, z);
    }

    public Vector3f getRight() {
        return this.right;
    }

    public void setRight(float x, float y, float z) {
        this.right.set(x, y, z);
    }

    public void reset(Vector3f start, Vector3f end) {
        this.left.set((Vector3fc)start).lerp((Vector3fc)end, 0.4f);
        this.right.set((Vector3fc)end).lerp((Vector3fc)start, 0.4f);
    }

    public Vector3f interpolate(float delta, Vector3f start, Vector3f end, Vector3f dest) {
        return InterpolationMath.bezier(delta, start, this.left, this.right, end, dest);
    }

    public static ListTag toNBT(Vec3BezierController bezier) {
        ListTag root = new ListTag();
        root.add((Object)FloatTag.m_128566_((float)bezier.left.x));
        root.add((Object)FloatTag.m_128566_((float)bezier.left.y));
        root.add((Object)FloatTag.m_128566_((float)bezier.left.z));
        root.add((Object)FloatTag.m_128566_((float)bezier.right.x));
        root.add((Object)FloatTag.m_128566_((float)bezier.right.y));
        root.add((Object)FloatTag.m_128566_((float)bezier.right.z));
        return root;
    }

    public static Vec3BezierController fromNBT(ListTag root) {
        return new Vec3BezierController(new Vector3f(root.m_128775_(0), root.m_128775_(1), root.m_128775_(2)), new Vector3f(root.m_128775_(3), root.m_128775_(4), root.m_128775_(5)));
    }
}

