/*
 * Decompiled with CFR 0.152.
 */
package cn.anecansaitin.cameraanim.common.listener;

import cn.anecansaitin.cameraanim.common.GlobalCameraSavedData;
import cn.anecansaitin.cameraanim.common.animation.GlobalCameraPath;
import cn.anecansaitin.cameraanim.common.network.ServerPayloadSender;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="camera_anim")
public class OnRegisterCommands {
    private static final Component PLAY_ANIM_FAILURE = Component.m_237115_((String)"commands.cameraanim.play.failure");
    private static final Component PLAY_NATIVE_ANIM_FAILURE = Component.m_237115_((String)"commands.cameraanim.play.native.failure");

    @SubscribeEvent
    public static void register(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"cameraanim").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"play").requires(source -> {
            if (source.f_81288_ instanceof BaseCommandBlock) {
                return true;
            }
            if (source.m_230897_()) {
                return source.m_81377_().m_129944_(source.m_230896_().m_36316_()) > 1;
            }
            return false;
        })).then(Commands.m_82129_((String)"Target", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"Anim Id", (ArgumentType)StringArgumentType.string()).executes(context -> {
            EntitySelector target = (EntitySelector)context.getArgument("Target", EntitySelector.class);
            List players = target.m_121166_((CommandSourceStack)context.getSource());
            if (players.isEmpty()) {
                return 1;
            }
            ServerPlayer player = (ServerPlayer)players.get(0);
            String animId = (String)context.getArgument("Anim Id", String.class);
            GlobalCameraSavedData data = GlobalCameraSavedData.getData((ServerLevel)player.m_9236_());
            GlobalCameraPath path = data.getPath(animId);
            if (path == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)PLAY_ANIM_FAILURE.m_6881_().m_130946_(animId));
            }
            for (ServerPlayer serverPlayer : players) {
                ServerPayloadSender.sendGlobalPath(path, serverPlayer, 1);
            }
            return 1;
        })).then(Commands.m_82129_((String)"Center", (ArgumentType)EntityArgument.m_91449_()).executes(context -> {
            EntitySelector target = (EntitySelector)context.getArgument("Target", EntitySelector.class);
            List players = target.m_121166_((CommandSourceStack)context.getSource());
            if (players.isEmpty()) {
                return 1;
            }
            ServerPlayer player = (ServerPlayer)players.get(0);
            String animId = (String)context.getArgument("Anim Id", String.class);
            GlobalCameraSavedData data = GlobalCameraSavedData.getData((ServerLevel)player.m_9236_());
            GlobalCameraPath path = data.getPath(animId);
            if (path == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)PLAY_ANIM_FAILURE.m_6881_().m_130946_(animId));
                return 1;
            }
            if (!path.isNativeMode()) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)PLAY_NATIVE_ANIM_FAILURE.m_6881_().m_130946_(animId));
                return 1;
            }
            EntitySelector center = (EntitySelector)context.getArgument("Center", EntitySelector.class);
            Entity centerEntity = center.m_121139_((CommandSourceStack)context.getSource());
            for (ServerPlayer serverPlayer : players) {
                ServerPayloadSender.sendNativePath(path, serverPlayer, centerEntity);
            }
            return 1;
        }))))));
    }
}

