/*
 * Decompiled with CFR 0.152.
 */
package cn.anecansaitin.cameraanim.common.network;

import cn.anecansaitin.cameraanim.common.ModNetwork;
import cn.anecansaitin.cameraanim.common.animation.GlobalCameraPath;
import cn.anecansaitin.cameraanim.common.network.S2CPayloadReply;
import cn.anecansaitin.cameraanim.common.network.ServerPayloadManager;
import java.util.HashMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public record C2SPayloadManager(CompoundTag tag) {
    private static final HashMap<String, BiFunction<CompoundTag, NetworkEvent.Context, CompoundTag>> HANDLERS = new HashMap();

    public static void encode(C2SPayloadManager pag, FriendlyByteBuf buf) {
        buf.m_130079_(pag.tag);
    }

    public static C2SPayloadManager decode(FriendlyByteBuf bug) {
        return new C2SPayloadManager(bug.m_130260_());
    }

    public static void handle(C2SPayloadManager payload, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            String key = payload.tag.m_128461_("key");
            BiFunction<CompoundTag, NetworkEvent.Context, CompoundTag> handler = HANDLERS.get(key);
            if (handler == null) {
                return;
            }
            CompoundTag result = handler.apply(payload.tag.m_128469_("value"), context);
            if (result == null) {
                return;
            }
            CompoundTag root = new CompoundTag();
            root.m_128359_("key", key);
            root.m_128365_("value", (Tag)result);
            ModNetwork.INSTANCE.reply((Object)new S2CPayloadReply(root), context);
        });
        context.setPacketHandled(true);
    }

    static {
        HANDLERS.put("checkGlobalPath", (tag, context) -> ServerPayloadManager.INSTANCE.checkGlobalPath(tag.m_128451_("page"), tag.m_128451_("size"), (NetworkEvent.Context)context));
        HANDLERS.put("putGlobalPath", (tag, context) -> ServerPayloadManager.INSTANCE.putGlobalPath(GlobalCameraPath.fromNBT(tag), (NetworkEvent.Context)context));
        HANDLERS.put("removeGlobalPath", (tag, context) -> ServerPayloadManager.INSTANCE.removeGlobalPath(tag.m_128461_("id"), (NetworkEvent.Context)context));
        HANDLERS.put("getGlobalPath", (tag, context) -> ServerPayloadManager.INSTANCE.getGlobalPath(tag.m_128461_("id"), tag.m_128451_("receiver"), (NetworkEvent.Context)context));
    }
}

