/*
 * Decompiled with CFR 0.152.
 */
package cn.anecansaitin.cameraanim.common.network;

import cn.anecansaitin.cameraanim.common.GlobalCameraSavedData;
import cn.anecansaitin.cameraanim.common.animation.GlobalCameraPath;
import cn.anecansaitin.cameraanim.common.data_entity.GlobalCameraPathInfo;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.network.NetworkEvent;

public class ServerPayloadManager {
    public static final ServerPayloadManager INSTANCE = new ServerPayloadManager();

    public CompoundTag checkGlobalPath(int page, int size, NetworkEvent.Context context) {
        ServerLevel level = context.getSender().m_284548_();
        Collection<GlobalCameraPath> paths = GlobalCameraSavedData.getData(level).getPaths();
        ArrayList<GlobalCameraPath> pathList = new ArrayList<GlobalCameraPath>(paths);
        int begin = (page - 1) * size;
        int end = Math.min(begin + size, pathList.size());
        CompoundTag root = new CompoundTag();
        root.m_128405_("size", size);
        root.m_128405_("page", page);
        if (begin >= end) {
            root.m_128379_("succeed", false);
        } else {
            root.m_128379_("succeed", true);
            ListTag result = new ListTag();
            root.m_128365_("paths", (Tag)result);
            for (int i = begin; i < end; ++i) {
                GlobalCameraPath path = pathList.get(i);
                result.add((Object)GlobalCameraPathInfo.toNBT(path));
            }
        }
        return root;
    }

    public CompoundTag putGlobalPath(GlobalCameraPath path, NetworkEvent.Context context) {
        ServerLevel level = context.getSender().m_284548_();
        path.setVersion(System.currentTimeMillis());
        path.setLastModifier(context.getSender().m_20148_());
        GlobalCameraSavedData.getData(level).addPath(path);
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("succeed", true);
        return tag;
    }

    public CompoundTag removeGlobalPath(String id, NetworkEvent.Context context) {
        ServerLevel level = context.getSender().m_284548_();
        GlobalCameraSavedData.getData(level).removePath(id);
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("succeed", true);
        return tag;
    }

    public CompoundTag getGlobalPath(String id, int receiver, NetworkEvent.Context context) {
        ServerLevel level = context.getSender().m_284548_();
        GlobalCameraPath path = GlobalCameraSavedData.getData(level).getPath(id);
        CompoundTag root = new CompoundTag();
        root.m_128405_("receiver", receiver);
        if (path == null) {
            root.m_128379_("succeed", false);
        } else {
            root.m_128365_("path", (Tag)GlobalCameraPath.toNBT(path));
            root.m_128379_("succeed", true);
        }
        return root;
    }
}

