/*
 * Decompiled with CFR 0.152.
 */
package me.novoro.helditemsaver;

import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import me.novoro.helditemsaver.api.configuration.Configuration;
import me.novoro.helditemsaver.api.configuration.YamlConfiguration;
import me.novoro.helditemsaver.commands.ReloadCommand;
import me.novoro.helditemsaver.config.LangManager;
import me.novoro.helditemsaver.config.SettingsManager;
import me.novoro.helditemsaver.events.BattleListener;
import me.novoro.helditemsaver.util.HeldItemSaverLogger;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.server.MinecraftServer;

public class HeldItemSaver
implements ModInitializer {
    public static final String MOD_PREFIX = "<gray><bold>[<gradient:#FDC830:#F37335>&l[H\u1d07\u029f\u1d05I\u1d1b\u1d07\u1d0dS\u1d00\u1d20\u1d07\u0280</gradient><gray><bold>]&f ";
    private static HeldItemSaver instance;
    public static MinecraftServer server;
    private final SettingsManager settingsManager = new SettingsManager();
    private final LangManager langManager = new LangManager();

    public void onInitialize() {
        instance = this;
        this.displayAsciiArt();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            HeldItemSaver.server = server;
            this.reloadConfigs();
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> this.registerCommands((CommandDispatcher<class_2168>)dispatcher));
        new BattleListener();
    }

    public void reloadConfigs() {
        this.settingsManager.reload();
        this.langManager.reload();
    }

    private void displayAsciiArt() {
        HeldItemSaverLogger.info("\u001b[33m  _    _      _     _   _____ _                    _____                      \u001b[0m");
        HeldItemSaverLogger.info("\u001b[33m | |  | |    | |   | | |_   _| |                  / ____|                     \u001b[0m");
        HeldItemSaverLogger.info("\u001b[33m | |__| | ___| | __| |   | | | |_ ___ _ __ ___   | (___   __ ___   _____ _ __ \u001b[0m");
        HeldItemSaverLogger.info("\u001b[33m |  __  |/ _ \\ |/ _` |   | | | __/ _ \\ '_ ` _ \\   \\___ \\ / _` \\ \\ / / _ \\ '__|\u001b[0m");
        HeldItemSaverLogger.info("\u001b[33m | |  | |  __/ | (_| |  _| |_| ||  __/ | | | | |  ____) | (_| |\\ V /  __/ |   \u001b[0m");
        HeldItemSaverLogger.info("\u001b[33m |_|  |_|\\___|_|\\__,_| |_____|\\__\\___|_| |_| |_| |_____/ \\__,_| \\_/ \\___|_|   \u001b[0m");
        HeldItemSaverLogger.info("\u001b[33m By Novoro: https://discord.gg/wzpp8jeJ9s \u001b[0m");
    }

    public static HeldItemSaver inst() {
        return instance;
    }

    public static MinecraftServer getServer() {
        return server;
    }

    private void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        ReloadCommand.register(dispatcher);
    }

    public File getDataFolder() {
        File folder = FabricLoader.getInstance().getConfigDir().resolve("HeldItemSaver").toFile();
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return folder;
    }

    public File getFile(String fileName) {
        File file = new File(this.getDataFolder(), fileName);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        }
        return file;
    }

    public Configuration getConfig(String fileName, boolean saveResource) {
        File configFile = this.getFile(fileName);
        if (!configFile.exists()) {
            if (!saveResource) {
                return null;
            }
            this.saveResource(fileName, false);
        }
        return this.getConfig(configFile);
    }

    public Configuration getConfig(File configFile) {
        try {
            return YamlConfiguration.loadConfiguration(configFile);
        }
        catch (IOException e) {
            HeldItemSaverLogger.error("Something went wrong getting the config: " + configFile.getName() + ".");
            HeldItemSaverLogger.printStackTrace(e);
            return null;
        }
    }

    public void saveConfig(String fileName, Configuration config) {
        File file = this.getFile(fileName);
        try {
            YamlConfiguration.save(config, file);
        }
        catch (IOException e) {
            HeldItemSaverLogger.warn("Something went wrong saving the config: " + fileName + ".");
            HeldItemSaverLogger.printStackTrace(e);
        }
    }

    public void saveResource(String fileName, boolean overwrite) {
        File file = this.getFile(fileName);
        if (file.exists() && !overwrite) {
            return;
        }
        try {
            FileOutputStream outputStream = new FileOutputStream(file);
            Path path = Paths.get("configurations", fileName);
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(path.toString().replace("\\", "/"));
            assert (in != null);
            in.transferTo(outputStream);
        }
        catch (IOException e) {
            HeldItemSaverLogger.error("Something went wrong saving the resource: " + fileName + ".");
            HeldItemSaverLogger.printStackTrace(e);
        }
    }
}

