/*
 * Decompiled with CFR 0.152.
 */
package me.novoro.helditemsaver.config;

import java.util.HashMap;
import java.util.Map;
import me.novoro.helditemsaver.api.configuration.Configuration;
import me.novoro.helditemsaver.api.configuration.VersionedConfig;
import me.novoro.helditemsaver.util.ColorUtil;
import me.novoro.helditemsaver.util.StringUtil;
import net.kyori.adventure.audience.Audience;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LangManager
extends VersionedConfig {
    public static final LangManager EMPTY = new LangManager();
    private static final Map<String, String> LANG = new HashMap<String, String>();

    @Override
    protected void reload(Configuration config) {
        super.reload(config);
        LANG.clear();
        Configuration langSection = config.getSection("Lang");
        if (langSection == null) {
            return;
        }
        for (String key : langSection.getKeys()) {
            LANG.put(key, langSection.getString(key));
        }
    }

    @Nullable
    public static String getLang(String langKey) {
        String lang = LANG.get(langKey);
        if (lang == null || lang.isEmpty() || lang.isBlank()) {
            return null;
        }
        return lang;
    }

    @NotNull
    public static String getLangSafely(String langKey) {
        return LANG.getOrDefault(langKey, "");
    }

    public static void sendLang(Audience audience, String key) {
        LangManager.sendLang(audience, key, null);
    }

    public static void sendLang(Audience audience, String key, @Nullable Map<String, String> replacements) {
        Object lang = LangManager.getLang(key);
        if (lang == null) {
            return;
        }
        lang = StringUtil.replaceReplacements((String)lang, replacements);
        String prefix = LangManager.getLang("Prefix");
        if (prefix != null) {
            lang = prefix + (String)lang;
        }
        audience.sendMessage(ColorUtil.parseColour((String)lang));
    }

    @Override
    protected double getCurrentConfigVersion() {
        return 2.0;
    }

    @Override
    protected String getConfigFileName() {
        return "lang.yml";
    }
}

