/*
 * Decompiled with CFR 0.152.
 */
package me.novoro.helditemsaver.events;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.battles.BattleEvent;
import com.cobblemon.mod.common.api.events.battles.BattleFledEvent;
import com.cobblemon.mod.common.api.events.battles.BattleStartedEvent;
import com.cobblemon.mod.common.api.events.battles.BattleVictoryEvent;
import com.cobblemon.mod.common.api.storage.NoPokemonStoreException;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.battles.actor.PlayerBattleActor;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import kotlin.Unit;
import me.novoro.helditemsaver.util.HeldItemManager;
import me.novoro.helditemsaver.util.HeldItemSaverLogger;
import net.minecraft.class_1799;
import net.minecraft.class_3222;

public class BattleListener {
    private final HeldItemManager heldItemManager = new HeldItemManager();
    private final Set<UUID> processedBattles = ConcurrentHashMap.newKeySet();

    public BattleListener() {
        this.BattleEventListener();
    }

    public void BattleEventListener() {
        CobblemonEvents.BATTLE_STARTED_POST.subscribe(Priority.NORMAL, this::handleBattleStartedEvent);
        CobblemonEvents.BATTLE_VICTORY.subscribe(Priority.NORMAL, this::handleBattleEndedEvent);
        CobblemonEvents.BATTLE_FLED.subscribe(Priority.NORMAL, this::handleBattleEndedEvent);
    }

    private Unit handleBattleStartedEvent(BattleStartedEvent.Post event) {
        try {
            this.onBattleStartedPost(event);
        }
        catch (NoPokemonStoreException e) {
            HeldItemSaverLogger.error("Storage exception during battle start processing");
            HeldItemSaverLogger.printStackTrace(e);
        }
        return Unit.INSTANCE;
    }

    private Unit handleBattleEndedEvent(BattleEvent event) {
        String eventType = event instanceof BattleVictoryEvent ? "Victory" : (event instanceof BattleFledEvent ? "Flee" : "Faint");
        HeldItemSaverLogger.info("Battle ended with " + eventType);
        try {
            this.processBattleEnd(event.getBattle());
        }
        catch (NoPokemonStoreException e) {
            HeldItemSaverLogger.error("Storage exception during battle " + eventType + " processing");
            HeldItemSaverLogger.printStackTrace(e);
        }
        return Unit.INSTANCE;
    }

    private void processBattleEnd(PokemonBattle battle) throws NoPokemonStoreException {
        if (!this.processedBattles.add(battle.getBattleId())) {
            HeldItemSaverLogger.error("Battle already processed, skipping: {}", battle.getBattleId());
            return;
        }
        for (PlayerBattleActor actor : this.getPlayerBattleActors(battle)) {
            this.processPlayerBattleEnd(actor);
        }
    }

    private void onBattleStartedPost(BattleStartedEvent.Post event) throws NoPokemonStoreException {
        HeldItemSaverLogger.info("Processing start of a battle");
        List players = event.getBattle().getPlayers();
        for (class_3222 player : players) {
            UUID playerUUID = player.method_5667();
            PlayerPartyStore partyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
            HeldItemSaverLogger.info("Storing held items for player {} (UUID: {})", player.method_5477().getString(), playerUUID);
            class_1799[] heldItems = new class_1799[partyStore.size()];
            for (int i = 0; i < partyStore.size(); ++i) {
                Pokemon pokemon = partyStore.get(i);
                heldItems[i] = pokemon != null ? pokemon.heldItem() : class_1799.field_8037;
                HeldItemSaverLogger.info("Slot {} - Start Item: {}", heldItems[i] != class_1799.field_8037 ? heldItems[i].method_7909().toString() : "null", playerUUID);
            }
            this.heldItemManager.storeHeldItemsBeforeBattle(playerUUID, heldItems);
            HeldItemSaverLogger.info("Held items stored for player {} (UUID: {})", player.method_5477().getString(), playerUUID);
        }
    }

    private List<PlayerBattleActor> getPlayerBattleActors(PokemonBattle battle) {
        return StreamSupport.stream(battle.getActors().spliterator(), false).filter(PlayerBattleActor.class::isInstance).map(PlayerBattleActor.class::cast).collect(Collectors.toList());
    }

    private void processPlayerBattleEnd(PlayerBattleActor actor) throws NoPokemonStoreException {
        for (UUID playerUUID : actor.getPlayerUUIDs()) {
            class_3222 player = actor.getEntity();
            HeldItemSaverLogger.error("Processing battle end for player UUID: {}", playerUUID);
            this.restorePlayerHeldItems(player, playerUUID);
        }
    }

    private void restorePlayerHeldItems(class_3222 player, UUID playerUUID) {
        if (player == null) {
            HeldItemSaverLogger.error("Player (UUID: {}) unavailable to restore items.", playerUUID);
            return;
        }
        PlayerPartyStore partyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
        if (partyStore == null) {
            HeldItemSaverLogger.error("Party store not found for player UUID: {}", playerUUID);
            return;
        }
        ArrayList<Pokemon> partyPokemon = new ArrayList<Pokemon>();
        for (int i = 0; i < partyStore.size(); ++i) {
            Pokemon pokemon = partyStore.get(i);
            String endItemDesc = pokemon != null && pokemon.heldItem() != null ? pokemon.heldItem().method_7909().toString() : "null";
            HeldItemSaverLogger.info("Slot {} - End Item: {}", endItemDesc, playerUUID);
            partyPokemon.add(pokemon);
        }
        this.heldItemManager.restoreHeldItems(playerUUID, partyPokemon);
        this.logFinalItemStates(partyStore, playerUUID);
    }

    private void logFinalItemStates(PlayerPartyStore partyStore, UUID playerUUID) {
        for (int i = 0; i < partyStore.size(); ++i) {
            Pokemon pokemon = partyStore.get(i);
            String finalItemDesc = pokemon != null && pokemon.heldItem() != null ? pokemon.heldItem().method_7909().toString() : "null";
            HeldItemSaverLogger.info("Final state - Slot {} - Item: {}", finalItemDesc, playerUUID);
        }
        HeldItemSaverLogger.error("Restored held items for player UUID: {}", playerUUID);
    }
}

