/*
 * Decompiled with CFR 0.152.
 */
package me.novoro.helditemsaver.util;

import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.novoro.helditemsaver.util.HeldItemSaverLogger;
import net.minecraft.class_1799;

public class HeldItemManager {
    private final Map<UUID, class_1799[]> heldItemsBeforeBattle = new ConcurrentHashMap<UUID, class_1799[]>();

    public void storeHeldItemsBeforeBattle(UUID uuid, class_1799[] heldItems) {
        if (heldItems == null) {
            HeldItemSaverLogger.error("Failed to store held items: 'heldItems' is null for UUID {}", uuid);
            return;
        }
        this.heldItemsBeforeBattle.put(uuid, heldItems);
        HeldItemSaverLogger.error("Stored held items for UUID {}", uuid);
    }

    public void restoreHeldItems(UUID uuid, List<Pokemon> pokemons) {
        class_1799[] heldItemsBefore = this.heldItemsBeforeBattle.get(uuid);
        if (heldItemsBefore == null) {
            HeldItemSaverLogger.error("Restoration failed: Missing data for UUID {}", uuid);
            return;
        }
        for (int i = 0; i < pokemons.size(); ++i) {
            class_1799 currentHeldItem;
            Pokemon pokemon = pokemons.get(i);
            if (pokemon == null || class_1799.method_7984((class_1799)heldItemsBefore[i], (class_1799)(currentHeldItem = pokemon.heldItem()))) continue;
            pokemon.swapHeldItem(heldItemsBefore[i], false, false);
            HeldItemSaverLogger.error("Restored held item for UUID {}", uuid);
        }
        this.clearHeldItems(uuid);
    }

    public void clearHeldItems(UUID uuid) {
        HeldItemSaverLogger.error("Clearing stored held items for UUID {}", uuid);
        if (this.heldItemsBeforeBattle.remove(uuid) == null) {
            HeldItemSaverLogger.error("Attempted to clear non-existent held items for UUID {}", uuid);
        }
    }
}

