/*
 * Decompiled with CFR 0.152.
 */
package me.novoro.helditemsaver.util;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import java.util.UUID;
import me.novoro.helditemsaver.config.SettingsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeldItemSaverLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"HeldItemSaver");

    private static boolean enabled() {
        return SettingsManager.areLogsEnabled();
    }

    public static void info(String s) {
        if (!HeldItemSaverLogger.enabled()) {
            return;
        }
        LOGGER.info("[HeldItemSaver] {}", (Object)s);
    }

    public static void info(String s, PokemonBattle battle) {
        if (!HeldItemSaverLogger.enabled()) {
            return;
        }
        LOGGER.info("{}{}{}", new Object[]{"[HeldItemSaver]: ", s, battle});
    }

    public static void warn(String s) {
        if (!HeldItemSaverLogger.enabled()) {
            return;
        }
        LOGGER.warn("[HeldItemSaver] {}", (Object)s);
    }

    public static void error(String s) {
        if (!HeldItemSaverLogger.enabled()) {
            return;
        }
        LOGGER.error("[HeldItemSaver] {}", (Object)s);
    }

    public static void error(String s, UUID uuid) {
        if (!HeldItemSaverLogger.enabled()) {
            return;
        }
        LOGGER.error("[HeldItemSaver] {} {}", (Object)s, (Object)uuid);
    }

    public static void printStackTrace(Throwable throwable) {
        if (!HeldItemSaverLogger.enabled()) {
            return;
        }
        HeldItemSaverLogger.error(throwable.toString());
        for (StackTraceElement el : throwable.getStackTrace()) {
            HeldItemSaverLogger.error("\tat " + String.valueOf(el));
        }
    }

    public static void info(String s, String string, UUID playerUUID) {
        if (!HeldItemSaverLogger.enabled()) {
            return;
        }
        LOGGER.error("{}{}{}{}", new Object[]{"[HeldItemSaver]: ", s, string, playerUUID});
    }
}

