/*
 * Decompiled with CFR 0.152.
 */
package me.novoro.helditemsaver.util;

import java.util.Map;
import org.jetbrains.annotations.Nullable;

public final class StringUtil {
    public static String replaceReplacements(String input, @Nullable Map<String, String> replacements) {
        if (input == null) {
            return null;
        }
        if (replacements != null) {
            for (Map.Entry<String, String> replacer : replacements.entrySet()) {
                input = input.replace(replacer.getKey(), replacer.getValue());
            }
        }
        input = StringUtil.n(input);
        input = StringUtil.s(input);
        return input;
    }

    public static String n(String string) {
        return string.replaceAll("\\{n} (&#?[a-fA-F0-9]+)?([aeiouAEIOU])", "n $1$2").replace("{n}", "");
    }

    public static String s(String string) {
        return string.replaceAll("([sS])\\{s}", "$1'").replace("{s}", "'s");
    }

    public static Object replaceObject(String input, Map<String, String> replacements) {
        String parsed = StringUtil.replaceReplacements(input, replacements);
        try {
            double doubleVal = Double.parseDouble(parsed);
            try {
                return Integer.parseInt(parsed);
            }
            catch (NumberFormatException e) {
                return doubleVal;
            }
        }
        catch (NumberFormatException e) {
            return parsed;
        }
    }
}

