/*
 * Decompiled with CFR 0.152.
 */
package com.barion.block_variants.registry;

import com.ametrinstudios.ametrin.world.block.helper.BlockBehaviourPropertiesHelper;
import com.barion.block_variants.BVUtil;
import com.barion.block_variants.BlockVariants;
import com.barion.block_variants.registry.BVItems;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class BVBlocks {
    public static final DeferredRegister.Blocks REGISTER = DeferredRegister.createBlocks((String)"block_variants");
    private static final Item.Properties DEFAULT_ITEM_PROPERTIES = new Item.Properties();
    private static final Item.Properties fireResistanceItemProperties = new Item.Properties().fireResistant();
    public static final DeferredBlock<WallBlock> POLISHED_GRANITE_WALL;
    public static final DeferredBlock<WallBlock> POLISHED_DIORITE_WALL;
    public static final DeferredBlock<WallBlock> POLISHED_ANDESITE_WALL;
    public static final DeferredBlock<WallBlock> STONE_WALL;
    public static final DeferredBlock<StairBlock> SMOOTH_STONE_STAIRS;
    public static final DeferredBlock<WallBlock> SMOOTH_STONE_WALL;
    public static final DeferredBlock<StairBlock> CUT_SANDSTONE_STAIRS;
    public static final DeferredBlock<WallBlock> CUT_SANDSTONE_WALL;
    public static final DeferredBlock<StairBlock> CUT_RED_SANDSTONE_STAIRS;
    public static final DeferredBlock<WallBlock> CUT_RED_SANDSTONE_WALL;
    public static final DeferredBlock<WallBlock> QUARTZ_WALL;
    public static final DeferredBlock<StairBlock> QUARTZ_BRICK_STAIRS;
    public static final DeferredBlock<SlabBlock> QUARTZ_BRICK_SLAB;
    public static final DeferredBlock<WallBlock> QUARTZ_BRICK_WALL;
    public static final DeferredBlock<WallBlock> SMOOTH_QUARTZ_WALL;
    public static final DeferredBlock<StairBlock> CHISELED_QUARTZ_BLOCK_STAIRS;
    public static final DeferredBlock<SlabBlock> CHISELED_QUARTZ_BLOCK_SLAB;
    public static final DeferredBlock<WallBlock> CHISELED_QUARTZ_BLOCK_WALL;
    public static final DeferredBlock<WallBlock> PRISMARINE_BRICK_WALL;
    public static final DeferredBlock<WallBlock> DARK_PRISMARINE_WALL;
    public static final DeferredBlock<StairBlock> NETHERRACK_STAIRS;
    public static final DeferredBlock<SlabBlock> NETHERRACK_SLAB;
    public static final DeferredBlock<WallBlock> NETHERRACK_WALL;
    public static final DeferredBlock<StairBlock> END_STONE_STAIRS;
    public static final DeferredBlock<SlabBlock> END_STONE_SLAB;
    public static final DeferredBlock<WallBlock> END_STONE_WALL;
    public static final DeferredBlock<WallBlock> PURPUR_WALL;
    public static final DeferredBlock<StairBlock> CRACKED_POLISHED_BLACKSTONE_BRICK_STAIRS;
    public static final DeferredBlock<SlabBlock> CRACKED_POLISHED_BLACKSTONE_BRICK_SLAB;
    public static final DeferredBlock<WallBlock> CRACKED_POLISHED_BLACKSTONE_BRICK_WALL;
    public static final DeferredBlock<StairBlock> BASALT_STAIRS;
    public static final DeferredBlock<SlabBlock> BASALT_SLAB;
    public static final DeferredBlock<WallBlock> BASALT_WALL;
    public static final DeferredBlock<StairBlock> POLISHED_BASALT_STAIRS;
    public static final DeferredBlock<SlabBlock> POLISHED_BASALT_SLAB;
    public static final DeferredBlock<WallBlock> POLISHED_BASALT_WALL;
    public static final DeferredBlock<StairBlock> TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> WHITE_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> WHITE_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> WHITE_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> ORANGE_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> ORANGE_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> ORANGE_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> MAGENTA_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> MAGENTA_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> MAGENTA_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> LIGHT_BLUE_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> LIGHT_BLUE_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> LIGHT_BLUE_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> YELLOW_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> YELLOW_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> YELLOW_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> LIME_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> LIME_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> LIME_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> PINK_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> PINK_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> PINK_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> GRAY_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> GRAY_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> GRAY_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> LIGHT_GRAY_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> LIGHT_GRAY_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> LIGHT_GRAY_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> CYAN_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> CYAN_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> CYAN_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> PURPLE_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> PURPLE_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> PURPLE_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> BLUE_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> BLUE_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> BLUE_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> BROWN_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> BROWN_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> BROWN_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> GREEN_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> GREEN_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> GREEN_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> RED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> RED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> RED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> BLACK_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> BLACK_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> BLACK_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> DRIPSTONE_BLOCK_STAIRS;
    public static final DeferredBlock<SlabBlock> DRIPSTONE_BLOCK_SLAB;
    public static final DeferredBlock<WallBlock> DRIPSTONE_BLOCK_WALL;
    public static final DeferredBlock<StairBlock> AMETHYST_BLOCK_STAIRS;
    public static final DeferredBlock<SlabBlock> AMETHYST_BLOCK_SLAB;
    public static final DeferredBlock<WallBlock> AMETHYST_BLOCK_WALL;
    public static final DeferredBlock<StairBlock> CRACKED_STONE_BRICK_STAIRS;
    public static final DeferredBlock<SlabBlock> CRACKED_STONE_BRICK_SLAB;
    public static final DeferredBlock<WallBlock> CRACKED_STONE_BRICK_WALL;
    public static final DeferredBlock<StairBlock> OAK_LOG_STAIRS;
    public static final DeferredBlock<SlabBlock> OAK_LOG_SLAB;
    public static final DeferredBlock<StairBlock> SPRUCE_LOG_STAIRS;
    public static final DeferredBlock<SlabBlock> SPRUCE_LOG_SLAB;
    public static final DeferredBlock<StairBlock> BIRCH_LOG_STAIRS;
    public static final DeferredBlock<SlabBlock> BIRCH_LOG_SLAB;
    public static final DeferredBlock<StairBlock> JUNGLE_LOG_STAIRS;
    public static final DeferredBlock<SlabBlock> JUNGLE_LOG_SLAB;
    public static final DeferredBlock<StairBlock> ACACIA_LOG_STAIRS;
    public static final DeferredBlock<SlabBlock> ACACIA_LOG_SLAB;
    public static final DeferredBlock<StairBlock> DARK_OAK_LOG_STAIRS;
    public static final DeferredBlock<SlabBlock> DARK_OAK_LOG_SLAB;
    public static final DeferredBlock<StairBlock> MANGROVE_LOG_STAIRS;
    public static final DeferredBlock<SlabBlock> MANGROVE_LOG_SLAB;
    public static final DeferredBlock<StairBlock> CHERRY_LOG_STAIRS;
    public static final DeferredBlock<SlabBlock> CHERRY_LOG_SLAB;
    public static final DeferredBlock<StairBlock> PALE_OAK_LOG_STAIRS;
    public static final DeferredBlock<SlabBlock> PALE_OAK_LOG_SLAB;
    public static final DeferredBlock<StairBlock> STRIPPED_OAK_LOG_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_OAK_LOG_SLAB;
    public static final DeferredBlock<StairBlock> STRIPPED_SPRUCE_LOG_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_SPRUCE_LOG_SLAB;
    public static final DeferredBlock<StairBlock> STRIPPED_BIRCH_LOG_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_BIRCH_LOG_SLAB;
    public static final DeferredBlock<StairBlock> STRIPPED_JUNGLE_LOG_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_JUNGLE_LOG_SLAB;
    public static final DeferredBlock<StairBlock> STRIPPED_ACACIA_LOG_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_ACACIA_LOG_SLAB;
    public static final DeferredBlock<StairBlock> STRIPPED_DARK_OAK_LOG_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_DARK_OAK_LOG_SLAB;
    public static final DeferredBlock<StairBlock> STRIPPED_MANGROVE_LOG_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_MANGROVE_LOG_SLAB;
    public static final DeferredBlock<StairBlock> STRIPPED_CHERRY_LOG_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_CHERRY_LOG_SLAB;
    public static final DeferredBlock<StairBlock> STRIPPED_PALE_OAK_LOG_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_PALE_OAK_LOG_SLAB;
    public static final DeferredBlock<StairBlock> CRIMSON_STEM_STAIRS;
    public static final DeferredBlock<SlabBlock> CRIMSON_STEM_SLAB;
    public static final DeferredBlock<StairBlock> WARPED_STEM_STAIRS;
    public static final DeferredBlock<SlabBlock> WARPED_STEM_SLAB;
    public static final DeferredBlock<StairBlock> STRIPPED_CRIMSON_STEM_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_CRIMSON_STEM_SLAB;
    public static final DeferredBlock<StairBlock> STRIPPED_WARPED_STEM_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_WARPED_STEM_SLAB;
    public static final DeferredBlock<StairBlock> OAK_WOOD_STAIRS;
    public static final DeferredBlock<SlabBlock> OAK_WOOD_SLAB;
    public static final DeferredBlock<WallBlock> OAK_WOOD_WALL;
    public static final DeferredBlock<FenceBlock> OAK_WOOD_FENCE;
    public static final DeferredBlock<FenceGateBlock> OAK_WOOD_FENCE_GATE;
    public static final DeferredBlock<StairBlock> SPRUCE_WOOD_STAIRS;
    public static final DeferredBlock<SlabBlock> SPRUCE_WOOD_SLAB;
    public static final DeferredBlock<WallBlock> SPRUCE_WOOD_WALL;
    public static final DeferredBlock<FenceBlock> SPRUCE_WOOD_FENCE;
    public static final DeferredBlock<FenceGateBlock> SPRUCE_WOOD_FENCE_GATE;
    public static final DeferredBlock<StairBlock> BIRCH_WOOD_STAIRS;
    public static final DeferredBlock<SlabBlock> BIRCH_WOOD_SLAB;
    public static final DeferredBlock<WallBlock> BIRCH_WOOD_WALL;
    public static final DeferredBlock<FenceBlock> BIRCH_WOOD_FENCE;
    public static final DeferredBlock<FenceGateBlock> BIRCH_WOOD_FENCE_GATE;
    public static final DeferredBlock<StairBlock> JUNGLE_WOOD_STAIRS;
    public static final DeferredBlock<SlabBlock> JUNGLE_WOOD_SLAB;
    public static final DeferredBlock<WallBlock> JUNGLE_WOOD_WALL;
    public static final DeferredBlock<FenceBlock> JUNGLE_WOOD_FENCE;
    public static final DeferredBlock<FenceGateBlock> JUNGLE_WOOD_FENCE_GATE;
    public static final DeferredBlock<StairBlock> ACACIA_WOOD_STAIRS;
    public static final DeferredBlock<SlabBlock> ACACIA_WOOD_SLAB;
    public static final DeferredBlock<WallBlock> ACACIA_WOOD_WALL;
    public static final DeferredBlock<FenceBlock> ACACIA_WOOD_FENCE;
    public static final DeferredBlock<FenceGateBlock> ACACIA_WOOD_FENCE_GATE;
    public static final DeferredBlock<StairBlock> DARK_OAK_WOOD_STAIRS;
    public static final DeferredBlock<SlabBlock> DARK_OAK_WOOD_SLAB;
    public static final DeferredBlock<WallBlock> DARK_OAK_WOOD_WALL;
    public static final DeferredBlock<FenceBlock> DARK_OAK_WOOD_FENCE;
    public static final DeferredBlock<FenceGateBlock> DARK_OAK_WOOD_FENCE_GATE;
    public static final DeferredBlock<StairBlock> MANGROVE_WOOD_STAIRS;
    public static final DeferredBlock<SlabBlock> MANGROVE_WOOD_SLAB;
    public static final DeferredBlock<WallBlock> MANGROVE_WOOD_WALL;
    public static final DeferredBlock<FenceBlock> MANGROVE_WOOD_FENCE;
    public static final DeferredBlock<FenceGateBlock> MANGROVE_WOOD_FENCE_GATE;
    public static final DeferredBlock<StairBlock> CHERRY_WOOD_STAIRS;
    public static final DeferredBlock<SlabBlock> CHERRY_WOOD_SLAB;
    public static final DeferredBlock<WallBlock> CHERRY_WOOD_WALL;
    public static final DeferredBlock<FenceBlock> CHERRY_WOOD_FENCE;
    public static final DeferredBlock<FenceGateBlock> CHERRY_WOOD_FENCE_GATE;
    public static final DeferredBlock<StairBlock> PALE_OAK_WOOD_STAIRS;
    public static final DeferredBlock<SlabBlock> PALE_OAK_WOOD_SLAB;
    public static final DeferredBlock<WallBlock> PALE_OAK_WOOD_WALL;
    public static final DeferredBlock<FenceBlock> PALE_OAK_WOOD_FENCE;
    public static final DeferredBlock<FenceGateBlock> PALE_OAK_WOOD_FENCE_GATE;
    public static final DeferredBlock<StairBlock> BAMBOO_BLOCK_STAIRS;
    public static final DeferredBlock<SlabBlock> BAMBOO_BLOCK_SLAB;
    public static final DeferredBlock<WallBlock> BAMBOO_BLOCK_WALL;
    public static final DeferredBlock<FenceBlock> BAMBOO_BLOCK_FENCE;
    public static final DeferredBlock<FenceGateBlock> BAMBOO_BLOCK_FENCE_GATE;
    public static final DeferredBlock<StairBlock> STRIPPED_OAK_WOOD_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_OAK_WOOD_SLAB;
    public static final DeferredBlock<WallBlock> STRIPPED_OAK_WOOD_WALL;
    public static final DeferredBlock<FenceBlock> STRIPPED_OAK_WOOD_FENCE;
    public static final DeferredBlock<FenceGateBlock> STRIPPED_OAK_WOOD_FENCE_GATE;
    public static final DeferredBlock<StairBlock> STRIPPED_SPRUCE_WOOD_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_SPRUCE_WOOD_SLAB;
    public static final DeferredBlock<WallBlock> STRIPPED_SPRUCE_WOOD_WALL;
    public static final DeferredBlock<FenceBlock> STRIPPED_SPRUCE_WOOD_FENCE;
    public static final DeferredBlock<FenceGateBlock> STRIPPED_SPRUCE_WOOD_FENCE_GATE;
    public static final DeferredBlock<StairBlock> STRIPPED_BIRCH_WOOD_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_BIRCH_WOOD_SLAB;
    public static final DeferredBlock<WallBlock> STRIPPED_BIRCH_WOOD_WALL;
    public static final DeferredBlock<FenceBlock> STRIPPED_BIRCH_WOOD_FENCE;
    public static final DeferredBlock<FenceGateBlock> STRIPPED_BIRCH_WOOD_FENCE_GATE;
    public static final DeferredBlock<StairBlock> STRIPPED_JUNGLE_WOOD_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_JUNGLE_WOOD_SLAB;
    public static final DeferredBlock<WallBlock> STRIPPED_JUNGLE_WOOD_WALL;
    public static final DeferredBlock<FenceBlock> STRIPPED_JUNGLE_WOOD_FENCE;
    public static final DeferredBlock<FenceGateBlock> STRIPPED_JUNGLE_WOOD_FENCE_GATE;
    public static final DeferredBlock<StairBlock> STRIPPED_ACACIA_WOOD_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_ACACIA_WOOD_SLAB;
    public static final DeferredBlock<WallBlock> STRIPPED_ACACIA_WOOD_WALL;
    public static final DeferredBlock<FenceBlock> STRIPPED_ACACIA_WOOD_FENCE;
    public static final DeferredBlock<FenceGateBlock> STRIPPED_ACACIA_WOOD_FENCE_GATE;
    public static final DeferredBlock<StairBlock> STRIPPED_DARK_OAK_WOOD_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_DARK_OAK_WOOD_SLAB;
    public static final DeferredBlock<WallBlock> STRIPPED_DARK_OAK_WOOD_WALL;
    public static final DeferredBlock<FenceBlock> STRIPPED_DARK_OAK_WOOD_FENCE;
    public static final DeferredBlock<FenceGateBlock> STRIPPED_DARK_OAK_WOOD_FENCE_GATE;
    public static final DeferredBlock<StairBlock> STRIPPED_MANGROVE_WOOD_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_MANGROVE_WOOD_SLAB;
    public static final DeferredBlock<WallBlock> STRIPPED_MANGROVE_WOOD_WALL;
    public static final DeferredBlock<FenceBlock> STRIPPED_MANGROVE_WOOD_FENCE;
    public static final DeferredBlock<FenceGateBlock> STRIPPED_MANGROVE_WOOD_FENCE_GATE;
    public static final DeferredBlock<StairBlock> STRIPPED_CHERRY_WOOD_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_CHERRY_WOOD_SLAB;
    public static final DeferredBlock<WallBlock> STRIPPED_CHERRY_WOOD_WALL;
    public static final DeferredBlock<FenceBlock> STRIPPED_CHERRY_WOOD_FENCE;
    public static final DeferredBlock<FenceGateBlock> STRIPPED_CHERRY_WOOD_FENCE_GATE;
    public static final DeferredBlock<StairBlock> STRIPPED_PALE_OAK_WOOD_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_PALE_OAK_WOOD_SLAB;
    public static final DeferredBlock<WallBlock> STRIPPED_PALE_OAK_WOOD_WALL;
    public static final DeferredBlock<FenceBlock> STRIPPED_PALE_OAK_WOOD_FENCE;
    public static final DeferredBlock<FenceGateBlock> STRIPPED_PALE_OAK_WOOD_FENCE_GATE;
    public static final DeferredBlock<StairBlock> STRIPPED_BAMBOO_BLOCK_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_BAMBOO_BLOCK_SLAB;
    public static final DeferredBlock<WallBlock> STRIPPED_BAMBOO_BLOCK_WALL;
    public static final DeferredBlock<FenceBlock> STRIPPED_BAMBOO_BLOCK_FENCE;
    public static final DeferredBlock<FenceGateBlock> STRIPPED_BAMBOO_BLOCK_FENCE_GATE;
    public static final DeferredBlock<StairBlock> CRIMSON_HYPHAE_STAIRS;
    public static final DeferredBlock<SlabBlock> CRIMSON_HYPHAE_SLAB;
    public static final DeferredBlock<WallBlock> CRIMSON_HYPHAE_WALL;
    public static final DeferredBlock<FenceBlock> CRIMSON_HYPHAE_FENCE;
    public static final DeferredBlock<FenceGateBlock> CRIMSON_HYPHAE_FENCE_GATE;
    public static final DeferredBlock<StairBlock> WARPED_HYPHAE_STAIRS;
    public static final DeferredBlock<SlabBlock> WARPED_HYPHAE_SLAB;
    public static final DeferredBlock<WallBlock> WARPED_HYPHAE_WALL;
    public static final DeferredBlock<FenceBlock> WARPED_HYPHAE_FENCE;
    public static final DeferredBlock<FenceGateBlock> WARPED_HYPHAE_FENCE_GATE;
    public static final DeferredBlock<StairBlock> STRIPPED_CRIMSON_HYPHAE_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_CRIMSON_HYPHAE_SLAB;
    public static final DeferredBlock<WallBlock> STRIPPED_CRIMSON_HYPHAE_WALL;
    public static final DeferredBlock<FenceBlock> STRIPPED_CRIMSON_HYPHAE_FENCE;
    public static final DeferredBlock<FenceGateBlock> STRIPPED_CRIMSON_HYPHAE_FENCE_GATE;
    public static final DeferredBlock<StairBlock> STRIPPED_WARPED_HYPHAE_STAIRS;
    public static final DeferredBlock<SlabBlock> STRIPPED_WARPED_HYPHAE_SLAB;
    public static final DeferredBlock<WallBlock> STRIPPED_WARPED_HYPHAE_WALL;
    public static final DeferredBlock<FenceBlock> STRIPPED_WARPED_HYPHAE_FENCE;
    public static final DeferredBlock<FenceGateBlock> STRIPPED_WARPED_HYPHAE_FENCE_GATE;
    public static final DeferredBlock<StairBlock> CALCITE_STAIRS;
    public static final DeferredBlock<SlabBlock> CALCITE_SLAB;
    public static final DeferredBlock<WallBlock> CALCITE_WALL;
    public static final DeferredBlock<StairBlock> SMOOTH_BASALT_STAIRS;
    public static final DeferredBlock<SlabBlock> SMOOTH_BASALT_SLAB;
    public static final DeferredBlock<WallBlock> SMOOTH_BASALT_WALL;
    public static final DeferredBlock<StairBlock> DEEPSLATE_STAIRS;
    public static final DeferredBlock<SlabBlock> DEEPSLATE_SLAB;
    public static final DeferredBlock<WallBlock> DEEPSLATE_WALL;
    public static final DeferredBlock<StairBlock> CRACKED_DEEPSLATE_BRICK_STAIRS;
    public static final DeferredBlock<SlabBlock> CRACKED_DEEPSLATE_BRICK_SLAB;
    public static final DeferredBlock<WallBlock> CRACKED_DEEPSLATE_BRICK_WALL;
    public static final DeferredBlock<StairBlock> CRACKED_DEEPSLATE_TILE_STAIRS;
    public static final DeferredBlock<SlabBlock> CRACKED_DEEPSLATE_TILE_SLAB;
    public static final DeferredBlock<WallBlock> CRACKED_DEEPSLATE_TILE_WALL;
    public static final DeferredBlock<FenceGateBlock> NETHER_BRICK_FENCE_GATE;
    public static final DeferredBlock<StairBlock> CRACKED_NETHER_BRICK_STAIRS;
    public static final DeferredBlock<SlabBlock> CRACKED_NETHER_BRICK_SLAB;
    public static final DeferredBlock<WallBlock> CRACKED_NETHER_BRICK_WALL;
    public static final DeferredBlock<FenceBlock> CRACKED_NETHER_BRICK_FENCE;
    public static final DeferredBlock<FenceGateBlock> CRACKED_NETHER_BRICK_FENCE_GATE;
    public static final DeferredBlock<FenceBlock> RED_NETHER_BRICK_FENCE;
    public static final DeferredBlock<FenceGateBlock> RED_NETHER_BRICK_FENCE_GATE;
    public static final DeferredBlock<StairBlock> OBSIDIAN_STAIRS;
    public static final DeferredBlock<SlabBlock> OBSIDIAN_SLAB;
    public static final DeferredBlock<WallBlock> OBSIDIAN_WALL;
    public static final DeferredBlock<StairBlock> CRYING_OBSIDIAN_STAIRS;
    public static final DeferredBlock<SlabBlock> CRYING_OBSIDIAN_SLAB;
    public static final DeferredBlock<WallBlock> CRYING_OBSIDIAN_WALL;
    public static final DeferredBlock<StairBlock> WHITE_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> WHITE_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> WHITE_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> ORANGE_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> ORANGE_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> ORANGE_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> MAGENTA_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> MAGENTA_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> MAGENTA_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> LIGHT_BLUE_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> LIGHT_BLUE_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> LIGHT_BLUE_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> YELLOW_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> YELLOW_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> YELLOW_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> LIME_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> LIME_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> LIME_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> PINK_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> PINK_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> PINK_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> GRAY_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> GRAY_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> GRAY_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> LIGHT_GRAY_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> LIGHT_GRAY_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> LIGHT_GRAY_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> CYAN_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> CYAN_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> CYAN_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> PURPLE_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> PURPLE_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> PURPLE_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> BLUE_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> BLUE_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> BLUE_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> BROWN_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> BROWN_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> BROWN_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> GREEN_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> GREEN_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> GREEN_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> RED_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> RED_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> RED_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> BLACK_GLAZED_TERRACOTTA_STAIRS;
    public static final DeferredBlock<SlabBlock> BLACK_GLAZED_TERRACOTTA_SLAB;
    public static final DeferredBlock<WallBlock> BLACK_GLAZED_TERRACOTTA_WALL;
    public static final DeferredBlock<StairBlock> WHITE_WOOL_STAIRS;
    public static final DeferredBlock<SlabBlock> WHITE_WOOL_SLAB;
    public static final DeferredBlock<WallBlock> WHITE_WOOL_WALL;
    public static final DeferredBlock<StairBlock> ORANGE_WOOL_STAIRS;
    public static final DeferredBlock<SlabBlock> ORANGE_WOOL_SLAB;
    public static final DeferredBlock<WallBlock> ORANGE_WOOL_WALL;
    public static final DeferredBlock<StairBlock> MAGENTA_WOOL_STAIRS;
    public static final DeferredBlock<SlabBlock> MAGENTA_WOOL_SLAB;
    public static final DeferredBlock<WallBlock> MAGENTA_WOOL_WALL;
    public static final DeferredBlock<StairBlock> LIGHT_BLUE_WOOL_STAIRS;
    public static final DeferredBlock<SlabBlock> LIGHT_BLUE_WOOL_SLAB;
    public static final DeferredBlock<WallBlock> LIGHT_BLUE_WOOL_WALL;
    public static final DeferredBlock<StairBlock> YELLOW_WOOL_STAIRS;
    public static final DeferredBlock<SlabBlock> YELLOW_WOOL_SLAB;
    public static final DeferredBlock<WallBlock> YELLOW_WOOL_WALL;
    public static final DeferredBlock<StairBlock> LIME_WOOL_STAIRS;
    public static final DeferredBlock<SlabBlock> LIME_WOOL_SLAB;
    public static final DeferredBlock<WallBlock> LIME_WOOL_WALL;
    public static final DeferredBlock<StairBlock> PINK_WOOL_STAIRS;
    public static final DeferredBlock<SlabBlock> PINK_WOOL_SLAB;
    public static final DeferredBlock<WallBlock> PINK_WOOL_WALL;
    public static final DeferredBlock<StairBlock> GRAY_WOOL_STAIRS;
    public static final DeferredBlock<SlabBlock> GRAY_WOOL_SLAB;
    public static final DeferredBlock<WallBlock> GRAY_WOOL_WALL;
    public static final DeferredBlock<StairBlock> LIGHT_GRAY_WOOL_STAIRS;
    public static final DeferredBlock<SlabBlock> LIGHT_GRAY_WOOL_SLAB;
    public static final DeferredBlock<WallBlock> LIGHT_GRAY_WOOL_WALL;
    public static final DeferredBlock<StairBlock> CYAN_WOOL_STAIRS;
    public static final DeferredBlock<SlabBlock> CYAN_WOOL_SLAB;
    public static final DeferredBlock<WallBlock> CYAN_WOOL_WALL;
    public static final DeferredBlock<StairBlock> PURPLE_WOOL_STAIRS;
    public static final DeferredBlock<SlabBlock> PURPLE_WOOL_SLAB;
    public static final DeferredBlock<WallBlock> PURPLE_WOOL_WALL;
    public static final DeferredBlock<StairBlock> BLUE_WOOL_STAIRS;
    public static final DeferredBlock<SlabBlock> BLUE_WOOL_SLAB;
    public static final DeferredBlock<WallBlock> BLUE_WOOL_WALL;
    public static final DeferredBlock<StairBlock> BROWN_WOOL_STAIRS;
    public static final DeferredBlock<SlabBlock> BROWN_WOOL_SLAB;
    public static final DeferredBlock<WallBlock> BROWN_WOOL_WALL;
    public static final DeferredBlock<StairBlock> GREEN_WOOL_STAIRS;
    public static final DeferredBlock<SlabBlock> GREEN_WOOL_SLAB;
    public static final DeferredBlock<WallBlock> GREEN_WOOL_WALL;
    public static final DeferredBlock<StairBlock> RED_WOOL_STAIRS;
    public static final DeferredBlock<SlabBlock> RED_WOOL_SLAB;
    public static final DeferredBlock<WallBlock> RED_WOOL_WALL;
    public static final DeferredBlock<StairBlock> BLACK_WOOL_STAIRS;
    public static final DeferredBlock<SlabBlock> BLACK_WOOL_SLAB;
    public static final DeferredBlock<WallBlock> BLACK_WOOL_WALL;
    public static final DeferredBlock<StairBlock> PACKED_MUD_STAIRS;
    public static final DeferredBlock<SlabBlock> PACKED_MUD_SLAB;
    public static final DeferredBlock<WallBlock> PACKED_MUD_WALL;

    private static DeferredBlock<StairBlock> regTerracottaStairs(DyeColor color, Block base) {
        return BVBlocks.register(color.getName() + "_terracotta_stairs", (BlockBehaviour.Properties prop) -> new StairBlock(base.defaultBlockState(), prop), BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)base));
    }

    private static DeferredBlock<SlabBlock> regTerracottaSlab(DyeColor color) {
        return BVBlocks.register(color.getName() + "_terracotta_slab", SlabBlock::new, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.TERRACOTTA));
    }

    private static DeferredBlock<WallBlock> regTerracottaWall(DyeColor color) {
        return BVBlocks.register(color.getName() + "_terracotta_wall", WallBlock::new, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.TERRACOTTA));
    }

    private static DeferredBlock<StairBlock> logStairs(String type, Block base) {
        return BVBlocks.register(type + "_log_stairs", (BlockBehaviour.Properties prop) -> new StairBlock(base.defaultBlockState(), prop), BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)base));
    }

    private static DeferredBlock<SlabBlock> logSlab(String type, Block base) {
        return BVBlocks.register(type + "_log_slab", SlabBlock::new, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)base));
    }

    private static DeferredBlock<StairBlock> woodStairs(String type, Block base) {
        return BVBlocks.register(type + "_wood_stairs", (BlockBehaviour.Properties prop) -> new StairBlock(base.defaultBlockState(), prop), BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)base));
    }

    private static DeferredBlock<SlabBlock> woodSlab(String type, Block base) {
        return BVBlocks.register(type + "_wood_slab", SlabBlock::new, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)base));
    }

    private static DeferredBlock<WallBlock> woodWall(String type, Block base) {
        return BVBlocks.register(type + "_wood_wall", WallBlock::new, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)base));
    }

    private static DeferredBlock<FenceBlock> woodFence(String type, Block base) {
        return BVBlocks.register(type + "_wood_fence", FenceBlock::new, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)base));
    }

    private static DeferredBlock<FenceGateBlock> woodFenceGate(String type, Block base) {
        return BVBlocks.register(type + "_wood_fence_gate", (BlockBehaviour.Properties prop) -> new FenceGateBlock(BVBlocks.woodTypeOf(type), prop), BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)base));
    }

    private static DeferredBlock<StairBlock> regGlazedTerracottaStairs(DyeColor color) {
        Block parent = BVBlocks.getVanillaBlock(color.getName() + "_glazed_terracotta");
        return BVBlocks.register(color.getName() + "_glazed_terracotta_stairs", (BlockBehaviour.Properties prop) -> new StairBlock(parent.defaultBlockState(), prop), parent);
    }

    private static DeferredBlock<SlabBlock> regGlazedTerracottaSlab(DyeColor color) {
        Block parent = BVBlocks.getVanillaBlock(color.getName() + "_glazed_terracotta");
        return BVBlocks.register(color.getName() + "_glazed_terracotta_slab", SlabBlock::new, parent);
    }

    private static DeferredBlock<WallBlock> regGlazedTerracottaWall(DyeColor color) {
        Block parent = BVBlocks.getVanillaBlock(color.getName() + "_glazed_terracotta");
        return BVBlocks.register(color.getName() + "_glazed_terracotta_wall", WallBlock::new, parent);
    }

    private static DeferredBlock<StairBlock> regWoolStairs(DyeColor color) {
        Block parent = BVBlocks.getVanillaBlock(color.getName() + "_wool");
        return BVBlocks.register(color.getName() + "_wool_stairs", (BlockBehaviour.Properties prop) -> new StairBlock(parent.defaultBlockState(), prop), parent);
    }

    private static DeferredBlock<SlabBlock> regWoolSlab(DyeColor color) {
        Block parent = BVBlocks.getVanillaBlock(color.getName() + "_wool");
        return BVBlocks.register(color.getName() + "_wool_slab", SlabBlock::new, parent);
    }

    private static DeferredBlock<WallBlock> regWoolWall(DyeColor color) {
        Block parent = BVBlocks.getVanillaBlock(color.getName() + "_wool");
        return BVBlocks.register(color.getName() + "_wool_wall", WallBlock::new, parent);
    }

    private static WoodType woodTypeOf(String key) {
        key = key.replace("stripped_", "");
        Iterator iterator = WoodType.values().iterator();
        while (iterator.hasNext()) {
            WoodType type = (WoodType)iterator.next();
            if (!type.name().contains(key)) continue;
            return type;
        }
        throw new IllegalArgumentException("No wood type with key: " + key);
    }

    private static Block getVanillaBlock(String name) {
        return (Block)((Holder.Reference)BuiltInRegistries.BLOCK.get(ResourceLocation.withDefaultNamespace((String)name)).orElseThrow()).value();
    }

    private static <T extends Block> DeferredBlock<T> register(String name, BiFunction<BlockState, BlockBehaviour.Properties, T> block, Block base) {
        return BVBlocks.register(name, (BlockBehaviour.Properties prop) -> (Block)block.apply(base.defaultBlockState(), (BlockBehaviour.Properties)prop), BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)base));
    }

    private static <T extends Block> DeferredBlock<T> register(String name, Function<BlockBehaviour.Properties, T> block, Block base) {
        return BVBlocks.register(name, block, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)base));
    }

    private static <T extends Block> DeferredBlock<T> register(String name, Function<BlockBehaviour.Properties, T> block, BlockBehaviour.Properties properties) {
        return BVBlocks.register(name, block, properties, DEFAULT_ITEM_PROPERTIES);
    }

    private static <T extends Block> DeferredBlock<T> register(String name, Function<BlockBehaviour.Properties, T> block, BlockBehaviour.Properties properties, Item.Properties itemProperties) {
        DeferredBlock<T> registryObject = BVBlocks.registerWithoutItem(name, block, properties);
        BVItems.REGISTER.registerSimpleBlockItem(registryObject, itemProperties);
        return registryObject;
    }

    private static <T extends Block> DeferredBlock<T> registerWithoutItem(String name, Function<BlockBehaviour.Properties, T> block, BlockBehaviour.Properties properties) {
        return REGISTER.registerBlock(name, block, properties);
    }

    public static Stream<? extends Block> getAllBlocks() {
        return REGISTER.getEntries().stream().map(Supplier::get);
    }

    static {
        REGISTER.addAlias(BlockVariants.locate("tuff_stairs"), BVUtil.getBlockID(Blocks.TUFF_STAIRS));
        REGISTER.addAlias(BlockVariants.locate("tuff_slab"), BVUtil.getBlockID(Blocks.TUFF_SLAB));
        REGISTER.addAlias(BlockVariants.locate("tuff_wall"), BVUtil.getBlockID(Blocks.TUFF_WALL));
        POLISHED_GRANITE_WALL = BVBlocks.register("polished_granite_wall", WallBlock::new, Blocks.POLISHED_GRANITE);
        POLISHED_DIORITE_WALL = BVBlocks.register("polished_diorite_wall", WallBlock::new, Blocks.POLISHED_DIORITE);
        POLISHED_ANDESITE_WALL = BVBlocks.register("polished_andesite_wall", WallBlock::new, Blocks.POLISHED_ANDESITE);
        STONE_WALL = BVBlocks.register("stone_wall", WallBlock::new, Blocks.STONE);
        SMOOTH_STONE_STAIRS = BVBlocks.register("smooth_stone_stairs", StairBlock::new, Blocks.SMOOTH_STONE);
        SMOOTH_STONE_WALL = BVBlocks.register("smooth_stone_wall", WallBlock::new, Blocks.SMOOTH_STONE);
        CUT_SANDSTONE_STAIRS = BVBlocks.register("cut_sandstone_stairs", StairBlock::new, Blocks.CUT_SANDSTONE);
        CUT_SANDSTONE_WALL = BVBlocks.register("cut_sandstone_wall", WallBlock::new, Blocks.CUT_SANDSTONE);
        CUT_RED_SANDSTONE_STAIRS = BVBlocks.register("cut_red_sandstone_stairs", StairBlock::new, Blocks.CUT_RED_SANDSTONE);
        CUT_RED_SANDSTONE_WALL = BVBlocks.register("cut_red_sandstone_wall", WallBlock::new, Blocks.CUT_RED_SANDSTONE);
        QUARTZ_WALL = BVBlocks.register("quartz_wall", WallBlock::new, Blocks.QUARTZ_BLOCK);
        QUARTZ_BRICK_STAIRS = BVBlocks.register("quartz_brick_stairs", StairBlock::new, Blocks.QUARTZ_BRICKS);
        QUARTZ_BRICK_SLAB = BVBlocks.register("quartz_brick_slab", SlabBlock::new, Blocks.QUARTZ_BRICKS);
        QUARTZ_BRICK_WALL = BVBlocks.register("quartz_brick_wall", WallBlock::new, Blocks.QUARTZ_BRICKS);
        SMOOTH_QUARTZ_WALL = BVBlocks.register("smooth_quartz_wall", WallBlock::new, Blocks.SMOOTH_QUARTZ);
        CHISELED_QUARTZ_BLOCK_STAIRS = BVBlocks.register("chiseled_quartz_block_stairs", StairBlock::new, Blocks.CHISELED_QUARTZ_BLOCK);
        CHISELED_QUARTZ_BLOCK_SLAB = BVBlocks.register("chiseled_quartz_block_slab", SlabBlock::new, Blocks.CHISELED_QUARTZ_BLOCK);
        CHISELED_QUARTZ_BLOCK_WALL = BVBlocks.register("chiseled_quartz_block_wall", WallBlock::new, Blocks.CHISELED_QUARTZ_BLOCK);
        PRISMARINE_BRICK_WALL = BVBlocks.register("prismarine_brick_wall", WallBlock::new, Blocks.PRISMARINE_BRICKS);
        DARK_PRISMARINE_WALL = BVBlocks.register("dark_prismarine_wall", WallBlock::new, Blocks.PRISMARINE_BRICKS);
        NETHERRACK_STAIRS = BVBlocks.register("netherrack_stairs", StairBlock::new, Blocks.NETHERRACK);
        NETHERRACK_SLAB = BVBlocks.register("netherrack_slab", SlabBlock::new, Blocks.NETHERRACK);
        NETHERRACK_WALL = BVBlocks.register("netherrack_wall", WallBlock::new, Blocks.NETHERRACK);
        END_STONE_STAIRS = BVBlocks.register("end_stone_stairs", StairBlock::new, Blocks.END_STONE);
        END_STONE_SLAB = BVBlocks.register("end_stone_slab", SlabBlock::new, Blocks.END_STONE);
        END_STONE_WALL = BVBlocks.register("end_stone_wall", WallBlock::new, Blocks.END_STONE);
        PURPUR_WALL = BVBlocks.register("purpur_wall", WallBlock::new, Blocks.PURPUR_BLOCK);
        CRACKED_POLISHED_BLACKSTONE_BRICK_STAIRS = BVBlocks.register("cracked_polished_blackstone_brick_stairs", StairBlock::new, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS);
        CRACKED_POLISHED_BLACKSTONE_BRICK_SLAB = BVBlocks.register("cracked_polished_blackstone_brick_slab", SlabBlock::new, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS);
        CRACKED_POLISHED_BLACKSTONE_BRICK_WALL = BVBlocks.register("cracked_polished_blackstone_brick_wall", WallBlock::new, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS);
        BASALT_STAIRS = BVBlocks.register("basalt_stairs", StairBlock::new, Blocks.BASALT);
        BASALT_SLAB = BVBlocks.register("basalt_slab", SlabBlock::new, Blocks.BASALT);
        BASALT_WALL = BVBlocks.register("basalt_wall", WallBlock::new, Blocks.BASALT);
        POLISHED_BASALT_STAIRS = BVBlocks.register("polished_basalt_stairs", StairBlock::new, Blocks.POLISHED_BASALT);
        POLISHED_BASALT_SLAB = BVBlocks.register("polished_basalt_slab", SlabBlock::new, Blocks.POLISHED_BASALT);
        POLISHED_BASALT_WALL = BVBlocks.register("polished_basalt_wall", WallBlock::new, Blocks.POLISHED_BASALT);
        TERRACOTTA_STAIRS = BVBlocks.register("terracotta_stairs", StairBlock::new, Blocks.TERRACOTTA);
        TERRACOTTA_SLAB = BVBlocks.register("terracotta_slab", SlabBlock::new, Blocks.TERRACOTTA);
        TERRACOTTA_WALL = BVBlocks.register("terracotta_wall", WallBlock::new, Blocks.TERRACOTTA);
        WHITE_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.WHITE, Blocks.WHITE_TERRACOTTA);
        WHITE_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.WHITE);
        WHITE_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.WHITE);
        ORANGE_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.ORANGE, Blocks.ORANGE_TERRACOTTA);
        ORANGE_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.ORANGE);
        ORANGE_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.ORANGE);
        MAGENTA_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.MAGENTA, Blocks.MAGENTA_TERRACOTTA);
        MAGENTA_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.MAGENTA);
        MAGENTA_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.MAGENTA);
        LIGHT_BLUE_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.LIGHT_BLUE, Blocks.LIGHT_BLUE_TERRACOTTA);
        LIGHT_BLUE_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.LIGHT_BLUE);
        LIGHT_BLUE_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.LIGHT_BLUE);
        YELLOW_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.YELLOW, Blocks.YELLOW_TERRACOTTA);
        YELLOW_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.YELLOW);
        YELLOW_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.YELLOW);
        LIME_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.LIME, Blocks.LIME_TERRACOTTA);
        LIME_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.LIME);
        LIME_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.LIME);
        PINK_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.PINK, Blocks.PINK_TERRACOTTA);
        PINK_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.PINK);
        PINK_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.PINK);
        GRAY_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.GRAY, Blocks.GRAY_TERRACOTTA);
        GRAY_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.GRAY);
        GRAY_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.GRAY);
        LIGHT_GRAY_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.LIGHT_GRAY, Blocks.LIGHT_GRAY_TERRACOTTA);
        LIGHT_GRAY_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.LIGHT_GRAY);
        LIGHT_GRAY_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.LIGHT_GRAY);
        CYAN_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.CYAN, Blocks.CYAN_TERRACOTTA);
        CYAN_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.CYAN);
        CYAN_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.CYAN);
        PURPLE_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.PURPLE, Blocks.PURPLE_TERRACOTTA);
        PURPLE_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.PURPLE);
        PURPLE_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.PURPLE);
        BLUE_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.BLUE, Blocks.BLUE_TERRACOTTA);
        BLUE_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.BLUE);
        BLUE_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.BLUE);
        BROWN_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.BROWN, Blocks.BROWN_TERRACOTTA);
        BROWN_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.BROWN);
        BROWN_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.BROWN);
        GREEN_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.GREEN, Blocks.GREEN_TERRACOTTA);
        GREEN_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.GREEN);
        GREEN_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.GREEN);
        RED_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.RED, Blocks.RED_TERRACOTTA);
        RED_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.RED);
        RED_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.RED);
        BLACK_TERRACOTTA_STAIRS = BVBlocks.regTerracottaStairs(DyeColor.BLACK, Blocks.BLACK_TERRACOTTA);
        BLACK_TERRACOTTA_SLAB = BVBlocks.regTerracottaSlab(DyeColor.BLACK);
        BLACK_TERRACOTTA_WALL = BVBlocks.regTerracottaWall(DyeColor.BLACK);
        DRIPSTONE_BLOCK_STAIRS = BVBlocks.register("dripstone_block_stairs", StairBlock::new, Blocks.DRIPSTONE_BLOCK);
        DRIPSTONE_BLOCK_SLAB = BVBlocks.register("dripstone_block_slab", SlabBlock::new, Blocks.DRIPSTONE_BLOCK);
        DRIPSTONE_BLOCK_WALL = BVBlocks.register("dripstone_block_wall", WallBlock::new, Blocks.DRIPSTONE_BLOCK);
        AMETHYST_BLOCK_STAIRS = BVBlocks.register("amethyst_block_stairs", StairBlock::new, Blocks.AMETHYST_BLOCK);
        AMETHYST_BLOCK_SLAB = BVBlocks.register("amethyst_block_slab", SlabBlock::new, Blocks.AMETHYST_BLOCK);
        AMETHYST_BLOCK_WALL = BVBlocks.register("amethyst_block_wall", WallBlock::new, Blocks.AMETHYST_BLOCK);
        CRACKED_STONE_BRICK_STAIRS = BVBlocks.register("cracked_stone_brick_stairs", StairBlock::new, Blocks.CRACKED_STONE_BRICKS);
        CRACKED_STONE_BRICK_SLAB = BVBlocks.register("cracked_stone_brick_slab", SlabBlock::new, Blocks.CRACKED_STONE_BRICKS);
        CRACKED_STONE_BRICK_WALL = BVBlocks.register("cracked_stone_brick_wall", WallBlock::new, Blocks.CRACKED_STONE_BRICKS);
        OAK_LOG_STAIRS = BVBlocks.logStairs("oak", Blocks.OAK_WOOD);
        OAK_LOG_SLAB = BVBlocks.logSlab("oak", Blocks.OAK_WOOD);
        SPRUCE_LOG_STAIRS = BVBlocks.logStairs("spruce", Blocks.SPRUCE_WOOD);
        SPRUCE_LOG_SLAB = BVBlocks.logSlab("spruce", Blocks.SPRUCE_WOOD);
        BIRCH_LOG_STAIRS = BVBlocks.logStairs("birch", Blocks.BIRCH_WOOD);
        BIRCH_LOG_SLAB = BVBlocks.logSlab("birch", Blocks.BIRCH_WOOD);
        JUNGLE_LOG_STAIRS = BVBlocks.logStairs("jungle", Blocks.JUNGLE_WOOD);
        JUNGLE_LOG_SLAB = BVBlocks.logSlab("jungle", Blocks.JUNGLE_WOOD);
        ACACIA_LOG_STAIRS = BVBlocks.logStairs("acacia", Blocks.ACACIA_WOOD);
        ACACIA_LOG_SLAB = BVBlocks.logSlab("acacia", Blocks.ACACIA_WOOD);
        DARK_OAK_LOG_STAIRS = BVBlocks.logStairs("dark_oak", Blocks.DARK_OAK_WOOD);
        DARK_OAK_LOG_SLAB = BVBlocks.logSlab("dark_oak", Blocks.DARK_OAK_WOOD);
        MANGROVE_LOG_STAIRS = BVBlocks.logStairs("mangrove", Blocks.MANGROVE_WOOD);
        MANGROVE_LOG_SLAB = BVBlocks.logSlab("mangrove", Blocks.MANGROVE_WOOD);
        CHERRY_LOG_STAIRS = BVBlocks.logStairs("cherry", Blocks.CHERRY_WOOD);
        CHERRY_LOG_SLAB = BVBlocks.logSlab("cherry", Blocks.CHERRY_WOOD);
        PALE_OAK_LOG_STAIRS = BVBlocks.logStairs("pale_oak", Blocks.PALE_OAK_WOOD);
        PALE_OAK_LOG_SLAB = BVBlocks.logSlab("pale_oak", Blocks.PALE_OAK_WOOD);
        STRIPPED_OAK_LOG_STAIRS = BVBlocks.logStairs("stripped_oak", Blocks.STRIPPED_OAK_WOOD);
        STRIPPED_OAK_LOG_SLAB = BVBlocks.logSlab("stripped_oak", Blocks.STRIPPED_OAK_WOOD);
        STRIPPED_SPRUCE_LOG_STAIRS = BVBlocks.logStairs("stripped_spruce", Blocks.STRIPPED_SPRUCE_WOOD);
        STRIPPED_SPRUCE_LOG_SLAB = BVBlocks.logSlab("stripped_spruce", Blocks.STRIPPED_SPRUCE_WOOD);
        STRIPPED_BIRCH_LOG_STAIRS = BVBlocks.logStairs("stripped_birch", Blocks.STRIPPED_BIRCH_WOOD);
        STRIPPED_BIRCH_LOG_SLAB = BVBlocks.logSlab("stripped_birch", Blocks.STRIPPED_BIRCH_WOOD);
        STRIPPED_JUNGLE_LOG_STAIRS = BVBlocks.logStairs("stripped_jungle", Blocks.STRIPPED_JUNGLE_WOOD);
        STRIPPED_JUNGLE_LOG_SLAB = BVBlocks.logSlab("stripped_jungle", Blocks.STRIPPED_JUNGLE_WOOD);
        STRIPPED_ACACIA_LOG_STAIRS = BVBlocks.logStairs("stripped_acacia", Blocks.STRIPPED_ACACIA_WOOD);
        STRIPPED_ACACIA_LOG_SLAB = BVBlocks.logSlab("stripped_acacia", Blocks.STRIPPED_ACACIA_WOOD);
        STRIPPED_DARK_OAK_LOG_STAIRS = BVBlocks.logStairs("stripped_dark_oak", Blocks.STRIPPED_DARK_OAK_WOOD);
        STRIPPED_DARK_OAK_LOG_SLAB = BVBlocks.logSlab("stripped_dark_oak", Blocks.STRIPPED_DARK_OAK_WOOD);
        STRIPPED_MANGROVE_LOG_STAIRS = BVBlocks.logStairs("stripped_mangrove", Blocks.STRIPPED_DARK_OAK_WOOD);
        STRIPPED_MANGROVE_LOG_SLAB = BVBlocks.logSlab("stripped_mangrove", Blocks.STRIPPED_DARK_OAK_WOOD);
        STRIPPED_CHERRY_LOG_STAIRS = BVBlocks.logStairs("stripped_cherry", Blocks.STRIPPED_CHERRY_WOOD);
        STRIPPED_CHERRY_LOG_SLAB = BVBlocks.logSlab("stripped_cherry", Blocks.STRIPPED_CHERRY_WOOD);
        STRIPPED_PALE_OAK_LOG_STAIRS = BVBlocks.logStairs("stripped_pale_oak", Blocks.STRIPPED_PALE_OAK_WOOD);
        STRIPPED_PALE_OAK_LOG_SLAB = BVBlocks.logSlab("stripped_pale_oak", Blocks.STRIPPED_PALE_OAK_WOOD);
        CRIMSON_STEM_STAIRS = BVBlocks.register("crimson_stem_stairs", (BlockBehaviour.Properties prop) -> new StairBlock(Blocks.CRIMSON_STEM.defaultBlockState(), prop), Blocks.CRIMSON_STEM);
        CRIMSON_STEM_SLAB = BVBlocks.register("crimson_stem_slab", SlabBlock::new, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.CRIMSON_STEM));
        WARPED_STEM_STAIRS = BVBlocks.register("warped_stem_stairs", (BlockBehaviour.Properties prop) -> new StairBlock(Blocks.WARPED_STEM.defaultBlockState(), prop), Blocks.WARPED_STEM);
        WARPED_STEM_SLAB = BVBlocks.register("warped_stem_slab", SlabBlock::new, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.WARPED_STEM));
        STRIPPED_CRIMSON_STEM_STAIRS = BVBlocks.register("stripped_crimson_stem_stairs", StairBlock::new, Blocks.STRIPPED_CRIMSON_STEM);
        STRIPPED_CRIMSON_STEM_SLAB = BVBlocks.register("stripped_crimson_stem_slab", SlabBlock::new, Blocks.STRIPPED_CRIMSON_STEM);
        STRIPPED_WARPED_STEM_STAIRS = BVBlocks.register("stripped_warped_stem_stairs", StairBlock::new, Blocks.STRIPPED_WARPED_STEM);
        STRIPPED_WARPED_STEM_SLAB = BVBlocks.register("stripped_warped_stem_slab", SlabBlock::new, Blocks.STRIPPED_WARPED_STEM);
        OAK_WOOD_STAIRS = BVBlocks.woodStairs("oak", Blocks.OAK_WOOD);
        OAK_WOOD_SLAB = BVBlocks.woodSlab("oak", Blocks.OAK_WOOD);
        OAK_WOOD_WALL = BVBlocks.woodWall("oak", Blocks.OAK_WOOD);
        OAK_WOOD_FENCE = BVBlocks.woodFence("oak", Blocks.OAK_WOOD);
        OAK_WOOD_FENCE_GATE = BVBlocks.woodFenceGate("oak", Blocks.OAK_WOOD);
        SPRUCE_WOOD_STAIRS = BVBlocks.woodStairs("spruce", Blocks.SPRUCE_WOOD);
        SPRUCE_WOOD_SLAB = BVBlocks.woodSlab("spruce", Blocks.SPRUCE_WOOD);
        SPRUCE_WOOD_WALL = BVBlocks.woodWall("spruce", Blocks.SPRUCE_WOOD);
        SPRUCE_WOOD_FENCE = BVBlocks.woodFence("spruce", Blocks.SPRUCE_WOOD);
        SPRUCE_WOOD_FENCE_GATE = BVBlocks.woodFenceGate("spruce", Blocks.SPRUCE_WOOD);
        BIRCH_WOOD_STAIRS = BVBlocks.woodStairs("birch", Blocks.BIRCH_WOOD);
        BIRCH_WOOD_SLAB = BVBlocks.woodSlab("birch", Blocks.BIRCH_WOOD);
        BIRCH_WOOD_WALL = BVBlocks.woodWall("birch", Blocks.BIRCH_WOOD);
        BIRCH_WOOD_FENCE = BVBlocks.woodFence("birch", Blocks.BIRCH_WOOD);
        BIRCH_WOOD_FENCE_GATE = BVBlocks.woodFenceGate("birch", Blocks.BIRCH_WOOD);
        JUNGLE_WOOD_STAIRS = BVBlocks.woodStairs("jungle", Blocks.JUNGLE_WOOD);
        JUNGLE_WOOD_SLAB = BVBlocks.woodSlab("jungle", Blocks.JUNGLE_WOOD);
        JUNGLE_WOOD_WALL = BVBlocks.woodWall("jungle", Blocks.JUNGLE_WOOD);
        JUNGLE_WOOD_FENCE = BVBlocks.woodFence("jungle", Blocks.JUNGLE_WOOD);
        JUNGLE_WOOD_FENCE_GATE = BVBlocks.woodFenceGate("jungle", Blocks.JUNGLE_WOOD);
        ACACIA_WOOD_STAIRS = BVBlocks.woodStairs("acacia", Blocks.ACACIA_WOOD);
        ACACIA_WOOD_SLAB = BVBlocks.woodSlab("acacia", Blocks.ACACIA_WOOD);
        ACACIA_WOOD_WALL = BVBlocks.woodWall("acacia", Blocks.ACACIA_WOOD);
        ACACIA_WOOD_FENCE = BVBlocks.woodFence("acacia", Blocks.ACACIA_WOOD);
        ACACIA_WOOD_FENCE_GATE = BVBlocks.woodFenceGate("acacia", Blocks.ACACIA_WOOD);
        DARK_OAK_WOOD_STAIRS = BVBlocks.woodStairs("dark_oak", Blocks.DARK_OAK_WOOD);
        DARK_OAK_WOOD_SLAB = BVBlocks.woodSlab("dark_oak", Blocks.DARK_OAK_WOOD);
        DARK_OAK_WOOD_WALL = BVBlocks.woodWall("dark_oak", Blocks.DARK_OAK_WOOD);
        DARK_OAK_WOOD_FENCE = BVBlocks.woodFence("dark_oak", Blocks.DARK_OAK_WOOD);
        DARK_OAK_WOOD_FENCE_GATE = BVBlocks.woodFenceGate("dark_oak", Blocks.DARK_OAK_WOOD);
        MANGROVE_WOOD_STAIRS = BVBlocks.woodStairs("mangrove", Blocks.MANGROVE_WOOD);
        MANGROVE_WOOD_SLAB = BVBlocks.woodSlab("mangrove", Blocks.MANGROVE_WOOD);
        MANGROVE_WOOD_WALL = BVBlocks.woodWall("mangrove", Blocks.MANGROVE_WOOD);
        MANGROVE_WOOD_FENCE = BVBlocks.woodFence("mangrove", Blocks.MANGROVE_WOOD);
        MANGROVE_WOOD_FENCE_GATE = BVBlocks.woodFenceGate("mangrove", Blocks.MANGROVE_WOOD);
        CHERRY_WOOD_STAIRS = BVBlocks.woodStairs("cherry", Blocks.CHERRY_WOOD);
        CHERRY_WOOD_SLAB = BVBlocks.woodSlab("cherry", Blocks.CHERRY_WOOD);
        CHERRY_WOOD_WALL = BVBlocks.woodWall("cherry", Blocks.CHERRY_WOOD);
        CHERRY_WOOD_FENCE = BVBlocks.woodFence("cherry", Blocks.CHERRY_WOOD);
        CHERRY_WOOD_FENCE_GATE = BVBlocks.woodFenceGate("cherry", Blocks.CHERRY_WOOD);
        PALE_OAK_WOOD_STAIRS = BVBlocks.woodStairs("pale_oak", Blocks.PALE_OAK_WOOD);
        PALE_OAK_WOOD_SLAB = BVBlocks.woodSlab("pale_oak", Blocks.PALE_OAK_WOOD);
        PALE_OAK_WOOD_WALL = BVBlocks.woodWall("pale_oak", Blocks.PALE_OAK_WOOD);
        PALE_OAK_WOOD_FENCE = BVBlocks.woodFence("pale_oak", Blocks.PALE_OAK_WOOD);
        PALE_OAK_WOOD_FENCE_GATE = BVBlocks.woodFenceGate("pale_oak", Blocks.PALE_OAK_WOOD);
        BAMBOO_BLOCK_STAIRS = BVBlocks.register("bamboo_block_stairs", (BlockBehaviour.Properties prop) -> new StairBlock(Blocks.BAMBOO_BLOCK.defaultBlockState(), prop), BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.BAMBOO_BLOCK).mapColor(MapColor.COLOR_YELLOW));
        BAMBOO_BLOCK_SLAB = BVBlocks.register("bamboo_block_slab", SlabBlock::new, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.BAMBOO_BLOCK).mapColor(MapColor.COLOR_YELLOW));
        BAMBOO_BLOCK_WALL = BVBlocks.register("bamboo_block_wall", WallBlock::new, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.BAMBOO_BLOCK).mapColor(MapColor.PLANT));
        BAMBOO_BLOCK_FENCE = BVBlocks.register("bamboo_block_fence", FenceBlock::new, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.BAMBOO_BLOCK).mapColor(MapColor.PLANT));
        BAMBOO_BLOCK_FENCE_GATE = BVBlocks.register("bamboo_block_fence_gate", (BlockBehaviour.Properties prop) -> new FenceGateBlock(WoodType.BAMBOO, prop), BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.BAMBOO_BLOCK).mapColor(MapColor.PLANT));
        STRIPPED_OAK_WOOD_STAIRS = BVBlocks.woodStairs("stripped_oak", Blocks.STRIPPED_OAK_WOOD);
        STRIPPED_OAK_WOOD_SLAB = BVBlocks.woodSlab("stripped_oak", Blocks.STRIPPED_OAK_WOOD);
        STRIPPED_OAK_WOOD_WALL = BVBlocks.woodWall("stripped_oak", Blocks.STRIPPED_OAK_WOOD);
        STRIPPED_OAK_WOOD_FENCE = BVBlocks.woodFence("stripped_oak", Blocks.STRIPPED_OAK_WOOD);
        STRIPPED_OAK_WOOD_FENCE_GATE = BVBlocks.woodFenceGate("stripped_oak", Blocks.STRIPPED_OAK_WOOD);
        STRIPPED_SPRUCE_WOOD_STAIRS = BVBlocks.woodStairs("stripped_spruce", Blocks.STRIPPED_SPRUCE_WOOD);
        STRIPPED_SPRUCE_WOOD_SLAB = BVBlocks.woodSlab("stripped_spruce", Blocks.STRIPPED_SPRUCE_WOOD);
        STRIPPED_SPRUCE_WOOD_WALL = BVBlocks.woodWall("stripped_spruce", Blocks.STRIPPED_SPRUCE_WOOD);
        STRIPPED_SPRUCE_WOOD_FENCE = BVBlocks.woodFence("stripped_spruce", Blocks.STRIPPED_SPRUCE_WOOD);
        STRIPPED_SPRUCE_WOOD_FENCE_GATE = BVBlocks.woodFenceGate("stripped_spruce", Blocks.STRIPPED_SPRUCE_WOOD);
        STRIPPED_BIRCH_WOOD_STAIRS = BVBlocks.woodStairs("stripped_birch", Blocks.STRIPPED_BIRCH_WOOD);
        STRIPPED_BIRCH_WOOD_SLAB = BVBlocks.woodSlab("stripped_birch", Blocks.STRIPPED_BIRCH_WOOD);
        STRIPPED_BIRCH_WOOD_WALL = BVBlocks.woodWall("stripped_birch", Blocks.STRIPPED_BIRCH_WOOD);
        STRIPPED_BIRCH_WOOD_FENCE = BVBlocks.woodFence("stripped_birch", Blocks.STRIPPED_BIRCH_WOOD);
        STRIPPED_BIRCH_WOOD_FENCE_GATE = BVBlocks.woodFenceGate("stripped_birch", Blocks.STRIPPED_BIRCH_WOOD);
        STRIPPED_JUNGLE_WOOD_STAIRS = BVBlocks.woodStairs("stripped_jungle", Blocks.STRIPPED_JUNGLE_WOOD);
        STRIPPED_JUNGLE_WOOD_SLAB = BVBlocks.woodSlab("stripped_jungle", Blocks.STRIPPED_JUNGLE_WOOD);
        STRIPPED_JUNGLE_WOOD_WALL = BVBlocks.woodWall("stripped_jungle", Blocks.STRIPPED_JUNGLE_WOOD);
        STRIPPED_JUNGLE_WOOD_FENCE = BVBlocks.woodFence("stripped_jungle", Blocks.STRIPPED_JUNGLE_WOOD);
        STRIPPED_JUNGLE_WOOD_FENCE_GATE = BVBlocks.woodFenceGate("stripped_jungle", Blocks.STRIPPED_JUNGLE_WOOD);
        STRIPPED_ACACIA_WOOD_STAIRS = BVBlocks.woodStairs("stripped_acacia", Blocks.STRIPPED_ACACIA_WOOD);
        STRIPPED_ACACIA_WOOD_SLAB = BVBlocks.woodSlab("stripped_acacia", Blocks.STRIPPED_ACACIA_WOOD);
        STRIPPED_ACACIA_WOOD_WALL = BVBlocks.woodWall("stripped_acacia", Blocks.STRIPPED_ACACIA_WOOD);
        STRIPPED_ACACIA_WOOD_FENCE = BVBlocks.woodFence("stripped_acacia", Blocks.STRIPPED_ACACIA_WOOD);
        STRIPPED_ACACIA_WOOD_FENCE_GATE = BVBlocks.woodFenceGate("stripped_acacia", Blocks.STRIPPED_ACACIA_WOOD);
        STRIPPED_DARK_OAK_WOOD_STAIRS = BVBlocks.woodStairs("stripped_dark_oak", Blocks.STRIPPED_DARK_OAK_WOOD);
        STRIPPED_DARK_OAK_WOOD_SLAB = BVBlocks.woodSlab("stripped_dark_oak", Blocks.STRIPPED_DARK_OAK_WOOD);
        STRIPPED_DARK_OAK_WOOD_WALL = BVBlocks.woodWall("stripped_dark_oak", Blocks.STRIPPED_DARK_OAK_WOOD);
        STRIPPED_DARK_OAK_WOOD_FENCE = BVBlocks.woodFence("stripped_dark_oak", Blocks.STRIPPED_DARK_OAK_WOOD);
        STRIPPED_DARK_OAK_WOOD_FENCE_GATE = BVBlocks.woodFenceGate("stripped_dark_oak", Blocks.STRIPPED_DARK_OAK_WOOD);
        STRIPPED_MANGROVE_WOOD_STAIRS = BVBlocks.woodStairs("stripped_mangrove", Blocks.STRIPPED_DARK_OAK_WOOD);
        STRIPPED_MANGROVE_WOOD_SLAB = BVBlocks.woodSlab("stripped_mangrove", Blocks.STRIPPED_DARK_OAK_WOOD);
        STRIPPED_MANGROVE_WOOD_WALL = BVBlocks.woodWall("stripped_mangrove", Blocks.STRIPPED_DARK_OAK_WOOD);
        STRIPPED_MANGROVE_WOOD_FENCE = BVBlocks.woodFence("stripped_mangrove", Blocks.STRIPPED_DARK_OAK_WOOD);
        STRIPPED_MANGROVE_WOOD_FENCE_GATE = BVBlocks.woodFenceGate("stripped_mangrove", Blocks.STRIPPED_DARK_OAK_WOOD);
        STRIPPED_CHERRY_WOOD_STAIRS = BVBlocks.woodStairs("stripped_cherry", Blocks.STRIPPED_CHERRY_WOOD);
        STRIPPED_CHERRY_WOOD_SLAB = BVBlocks.woodSlab("stripped_cherry", Blocks.STRIPPED_CHERRY_WOOD);
        STRIPPED_CHERRY_WOOD_WALL = BVBlocks.woodWall("stripped_cherry", Blocks.STRIPPED_CHERRY_WOOD);
        STRIPPED_CHERRY_WOOD_FENCE = BVBlocks.woodFence("stripped_cherry", Blocks.STRIPPED_CHERRY_WOOD);
        STRIPPED_CHERRY_WOOD_FENCE_GATE = BVBlocks.woodFenceGate("stripped_cherry", Blocks.STRIPPED_CHERRY_WOOD);
        STRIPPED_PALE_OAK_WOOD_STAIRS = BVBlocks.woodStairs("stripped_pale_oak", Blocks.STRIPPED_PALE_OAK_WOOD);
        STRIPPED_PALE_OAK_WOOD_SLAB = BVBlocks.woodSlab("stripped_pale_oak", Blocks.STRIPPED_PALE_OAK_WOOD);
        STRIPPED_PALE_OAK_WOOD_WALL = BVBlocks.woodWall("stripped_pale_oak", Blocks.STRIPPED_PALE_OAK_WOOD);
        STRIPPED_PALE_OAK_WOOD_FENCE = BVBlocks.woodFence("stripped_pale_oak", Blocks.STRIPPED_PALE_OAK_WOOD);
        STRIPPED_PALE_OAK_WOOD_FENCE_GATE = BVBlocks.woodFenceGate("stripped_pale_oak", Blocks.STRIPPED_PALE_OAK_WOOD);
        STRIPPED_BAMBOO_BLOCK_STAIRS = BVBlocks.register("stripped_bamboo_block_stairs", (BlockBehaviour.Properties prop) -> new StairBlock(Blocks.STRIPPED_BAMBOO_BLOCK.defaultBlockState(), prop), BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.STRIPPED_BAMBOO_BLOCK).mapColor(MapColor.COLOR_YELLOW));
        STRIPPED_BAMBOO_BLOCK_SLAB = BVBlocks.register("stripped_bamboo_block_slab", SlabBlock::new, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.STRIPPED_BAMBOO_BLOCK).mapColor(MapColor.COLOR_YELLOW));
        STRIPPED_BAMBOO_BLOCK_WALL = BVBlocks.register("stripped_bamboo_block_wall", WallBlock::new, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.STRIPPED_BAMBOO_BLOCK).mapColor(MapColor.COLOR_YELLOW));
        STRIPPED_BAMBOO_BLOCK_FENCE = BVBlocks.register("stripped_bamboo_block_fence", FenceBlock::new, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.STRIPPED_BAMBOO_BLOCK).mapColor(MapColor.COLOR_YELLOW));
        STRIPPED_BAMBOO_BLOCK_FENCE_GATE = BVBlocks.register("stripped_bamboo_block_fence_gate", (BlockBehaviour.Properties prop) -> new FenceGateBlock(WoodType.BAMBOO, prop), BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.STRIPPED_BAMBOO_BLOCK).mapColor(MapColor.COLOR_YELLOW));
        CRIMSON_HYPHAE_STAIRS = BVBlocks.register("crimson_hyphae_stairs", prop -> new StairBlock(Blocks.CRIMSON_HYPHAE.defaultBlockState(), prop), BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.CRIMSON_HYPHAE), fireResistanceItemProperties);
        CRIMSON_HYPHAE_SLAB = BVBlocks.register("crimson_hyphae_slab", SlabBlock::new, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.CRIMSON_HYPHAE), fireResistanceItemProperties);
        CRIMSON_HYPHAE_WALL = BVBlocks.register("crimson_hyphae_wall", WallBlock::new, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.CRIMSON_HYPHAE), fireResistanceItemProperties);
        CRIMSON_HYPHAE_FENCE = BVBlocks.register("crimson_hyphae_fence", FenceBlock::new, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.CRIMSON_HYPHAE), fireResistanceItemProperties);
        CRIMSON_HYPHAE_FENCE_GATE = BVBlocks.register("crimson_hyphae_fence_gate", prop -> new FenceGateBlock(WoodType.CRIMSON, prop), BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.CRIMSON_HYPHAE), fireResistanceItemProperties);
        WARPED_HYPHAE_STAIRS = BVBlocks.register("warped_hyphae_stairs", prop -> new StairBlock(Blocks.WARPED_HYPHAE.defaultBlockState(), prop), BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.WARPED_HYPHAE), fireResistanceItemProperties);
        WARPED_HYPHAE_SLAB = BVBlocks.register("warped_hyphae_slab", SlabBlock::new, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.WARPED_HYPHAE), fireResistanceItemProperties);
        WARPED_HYPHAE_WALL = BVBlocks.register("warped_hyphae_wall", WallBlock::new, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.WARPED_HYPHAE), fireResistanceItemProperties);
        WARPED_HYPHAE_FENCE = BVBlocks.register("warped_hyphae_fence", FenceBlock::new, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.WARPED_HYPHAE), fireResistanceItemProperties);
        WARPED_HYPHAE_FENCE_GATE = BVBlocks.register("warped_hyphae_fence_gate", prop -> new FenceGateBlock(WoodType.WARPED, prop), BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.WARPED_HYPHAE), fireResistanceItemProperties);
        STRIPPED_CRIMSON_HYPHAE_STAIRS = BVBlocks.register("stripped_crimson_hyphae_stairs", prop -> new StairBlock(Blocks.STRIPPED_CRIMSON_HYPHAE.defaultBlockState(), prop), BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.STRIPPED_CRIMSON_HYPHAE), fireResistanceItemProperties);
        STRIPPED_CRIMSON_HYPHAE_SLAB = BVBlocks.register("stripped_crimson_hyphae_slab", SlabBlock::new, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.STRIPPED_CRIMSON_HYPHAE), fireResistanceItemProperties);
        STRIPPED_CRIMSON_HYPHAE_WALL = BVBlocks.register("stripped_crimson_hyphae_wall", WallBlock::new, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.STRIPPED_CRIMSON_HYPHAE), fireResistanceItemProperties);
        STRIPPED_CRIMSON_HYPHAE_FENCE = BVBlocks.register("stripped_crimson_hyphae_fence", FenceBlock::new, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.STRIPPED_CRIMSON_HYPHAE), fireResistanceItemProperties);
        STRIPPED_CRIMSON_HYPHAE_FENCE_GATE = BVBlocks.register("stripped_crimson_hyphae_fence_gate", prop -> new FenceGateBlock(WoodType.CRIMSON, prop), BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.STRIPPED_CRIMSON_HYPHAE), fireResistanceItemProperties);
        STRIPPED_WARPED_HYPHAE_STAIRS = BVBlocks.register("stripped_warped_hyphae_stairs", prop -> new StairBlock(Blocks.STRIPPED_WARPED_HYPHAE.defaultBlockState(), prop), BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.STRIPPED_WARPED_HYPHAE), fireResistanceItemProperties);
        STRIPPED_WARPED_HYPHAE_SLAB = BVBlocks.register("stripped_warped_hyphae_slab", SlabBlock::new, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.STRIPPED_WARPED_HYPHAE), fireResistanceItemProperties);
        STRIPPED_WARPED_HYPHAE_WALL = BVBlocks.register("stripped_warped_hyphae_wall", WallBlock::new, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.STRIPPED_WARPED_HYPHAE), fireResistanceItemProperties);
        STRIPPED_WARPED_HYPHAE_FENCE = BVBlocks.register("stripped_warped_hyphae_fence", FenceBlock::new, BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.STRIPPED_WARPED_HYPHAE), fireResistanceItemProperties);
        STRIPPED_WARPED_HYPHAE_FENCE_GATE = BVBlocks.register("stripped_warped_hyphae_fence_gate", prop -> new FenceGateBlock(WoodType.WARPED, prop), BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.STRIPPED_WARPED_HYPHAE), fireResistanceItemProperties);
        CALCITE_STAIRS = BVBlocks.register("calcite_stairs", (BlockBehaviour.Properties prop) -> new StairBlock(Blocks.CALCITE.defaultBlockState(), prop), Blocks.CALCITE);
        CALCITE_SLAB = BVBlocks.register("calcite_slab", SlabBlock::new, Blocks.CALCITE);
        CALCITE_WALL = BVBlocks.register("calcite_wall", WallBlock::new, Blocks.CALCITE);
        SMOOTH_BASALT_STAIRS = BVBlocks.register("smooth_basalt_stairs", (BlockBehaviour.Properties prop) -> new StairBlock(Blocks.SMOOTH_BASALT.defaultBlockState(), prop), Blocks.SMOOTH_BASALT);
        SMOOTH_BASALT_SLAB = BVBlocks.register("smooth_basalt_slab", SlabBlock::new, Blocks.SMOOTH_BASALT);
        SMOOTH_BASALT_WALL = BVBlocks.register("smooth_basalt_wall", WallBlock::new, Blocks.SMOOTH_BASALT);
        DEEPSLATE_STAIRS = BVBlocks.register("deepslate_stairs", (BlockBehaviour.Properties prop) -> new StairBlock(Blocks.DEEPSLATE.defaultBlockState(), prop), Blocks.DEEPSLATE);
        DEEPSLATE_SLAB = BVBlocks.register("deepslate_slab", SlabBlock::new, Blocks.DEEPSLATE);
        DEEPSLATE_WALL = BVBlocks.register("deepslate_wall", WallBlock::new, Blocks.DEEPSLATE);
        CRACKED_DEEPSLATE_BRICK_STAIRS = BVBlocks.register("cracked_deepslate_brick_stairs", (BlockBehaviour.Properties prop) -> new StairBlock(Blocks.CRACKED_DEEPSLATE_BRICKS.defaultBlockState(), prop), Blocks.CRACKED_DEEPSLATE_BRICKS);
        CRACKED_DEEPSLATE_BRICK_SLAB = BVBlocks.register("cracked_deepslate_brick_slab", SlabBlock::new, Blocks.CRACKED_DEEPSLATE_BRICKS);
        CRACKED_DEEPSLATE_BRICK_WALL = BVBlocks.register("cracked_deepslate_brick_wall", WallBlock::new, Blocks.CRACKED_DEEPSLATE_BRICKS);
        CRACKED_DEEPSLATE_TILE_STAIRS = BVBlocks.register("cracked_deepslate_tile_stairs", (BlockBehaviour.Properties prop) -> new StairBlock(Blocks.CRACKED_DEEPSLATE_TILES.defaultBlockState(), prop), Blocks.CRACKED_DEEPSLATE_TILES);
        CRACKED_DEEPSLATE_TILE_SLAB = BVBlocks.register("cracked_deepslate_tile_slab", SlabBlock::new, Blocks.CRACKED_DEEPSLATE_TILES);
        CRACKED_DEEPSLATE_TILE_WALL = BVBlocks.register("cracked_deepslate_tile_wall", WallBlock::new, Blocks.CRACKED_DEEPSLATE_TILES);
        NETHER_BRICK_FENCE_GATE = BVBlocks.register("nether_brick_fence_gate", (BlockBehaviour.Properties prop) -> new FenceGateBlock(WoodType.CRIMSON, prop), BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.NETHER_BRICK_FENCE));
        CRACKED_NETHER_BRICK_STAIRS = BVBlocks.register("cracked_nether_brick_stairs", (BlockBehaviour.Properties prop) -> new StairBlock(Blocks.CRACKED_NETHER_BRICKS.defaultBlockState(), prop), Blocks.CRACKED_NETHER_BRICKS);
        CRACKED_NETHER_BRICK_SLAB = BVBlocks.register("cracked_nether_brick_slab", SlabBlock::new, Blocks.CRACKED_NETHER_BRICKS);
        CRACKED_NETHER_BRICK_WALL = BVBlocks.register("cracked_nether_brick_wall", WallBlock::new, Blocks.CRACKED_NETHER_BRICKS);
        CRACKED_NETHER_BRICK_FENCE = BVBlocks.register("cracked_nether_brick_fence", FenceBlock::new, Blocks.CRACKED_NETHER_BRICKS);
        CRACKED_NETHER_BRICK_FENCE_GATE = BVBlocks.register("cracked_nether_brick_fence_gate", (BlockBehaviour.Properties prop) -> new FenceGateBlock(WoodType.OAK, prop), BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.CRACKED_NETHER_BRICKS));
        RED_NETHER_BRICK_FENCE = BVBlocks.register("red_nether_brick_fence", FenceBlock::new, Blocks.RED_NETHER_BRICKS);
        RED_NETHER_BRICK_FENCE_GATE = BVBlocks.register("red_nether_brick_fence_gate", (BlockBehaviour.Properties prop) -> new FenceGateBlock(WoodType.OAK, prop), BlockBehaviourPropertiesHelper.copyProperties((BlockBehaviour)Blocks.RED_NETHER_BRICKS));
        OBSIDIAN_STAIRS = BVBlocks.register("obsidian_stairs", (BlockBehaviour.Properties prop) -> new StairBlock(Blocks.OBSIDIAN.defaultBlockState(), prop), Blocks.OBSIDIAN);
        OBSIDIAN_SLAB = BVBlocks.register("obsidian_slab", SlabBlock::new, Blocks.OBSIDIAN);
        OBSIDIAN_WALL = BVBlocks.register("obsidian_wall", WallBlock::new, Blocks.OBSIDIAN);
        CRYING_OBSIDIAN_STAIRS = BVBlocks.register("crying_obsidian_stairs", (BlockBehaviour.Properties prop) -> new StairBlock(Blocks.CRYING_OBSIDIAN.defaultBlockState(), prop), Blocks.CRYING_OBSIDIAN);
        CRYING_OBSIDIAN_SLAB = BVBlocks.register("crying_obsidian_slab", SlabBlock::new, Blocks.CRYING_OBSIDIAN);
        CRYING_OBSIDIAN_WALL = BVBlocks.register("crying_obsidian_wall", WallBlock::new, Blocks.CRYING_OBSIDIAN);
        WHITE_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.WHITE);
        WHITE_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.WHITE);
        WHITE_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.WHITE);
        ORANGE_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.ORANGE);
        ORANGE_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.ORANGE);
        ORANGE_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.ORANGE);
        MAGENTA_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.MAGENTA);
        MAGENTA_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.MAGENTA);
        MAGENTA_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.MAGENTA);
        LIGHT_BLUE_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.LIGHT_BLUE);
        LIGHT_BLUE_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.LIGHT_BLUE);
        LIGHT_BLUE_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.LIGHT_BLUE);
        YELLOW_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.YELLOW);
        YELLOW_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.YELLOW);
        YELLOW_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.YELLOW);
        LIME_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.LIME);
        LIME_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.LIME);
        LIME_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.LIME);
        PINK_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.PINK);
        PINK_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.PINK);
        PINK_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.PINK);
        GRAY_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.GRAY);
        GRAY_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.GRAY);
        GRAY_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.GRAY);
        LIGHT_GRAY_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.LIGHT_GRAY);
        LIGHT_GRAY_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.LIGHT_GRAY);
        LIGHT_GRAY_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.LIGHT_GRAY);
        CYAN_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.CYAN);
        CYAN_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.CYAN);
        CYAN_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.CYAN);
        PURPLE_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.PURPLE);
        PURPLE_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.PURPLE);
        PURPLE_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.PURPLE);
        BLUE_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.BLUE);
        BLUE_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.BLUE);
        BLUE_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.BLUE);
        BROWN_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.BROWN);
        BROWN_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.BROWN);
        BROWN_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.BROWN);
        GREEN_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.GREEN);
        GREEN_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.GREEN);
        GREEN_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.GREEN);
        RED_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.RED);
        RED_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.RED);
        RED_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.RED);
        BLACK_GLAZED_TERRACOTTA_STAIRS = BVBlocks.regGlazedTerracottaStairs(DyeColor.BLACK);
        BLACK_GLAZED_TERRACOTTA_SLAB = BVBlocks.regGlazedTerracottaSlab(DyeColor.BLACK);
        BLACK_GLAZED_TERRACOTTA_WALL = BVBlocks.regGlazedTerracottaWall(DyeColor.BLACK);
        WHITE_WOOL_STAIRS = BVBlocks.regWoolStairs(DyeColor.WHITE);
        WHITE_WOOL_SLAB = BVBlocks.regWoolSlab(DyeColor.WHITE);
        WHITE_WOOL_WALL = BVBlocks.regWoolWall(DyeColor.WHITE);
        ORANGE_WOOL_STAIRS = BVBlocks.regWoolStairs(DyeColor.ORANGE);
        ORANGE_WOOL_SLAB = BVBlocks.regWoolSlab(DyeColor.ORANGE);
        ORANGE_WOOL_WALL = BVBlocks.regWoolWall(DyeColor.ORANGE);
        MAGENTA_WOOL_STAIRS = BVBlocks.regWoolStairs(DyeColor.MAGENTA);
        MAGENTA_WOOL_SLAB = BVBlocks.regWoolSlab(DyeColor.MAGENTA);
        MAGENTA_WOOL_WALL = BVBlocks.regWoolWall(DyeColor.MAGENTA);
        LIGHT_BLUE_WOOL_STAIRS = BVBlocks.regWoolStairs(DyeColor.LIGHT_BLUE);
        LIGHT_BLUE_WOOL_SLAB = BVBlocks.regWoolSlab(DyeColor.LIGHT_BLUE);
        LIGHT_BLUE_WOOL_WALL = BVBlocks.regWoolWall(DyeColor.LIGHT_BLUE);
        YELLOW_WOOL_STAIRS = BVBlocks.regWoolStairs(DyeColor.YELLOW);
        YELLOW_WOOL_SLAB = BVBlocks.regWoolSlab(DyeColor.YELLOW);
        YELLOW_WOOL_WALL = BVBlocks.regWoolWall(DyeColor.YELLOW);
        LIME_WOOL_STAIRS = BVBlocks.regWoolStairs(DyeColor.LIME);
        LIME_WOOL_SLAB = BVBlocks.regWoolSlab(DyeColor.LIME);
        LIME_WOOL_WALL = BVBlocks.regWoolWall(DyeColor.LIME);
        PINK_WOOL_STAIRS = BVBlocks.regWoolStairs(DyeColor.PINK);
        PINK_WOOL_SLAB = BVBlocks.regWoolSlab(DyeColor.PINK);
        PINK_WOOL_WALL = BVBlocks.regWoolWall(DyeColor.PINK);
        GRAY_WOOL_STAIRS = BVBlocks.regWoolStairs(DyeColor.GRAY);
        GRAY_WOOL_SLAB = BVBlocks.regWoolSlab(DyeColor.GRAY);
        GRAY_WOOL_WALL = BVBlocks.regWoolWall(DyeColor.GRAY);
        LIGHT_GRAY_WOOL_STAIRS = BVBlocks.regWoolStairs(DyeColor.LIGHT_GRAY);
        LIGHT_GRAY_WOOL_SLAB = BVBlocks.regWoolSlab(DyeColor.LIGHT_GRAY);
        LIGHT_GRAY_WOOL_WALL = BVBlocks.regWoolWall(DyeColor.LIGHT_GRAY);
        CYAN_WOOL_STAIRS = BVBlocks.regWoolStairs(DyeColor.CYAN);
        CYAN_WOOL_SLAB = BVBlocks.regWoolSlab(DyeColor.CYAN);
        CYAN_WOOL_WALL = BVBlocks.regWoolWall(DyeColor.CYAN);
        PURPLE_WOOL_STAIRS = BVBlocks.regWoolStairs(DyeColor.PURPLE);
        PURPLE_WOOL_SLAB = BVBlocks.regWoolSlab(DyeColor.PURPLE);
        PURPLE_WOOL_WALL = BVBlocks.regWoolWall(DyeColor.PURPLE);
        BLUE_WOOL_STAIRS = BVBlocks.regWoolStairs(DyeColor.BLUE);
        BLUE_WOOL_SLAB = BVBlocks.regWoolSlab(DyeColor.BLUE);
        BLUE_WOOL_WALL = BVBlocks.regWoolWall(DyeColor.BLUE);
        BROWN_WOOL_STAIRS = BVBlocks.regWoolStairs(DyeColor.BROWN);
        BROWN_WOOL_SLAB = BVBlocks.regWoolSlab(DyeColor.BROWN);
        BROWN_WOOL_WALL = BVBlocks.regWoolWall(DyeColor.BROWN);
        GREEN_WOOL_STAIRS = BVBlocks.regWoolStairs(DyeColor.GREEN);
        GREEN_WOOL_SLAB = BVBlocks.regWoolSlab(DyeColor.GREEN);
        GREEN_WOOL_WALL = BVBlocks.regWoolWall(DyeColor.GREEN);
        RED_WOOL_STAIRS = BVBlocks.regWoolStairs(DyeColor.RED);
        RED_WOOL_SLAB = BVBlocks.regWoolSlab(DyeColor.RED);
        RED_WOOL_WALL = BVBlocks.regWoolWall(DyeColor.RED);
        BLACK_WOOL_STAIRS = BVBlocks.regWoolStairs(DyeColor.BLACK);
        BLACK_WOOL_SLAB = BVBlocks.regWoolSlab(DyeColor.BLACK);
        BLACK_WOOL_WALL = BVBlocks.regWoolWall(DyeColor.BLACK);
        PACKED_MUD_STAIRS = BVBlocks.register("packed_mud_stairs", (BlockBehaviour.Properties prop) -> new StairBlock(Blocks.PACKED_MUD.defaultBlockState(), prop), Blocks.PACKED_MUD);
        PACKED_MUD_SLAB = BVBlocks.register("packed_mud_slab", SlabBlock::new, Blocks.PACKED_MUD);
        PACKED_MUD_WALL = BVBlocks.register("packed_mud_wall", WallBlock::new, Blocks.PACKED_MUD);
    }
}

