/*
 * Decompiled with CFR 0.152.
 */
package com.barion.block_variants.data.provider;

import com.ametrinstudios.ametrin.data.provider.ExtendedModelProvider;
import com.barion.block_variants.registry.BVBlocks;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import org.jetbrains.annotations.NotNull;

public final class BVModelProvider
extends ExtendedModelProvider {
    public BVModelProvider(PackOutput output) {
        super(output, "block_variants");
    }

    protected void registerModels(@NotNull BlockModelGenerators blockModels, @NotNull ItemModelGenerators itemModels) {
        blockModels.familyWithExistingFullBlock(Blocks.POLISHED_GRANITE).wall((Block)BVBlocks.POLISHED_GRANITE_WALL.get());
        blockModels.familyWithExistingFullBlock(Blocks.POLISHED_DIORITE).wall((Block)BVBlocks.POLISHED_DIORITE_WALL.get());
        blockModels.familyWithExistingFullBlock(Blocks.POLISHED_ANDESITE).wall((Block)BVBlocks.POLISHED_ANDESITE_WALL.get());
        blockModels.familyWithExistingFullBlock(Blocks.STONE).wall((Block)BVBlocks.STONE_WALL.get());
        blockModels.familyWithExistingFullBlock(Blocks.SMOOTH_STONE).wall((Block)BVBlocks.SMOOTH_STONE_WALL.get());
        BVModelProvider.customStairs(blockModels, (Block)BVBlocks.SMOOTH_STONE_STAIRS.get(), TextureMapping.cube((Block)Blocks.SMOOTH_STONE).put(TextureSlot.SIDE, ResourceLocation.withDefaultNamespace((String)"block/smooth_stone_slab_side")));
        blockModels.familyWithExistingFullBlock(Blocks.CUT_SANDSTONE).wall((Block)BVBlocks.CUT_SANDSTONE_WALL.get());
        BVModelProvider.customStairs(blockModels, (Block)BVBlocks.CUT_SANDSTONE_STAIRS.get(), BVModelProvider.sandstoneTextureMapping(Blocks.CUT_SANDSTONE, Blocks.SANDSTONE));
        blockModels.familyWithExistingFullBlock(Blocks.CUT_RED_SANDSTONE).wall((Block)BVBlocks.CUT_RED_SANDSTONE_WALL.get());
        BVModelProvider.customStairs(blockModels, (Block)BVBlocks.CUT_RED_SANDSTONE_STAIRS.get(), BVModelProvider.sandstoneTextureMapping(Blocks.CUT_RED_SANDSTONE, Blocks.RED_SANDSTONE));
        BVModelProvider.customWall(blockModels, (Block)BVBlocks.QUARTZ_WALL.get(), new TextureMapping().put(TextureSlot.WALL, ResourceLocation.withDefaultNamespace((String)"block/quartz_block_top")));
        blockModels.familyWithExistingFullBlock(Blocks.QUARTZ_BRICKS).stairs((Block)BVBlocks.QUARTZ_BRICK_STAIRS.get()).slab((Block)BVBlocks.QUARTZ_BRICK_SLAB.get()).wall((Block)BVBlocks.QUARTZ_BRICK_WALL.get());
        BVModelProvider.customWall(blockModels, (Block)BVBlocks.SMOOTH_QUARTZ_WALL.get(), new TextureMapping().put(TextureSlot.WALL, ResourceLocation.withDefaultNamespace((String)"block/quartz_block_bottom")));
        blockModels.familyWithExistingFullBlock(Blocks.CHISELED_QUARTZ_BLOCK).stairs((Block)BVBlocks.CHISELED_QUARTZ_BLOCK_STAIRS.get()).slab((Block)BVBlocks.CHISELED_QUARTZ_BLOCK_SLAB.get()).wall((Block)BVBlocks.CHISELED_QUARTZ_BLOCK_WALL.get());
        blockModels.familyWithExistingFullBlock(Blocks.PRISMARINE_BRICKS).wall((Block)BVBlocks.PRISMARINE_BRICK_WALL.get());
        blockModels.familyWithExistingFullBlock(Blocks.DARK_PRISMARINE).wall((Block)BVBlocks.DARK_PRISMARINE_WALL.get());
        blockModels.familyWithExistingFullBlock(Blocks.NETHERRACK).stairs((Block)BVBlocks.NETHERRACK_STAIRS.get()).slab((Block)BVBlocks.NETHERRACK_SLAB.get()).wall((Block)BVBlocks.NETHERRACK_WALL.get());
        blockModels.familyWithExistingFullBlock(Blocks.END_STONE).stairs((Block)BVBlocks.END_STONE_STAIRS.get()).slab((Block)BVBlocks.END_STONE_SLAB.get()).wall((Block)BVBlocks.END_STONE_WALL.get());
        blockModels.familyWithExistingFullBlock(Blocks.PURPUR_BLOCK).wall((Block)BVBlocks.PURPUR_WALL.get());
        blockModels.familyWithExistingFullBlock(Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS).stairs((Block)BVBlocks.CRACKED_POLISHED_BLACKSTONE_BRICK_STAIRS.get()).slab((Block)BVBlocks.CRACKED_POLISHED_BLACKSTONE_BRICK_SLAB.get()).wall((Block)BVBlocks.CRACKED_POLISHED_BLACKSTONE_BRICK_WALL.get());
        BVModelProvider.columnStairsSlabWall(blockModels, Blocks.BASALT, (StairBlock)BVBlocks.BASALT_STAIRS.get(), (SlabBlock)BVBlocks.BASALT_SLAB.get(), (WallBlock)BVBlocks.BASALT_WALL.get());
        BVModelProvider.columnStairsSlabWall(blockModels, Blocks.POLISHED_BASALT, (StairBlock)BVBlocks.POLISHED_BASALT_STAIRS.get(), (SlabBlock)BVBlocks.POLISHED_BASALT_SLAB.get(), (WallBlock)BVBlocks.POLISHED_BASALT_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.TERRACOTTA, (StairBlock)BVBlocks.TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.WHITE_TERRACOTTA, (StairBlock)BVBlocks.WHITE_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.WHITE_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.WHITE_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.ORANGE_TERRACOTTA, (StairBlock)BVBlocks.ORANGE_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.ORANGE_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.ORANGE_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.MAGENTA_TERRACOTTA, (StairBlock)BVBlocks.MAGENTA_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.MAGENTA_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.MAGENTA_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.LIGHT_BLUE_TERRACOTTA, (StairBlock)BVBlocks.LIGHT_BLUE_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.LIGHT_BLUE_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.LIGHT_BLUE_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.YELLOW_TERRACOTTA, (StairBlock)BVBlocks.YELLOW_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.YELLOW_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.YELLOW_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.LIME_TERRACOTTA, (StairBlock)BVBlocks.LIME_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.LIME_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.LIME_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.PINK_TERRACOTTA, (StairBlock)BVBlocks.PINK_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.PINK_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.PINK_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.GRAY_TERRACOTTA, (StairBlock)BVBlocks.GRAY_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.GRAY_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.GRAY_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.LIGHT_GRAY_TERRACOTTA, (StairBlock)BVBlocks.LIGHT_GRAY_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.LIGHT_GRAY_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.LIGHT_GRAY_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.CYAN_TERRACOTTA, (StairBlock)BVBlocks.CYAN_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.CYAN_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.CYAN_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.PURPLE_TERRACOTTA, (StairBlock)BVBlocks.PURPLE_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.PURPLE_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.PURPLE_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.BLUE_TERRACOTTA, (StairBlock)BVBlocks.BLUE_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.BLUE_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.BLUE_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.BROWN_TERRACOTTA, (StairBlock)BVBlocks.BROWN_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.BROWN_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.BROWN_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.GREEN_TERRACOTTA, (StairBlock)BVBlocks.GREEN_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.GREEN_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.GREEN_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.RED_TERRACOTTA, (StairBlock)BVBlocks.RED_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.RED_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.RED_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.BLACK_TERRACOTTA, (StairBlock)BVBlocks.BLACK_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.BLACK_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.BLACK_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.DRIPSTONE_BLOCK, (StairBlock)BVBlocks.DRIPSTONE_BLOCK_STAIRS.get(), (SlabBlock)BVBlocks.DRIPSTONE_BLOCK_SLAB.get(), (WallBlock)BVBlocks.DRIPSTONE_BLOCK_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.AMETHYST_BLOCK, (StairBlock)BVBlocks.AMETHYST_BLOCK_STAIRS.get(), (SlabBlock)BVBlocks.AMETHYST_BLOCK_SLAB.get(), (WallBlock)BVBlocks.AMETHYST_BLOCK_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.CRACKED_STONE_BRICKS, (StairBlock)BVBlocks.CRACKED_STONE_BRICK_STAIRS.get(), (SlabBlock)BVBlocks.CRACKED_STONE_BRICK_SLAB.get(), (WallBlock)BVBlocks.CRACKED_STONE_BRICK_WALL.get());
        BVModelProvider.logStairsSlab(blockModels, Blocks.STRIPPED_OAK_LOG, (StairBlock)BVBlocks.STRIPPED_OAK_LOG_STAIRS.get(), (SlabBlock)BVBlocks.STRIPPED_OAK_LOG_SLAB.get());
        BVModelProvider.logStairsSlab(blockModels, Blocks.STRIPPED_SPRUCE_LOG, (StairBlock)BVBlocks.STRIPPED_SPRUCE_LOG_STAIRS.get(), (SlabBlock)BVBlocks.STRIPPED_SPRUCE_LOG_SLAB.get());
        BVModelProvider.logStairsSlab(blockModels, Blocks.STRIPPED_BIRCH_LOG, (StairBlock)BVBlocks.STRIPPED_BIRCH_LOG_STAIRS.get(), (SlabBlock)BVBlocks.STRIPPED_BIRCH_LOG_SLAB.get());
        BVModelProvider.logStairsSlab(blockModels, Blocks.STRIPPED_JUNGLE_LOG, (StairBlock)BVBlocks.STRIPPED_JUNGLE_LOG_STAIRS.get(), (SlabBlock)BVBlocks.STRIPPED_JUNGLE_LOG_SLAB.get());
        BVModelProvider.logStairsSlab(blockModels, Blocks.STRIPPED_ACACIA_LOG, (StairBlock)BVBlocks.STRIPPED_ACACIA_LOG_STAIRS.get(), (SlabBlock)BVBlocks.STRIPPED_ACACIA_LOG_SLAB.get());
        BVModelProvider.logStairsSlab(blockModels, Blocks.STRIPPED_DARK_OAK_LOG, (StairBlock)BVBlocks.STRIPPED_DARK_OAK_LOG_STAIRS.get(), (SlabBlock)BVBlocks.STRIPPED_DARK_OAK_LOG_SLAB.get());
        BVModelProvider.logStairsSlab(blockModels, Blocks.STRIPPED_MANGROVE_LOG, (StairBlock)BVBlocks.STRIPPED_MANGROVE_LOG_STAIRS.get(), (SlabBlock)BVBlocks.STRIPPED_MANGROVE_LOG_SLAB.get());
        BVModelProvider.logStairsSlab(blockModels, Blocks.STRIPPED_CHERRY_LOG, (StairBlock)BVBlocks.STRIPPED_CHERRY_LOG_STAIRS.get(), (SlabBlock)BVBlocks.STRIPPED_CHERRY_LOG_SLAB.get());
        BVModelProvider.logStairsSlab(blockModels, Blocks.STRIPPED_PALE_OAK_LOG, (StairBlock)BVBlocks.STRIPPED_PALE_OAK_LOG_STAIRS.get(), (SlabBlock)BVBlocks.STRIPPED_PALE_OAK_LOG_SLAB.get());
        BVModelProvider.logStairsSlab(blockModels, Blocks.OAK_LOG, (StairBlock)BVBlocks.OAK_LOG_STAIRS.get(), (SlabBlock)BVBlocks.OAK_LOG_SLAB.get());
        BVModelProvider.logStairsSlab(blockModels, Blocks.SPRUCE_LOG, (StairBlock)BVBlocks.SPRUCE_LOG_STAIRS.get(), (SlabBlock)BVBlocks.SPRUCE_LOG_SLAB.get());
        BVModelProvider.logStairsSlab(blockModels, Blocks.BIRCH_LOG, (StairBlock)BVBlocks.BIRCH_LOG_STAIRS.get(), (SlabBlock)BVBlocks.BIRCH_LOG_SLAB.get());
        BVModelProvider.logStairsSlab(blockModels, Blocks.JUNGLE_LOG, (StairBlock)BVBlocks.JUNGLE_LOG_STAIRS.get(), (SlabBlock)BVBlocks.JUNGLE_LOG_SLAB.get());
        BVModelProvider.logStairsSlab(blockModels, Blocks.ACACIA_LOG, (StairBlock)BVBlocks.ACACIA_LOG_STAIRS.get(), (SlabBlock)BVBlocks.ACACIA_LOG_SLAB.get());
        BVModelProvider.logStairsSlab(blockModels, Blocks.DARK_OAK_LOG, (StairBlock)BVBlocks.DARK_OAK_LOG_STAIRS.get(), (SlabBlock)BVBlocks.DARK_OAK_LOG_SLAB.get());
        BVModelProvider.logStairsSlab(blockModels, Blocks.MANGROVE_LOG, (StairBlock)BVBlocks.MANGROVE_LOG_STAIRS.get(), (SlabBlock)BVBlocks.MANGROVE_LOG_SLAB.get());
        BVModelProvider.logStairsSlab(blockModels, Blocks.CHERRY_LOG, (StairBlock)BVBlocks.CHERRY_LOG_STAIRS.get(), (SlabBlock)BVBlocks.CHERRY_LOG_SLAB.get());
        BVModelProvider.logStairsSlab(blockModels, Blocks.PALE_OAK_LOG, (StairBlock)BVBlocks.PALE_OAK_LOG_STAIRS.get(), (SlabBlock)BVBlocks.PALE_OAK_LOG_SLAB.get());
        BVModelProvider.logStairsSlab(blockModels, Blocks.STRIPPED_CRIMSON_STEM, (StairBlock)BVBlocks.STRIPPED_CRIMSON_STEM_STAIRS.get(), (SlabBlock)BVBlocks.STRIPPED_CRIMSON_STEM_SLAB.get());
        BVModelProvider.logStairsSlab(blockModels, Blocks.STRIPPED_WARPED_STEM, (StairBlock)BVBlocks.STRIPPED_WARPED_STEM_STAIRS.get(), (SlabBlock)BVBlocks.STRIPPED_WARPED_STEM_SLAB.get());
        BVModelProvider.logStairsSlab(blockModels, Blocks.CRIMSON_STEM, (StairBlock)BVBlocks.CRIMSON_STEM_STAIRS.get(), (SlabBlock)BVBlocks.CRIMSON_STEM_SLAB.get());
        BVModelProvider.logStairsSlab(blockModels, Blocks.WARPED_STEM, (StairBlock)BVBlocks.WARPED_STEM_STAIRS.get(), (SlabBlock)BVBlocks.WARPED_STEM_SLAB.get());
        BVModelProvider.woodStairsSlabWallFenceGate(blockModels, Blocks.STRIPPED_OAK_LOG, (StairBlock)BVBlocks.STRIPPED_OAK_WOOD_STAIRS.get(), (SlabBlock)BVBlocks.STRIPPED_OAK_WOOD_SLAB.get(), Blocks.STRIPPED_OAK_WOOD, (WallBlock)BVBlocks.STRIPPED_OAK_WOOD_WALL.get(), (FenceBlock)BVBlocks.STRIPPED_OAK_WOOD_FENCE.get(), (FenceGateBlock)BVBlocks.STRIPPED_OAK_WOOD_FENCE_GATE.get());
        BVModelProvider.woodStairsSlabWallFenceGate(blockModels, Blocks.STRIPPED_SPRUCE_LOG, (StairBlock)BVBlocks.STRIPPED_SPRUCE_WOOD_STAIRS.get(), (SlabBlock)BVBlocks.STRIPPED_SPRUCE_WOOD_SLAB.get(), Blocks.STRIPPED_SPRUCE_WOOD, (WallBlock)BVBlocks.STRIPPED_SPRUCE_WOOD_WALL.get(), (FenceBlock)BVBlocks.STRIPPED_SPRUCE_WOOD_FENCE.get(), (FenceGateBlock)BVBlocks.STRIPPED_SPRUCE_WOOD_FENCE_GATE.get());
        BVModelProvider.woodStairsSlabWallFenceGate(blockModels, Blocks.STRIPPED_BIRCH_LOG, (StairBlock)BVBlocks.STRIPPED_BIRCH_WOOD_STAIRS.get(), (SlabBlock)BVBlocks.STRIPPED_BIRCH_WOOD_SLAB.get(), Blocks.STRIPPED_BIRCH_WOOD, (WallBlock)BVBlocks.STRIPPED_BIRCH_WOOD_WALL.get(), (FenceBlock)BVBlocks.STRIPPED_BIRCH_WOOD_FENCE.get(), (FenceGateBlock)BVBlocks.STRIPPED_BIRCH_WOOD_FENCE_GATE.get());
        BVModelProvider.woodStairsSlabWallFenceGate(blockModels, Blocks.STRIPPED_JUNGLE_LOG, (StairBlock)BVBlocks.STRIPPED_JUNGLE_WOOD_STAIRS.get(), (SlabBlock)BVBlocks.STRIPPED_JUNGLE_WOOD_SLAB.get(), Blocks.STRIPPED_JUNGLE_WOOD, (WallBlock)BVBlocks.STRIPPED_JUNGLE_WOOD_WALL.get(), (FenceBlock)BVBlocks.STRIPPED_JUNGLE_WOOD_FENCE.get(), (FenceGateBlock)BVBlocks.STRIPPED_JUNGLE_WOOD_FENCE_GATE.get());
        BVModelProvider.woodStairsSlabWallFenceGate(blockModels, Blocks.STRIPPED_ACACIA_LOG, (StairBlock)BVBlocks.STRIPPED_ACACIA_WOOD_STAIRS.get(), (SlabBlock)BVBlocks.STRIPPED_ACACIA_WOOD_SLAB.get(), Blocks.STRIPPED_ACACIA_WOOD, (WallBlock)BVBlocks.STRIPPED_ACACIA_WOOD_WALL.get(), (FenceBlock)BVBlocks.STRIPPED_ACACIA_WOOD_FENCE.get(), (FenceGateBlock)BVBlocks.STRIPPED_ACACIA_WOOD_FENCE_GATE.get());
        BVModelProvider.woodStairsSlabWallFenceGate(blockModels, Blocks.STRIPPED_DARK_OAK_LOG, (StairBlock)BVBlocks.STRIPPED_DARK_OAK_WOOD_STAIRS.get(), (SlabBlock)BVBlocks.STRIPPED_DARK_OAK_WOOD_SLAB.get(), Blocks.STRIPPED_DARK_OAK_WOOD, (WallBlock)BVBlocks.STRIPPED_DARK_OAK_WOOD_WALL.get(), (FenceBlock)BVBlocks.STRIPPED_DARK_OAK_WOOD_FENCE.get(), (FenceGateBlock)BVBlocks.STRIPPED_DARK_OAK_WOOD_FENCE_GATE.get());
        BVModelProvider.woodStairsSlabWallFenceGate(blockModels, Blocks.STRIPPED_MANGROVE_LOG, (StairBlock)BVBlocks.STRIPPED_MANGROVE_WOOD_STAIRS.get(), (SlabBlock)BVBlocks.STRIPPED_MANGROVE_WOOD_SLAB.get(), Blocks.STRIPPED_MANGROVE_WOOD, (WallBlock)BVBlocks.STRIPPED_MANGROVE_WOOD_WALL.get(), (FenceBlock)BVBlocks.STRIPPED_MANGROVE_WOOD_FENCE.get(), (FenceGateBlock)BVBlocks.STRIPPED_MANGROVE_WOOD_FENCE_GATE.get());
        BVModelProvider.woodStairsSlabWallFenceGate(blockModels, Blocks.STRIPPED_CHERRY_LOG, (StairBlock)BVBlocks.STRIPPED_CHERRY_WOOD_STAIRS.get(), (SlabBlock)BVBlocks.STRIPPED_CHERRY_WOOD_SLAB.get(), Blocks.STRIPPED_CHERRY_WOOD, (WallBlock)BVBlocks.STRIPPED_CHERRY_WOOD_WALL.get(), (FenceBlock)BVBlocks.STRIPPED_CHERRY_WOOD_FENCE.get(), (FenceGateBlock)BVBlocks.STRIPPED_CHERRY_WOOD_FENCE_GATE.get());
        BVModelProvider.woodStairsSlabWallFenceGate(blockModels, Blocks.STRIPPED_PALE_OAK_LOG, (StairBlock)BVBlocks.STRIPPED_PALE_OAK_WOOD_STAIRS.get(), (SlabBlock)BVBlocks.STRIPPED_PALE_OAK_WOOD_SLAB.get(), Blocks.STRIPPED_PALE_OAK_WOOD, (WallBlock)BVBlocks.STRIPPED_PALE_OAK_WOOD_WALL.get(), (FenceBlock)BVBlocks.STRIPPED_PALE_OAK_WOOD_FENCE.get(), (FenceGateBlock)BVBlocks.STRIPPED_PALE_OAK_WOOD_FENCE_GATE.get());
        BVModelProvider.logStairsSlabWallFenceGate(blockModels, Blocks.STRIPPED_BAMBOO_BLOCK, (StairBlock)BVBlocks.STRIPPED_BAMBOO_BLOCK_STAIRS.get(), (SlabBlock)BVBlocks.STRIPPED_BAMBOO_BLOCK_SLAB.get(), (WallBlock)BVBlocks.STRIPPED_BAMBOO_BLOCK_WALL.get(), (FenceBlock)BVBlocks.STRIPPED_BAMBOO_BLOCK_FENCE.get(), (FenceGateBlock)BVBlocks.STRIPPED_BAMBOO_BLOCK_FENCE_GATE.get());
        BVModelProvider.woodStairsSlabWallFenceGate(blockModels, Blocks.OAK_LOG, (StairBlock)BVBlocks.OAK_WOOD_STAIRS.get(), (SlabBlock)BVBlocks.OAK_WOOD_SLAB.get(), Blocks.OAK_WOOD, (WallBlock)BVBlocks.OAK_WOOD_WALL.get(), (FenceBlock)BVBlocks.OAK_WOOD_FENCE.get(), (FenceGateBlock)BVBlocks.OAK_WOOD_FENCE_GATE.get());
        BVModelProvider.woodStairsSlabWallFenceGate(blockModels, Blocks.SPRUCE_LOG, (StairBlock)BVBlocks.SPRUCE_WOOD_STAIRS.get(), (SlabBlock)BVBlocks.SPRUCE_WOOD_SLAB.get(), Blocks.SPRUCE_WOOD, (WallBlock)BVBlocks.SPRUCE_WOOD_WALL.get(), (FenceBlock)BVBlocks.SPRUCE_WOOD_FENCE.get(), (FenceGateBlock)BVBlocks.SPRUCE_WOOD_FENCE_GATE.get());
        BVModelProvider.woodStairsSlabWallFenceGate(blockModels, Blocks.BIRCH_LOG, (StairBlock)BVBlocks.BIRCH_WOOD_STAIRS.get(), (SlabBlock)BVBlocks.BIRCH_WOOD_SLAB.get(), Blocks.BIRCH_WOOD, (WallBlock)BVBlocks.BIRCH_WOOD_WALL.get(), (FenceBlock)BVBlocks.BIRCH_WOOD_FENCE.get(), (FenceGateBlock)BVBlocks.BIRCH_WOOD_FENCE_GATE.get());
        BVModelProvider.woodStairsSlabWallFenceGate(blockModels, Blocks.JUNGLE_LOG, (StairBlock)BVBlocks.JUNGLE_WOOD_STAIRS.get(), (SlabBlock)BVBlocks.JUNGLE_WOOD_SLAB.get(), Blocks.JUNGLE_WOOD, (WallBlock)BVBlocks.JUNGLE_WOOD_WALL.get(), (FenceBlock)BVBlocks.JUNGLE_WOOD_FENCE.get(), (FenceGateBlock)BVBlocks.JUNGLE_WOOD_FENCE_GATE.get());
        BVModelProvider.woodStairsSlabWallFenceGate(blockModels, Blocks.ACACIA_LOG, (StairBlock)BVBlocks.ACACIA_WOOD_STAIRS.get(), (SlabBlock)BVBlocks.ACACIA_WOOD_SLAB.get(), Blocks.ACACIA_WOOD, (WallBlock)BVBlocks.ACACIA_WOOD_WALL.get(), (FenceBlock)BVBlocks.ACACIA_WOOD_FENCE.get(), (FenceGateBlock)BVBlocks.ACACIA_WOOD_FENCE_GATE.get());
        BVModelProvider.woodStairsSlabWallFenceGate(blockModels, Blocks.DARK_OAK_LOG, (StairBlock)BVBlocks.DARK_OAK_WOOD_STAIRS.get(), (SlabBlock)BVBlocks.DARK_OAK_WOOD_SLAB.get(), Blocks.DARK_OAK_WOOD, (WallBlock)BVBlocks.DARK_OAK_WOOD_WALL.get(), (FenceBlock)BVBlocks.DARK_OAK_WOOD_FENCE.get(), (FenceGateBlock)BVBlocks.DARK_OAK_WOOD_FENCE_GATE.get());
        BVModelProvider.woodStairsSlabWallFenceGate(blockModels, Blocks.MANGROVE_LOG, (StairBlock)BVBlocks.MANGROVE_WOOD_STAIRS.get(), (SlabBlock)BVBlocks.MANGROVE_WOOD_SLAB.get(), Blocks.MANGROVE_WOOD, (WallBlock)BVBlocks.MANGROVE_WOOD_WALL.get(), (FenceBlock)BVBlocks.MANGROVE_WOOD_FENCE.get(), (FenceGateBlock)BVBlocks.MANGROVE_WOOD_FENCE_GATE.get());
        BVModelProvider.woodStairsSlabWallFenceGate(blockModels, Blocks.CHERRY_LOG, (StairBlock)BVBlocks.CHERRY_WOOD_STAIRS.get(), (SlabBlock)BVBlocks.CHERRY_WOOD_SLAB.get(), Blocks.CHERRY_WOOD, (WallBlock)BVBlocks.CHERRY_WOOD_WALL.get(), (FenceBlock)BVBlocks.CHERRY_WOOD_FENCE.get(), (FenceGateBlock)BVBlocks.CHERRY_WOOD_FENCE_GATE.get());
        BVModelProvider.woodStairsSlabWallFenceGate(blockModels, Blocks.PALE_OAK_LOG, (StairBlock)BVBlocks.PALE_OAK_WOOD_STAIRS.get(), (SlabBlock)BVBlocks.PALE_OAK_WOOD_SLAB.get(), Blocks.PALE_OAK_WOOD, (WallBlock)BVBlocks.PALE_OAK_WOOD_WALL.get(), (FenceBlock)BVBlocks.PALE_OAK_WOOD_FENCE.get(), (FenceGateBlock)BVBlocks.PALE_OAK_WOOD_FENCE_GATE.get());
        BVModelProvider.logStairsSlabWallFenceGate(blockModels, Blocks.BAMBOO_BLOCK, (StairBlock)BVBlocks.BAMBOO_BLOCK_STAIRS.get(), (SlabBlock)BVBlocks.BAMBOO_BLOCK_SLAB.get(), (WallBlock)BVBlocks.BAMBOO_BLOCK_WALL.get(), (FenceBlock)BVBlocks.BAMBOO_BLOCK_FENCE.get(), (FenceGateBlock)BVBlocks.BAMBOO_BLOCK_FENCE_GATE.get());
        BVModelProvider.woodStairsSlabWallFenceGate(blockModels, Blocks.STRIPPED_CRIMSON_STEM, (StairBlock)BVBlocks.STRIPPED_CRIMSON_HYPHAE_STAIRS.get(), (SlabBlock)BVBlocks.STRIPPED_CRIMSON_HYPHAE_SLAB.get(), Blocks.STRIPPED_CRIMSON_HYPHAE, (WallBlock)BVBlocks.STRIPPED_CRIMSON_HYPHAE_WALL.get(), (FenceBlock)BVBlocks.STRIPPED_CRIMSON_HYPHAE_FENCE.get(), (FenceGateBlock)BVBlocks.STRIPPED_CRIMSON_HYPHAE_FENCE_GATE.get());
        BVModelProvider.woodStairsSlabWallFenceGate(blockModels, Blocks.STRIPPED_WARPED_STEM, (StairBlock)BVBlocks.STRIPPED_WARPED_HYPHAE_STAIRS.get(), (SlabBlock)BVBlocks.STRIPPED_WARPED_HYPHAE_SLAB.get(), Blocks.STRIPPED_WARPED_HYPHAE, (WallBlock)BVBlocks.STRIPPED_WARPED_HYPHAE_WALL.get(), (FenceBlock)BVBlocks.STRIPPED_WARPED_HYPHAE_FENCE.get(), (FenceGateBlock)BVBlocks.STRIPPED_WARPED_HYPHAE_FENCE_GATE.get());
        BVModelProvider.woodStairsSlabWallFenceGate(blockModels, Blocks.CRIMSON_STEM, (StairBlock)BVBlocks.CRIMSON_HYPHAE_STAIRS.get(), (SlabBlock)BVBlocks.CRIMSON_HYPHAE_SLAB.get(), Blocks.CRIMSON_HYPHAE, (WallBlock)BVBlocks.CRIMSON_HYPHAE_WALL.get(), (FenceBlock)BVBlocks.CRIMSON_HYPHAE_FENCE.get(), (FenceGateBlock)BVBlocks.CRIMSON_HYPHAE_FENCE_GATE.get());
        BVModelProvider.woodStairsSlabWallFenceGate(blockModels, Blocks.WARPED_STEM, (StairBlock)BVBlocks.WARPED_HYPHAE_STAIRS.get(), (SlabBlock)BVBlocks.WARPED_HYPHAE_SLAB.get(), Blocks.WARPED_HYPHAE, (WallBlock)BVBlocks.WARPED_HYPHAE_WALL.get(), (FenceBlock)BVBlocks.WARPED_HYPHAE_FENCE.get(), (FenceGateBlock)BVBlocks.WARPED_HYPHAE_FENCE_GATE.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.CALCITE, (StairBlock)BVBlocks.CALCITE_STAIRS.get(), (SlabBlock)BVBlocks.CALCITE_SLAB.get(), (WallBlock)BVBlocks.CALCITE_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.SMOOTH_BASALT, (StairBlock)BVBlocks.SMOOTH_BASALT_STAIRS.get(), (SlabBlock)BVBlocks.SMOOTH_BASALT_SLAB.get(), (WallBlock)BVBlocks.SMOOTH_BASALT_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.DEEPSLATE, (StairBlock)BVBlocks.DEEPSLATE_STAIRS.get(), (SlabBlock)BVBlocks.DEEPSLATE_SLAB.get(), (WallBlock)BVBlocks.DEEPSLATE_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.CRACKED_DEEPSLATE_BRICKS, (StairBlock)BVBlocks.CRACKED_DEEPSLATE_BRICK_STAIRS.get(), (SlabBlock)BVBlocks.CRACKED_DEEPSLATE_BRICK_SLAB.get(), (WallBlock)BVBlocks.CRACKED_DEEPSLATE_BRICK_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.CRACKED_DEEPSLATE_TILES, (StairBlock)BVBlocks.CRACKED_DEEPSLATE_TILE_STAIRS.get(), (SlabBlock)BVBlocks.CRACKED_DEEPSLATE_TILE_SLAB.get(), (WallBlock)BVBlocks.CRACKED_DEEPSLATE_TILE_WALL.get());
        blockModels.familyWithExistingFullBlock(Blocks.NETHER_BRICKS).fenceGate((Block)BVBlocks.NETHER_BRICK_FENCE_GATE.get());
        BVModelProvider.stairsSlabWallFenceGate(blockModels, Blocks.CRACKED_NETHER_BRICKS, (StairBlock)BVBlocks.CRACKED_NETHER_BRICK_STAIRS.get(), (SlabBlock)BVBlocks.CRACKED_NETHER_BRICK_SLAB.get(), (WallBlock)BVBlocks.CRACKED_NETHER_BRICK_WALL.get(), (FenceBlock)BVBlocks.CRACKED_NETHER_BRICK_FENCE.get(), (FenceGateBlock)BVBlocks.CRACKED_NETHER_BRICK_FENCE_GATE.get());
        blockModels.familyWithExistingFullBlock(Blocks.RED_NETHER_BRICKS).fence((Block)BVBlocks.RED_NETHER_BRICK_FENCE.get()).fenceGate((Block)BVBlocks.RED_NETHER_BRICK_FENCE_GATE.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.OBSIDIAN, (StairBlock)BVBlocks.OBSIDIAN_STAIRS.get(), (SlabBlock)BVBlocks.OBSIDIAN_SLAB.get(), (WallBlock)BVBlocks.OBSIDIAN_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.CRYING_OBSIDIAN, (StairBlock)BVBlocks.CRYING_OBSIDIAN_STAIRS.get(), (SlabBlock)BVBlocks.CRYING_OBSIDIAN_SLAB.get(), (WallBlock)BVBlocks.CRYING_OBSIDIAN_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.WHITE_GLAZED_TERRACOTTA, (StairBlock)BVBlocks.WHITE_GLAZED_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.WHITE_GLAZED_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.WHITE_GLAZED_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.ORANGE_GLAZED_TERRACOTTA, (StairBlock)BVBlocks.ORANGE_GLAZED_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.ORANGE_GLAZED_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.ORANGE_GLAZED_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.MAGENTA_GLAZED_TERRACOTTA, (StairBlock)BVBlocks.MAGENTA_GLAZED_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.MAGENTA_GLAZED_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.MAGENTA_GLAZED_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.LIGHT_BLUE_GLAZED_TERRACOTTA, (StairBlock)BVBlocks.LIGHT_BLUE_GLAZED_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.LIGHT_BLUE_GLAZED_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.LIGHT_BLUE_GLAZED_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.YELLOW_GLAZED_TERRACOTTA, (StairBlock)BVBlocks.YELLOW_GLAZED_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.YELLOW_GLAZED_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.YELLOW_GLAZED_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.LIME_GLAZED_TERRACOTTA, (StairBlock)BVBlocks.LIME_GLAZED_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.LIME_GLAZED_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.LIME_GLAZED_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.PINK_GLAZED_TERRACOTTA, (StairBlock)BVBlocks.PINK_GLAZED_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.PINK_GLAZED_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.PINK_GLAZED_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.GRAY_GLAZED_TERRACOTTA, (StairBlock)BVBlocks.GRAY_GLAZED_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.GRAY_GLAZED_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.GRAY_GLAZED_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.LIGHT_GRAY_GLAZED_TERRACOTTA, (StairBlock)BVBlocks.LIGHT_GRAY_GLAZED_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.LIGHT_GRAY_GLAZED_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.LIGHT_GRAY_GLAZED_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.CYAN_GLAZED_TERRACOTTA, (StairBlock)BVBlocks.CYAN_GLAZED_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.CYAN_GLAZED_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.CYAN_GLAZED_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.PURPLE_GLAZED_TERRACOTTA, (StairBlock)BVBlocks.PURPLE_GLAZED_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.PURPLE_GLAZED_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.PURPLE_GLAZED_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.BLUE_GLAZED_TERRACOTTA, (StairBlock)BVBlocks.BLUE_GLAZED_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.BLUE_GLAZED_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.BLUE_GLAZED_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.BROWN_GLAZED_TERRACOTTA, (StairBlock)BVBlocks.BROWN_GLAZED_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.BROWN_GLAZED_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.BROWN_GLAZED_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.GREEN_GLAZED_TERRACOTTA, (StairBlock)BVBlocks.GREEN_GLAZED_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.GREEN_GLAZED_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.GREEN_GLAZED_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.RED_GLAZED_TERRACOTTA, (StairBlock)BVBlocks.RED_GLAZED_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.RED_GLAZED_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.RED_GLAZED_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.BLACK_GLAZED_TERRACOTTA, (StairBlock)BVBlocks.BLACK_GLAZED_TERRACOTTA_STAIRS.get(), (SlabBlock)BVBlocks.BLACK_GLAZED_TERRACOTTA_SLAB.get(), (WallBlock)BVBlocks.BLACK_GLAZED_TERRACOTTA_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.WHITE_WOOL, (StairBlock)BVBlocks.WHITE_WOOL_STAIRS.get(), (SlabBlock)BVBlocks.WHITE_WOOL_SLAB.get(), (WallBlock)BVBlocks.WHITE_WOOL_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.ORANGE_WOOL, (StairBlock)BVBlocks.ORANGE_WOOL_STAIRS.get(), (SlabBlock)BVBlocks.ORANGE_WOOL_SLAB.get(), (WallBlock)BVBlocks.ORANGE_WOOL_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.MAGENTA_WOOL, (StairBlock)BVBlocks.MAGENTA_WOOL_STAIRS.get(), (SlabBlock)BVBlocks.MAGENTA_WOOL_SLAB.get(), (WallBlock)BVBlocks.MAGENTA_WOOL_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.LIGHT_BLUE_WOOL, (StairBlock)BVBlocks.LIGHT_BLUE_WOOL_STAIRS.get(), (SlabBlock)BVBlocks.LIGHT_BLUE_WOOL_SLAB.get(), (WallBlock)BVBlocks.LIGHT_BLUE_WOOL_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.YELLOW_WOOL, (StairBlock)BVBlocks.YELLOW_WOOL_STAIRS.get(), (SlabBlock)BVBlocks.YELLOW_WOOL_SLAB.get(), (WallBlock)BVBlocks.YELLOW_WOOL_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.LIME_WOOL, (StairBlock)BVBlocks.LIME_WOOL_STAIRS.get(), (SlabBlock)BVBlocks.LIME_WOOL_SLAB.get(), (WallBlock)BVBlocks.LIME_WOOL_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.PINK_WOOL, (StairBlock)BVBlocks.PINK_WOOL_STAIRS.get(), (SlabBlock)BVBlocks.PINK_WOOL_SLAB.get(), (WallBlock)BVBlocks.PINK_WOOL_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.GRAY_WOOL, (StairBlock)BVBlocks.GRAY_WOOL_STAIRS.get(), (SlabBlock)BVBlocks.GRAY_WOOL_SLAB.get(), (WallBlock)BVBlocks.GRAY_WOOL_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.LIGHT_GRAY_WOOL, (StairBlock)BVBlocks.LIGHT_GRAY_WOOL_STAIRS.get(), (SlabBlock)BVBlocks.LIGHT_GRAY_WOOL_SLAB.get(), (WallBlock)BVBlocks.LIGHT_GRAY_WOOL_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.CYAN_WOOL, (StairBlock)BVBlocks.CYAN_WOOL_STAIRS.get(), (SlabBlock)BVBlocks.CYAN_WOOL_SLAB.get(), (WallBlock)BVBlocks.CYAN_WOOL_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.PURPLE_WOOL, (StairBlock)BVBlocks.PURPLE_WOOL_STAIRS.get(), (SlabBlock)BVBlocks.PURPLE_WOOL_SLAB.get(), (WallBlock)BVBlocks.PURPLE_WOOL_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.BLUE_WOOL, (StairBlock)BVBlocks.BLUE_WOOL_STAIRS.get(), (SlabBlock)BVBlocks.BLUE_WOOL_SLAB.get(), (WallBlock)BVBlocks.BLUE_WOOL_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.BROWN_WOOL, (StairBlock)BVBlocks.BROWN_WOOL_STAIRS.get(), (SlabBlock)BVBlocks.BROWN_WOOL_SLAB.get(), (WallBlock)BVBlocks.BROWN_WOOL_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.GREEN_WOOL, (StairBlock)BVBlocks.GREEN_WOOL_STAIRS.get(), (SlabBlock)BVBlocks.GREEN_WOOL_SLAB.get(), (WallBlock)BVBlocks.GREEN_WOOL_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.RED_WOOL, (StairBlock)BVBlocks.RED_WOOL_STAIRS.get(), (SlabBlock)BVBlocks.RED_WOOL_SLAB.get(), (WallBlock)BVBlocks.RED_WOOL_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.BLACK_WOOL, (StairBlock)BVBlocks.BLACK_WOOL_STAIRS.get(), (SlabBlock)BVBlocks.BLACK_WOOL_SLAB.get(), (WallBlock)BVBlocks.BLACK_WOOL_WALL.get());
        BVModelProvider.stairsSlabWall(blockModels, Blocks.PACKED_MUD, (StairBlock)BVBlocks.PACKED_MUD_STAIRS.get(), (SlabBlock)BVBlocks.PACKED_MUD_SLAB.get(), (WallBlock)BVBlocks.PACKED_MUD_WALL.get());
    }

    private static void stairsSlabWall(BlockModelGenerators blockModels, Block base, StairBlock stair, SlabBlock slab, WallBlock wall) {
        blockModels.familyWithExistingFullBlock(base).stairs((Block)stair).slab((Block)slab).wall((Block)wall);
    }

    private static void stairsSlabWallFenceGate(BlockModelGenerators blockModels, Block base, StairBlock stair, SlabBlock slab, WallBlock wall, FenceBlock fence, FenceGateBlock gate) {
        blockModels.familyWithExistingFullBlock(base).stairs((Block)stair).slab((Block)slab).wall((Block)wall).fence((Block)fence).fenceGate((Block)gate);
    }

    public static void woodStairsSlabWallFenceGate(BlockModelGenerators blockModels, Block base, StairBlock stair, SlabBlock slab, Block doubleSlap, WallBlock wall, FenceBlock fence, FenceGateBlock gate) {
        blockModels.familyWithExistingFullBlock(base).stairs((Block)stair).wall((Block)wall).fence((Block)fence).fenceGate((Block)gate);
        BVModelProvider.customSlab(blockModels, (Block)slab, doubleSlap, new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)base)).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)base)).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)base)));
    }

    private static void logStairsSlabWallFenceGate(BlockModelGenerators blockModels, Block base, StairBlock stair, SlabBlock slab, WallBlock wall, FenceBlock fence, FenceGateBlock gate) {
        blockModels.familyWithExistingFullBlock(base).wall((Block)wall).fence((Block)fence).fenceGate((Block)gate);
        TextureMapping mapping = BVModelProvider.logTextureMapping(base);
        BVModelProvider.customStairs(blockModels, (Block)stair, mapping);
        BVModelProvider.customSlab(blockModels, (Block)slab, base, mapping);
    }

    public static void logStairsSlab(BlockModelGenerators blockModels, Block base, StairBlock stair, SlabBlock slab) {
        TextureMapping mapping = BVModelProvider.logTextureMapping(base);
        BVModelProvider.customStairs(blockModels, (Block)stair, mapping);
        BVModelProvider.customSlab(blockModels, (Block)slab, base, mapping);
    }

    private static void columnStairsSlabWall(BlockModelGenerators blockModels, Block base, StairBlock stair, SlabBlock slab, WallBlock wall) {
        TextureMapping mapping = BVModelProvider.columnTopSideTextureMapping(base);
        BVModelProvider.customStairs(blockModels, (Block)stair, mapping);
        BVModelProvider.customSlab(blockModels, (Block)slab, base, mapping);
        BVModelProvider.customWall(blockModels, (Block)wall, mapping);
    }

    public static TextureMapping logTextureMapping(Block log) {
        return new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)log)).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)log, (String)"_top")).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)log, (String)"_top"));
    }

    private static TextureMapping sandstoneTextureMapping(Block side, Block top) {
        return new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)side)).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)top, (String)"_top")).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)top, (String)"_top"));
    }

    private static TextureMapping columnTopSideTextureMapping(Block log) {
        return new TextureMapping().put(TextureSlot.WALL, TextureMapping.getBlockTexture((Block)log, (String)"_side")).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)log, (String)"_side")).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)log, (String)"_top")).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)log, (String)"_top"));
    }

    public static void customStairs(BlockModelGenerators blockModels, Block stairsBlock, TextureMapping mapping) {
        ResourceLocation innerModel = ModelTemplates.STAIRS_INNER.create(stairsBlock, mapping, blockModels.modelOutput);
        ResourceLocation straightModel = ModelTemplates.STAIRS_STRAIGHT.create(stairsBlock, mapping, blockModels.modelOutput);
        ResourceLocation outerModel = ModelTemplates.STAIRS_OUTER.create(stairsBlock, mapping, blockModels.modelOutput);
        blockModels.blockStateOutput.accept(BlockModelGenerators.createStairs((Block)stairsBlock, (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)innerModel), (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)straightModel), (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)outerModel)));
        blockModels.registerSimpleItemModel(stairsBlock, straightModel);
    }

    public static void customSlab(BlockModelGenerators blockModels, Block slabBlock, Block doubleSlab, TextureMapping mapping) {
        ResourceLocation bottomModel = ModelTemplates.SLAB_BOTTOM.create(slabBlock, mapping, blockModels.modelOutput);
        ResourceLocation topModel = ModelTemplates.SLAB_TOP.create(slabBlock, mapping, blockModels.modelOutput);
        blockModels.blockStateOutput.accept(BlockModelGenerators.createSlab((Block)slabBlock, (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)bottomModel), (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)topModel), (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)doubleSlab))));
        blockModels.registerSimpleItemModel(slabBlock, bottomModel);
    }

    public static void customWall(BlockModelGenerators blockModels, Block wallBlock, TextureMapping mapping) {
        ResourceLocation postModel = ModelTemplates.WALL_POST.create(wallBlock, mapping, blockModels.modelOutput);
        ResourceLocation lowModel = ModelTemplates.WALL_LOW_SIDE.create(wallBlock, mapping, blockModels.modelOutput);
        ResourceLocation tallModel = ModelTemplates.WALL_TALL_SIDE.create(wallBlock, mapping, blockModels.modelOutput);
        blockModels.blockStateOutput.accept(BlockModelGenerators.createWall((Block)wallBlock, (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)postModel), (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)lowModel), (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)tallModel)));
        ResourceLocation inventoryModel = ModelTemplates.WALL_INVENTORY.create(wallBlock, mapping, blockModels.modelOutput);
        blockModels.registerSimpleItemModel(wallBlock, inventoryModel);
    }
}

