/*
 * Decompiled with CFR 0.152.
 */
package net.azurune.runiclib.common.effect;

import net.azurune.runiclib.RunicLib;
import net.azurune.runiclib.common.publicized.PublicMobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class BerserkEffect
extends PublicMobEffect {
    public BerserkEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity living, int amplifier) {
        float damageModifier = 1.0f - living.getHealth() / living.getMaxHealth();
        if (living.getAttribute(Attributes.ATTACK_DAMAGE) == null) {
            return false;
        }
        AttributeModifier originalModifier = living.getAttribute(Attributes.MOVEMENT_SPEED).getModifier(RunicLib.modid("berserk.attack_damage"));
        if (originalModifier == null) {
            return false;
        }
        AttributeModifier newAttributeModifier = new AttributeModifier(originalModifier.id(), (double)(damageModifier * ((float)amplifier + 1.0f)), originalModifier.operation());
        living.getAttribute(Attributes.ATTACK_DAMAGE).removeModifier(originalModifier.id());
        living.getAttribute(Attributes.ATTACK_DAMAGE).addTransientModifier(newAttributeModifier);
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

