/*
 * Decompiled with CFR 0.152.
 */
package net.azurune.runiclib.common.effect;

import net.azurune.runiclib.common.publicized.PublicMobEffect;
import net.azurune.runiclib.core.register.RLMobEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;

public class TrailBlazingEffect
extends PublicMobEffect {
    public TrailBlazingEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity living, int amplifier) {
        BlockPos pos = living.blockPosition();
        if (living.hasEffect(RLMobEffects.TRAIL_BLAZING) && living.level().getBlockState(pos).isAir() && !living.isCrouching()) {
            Player player;
            if (living instanceof Player && (player = (Player)living).isSprinting()) {
                living.level().setBlockAndUpdate(pos, Blocks.FIRE.defaultBlockState());
            } else {
                living.level().setBlockAndUpdate(pos, Blocks.FIRE.defaultBlockState());
            }
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

