/*
 * Decompiled with CFR 0.152.
 */
package net.azurune.runiclib.common.util;

import com.mojang.datafixers.util.Pair;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.azurune.runiclib.RunicLib;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RLToolActions {
    private static final Map<Block, Block> LOGS = new LinkedHashMap<Block, Block>();
    private static final Map<Block, BlockState> PATHS = new LinkedHashMap<Block, BlockState>();
    private static final Map<Block, Pair<Predicate<UseOnContext>, Consumer<UseOnContext>>> TILLABLES = new LinkedHashMap<Block, Pair<Predicate<UseOnContext>, Consumer<UseOnContext>>>();

    public static Map<Block, Block> getStrippables() {
        return LOGS;
    }

    public static void addStrippable(Block log, Block stripped) {
        boolean noStripAxis;
        boolean noLogAxis = !log.defaultBlockState().hasProperty((Property)RotatedPillarBlock.AXIS);
        boolean bl = noStripAxis = !stripped.defaultBlockState().hasProperty((Property)RotatedPillarBlock.AXIS);
        if (noLogAxis || noStripAxis) {
            String output = noLogAxis && noStripAxis ? "both" : (noLogAxis ? log.toString() : stripped.toString());
            RunicLib.LOGGER.error("Could not register axe stripping behavior for {} and {} due to a missing axis property in {}!", new Object[]{log, stripped, output});
        } else {
            LOGS.put(log, stripped);
        }
    }

    public static void addStrippable(Supplier<Block> log, Supplier<Block> stripped) {
        RLToolActions.addStrippable(log.get(), stripped.get());
    }

    public static Map<Block, BlockState> getPathables() {
        return PATHS;
    }

    public static void addPathable(Block block, Block path) {
        PATHS.put(block, path.defaultBlockState());
    }

    public static void addPathable(Supplier<Block> block, Supplier<Block> path) {
        RLToolActions.addPathable(block.get(), path.get());
    }

    public static Map<Block, Pair<Predicate<UseOnContext>, Consumer<UseOnContext>>> getTillables() {
        return TILLABLES;
    }

    public static void addTillableAdv(Block block, Predicate<UseOnContext> predicate, Consumer<UseOnContext> consumer) {
        TILLABLES.put(block, (Pair<Predicate<UseOnContext>, Consumer<UseOnContext>>)Pair.of(predicate, consumer));
    }

    public static void addTillable(Block block, Block tilled) {
        RLToolActions.addTillableAdv(block, HoeItem::onlyIfAirAbove, HoeItem.changeIntoState((BlockState)tilled.defaultBlockState()));
    }

    public static void addTillable(Supplier<Block> block, Supplier<Block> tilled) {
        RLToolActions.addTillable(block.get(), tilled.get());
    }

    public static void addTillableWithDrop(Block block, Block tilled, ItemLike output, boolean requireAirAbove) {
        Predicate<UseOnContext> inputPred = requireAirAbove ? HoeItem::onlyIfAirAbove : blah -> true;
        RLToolActions.addTillableAdv(block, inputPred, HoeItem.changeIntoStateAndDropItem((BlockState)tilled.defaultBlockState(), (ItemLike)output));
    }

    public static void addTillableWithDrop(Supplier<Block> block, Supplier<Block> tilled, ItemLike output, boolean requireAirAbove) {
        RLToolActions.addTillableWithDrop(block.get(), tilled.get(), output, requireAirAbove);
    }
}

