/*
 * Decompiled with CFR 0.152.
 */
package net.azurune.runiclib.core.mixin.server;

import java.util.Random;
import net.azurune.runiclib.core.init.RLDamageTypes;
import net.azurune.runiclib.core.init.RLTags;
import net.azurune.runiclib.core.register.RLAttributes;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityAttributesMixin {
    LivingEntity living = (LivingEntity)this;
    private static Random random = new Random();

    @Inject(at={@At(value="RETURN")}, method={"createLivingAttributes"})
    private static void runiclib$createLivingAttributes(CallbackInfoReturnable<AttributeSupplier.Builder> cir) {
        ((AttributeSupplier.Builder)cir.getReturnValue()).add(RLAttributes.DODGE_CHANCE).add(RLAttributes.LIFESTEAL_CHANCE).add(RLAttributes.LIFESTEAL_HEAL_AMOUNT).add(RLAttributes.VULNERABILITY_CHANCE).add(RLAttributes.VULNERABILITY_MULTIPLIER).add(RLAttributes.RETALIATION_CHANCE).add(RLAttributes.RETALIATION_AMOUNT).add(RLAttributes.BURNING_RETALIATION_LENGTH).add(RLAttributes.BURNING_RETALIATION_CHANCE).add(RLAttributes.CRITICAL_STRIKE_CHANCE).add(RLAttributes.CRITICAL_STRIKE_MULTIPLIER);
    }

    @Inject(at={@At(value="HEAD")}, method={"hurt"})
    public void runiclib$hurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (this.living.getAttributes().hasAttribute(RLAttributes.DODGE_CHANCE)) {
            double dodgeChance = this.living.getAttributeValue(RLAttributes.DODGE_CHANCE);
            if (!source.is(RLTags.DamageTypeTags.BYPASSES_DODGE) && dodgeChance != 0.0 && this.living.isAlive() && random.nextDouble(100.0) < dodgeChance) {
                this.living.level().playSound(null, this.living.getX(), this.living.getY(), this.living.getZ(), SoundEvents.ARMOR_EQUIP_GENERIC, SoundSource.PLAYERS, 1.0f, 1.0f);
                cir.cancel();
            }
        }
    }

    @ModifyVariable(at=@At(value="HEAD"), method={"hurt"}, argsOnly=true)
    public float runiclib$vulnerability(float amount) {
        if (this.living.getAttributes().hasAttribute(RLAttributes.VULNERABILITY_CHANCE) && this.living.getAttributes().hasAttribute(RLAttributes.VULNERABILITY_MULTIPLIER)) {
            double vulnerabilityChance = this.living.getAttributeValue(RLAttributes.VULNERABILITY_CHANCE);
            float vulnerabilityModifier = (float)this.living.getAttributeValue(RLAttributes.VULNERABILITY_MULTIPLIER);
            if (vulnerabilityChance != 0.0 && this.living.isAlive() && random.nextDouble(100.0) < vulnerabilityChance) {
                return amount + amount * vulnerabilityModifier;
            }
            return amount;
        }
        return amount;
    }

    @Inject(at={@At(value="TAIL")}, method={"getDamageAfterMagicAbsorb"})
    public void runiclib$getDamageAfterMagicAbsorb(DamageSource source, float amount, CallbackInfoReturnable<Float> cir) {
        LivingEntity attacker;
        Entity entity = source.getEntity();
        if (this.living.getAttributes().hasAttribute(RLAttributes.BURNING_RETALIATION_CHANCE) && this.living.getAttributes().hasAttribute(RLAttributes.BURNING_RETALIATION_LENGTH) && this.living.getAttributes().hasAttribute(RLAttributes.RETALIATION_CHANCE) && this.living.getAttributes().hasAttribute(RLAttributes.RETALIATION_AMOUNT) && entity instanceof LivingEntity && (attacker = (LivingEntity)entity).isAlive()) {
            double retaliationChance = this.living.getAttributeValue(RLAttributes.RETALIATION_CHANCE);
            double retaliationDamageAmount = this.living.getAttributeValue(RLAttributes.RETALIATION_AMOUNT);
            if (retaliationChance != 0.0 && random.nextDouble(100.0) < retaliationChance) {
                DamageSource damagesource = new DamageSource((Holder)entity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(RLDamageTypes.RETALIATION));
                attacker.hurt(damagesource, (float)retaliationDamageAmount);
            }
            double burningRetaliationChance = this.living.getAttributeValue(RLAttributes.BURNING_RETALIATION_CHANCE);
            double burningRetaliationLength = this.living.getAttributeValue(RLAttributes.BURNING_RETALIATION_LENGTH);
            if (burningRetaliationChance != 0.0 && random.nextDouble(100.0) < burningRetaliationChance && burningRetaliationLength > (double)attacker.getRemainingFireTicks()) {
                attacker.setRemainingFireTicks((int)burningRetaliationLength);
            }
        }
    }
}

