/*
 * Decompiled with CFR 0.152.
 */
package net.azurune.runiclib.core.platform;

import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.azurune.runiclib.RunicLib;
import net.azurune.runiclib.core.platform.services.RLRegistryHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class NeoForgeRLRegistryHelper
implements RLRegistryHelper {
    IEventBus modEventBus = ModLoadingContext.get().getActiveContainer().getEventBus();

    @Override
    public <T> Supplier<T> register(Registry<T> registry, String modid, String id, Supplier<T> supplier) {
        DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)registry.key(), (String)modid);
        deferredRegister.register(this.modEventBus);
        return deferredRegister.register(id, supplier);
    }

    @Override
    public <T> Holder<T> registerForHolder(Registry<T> registry, String modid, String id, T holder) {
        DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)registry.key(), (String)modid);
        deferredRegister.register(this.modEventBus);
        return deferredRegister.register(id, () -> holder);
    }

    @Override
    public <T extends Block> Supplier<T> registerBlock(String modid, String id, Supplier<T> supplier, boolean hasItem) {
        DeferredRegister blockDeferredRegister = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)modid);
        DeferredRegister itemDeferredRegister = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)modid);
        DeferredHolder blockRegister = blockDeferredRegister.register(id, supplier);
        if (hasItem) {
            itemDeferredRegister.register(id, () -> new BlockItem((Block)blockRegister.get(), new Item.Properties()));
        }
        blockDeferredRegister.register(this.modEventBus);
        itemDeferredRegister.register(this.modEventBus);
        return blockRegister;
    }

    @Override
    public <T extends Item> Supplier<T> registerItem(String modid, String id, Supplier<T> supplier) {
        DeferredRegister itemDeferredRegister = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)modid);
        itemDeferredRegister.register(this.modEventBus);
        return itemDeferredRegister.register(id, supplier);
    }

    @Override
    public <T extends Mob> SpawnEggItem registerSpawnEgg(Supplier<EntityType<T>> entity, int mainColor, int highlightColor) {
        return new DeferredSpawnEggItem(entity, mainColor, highlightColor, new Item.Properties());
    }

    @Override
    public <T extends Potion> Supplier<T> registerPotion(String modid, String id, Supplier<T> supplier) {
        DeferredRegister potionDeferredRegister = DeferredRegister.create((ResourceKey)Registries.POTION, (String)modid);
        potionDeferredRegister.register(this.modEventBus);
        return potionDeferredRegister.register(id, supplier);
    }

    @Override
    public <T extends BlockEntity> Supplier<BlockEntityType<T>> registerBlockEntityType(String modid, String id, Supplier<BlockEntityType<T>> supplier) {
        DeferredRegister blockEntityTypeDeferredRegister = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)modid);
        blockEntityTypeDeferredRegister.register(this.modEventBus);
        return blockEntityTypeDeferredRegister.register(id, supplier);
    }

    @Override
    public <T extends BlockEntity> BlockEntityType<T> createBlockEntity(RLRegistryHelper.BlockEntitySupplier<T> supplier, Block ... blocks) {
        return BlockEntityType.Builder.of(supplier::create, (Block[])blocks).build(null);
    }

    @Override
    public <T extends EntityType<?>> Supplier<T> registerEntityType(String modid, String id, Supplier<T> supplier) {
        DeferredRegister entityTypeDeferredRegister = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)modid);
        entityTypeDeferredRegister.register(this.modEventBus);
        return entityTypeDeferredRegister.register(id, supplier);
    }

    @Override
    public Holder<MobEffect> registerEffect(String modid, String id, MobEffect effect) {
        DeferredRegister mobEffectDeferredRegister = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)modid);
        mobEffectDeferredRegister.register(this.modEventBus);
        return mobEffectDeferredRegister.register(id, () -> effect);
    }

    @Override
    public <T extends CreativeModeTab> Supplier<T> registerCreativeModeTab(String modid, String id, Supplier<T> supplier) {
        DeferredRegister creativeModeTabDeferredRegister = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)modid);
        creativeModeTabDeferredRegister.register(this.modEventBus);
        return creativeModeTabDeferredRegister.register(id, supplier);
    }

    @Override
    public Supplier<ParticleType<?>> registerParticle(String modid, String id, Supplier<ParticleType<?>> supplier) {
        DeferredRegister particleTypeDeferredRegister = DeferredRegister.create((ResourceKey)Registries.PARTICLE_TYPE, (String)modid);
        particleTypeDeferredRegister.register(this.modEventBus);
        return particleTypeDeferredRegister.register(id, supplier);
    }

    @Override
    public Holder<Attribute> registerAttribute(String modid, String id, Attribute attribute) {
        DeferredRegister attributeDeferredRegister = DeferredRegister.create((ResourceKey)Registries.ATTRIBUTE, (String)modid);
        attributeDeferredRegister.register(this.modEventBus);
        return attributeDeferredRegister.register(id, () -> attribute);
    }

    @Override
    public <T> Supplier<DataComponentType<T>> registerComponentType(String modid, String id, UnaryOperator<DataComponentType.Builder<T>> builder) {
        DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)modid);
        deferredRegister.register(this.modEventBus);
        return deferredRegister.register(id, () -> ((DataComponentType.Builder)builder.apply(DataComponentType.builder())).build());
    }

    @Override
    public <T extends AbstractContainerMenu> Supplier<MenuType<T>> registerMenu(String modid, String id, RLRegistryHelper.MenuSupplier<T> factory) {
        DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)Registries.MENU, (String)modid);
        deferredRegister.register(this.modEventBus);
        return deferredRegister.register(id, () -> new MenuType(factory::create, FeatureFlags.DEFAULT_FLAGS));
    }

    @Override
    public <T extends Recipe<?>> Supplier<RecipeType<T>> registerRecipeType(String modid, String id) {
        DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)Registries.RECIPE_TYPE, (String)modid);
        deferredRegister.register(this.modEventBus);
        return deferredRegister.register(id, () -> RecipeType.simple((ResourceLocation)RunicLib.customid(modid, id)));
    }

    @Override
    public <T extends Recipe<?>> Supplier<RecipeSerializer<T>> registerRecipeSerializer(String modid, String id, RecipeSerializer<T> serializer) {
        DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)modid);
        deferredRegister.register(this.modEventBus);
        return deferredRegister.register(id, () -> serializer);
    }
}

