/*
 * Decompiled with CFR 0.152.
 */
package com.sol2f.server;

import com.sol2f.SpiceOfLifeFabricFlavor;
import com.sol2f.config.Sol2FConfig;
import com.sol2f.network.FoodPackets;
import com.sol2f.network.S2CFoodListSync;
import com.sol2f.server.FoodUseHandler;
import java.util.ArrayList;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;

public class ServerEventHandlers {
    public static void register() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            try {
                if (handler.field_14140 == null) {
                    return;
                }
                FoodUseHandler.initializePlayer(handler.field_14140);
            }
            catch (Exception e) {
                SpiceOfLifeFabricFlavor.LOGGER.error("sol2f: error during player join init", (Throwable)e);
            }
        });
        ServerPlayerEvents.COPY_FROM.register((oldPlayer, newPlayer, alive) -> {
            try {
                if (!alive && ((Sol2FConfig)AutoConfig.getConfigHolder(Sol2FConfig.class).getConfig()).features.resetOnDeath) {
                    FoodUseHandler.clearEatenFoods(newPlayer);
                } else {
                    FoodUseHandler.initializePlayer(newPlayer);
                }
            }
            catch (Exception e) {
                SpiceOfLifeFabricFlavor.LOGGER.error("sol2f: error during player respawn init", (Throwable)e);
            }
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)FoodPackets.C2S_REQUEST_LIST, (server, player, handler, buf, responder) -> {
            try {
                class_2487 nbt = new class_2487();
                player.method_5647(nbt);
                class_2499 consumed = nbt.method_10545("sol2f:consumed_foods") ? nbt.method_10554("sol2f:consumed_foods", 8) : new class_2499();
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < consumed.size(); ++i) {
                    list.add(consumed.method_10608(i));
                }
                S2CFoodListSync.sendTo(player, list);
            }
            catch (Exception e) {
                SpiceOfLifeFabricFlavor.LOGGER.error("sol2f: error responding to client list request", (Throwable)e);
            }
        });
    }
}

