/*
 * Decompiled with CFR 0.152.
 */
package com.sol2f.Gui;

import com.sol2f.client.FoodClient;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class FoodBookScreen
extends class_437 {
    private static final int GUI_WIDTH = 276;
    private static final int GUI_HEIGHT = 166;
    private static final int MAIN_PANEL_WIDTH = 248;
    private final class_2960 GUI_TEXTURE = new class_2960("sol2f", "textures/gui/food_book.png");
    private int scrollPageOffset = 0;
    private static final int ITEMS_PER_PAGE = 96;
    private class_1799 hoveredStack = class_1799.field_8037;

    public FoodBookScreen() {
        super((class_2561)class_2561.method_43471((String)"sol2f.gui.food_book.title"));
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int currentSliderY;
        this.method_25420(context);
        int guiLeft = (this.field_22789 - 248) / 2;
        int guiTop = (this.field_22790 - 166) / 2;
        int totalItem = FoodClient.getConsumedCount();
        int pageCount = (totalItem + 96 - 1) / 96;
        int maxOffset = Math.max(0, (totalItem + 96 - 1) / 96 - 1);
        this.scrollPageOffset = Math.min(0, Math.min(this.scrollPageOffset, maxOffset));
        context.method_25290(this.GUI_TEXTURE, guiLeft, guiTop, 0.0f, 0.0f, 276, 166, 276, 342);
        class_5250 title = class_2561.method_43471((String)"sol2f.gui.food_book.title");
        context.method_51439(this.field_22793, (class_2561)title, guiLeft + 9, guiTop + 5, 0xFFFFFF, true);
        if (pageCount <= 1) {
            currentSliderY = 17;
        } else {
            int trackHeight = 133;
            currentSliderY = 17 + trackHeight * this.scrollPageOffset / (pageCount - 1);
        }
        int sliderX = guiLeft + 232;
        int sliderY = guiTop + currentSliderY;
        context.method_25290(this.GUI_TEXTURE, sliderX, sliderY, 0.0f, 333.0f, 7, 9, 276, 342);
        this.renderItemGrid(context, guiLeft, guiTop, mouseX, mouseY);
        super.method_25394(context, mouseX, mouseY, delta);
        if (!this.hoveredStack.method_7960()) {
            List tooltip = this.hoveredStack.method_7950((class_1657)class_310.method_1551().field_1724, (class_1836)class_1836.class_1837.field_41070);
            if (tooltip.isEmpty()) {
                tooltip.add(this.hoveredStack.method_7964());
                if (tooltip.isEmpty()) {
                    tooltip.add(class_2561.method_43471((String)"sol2f.gui.food_book.unknown_item_text"));
                }
            } else {
                context.method_51434(this.field_22793, tooltip, mouseX, mouseY);
            }
        }
    }

    private void renderItemGrid(class_332 context, int guiLeft, int guiTop, int mouseX, int mouseY) {
        int totalItem = FoodClient.getConsumedCount();
        List<String> consumedItems = FoodClient.getConsumedSnapshot();
        int startIndex = this.scrollPageOffset * 96;
        for (int row = 0; row < 8; ++row) {
            for (int col = 0; col < 12; ++col) {
                int index = row * 12 + col;
                int itemIndex = startIndex + index;
                int slotX = guiLeft + 9 + col * 18;
                int slotY = guiTop + 16 + row * 18;
                if (itemIndex >= totalItem) continue;
                String itemId = consumedItems.get(itemIndex);
                try {
                    class_2960 id = new class_2960(itemId);
                    class_1792 item = class_7923.field_41178.method_17966(id).orElse(class_1802.field_8162);
                    if (item == class_1802.field_8162) continue;
                    class_1799 stack = new class_1799((class_1935)item);
                    context.method_51427(stack, slotX + 1, slotY + 1);
                    context.method_51431(this.field_22793, stack, slotX + 1, slotY + 1);
                    if (!this.isMouseOver(slotX, slotY, mouseX, mouseY)) continue;
                    this.hoveredStack = stack;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private boolean isMouseOver(int slotX, int slotY, int mouseX, int mouseY) {
        return mouseX >= slotX && mouseY >= slotY && mouseX < slotX + 18 && mouseY < slotY + 18;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        int totalItem = FoodClient.getConsumedCount();
        if (amount > 0.0) {
            this.scrollPageOffset = Math.max(0, this.scrollPageOffset - 1);
        } else if (amount < 0.0) {
            int maxOffset = (totalItem + 96 - 1) / 96 - 1;
            this.scrollPageOffset = Math.min(maxOffset, this.scrollPageOffset + 1);
        }
        return true;
    }
}

