/*
 * Decompiled with CFR 0.152.
 */
package com.sol2f;

import com.sol2f.command.FoodCommands;
import com.sol2f.config.Sol2FConfig;
import com.sol2f.server.FoodUseHandler;
import com.sol2f.server.ServerEventHandlers;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpiceOfLifeFabricFlavor
implements ModInitializer {
    public static final String MOD_ID = "sol2f";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"sol2f");
    private static BufferedWriter DEV_FILE_WRITER = null;
    private static final DateTimeFormatter TIME_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter STARTUP_FILE_FMT = DateTimeFormatter.ofPattern("yyyy-M-d-HH-mm-ss");

    public void onInitialize() {
        block7: {
            LOGGER.info("SpiceOfLife: initializing");
            AutoConfig.register(Sol2FConfig.class, GsonConfigSerializer::new);
            try {
                if (!((Sol2FConfig)AutoConfig.getConfigHolder(Sol2FConfig.class).getConfig()).features.developerMode) break block7;
                Path gameDir = FabricLoader.getInstance().getGameDir();
                Path logsDir = gameDir.resolve("logs").resolve(MOD_ID);
                if (!Files.exists(logsDir, new LinkOption[0])) {
                    Files.createDirectories(logsDir, new FileAttribute[0]);
                }
                String startupTime = LocalDateTime.now().format(STARTUP_FILE_FMT);
                String logFile = logsDir.resolve("sol2f_" + startupTime + ".log").toString();
                Class<?> loggerFactoryClass = Class.forName("org.slf4j.LoggerFactory");
                try {
                    Class<?> loggerContextClass = Class.forName("ch.qos.logback.classic.LoggerContext");
                    Class<?> patternEncoderClass = Class.forName("ch.qos.logback.classic.encoder.PatternLayoutEncoder");
                    Class<?> fileAppenderClass = Class.forName("ch.qos.logback.core.FileAppender");
                    Object ctx = loggerFactoryClass.getMethod("getILoggerFactory", new Class[0]).invoke(null, new Object[0]);
                    Constructor<?> encCtor = patternEncoderClass.getConstructor(new Class[0]);
                    Object ple = encCtor.newInstance(new Object[0]);
                    patternEncoderClass.getMethod("setPattern", String.class).invoke(ple, "%d{HH:mm:ss} [%thread] %-5level %logger{36} - %msg%n");
                    patternEncoderClass.getMethod("setContext", loggerContextClass).invoke(ple, ctx);
                    patternEncoderClass.getMethod("start", new Class[0]).invoke(ple, new Object[0]);
                    Constructor<?> faCtor = fileAppenderClass.getConstructor(new Class[0]);
                    Object fa = faCtor.newInstance(new Object[0]);
                    fileAppenderClass.getMethod("setFile", String.class).invoke(fa, logFile);
                    fileAppenderClass.getMethod("setEncoder", Class.forName("ch.qos.logback.core.encoder.Encoder")).invoke(fa, ple);
                    fileAppenderClass.getMethod("setContext", loggerContextClass).invoke(fa, ctx);
                    fileAppenderClass.getMethod("setName", String.class).invoke(fa, "SOL2F_FILE_APPENDER");
                    fileAppenderClass.getMethod("start", new Class[0]).invoke(fa, new Object[0]);
                    Class<?> classicLoggerClass = Class.forName("ch.qos.logback.classic.Logger");
                    Logger root = LoggerFactory.getLogger((String)"ROOT");
                    classicLoggerClass.getMethod("addAppender", Class.forName("ch.qos.logback.core.Appender")).invoke((Object)root, fa);
                    LOGGER.info("sol2f: developerMode enabled - logging to {}", (Object)logFile);
                    SpiceOfLifeFabricFlavor.writeDevLog("sol2f: developerMode enabled - logging to %s", logFile);
                }
                catch (Throwable t) {
                    LOGGER.warn("sol2f: Logback not available for developerMode file logging, falling back to simple file writer", t);
                    SpiceOfLifeFabricFlavor.writeDevLog("sol2f: Logback not available for developerMode file logging, falling back to simple file writer: %s", t.toString());
                    try {
                        DEV_FILE_WRITER = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(logFile, true), StandardCharsets.UTF_8));
                        DEV_FILE_WRITER.write("--- sol2f developer log started at " + LocalDateTime.now().format(TIME_FMT) + " ---\n");
                        DEV_FILE_WRITER.flush();
                    }
                    catch (Throwable ioe) {
                        LOGGER.warn("sol2f: failed to open fallback dev log file {}", (Object)logFile, (Object)ioe);
                        DEV_FILE_WRITER = null;
                    }
                }
            }
            catch (Throwable t) {
                LOGGER.warn("sol2f: failed to enable developerMode file logger", t);
                SpiceOfLifeFabricFlavor.writeDevLog("sol2f: failed to enable developerMode file logger: %s", t.toString());
            }
        }
        FoodUseHandler.register();
        ServerEventHandlers.register();
        FoodCommands.register();
        LOGGER.info("SpiceOfLife: initialized");
    }

    public static void writeDevLog(String fmt, Object ... args) {
        try {
            LOGGER.info(fmt.replace("{}", "%s"), args);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (DEV_FILE_WRITER != null) {
            try {
                String msg = String.format(fmt.replace("{}", "%s"), args);
                LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
                m.put("message", msg);
                SpiceOfLifeFabricFlavor.writeStructuredDevLog(m);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void writeStructuredDevLog(Map<String, String> fields) {
        if (DEV_FILE_WRITER == null) {
            return;
        }
        try {
            StringBuilder sb = new StringBuilder();
            String ts = LocalDateTime.now().format(TIME_FMT);
            sb.append('[').append(ts).append(']');
            sb.append('{');
            boolean first = true;
            for (Map.Entry<String, String> e : fields.entrySet()) {
                if (!first) {
                    sb.append(';');
                }
                first = false;
                String k = e.getKey();
                String v = e.getValue();
                if (v == null) {
                    v = "";
                }
                v = v.replace("\\", "\\\\").replace("\"", "\\\"");
                sb.append('\"').append(k).append('\"').append("=").append('\"').append(v).append('\"');
            }
            sb.append('}');
            sb.append('\n');
            DEV_FILE_WRITER.write(sb.toString());
            DEV_FILE_WRITER.flush();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

