/*
 * Decompiled with CFR 0.152.
 */
package com.sol2f.server;

import com.sol2f.SpiceOfLifeFabricFlavor;
import com.sol2f.config.Sol2FConfig;
import com.sol2f.network.S2CFoodListSync;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.UUID;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_7923;

public class FoodUseHandler {
    private static final UUID HEALTH_MODIFIER_ID = UUID.fromString("a6b4d2a1-9f23-41a2-a6c6-b56db969f6de");
    private static final String PERSISTENT_ROOT = "sol2f";
    private static final String CONSUMED_KEY = "consumed_foods";
    private static final String LEGACY_KEY = "sol2f:consumed_foods";
    private static final String DATA_VERSION = "data_version";
    private static final int CURRENT_VERSION = 1;
    private static Method persistentGetterMethod = null;
    private static boolean persistentReflectionInitialized = false;

    public static void register() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onFoodEaten(class_3222 serverPlayer, class_1799 stack) {
        if (stack == null || stack.method_7909().method_19264() == null) {
            return;
        }
        String id = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
        class_3222 class_32222 = serverPlayer;
        synchronized (class_32222) {
            try {
                if (((Sol2FConfig)AutoConfig.getConfigHolder(Sol2FConfig.class).getConfig()).features.developerMode) {
                    SpiceOfLifeFabricFlavor.LOGGER.info("sol2f-log: eat attempt player={} food={}", (Object)serverPlayer.method_5477().getString(), (Object)id);
                    LinkedHashMap<String, String> _f = new LinkedHashMap<String, String>();
                    _f.put("event", "eat_attempt");
                    _f.put("player", serverPlayer.method_5477().getString());
                    _f.put("food", id);
                    SpiceOfLifeFabricFlavor.writeStructuredDevLog(_f);
                }
            }
            catch (Throwable _f) {
                // empty catch block
            }
            Set<String> current = FoodUseHandler.getEatenFoods(serverPlayer);
            if (((Sol2FConfig)AutoConfig.getConfigHolder(Sol2FConfig.class).getConfig()).features.developerMode) {
                SpiceOfLifeFabricFlavor.LOGGER.info("sol2f-log: before change player={} eaten={}", (Object)serverPlayer.method_5477().getString(), current);
                LinkedHashMap<String, String> _b = new LinkedHashMap<String, String>();
                _b.put("event", "before_change");
                _b.put("player", serverPlayer.method_5477().getString());
                _b.put("eaten", current.toString());
                SpiceOfLifeFabricFlavor.writeStructuredDevLog(_b);
            }
            if (!current.contains(id)) {
                current.add(id);
                FoodUseHandler.saveEatenFoods(serverPlayer, current);
                Set<String> authoritative = FoodUseHandler.getEatenFoods(serverPlayer);
                if (!authoritative.contains(id)) {
                    SpiceOfLifeFabricFlavor.LOGGER.warn("sol2f: after save, authoritative eaten set does not contain {} for player {}", (Object)id, (Object)serverPlayer.method_5477().getString());
                } else {
                    double prevMax = serverPlayer.method_6063();
                    FoodUseHandler.applyHealthModifier(serverPlayer, authoritative);
                    double newMax = serverPlayer.method_6063();
                    FoodUseHandler.syncToClient(serverPlayer, authoritative);
                    serverPlayer.method_7353((class_2561)class_2561.method_43469((String)"sol2f.msg.first_eaten", (Object[])new Object[]{class_2561.method_43470((String)id)}), false);
                    SpiceOfLifeFabricFlavor.LOGGER.info("sol2f: Player {} first ate {}", (Object)serverPlayer.method_5477().getString(), (Object)id);
                    try {
                        if (((Sol2FConfig)AutoConfig.getConfigHolder(Sol2FConfig.class).getConfig()).features.developerMode) {
                            SpiceOfLifeFabricFlavor.LOGGER.info("sol2f-log: after eat player={} food={} prevMax={} newMax={} eaten={}", new Object[]{serverPlayer.method_5477().getString(), id, prevMax, newMax, authoritative});
                            LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
                            fields.put("event", "after_eat");
                            fields.put("player", serverPlayer.method_5477().getString());
                            fields.put("food", id);
                            fields.put("prevMax", Double.toString(prevMax));
                            fields.put("newMax", Double.toString(newMax));
                            fields.put("eaten", authoritative.toString());
                            fields.put("unique", Integer.toString(authoritative.size()));
                            fields.put("perHp", Double.toString(((Sol2FConfig)AutoConfig.getConfigHolder(Sol2FConfig.class).getConfig()).features.healthyGain));
                            fields.put("bonus", Double.toString(Math.min(((Sol2FConfig)AutoConfig.getConfigHolder(Sol2FConfig.class).getConfig()).healthy.defaultHealthy + authoritative.size() * ((Sol2FConfig)AutoConfig.getConfigHolder(Sol2FConfig.class).getConfig()).features.healthyGain, ((Sol2FConfig)AutoConfig.getConfigHolder(Sol2FConfig.class).getConfig()).healthy.maxHealthy) - ((Sol2FConfig)AutoConfig.getConfigHolder(Sol2FConfig.class).getConfig()).healthy.defaultHealthy));
                            fields.put("modifier_uuid", HEALTH_MODIFIER_ID.toString());
                            SpiceOfLifeFabricFlavor.writeStructuredDevLog(fields);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if (((Sol2FConfig)AutoConfig.getConfigHolder(Sol2FConfig.class).getConfig()).features.developerMode) {
                SpiceOfLifeFabricFlavor.LOGGER.info("sol2f-log: eat ignored (already eaten) player={} food={} eaten={}", new Object[]{serverPlayer.method_5477().getString(), id, current});
                LinkedHashMap<String, String> _i = new LinkedHashMap<String, String>();
                _i.put("event", "eat_ignored");
                _i.put("player", serverPlayer.method_5477().getString());
                _i.put("food", id);
                _i.put("eaten", current.toString());
                SpiceOfLifeFabricFlavor.writeStructuredDevLog(_i);
            }
        }
    }

    private static void ensurePersistentReflection() {
        if (persistentReflectionInitialized) {
            return;
        }
        persistentReflectionInitialized = true;
        try {
            Class<?> saver = null;
            try {
                saver = Class.forName("com.food_advancement.util.IEntityDataSaver");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (saver == null) {
                saver = Class.forName("com.sol2f.util.IEntityDataSaver");
            }
            persistentGetterMethod = saver.getMethod("getPersistentData", new Class[0]);
        }
        catch (Throwable t) {
            persistentGetterMethod = null;
        }
    }

    private static class_2487 readPersistentCompound(class_3222 player) {
        FoodUseHandler.ensurePersistentReflection();
        if (persistentGetterMethod != null) {
            try {
                Object res = persistentGetterMethod.invoke((Object)player, new Object[0]);
                if (res instanceof class_2487) {
                    return (class_2487)res;
                }
            }
            catch (Throwable t) {
                SpiceOfLifeFabricFlavor.LOGGER.debug("Persistent reflection failed, falling back", t);
            }
        }
        try {
            class_2487 nbt = new class_2487();
            player.method_5647(nbt);
            if (nbt.method_10573(PERSISTENT_ROOT, 10)) {
                return nbt.method_10562(PERSISTENT_ROOT);
            }
            if (nbt.method_10573(LEGACY_KEY, 9)) {
                class_2499 legacy = nbt.method_10554(LEGACY_KEY, 8);
                class_2487 root = new class_2487();
                root.method_10566(CONSUMED_KEY, (class_2520)legacy);
                root.method_10569(DATA_VERSION, 1);
                nbt.method_10566(PERSISTENT_ROOT, (class_2520)root);
                player.method_5651(nbt);
                return root;
            }
            class_2487 root = new class_2487();
            root.method_10569(DATA_VERSION, 1);
            nbt.method_10566(PERSISTENT_ROOT, (class_2520)root);
            player.method_5651(nbt);
            return root;
        }
        catch (Throwable t) {
            SpiceOfLifeFabricFlavor.LOGGER.error("Failed to read persistent compound", t);
            return new class_2487();
        }
    }

    private static void writePersistentCompound(class_3222 player, class_2487 data) {
        block17: {
            block16: {
                FoodUseHandler.ensurePersistentReflection();
                if (persistentGetterMethod != null) {
                    try {
                        Object res = persistentGetterMethod.invoke((Object)player, new Object[0]);
                        if (!(res instanceof class_2487)) break block16;
                        class_2487 target = (class_2487)res;
                        for (String key : data.method_10541()) {
                            target.method_10566(key, data.method_10580(key));
                        }
                        SpiceOfLifeFabricFlavor.LOGGER.debug("sol2f: attempted reflection write to persistent data for player {}", (Object)player.method_5477().getString());
                        try {
                            Object verify = persistentGetterMethod.invoke((Object)player, new Object[0]);
                            if (verify instanceof class_2487) {
                                class_2487 v = (class_2487)verify;
                                if (v.method_10573(CONSUMED_KEY, 9)) {
                                    SpiceOfLifeFabricFlavor.LOGGER.info("sol2f: persistent reflection write verified for player {}: {}", (Object)player.method_5477().getString(), (Object)v.method_10554(CONSUMED_KEY, 8));
                                    LinkedHashMap<String, String> _r = new LinkedHashMap<String, String>();
                                    _r.put("event", "persistent_reflection_write_verified");
                                    _r.put("player", player.method_5477().getString());
                                    _r.put("consumed", v.method_10554(CONSUMED_KEY, 8).toString());
                                    SpiceOfLifeFabricFlavor.writeStructuredDevLog(_r);
                                } else {
                                    SpiceOfLifeFabricFlavor.LOGGER.warn("sol2f: persistent reflection write did not find {} for player {}", (Object)CONSUMED_KEY, (Object)player.method_5477().getString());
                                }
                            }
                        }
                        catch (Throwable t) {
                            SpiceOfLifeFabricFlavor.LOGGER.debug("sol2f: verification after reflection write failed", t);
                        }
                        SpiceOfLifeFabricFlavor.LOGGER.debug("sol2f: falling back to NBT write after reflection attempt for player {}", (Object)player.method_5477().getString());
                    }
                    catch (Throwable t) {
                        SpiceOfLifeFabricFlavor.LOGGER.debug("Persistent reflection write failed, falling back", t);
                    }
                }
            }
            try {
                class_2487 nbt = new class_2487();
                player.method_5647(nbt);
                nbt.method_10566(PERSISTENT_ROOT, (class_2520)data);
                player.method_5651(nbt);
                try {
                    class_2487 check = new class_2487();
                    player.method_5647(check);
                    if (check.method_10573(PERSISTENT_ROOT, 10)) {
                        class_2487 root = check.method_10562(PERSISTENT_ROOT);
                        if (root.method_10573(CONSUMED_KEY, 9)) {
                            SpiceOfLifeFabricFlavor.LOGGER.info("sol2f: fallback write verified for player {}: {}", (Object)player.method_5477().getString(), (Object)root.method_10554(CONSUMED_KEY, 8));
                            LinkedHashMap<String, String> _rf = new LinkedHashMap<String, String>();
                            _rf.put("event", "fallback_write_verified");
                            _rf.put("player", player.method_5477().getString());
                            _rf.put("consumed", root.method_10554(CONSUMED_KEY, 8).toString());
                            SpiceOfLifeFabricFlavor.writeStructuredDevLog(_rf);
                        } else {
                            SpiceOfLifeFabricFlavor.LOGGER.warn("sol2f: fallback write did not find {} in player {}'s persistent root", (Object)CONSUMED_KEY, (Object)player.method_5477().getString());
                        }
                        break block17;
                    }
                    SpiceOfLifeFabricFlavor.LOGGER.warn("sol2f: fallback write did not produce persistent root for player {}", (Object)player.method_5477().getString());
                }
                catch (Throwable t) {
                    SpiceOfLifeFabricFlavor.LOGGER.debug("sol2f: verification after fallback write failed", t);
                }
            }
            catch (Throwable t) {
                SpiceOfLifeFabricFlavor.LOGGER.error("Failed to write persistent compound", t);
            }
        }
    }

    public static Set<String> getEatenFoods(class_3222 player) {
        try {
            class_2487 persistent = FoodUseHandler.readPersistentCompound(player);
            class_2499 consumed = persistent.method_10573(CONSUMED_KEY, 9) ? persistent.method_10554(CONSUMED_KEY, 8) : new class_2499();
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < consumed.size(); ++i) {
                set.add(consumed.method_10608(i));
            }
            return set;
        }
        catch (Exception e) {
            SpiceOfLifeFabricFlavor.LOGGER.error("sol2f: failed to get eaten foods", (Throwable)e);
            return new HashSet<String>();
        }
    }

    private static void saveEatenFoods(class_3222 player, Set<String> eatenFoods) {
        try {
            class_2487 persistent = FoodUseHandler.readPersistentCompound(player);
            SpiceOfLifeFabricFlavor.LOGGER.info("sol2f: before save for player {} persistent contains: {}", (Object)player.method_5477().getString(), persistent.method_10573(CONSUMED_KEY, 9) ? persistent.method_10554(CONSUMED_KEY, 8) : "<none>");
            class_2499 newList = new class_2499();
            for (String food : eatenFoods) {
                newList.add((Object)class_2519.method_23256((String)food));
            }
            persistent.method_10566(CONSUMED_KEY, (class_2520)newList);
            persistent.method_10569(DATA_VERSION, 1);
            FoodUseHandler.writePersistentCompound(player, persistent);
            try {
                class_2487 after = FoodUseHandler.readPersistentCompound(player);
                SpiceOfLifeFabricFlavor.LOGGER.info("sol2f: after save for player {} persistent contains: {}", (Object)player.method_5477().getString(), after.method_10573(CONSUMED_KEY, 9) ? after.method_10554(CONSUMED_KEY, 8) : "<none>");
            }
            catch (Throwable t) {
                SpiceOfLifeFabricFlavor.LOGGER.warn("sol2f: failed to read back persistent compound after save for player {}", (Object)player.method_5477().getString());
            }
        }
        catch (Exception e) {
            SpiceOfLifeFabricFlavor.LOGGER.error("sol2f: failed to save eaten foods", (Throwable)e);
        }
    }

    public static void addEatenFood(class_3222 player, class_1799 food) {
        String foodId;
        Set<String> eatenFoods = FoodUseHandler.getEatenFoods(player);
        if (eatenFoods.add(foodId = class_7923.field_41178.method_10221((Object)food.method_7909()).toString())) {
            FoodUseHandler.saveEatenFoods(player, eatenFoods);
            FoodUseHandler.applyHealthModifier(player, eatenFoods);
            FoodUseHandler.syncToClient(player, eatenFoods);
        }
    }

    public static void syncToClient(class_3222 player, Set<String> eatenFoods) {
        try {
            S2CFoodListSync.sendTo(player, new ArrayList<String>(eatenFoods));
            SpiceOfLifeFabricFlavor.LOGGER.info("Synced food list to client: {}", eatenFoods);
        }
        catch (Exception e) {
            SpiceOfLifeFabricFlavor.LOGGER.error("Failed to sync to client", (Throwable)e);
        }
    }

    public static void clearEatenFoods(class_3222 player) {
        HashSet<String> empty = new HashSet<String>();
        FoodUseHandler.saveEatenFoods(player, empty);
        Set<String> eaten = FoodUseHandler.getEatenFoods(player);
        FoodUseHandler.applyHealthModifier(player, eaten);
        FoodUseHandler.syncToClient(player, eaten);
    }

    public static void applyHealthModifier(class_3222 player) {
        FoodUseHandler.applyHealthModifier(player, FoodUseHandler.getEatenFoods(player));
    }

    public static void applyHealthModifier(class_3222 player, Set<String> eatenFoods) {
        try {
            class_1324 attr = player.method_5996(class_5134.field_23716);
            if (attr == null) {
                SpiceOfLifeFabricFlavor.LOGGER.error("Health attribute instance is null for player {}", (Object)player.method_5477().getString());
                return;
            }
            double defaultBase = ((Sol2FConfig)AutoConfig.getConfigHolder(Sol2FConfig.class).getConfig()).healthy.defaultHealthy;
            attr.method_6192(defaultBase);
            SpiceOfLifeFabricFlavor.LOGGER.info("Set base health to {} for player {}", (Object)defaultBase, (Object)player.method_5477().getString());
            attr.method_6200(HEALTH_MODIFIER_ID);
            SpiceOfLifeFabricFlavor.LOGGER.info("Removed existing health modifier for player {}", (Object)player.method_5477().getString());
            int unique = eatenFoods.size();
            double perHp = ((Sol2FConfig)AutoConfig.getConfigHolder(Sol2FConfig.class).getConfig()).features.healthyGain;
            double healthBonus = (double)unique * perHp;
            double maxHealthy = ((Sol2FConfig)AutoConfig.getConfigHolder(Sol2FConfig.class).getConfig()).healthy.maxHealthy;
            double newMaxHealth = Math.min(defaultBase + healthBonus, maxHealthy);
            if (newMaxHealth > defaultBase) {
                class_1322 mod = new class_1322(HEALTH_MODIFIER_ID, "sol2f Health Bonus", newMaxHealth - defaultBase, class_1322.class_1323.field_6328);
                attr.method_26837(mod);
                SpiceOfLifeFabricFlavor.LOGGER.info("Added health modifier: {} for player {} (unique={}, perHp={}, bonus={})", new Object[]{mod, player.method_5477().getString(), unique, perHp, healthBonus});
            } else {
                SpiceOfLifeFabricFlavor.LOGGER.info("No health bonus applied. Unique foods: {}, perHp: {}, computed bonus: {}, Max health: {}", new Object[]{unique, perHp, healthBonus, maxHealthy});
            }
            if (((Sol2FConfig)AutoConfig.getConfigHolder(Sol2FConfig.class).getConfig()).features.healToMaxOnIncrease) {
                player.method_6033(player.method_6063());
            } else if (((Sol2FConfig)AutoConfig.getConfigHolder(Sol2FConfig.class).getConfig()).features.healthIncrease > 0) {
                float currentHealth = player.method_6032();
                float increase = ((Sol2FConfig)AutoConfig.getConfigHolder(Sol2FConfig.class).getConfig()).features.healthIncrease;
                float newHealth = Math.min(currentHealth + increase, player.method_6063());
                player.method_6033(newHealth);
            }
            SpiceOfLifeFabricFlavor.LOGGER.info("Player {} healed to max health: {}", (Object)player.method_5477().getString(), (Object)Float.valueOf(player.method_6063()));
        }
        catch (Exception e) {
            SpiceOfLifeFabricFlavor.LOGGER.error("Failed to apply health modifier for player {}", (Object)player.method_5477().getString(), (Object)e);
        }
    }
}

