/*
 * Decompiled with CFR 0.152.
 */
package com.food_advancement;

import com.food_advancement.PlayerFoodState;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_5134;
import net.minecraft.server.MinecraftServer;

public class FoodStateSaverAndLoader
extends class_18 {
    private static final String NBT_KEY = "food_advancement_state";
    private HashMap<UUID, PlayerFoodState> players = new HashMap();

    public class_2487 method_75(class_2487 nbt) {
        class_2487 playersNbt = new class_2487();
        this.players.forEach((uuid, playerState) -> {
            class_2487 playerNbt = new class_2487();
            class_2499 foodList = new class_2499();
            for (String food : playerState.getEatenFoods()) {
                foodList.add((Object)class_2519.method_23256((String)food));
            }
            playerNbt.method_10566("foods", (class_2520)foodList);
            playerNbt.method_10549("maxHealth", playerState.getMaxHealth());
            playersNbt.method_10566(uuid.toString(), (class_2520)playerNbt);
        });
        nbt.method_10566("players", (class_2520)playersNbt);
        return nbt;
    }

    public static FoodStateSaverAndLoader createFromNbt(class_2487 nbt) {
        FoodStateSaverAndLoader state = new FoodStateSaverAndLoader();
        class_2487 playersNbt = nbt.method_10562("players");
        playersNbt.method_10541().forEach(key -> {
            PlayerFoodState playerState = new PlayerFoodState();
            class_2487 playerNbt = playersNbt.method_10562(key);
            class_2499 foodList = playerNbt.method_10554("foods", 8);
            for (int i = 0; i < foodList.size(); ++i) {
                playerState.addEatenFood(foodList.method_10608(i));
            }
            playerState.setMaxHealth(playerNbt.method_10574("maxHealth"));
            UUID uuid = UUID.fromString(key);
            state.players.put(uuid, playerState);
        });
        return state;
    }

    public static FoodStateSaverAndLoader getServerState(MinecraftServer server) {
        class_26 persistentStateManager = server.method_3847(class_1937.field_25179).method_17983();
        return (FoodStateSaverAndLoader)persistentStateManager.method_17924(nbt -> FoodStateSaverAndLoader.createFromNbt(nbt), () -> new FoodStateSaverAndLoader(), "food_advancement");
    }

    public static PlayerFoodState getPlayerState(class_1309 player) {
        FoodStateSaverAndLoader serverState = FoodStateSaverAndLoader.getServerState(player.method_37908().method_8503());
        return serverState.players.computeIfAbsent(player.method_5667(), uuid -> new PlayerFoodState());
    }

    public static void applyPlayerState(class_1309 player) {
        PlayerFoodState state = FoodStateSaverAndLoader.getPlayerState(player);
        class_1324 attr = player.method_5996(class_5134.field_23716);
        if (attr != null) {
            attr.method_6203();
            for (String foodId : state.getEatenFoods()) {
                UUID foodUUID = UUID.nameUUIDFromBytes(("food_advancement:" + foodId).getBytes());
                attr.method_26837(new class_1322(foodUUID, "FoodAdvancementHeart:" + foodId, 2.0, class_1322.class_1323.field_6328));
            }
            player.method_6033(player.method_6063());
        }
    }
}

