/*
 * Decompiled with CFR 0.152.
 */
package com.food_advancement;

import com.food_advancement.Food_advancement;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("food_advancement.json").toFile();
    private static ModConfig INSTANCE;
    private int maxHealthy = 120;
    private int defaultHealthy = 20;
    private int healthyGain = 2;
    private static final String CONFIG_COMMENT = "// \u98df\u7269\u8fdb\u5ea6\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\n// maxHealthy: \u751f\u547d\u503c\u4e0a\u9650\uff08\u9ed8\u8ba4120\uff0c\u537360\u5fc3\uff09\n// defaultHealthy: \u521d\u59cb\u751f\u547d\u503c\uff08\u9ed8\u8ba420\uff0c\u537310\u5fc3\uff09\n// healthyGain: \u6bcf\u79cd\u65b0\u98df\u7269\u589e\u52a0\u7684\u751f\u547d\u503c\uff08\u9ed8\u8ba42\uff0c\u53731\u5fc3\uff09\n// \u6ce8\u610f\uff1a\u6240\u6709\u6570\u503c\u90fd\u662f\u4ee5\u751f\u547d\u503c\u70b9\u6570\u8ba1\u7b97\uff0c1\u5fc3 = 2\u70b9\u751f\u547d\u503c\n";

    public static ModConfig getInstance() {
        if (INSTANCE == null) {
            ModConfig.loadConfig();
        }
        return INSTANCE;
    }

    public static void loadConfig() {
        block8: {
            try {
                if (CONFIG_FILE.exists()) {
                    try (FileReader reader = new FileReader(CONFIG_FILE);){
                        INSTANCE = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
                        Food_advancement.LOGGER.info("\u5df2\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\uff1amaxHealthy={}, defaultHealthy={}, healthyGain={}", new Object[]{ModConfig.INSTANCE.maxHealthy, ModConfig.INSTANCE.defaultHealthy, ModConfig.INSTANCE.healthyGain});
                        break block8;
                    }
                }
                INSTANCE = new ModConfig();
                ModConfig.saveConfig();
                Food_advancement.LOGGER.info("\u5df2\u521b\u5efa\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\uff1amaxHealthy={}, defaultHealthy={}, healthyGain={}", new Object[]{ModConfig.INSTANCE.maxHealthy, ModConfig.INSTANCE.defaultHealthy, ModConfig.INSTANCE.healthyGain});
            }
            catch (IOException e) {
                Food_advancement.LOGGER.error("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25: " + e.getMessage());
                INSTANCE = new ModConfig();
                Food_advancement.LOGGER.info("\u4f7f\u7528\u9ed8\u8ba4\u914d\u7f6e\uff1amaxHealthy={}, defaultHealthy={}, healthyGain={}", new Object[]{ModConfig.INSTANCE.maxHealthy, ModConfig.INSTANCE.defaultHealthy, ModConfig.INSTANCE.healthyGain});
            }
        }
    }

    public static void saveConfig() {
        try {
            if (!CONFIG_FILE.exists()) {
                CONFIG_FILE.getParentFile().mkdirs();
                CONFIG_FILE.createNewFile();
            }
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                writer.write(CONFIG_COMMENT);
                GSON.toJson((Object)INSTANCE, (Appendable)writer);
            }
        }
        catch (IOException e) {
            Food_advancement.LOGGER.error("Failed to save config: " + e.getMessage());
        }
    }

    public int getMaxHealthy() {
        return this.maxHealthy;
    }

    public void setMaxHealthy(int maxHealthy) {
        this.maxHealthy = maxHealthy;
        ModConfig.saveConfig();
    }

    public int getDefaultHealthy() {
        return this.defaultHealthy;
    }

    public void setDefaultHealthy(int defaultHealthy) {
        this.defaultHealthy = defaultHealthy;
        ModConfig.saveConfig();
    }

    public int getHealthyGain() {
        return this.healthyGain;
    }

    public void setHealthyGain(int healthyGain) {
        this.healthyGain = healthyGain;
        ModConfig.saveConfig();
    }
}

