/*
 * Decompiled with CFR 0.152.
 */
package com.food_advancement;

import com.food_advancement.Food_advancement;
import com.food_advancement.ModConfig;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_5134;

public class PlayerFoodState {
    private static final UUID HEALTH_MODIFIER_ID = UUID.fromString("d5d5d5d5-d5d5-d5d5-d5d5-d5d5d5d5d5d5");
    private Set<String> eatenFoods = new HashSet<String>();
    private double maxHealth = 20.0;

    public Set<String> getEatenFoods() {
        return this.eatenFoods;
    }

    public void addEatenFood(String foodId) {
        if (!this.eatenFoods.contains(foodId)) {
            this.eatenFoods.add(foodId);
            double newMaxHealth = Math.min(this.maxHealth + (double)ModConfig.getInstance().getHealthyGain(), (double)ModConfig.getInstance().getMaxHealthy());
            Food_advancement.LOGGER.info("\u589e\u52a0\u751f\u547d\u503c\u4e0a\u9650: {} -> {}", (Object)this.maxHealth, (Object)newMaxHealth);
            this.maxHealth = newMaxHealth;
        }
    }

    public double getMaxHealth() {
        return this.maxHealth;
    }

    public void setMaxHealth(double maxHealth) {
        this.maxHealth = maxHealth;
    }

    public class_2487 writeNbt(class_2487 nbt) {
        class_2499 foodList = new class_2499();
        for (String foodId : this.eatenFoods) {
            foodList.add((Object)class_2519.method_23256((String)foodId));
        }
        nbt.method_10566("eaten_foods", (class_2520)foodList);
        nbt.method_10549("max_health", this.maxHealth);
        return nbt;
    }

    public void readNbt(class_2487 nbt) {
        this.eatenFoods.clear();
        if (nbt.method_10545("eaten_foods")) {
            class_2499 foodList = nbt.method_10554("eaten_foods", 8);
            for (int i = 0; i < foodList.size(); ++i) {
                this.eatenFoods.add(foodList.method_10608(i));
            }
        }
        if (nbt.method_10545("max_health")) {
            this.maxHealth = nbt.method_10574("max_health");
        }
    }

    public void apply(class_1657 player) {
        try {
            class_1324 attributeInstance = player.method_5996(class_5134.field_23716);
            if (attributeInstance != null) {
                float newMaxHealth;
                float currentHealth;
                attributeInstance.method_6200(HEALTH_MODIFIER_ID);
                double healthyGain = ModConfig.getInstance().getHealthyGain();
                double maxHealthy = ModConfig.getInstance().getMaxHealthy();
                double additionalHealth = Math.min((double)this.eatenFoods.size() * healthyGain, maxHealthy - attributeInstance.method_6201());
                this.maxHealth = attributeInstance.method_6201() + additionalHealth;
                this.maxHealth = Math.min(this.maxHealth, maxHealthy);
                Food_advancement.LOGGER.info("\u66f4\u65b0\u73a9\u5bb6 {} \u7684\u751f\u547d\u503c\uff1a\u57fa\u7840\u503c={}, \u5df2\u5403\u98df\u7269\u6570={}, \u98df\u7269\u52a0\u6210={}, \u6700\u7ec8\u503c={}, \u7cfb\u7edf\u4e0a\u9650={}", new Object[]{player.method_5477().getString(), attributeInstance.method_6201(), this.eatenFoods.size(), additionalHealth, this.maxHealth, maxHealthy});
                if (additionalHealth > 0.0) {
                    class_1322 healthModifier = new class_1322(HEALTH_MODIFIER_ID, "Food Advancement Health Bonus", additionalHealth, class_1322.class_1323.field_6328);
                    attributeInstance.method_26837(healthModifier);
                }
                if ((currentHealth = player.method_6032()) > (newMaxHealth = player.method_6063())) {
                    player.method_6033(newMaxHealth);
                }
            }
        }
        catch (Exception e) {
            Food_advancement.LOGGER.error("\u5e94\u7528\u751f\u547d\u503c\u4fee\u6539\u65f6\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
        }
    }
}

