/*
 * Decompiled with CFR 0.152.
 */
package com.food_advancement;

import com.food_advancement.PlayerFoodState;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class PlayerFoodTracker {
    private static final HashMap<UUID, PlayerFoodState> playerStates = new HashMap();

    public static Set<String> getEatenFoods(class_1657 player) {
        if (player == null) {
            return new HashSet<String>();
        }
        return playerStates.computeIfAbsent(player.method_5667(), uuid -> new PlayerFoodState()).getEatenFoods();
    }

    public static boolean hasEaten(class_1657 player, class_1792 item) {
        class_2960 id = class_7923.field_41178.method_10221((Object)item);
        if (id == null) {
            return false;
        }
        return PlayerFoodTracker.getEatenFoods(player).contains(id.toString());
    }

    public static void addEatenFood(class_1657 player, class_1792 item) {
        class_2960 id = class_7923.field_41178.method_10221((Object)item);
        if (id == null) {
            return;
        }
        PlayerFoodState state = playerStates.computeIfAbsent(player.method_5667(), uuid -> new PlayerFoodState());
        state.addEatenFood(id.toString());
        state.apply(player);
    }

    public static void savePlayerState(class_3222 player, class_2487 tag) {
        PlayerFoodState state = playerStates.get(player.method_5667());
        if (state != null) {
            tag.method_10566("food_advancement", (class_2520)state.writeNbt(new class_2487()));
        }
    }

    public static void loadPlayerState(class_3222 player, class_2487 tag) {
        if (tag.method_10545("food_advancement")) {
            PlayerFoodState state = new PlayerFoodState();
            state.readNbt(tag.method_10562("food_advancement"));
            playerStates.put(player.method_5667(), state);
            state.apply((class_1657)player);
        }
    }

    public static void clearPlayerState(class_1657 player) {
        playerStates.remove(player.method_5667());
    }

    public static void copyPlayerState(class_1657 source, class_1657 target) {
        PlayerFoodState state = playerStates.get(source.method_5667());
        if (state != null) {
            playerStates.put(target.method_5667(), state);
            state.apply(target);
        }
    }
}

