/*
 * Decompiled with CFR 0.152.
 */
package com.sol2f;

import com.sol2f.command.FoodCommands;
import com.sol2f.config.ModConfig;
import com.sol2f.server.FoodUseHandler;
import com.sol2f.server.ServerEventHandlers;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.ModInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpiceOfLifeFabricFlavor
implements ModInitializer {
    public static final String MOD_ID = "sol2f";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"sol2f");

    public void onInitialize() {
        LOGGER.info("SpiceOfLife: initializing");
        ModConfig.load();
        try {
            if (ModConfig.getInstance().developerMode) {
                Path logsDir = Paths.get("run", "logs", MOD_ID);
                if (!Files.exists(logsDir, new LinkOption[0])) {
                    Files.createDirectories(logsDir, new FileAttribute[0]);
                }
                String logFile = logsDir.resolve("sol2f.log").toString();
                Class<?> loggerFactoryClass = Class.forName("org.slf4j.LoggerFactory");
                try {
                    Class<?> loggerContextClass = Class.forName("ch.qos.logback.classic.LoggerContext");
                    Class<?> patternEncoderClass = Class.forName("ch.qos.logback.classic.encoder.PatternLayoutEncoder");
                    Class<?> fileAppenderClass = Class.forName("ch.qos.logback.core.FileAppender");
                    Object ctx = loggerFactoryClass.getMethod("getILoggerFactory", new Class[0]).invoke(null, new Object[0]);
                    Constructor<?> encCtor = patternEncoderClass.getConstructor(new Class[0]);
                    Object ple = encCtor.newInstance(new Object[0]);
                    patternEncoderClass.getMethod("setPattern", String.class).invoke(ple, "%d{HH:mm:ss} [%thread] %-5level %logger{36} - %msg%n");
                    patternEncoderClass.getMethod("setContext", loggerContextClass).invoke(ple, ctx);
                    patternEncoderClass.getMethod("start", new Class[0]).invoke(ple, new Object[0]);
                    Constructor<?> faCtor = fileAppenderClass.getConstructor(new Class[0]);
                    Object fa = faCtor.newInstance(new Object[0]);
                    fileAppenderClass.getMethod("setFile", String.class).invoke(fa, logFile);
                    fileAppenderClass.getMethod("setEncoder", Class.forName("ch.qos.logback.core.encoder.Encoder")).invoke(fa, ple);
                    fileAppenderClass.getMethod("setContext", loggerContextClass).invoke(fa, ctx);
                    fileAppenderClass.getMethod("setName", String.class).invoke(fa, "SOL2F_FILE_APPENDER");
                    fileAppenderClass.getMethod("start", new Class[0]).invoke(fa, new Object[0]);
                    Class<?> classicLoggerClass = Class.forName("ch.qos.logback.classic.Logger");
                    Logger root = LoggerFactory.getLogger((String)"ROOT");
                    classicLoggerClass.getMethod("addAppender", Class.forName("ch.qos.logback.core.Appender")).invoke((Object)root, fa);
                    LOGGER.info("sol2f: developerMode enabled - logging to {}", (Object)logFile);
                }
                catch (Throwable t) {
                    LOGGER.warn("sol2f: Logback not available for developerMode file logging, skipping", t);
                }
            }
        }
        catch (Throwable t) {
            LOGGER.warn("sol2f: failed to enable developerMode file logger", t);
        }
        FoodUseHandler.register();
        ServerEventHandlers.register();
        FoodCommands.register();
        LOGGER.info("SpiceOfLife: initialized");
    }
}

