/*
 * Decompiled with CFR 0.152.
 */
package com.sol2f.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class ModConfig {
    public int maxHealthy = 120;
    public int defaultHealthy = 20;
    public int healthyGain = 2;
    public boolean resetOnDeath = false;
    public boolean developerMode = false;
    private static final Path CONFIG_PATH = Paths.get("config", "sol2f.json");
    private static ModConfig INSTANCE = new ModConfig();

    public static ModConfig getInstance() {
        return INSTANCE;
    }

    public static void load() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                String json = new String(Files.readAllBytes(CONFIG_PATH), StandardCharsets.UTF_8);
                INSTANCE = (ModConfig)gson.fromJson(json, ModConfig.class);
                if (INSTANCE == null) {
                    INSTANCE = new ModConfig();
                }
                try {
                    ModConfig.save();
                }
                catch (Exception exception) {}
            } else {
                INSTANCE = new ModConfig();
                ModConfig.save();
            }
        }
        catch (IOException e) {
            INSTANCE = new ModConfig();
            try {
                ModConfig.save();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void save() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            if (!Files.exists(CONFIG_PATH.getParent(), new LinkOption[0])) {
                Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            }
            String json = gson.toJson((Object)INSTANCE);
            Files.write(CONFIG_PATH, json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

