/*
 * Decompiled with CFR 0.152.
 */
package com.sol2f.server;

import com.sol2f.SpiceOfLifeFabricFlavor;
import com.sol2f.config.Sol2FConfig;
import com.sol2f.network.FoodPackets;
import com.sol2f.server.FoodUseHandler;
import com.sol2f.util.IEntityDataSaver;
import java.util.Set;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class ServerEventHandlers {
    public static void register() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.field_14140;
            if (player == null) {
                return;
            }
            Set<String> eaten = FoodUseHandler.getEatenFoods(player);
            FoodUseHandler.applyHealthModifier(player, eaten);
            FoodUseHandler.syncToClient(player, eaten);
        });
        ServerPlayerEvents.COPY_FROM.register((oldPlayer, newPlayer, alive) -> {
            if (!alive && !((Sol2FConfig)AutoConfig.getConfigHolder(Sol2FConfig.class).getConfig()).features.resetOnDeath && oldPlayer instanceof IEntityDataSaver) {
                IEntityDataSaver olDataSaver = (IEntityDataSaver)oldPlayer;
                if (newPlayer instanceof IEntityDataSaver) {
                    IEntityDataSaver newDataSaver = (IEntityDataSaver)newPlayer;
                    newDataSaver.getPersistentData().method_10543(olDataSaver.getPersistentData());
                }
            }
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            if (!alive) {
                if (((Sol2FConfig)AutoConfig.getConfigHolder(Sol2FConfig.class).getConfig()).features.resetOnDeath) {
                    FoodUseHandler.clearEatenFoods(newPlayer);
                } else {
                    Set<String> eaten = FoodUseHandler.getEatenFoods(newPlayer);
                    FoodUseHandler.applyHealthModifier(newPlayer, eaten);
                    FoodUseHandler.syncToClient(newPlayer, eaten);
                }
            }
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)FoodPackets.C2S_REQUEST_LIST, (server, player, handler, buf, responder) -> {
            try {
                Set<String> eaten = FoodUseHandler.getEatenFoods(player);
                FoodUseHandler.syncToClient(player, eaten);
            }
            catch (Exception e) {
                SpiceOfLifeFabricFlavor.LOGGER.error("sol2f: error responding to client list request", (Throwable)e);
            }
        });
    }
}

