/*
 * Decompiled with CFR 0.152.
 */
package io.github.jvuong4.flyingfrisbees.entity;

import io.github.jvuong4.flyingfrisbees.FlyingFrisbees;
import io.github.jvuong4.flyingfrisbees.item.Frisboomerang;
import io.github.jvuong4.flyingfrisbees.item.YoinkFrisbee;
import io.github.jvuong4.flyingfrisbees.registry.FlyingFrisbeesDamageTypes;
import io.github.jvuong4.flyingfrisbees.registry.FlyingFrisbeesEntities;
import io.github.jvuong4.flyingfrisbees.registry.FlyingFrisbeesItems;
import io.github.jvuong4.flyingfrisbees.registry.FlyingFrisbeesRegistry;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5321;
import net.minecraft.class_9109;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FrisbeeEntity
extends class_1665
implements GeoEntity {
    protected static final RawAnimation SPINNING_ANIM = RawAnimation.begin().thenLoop("animation.frisbee.spinning");
    protected static final RawAnimation STOPPED_ANIM = RawAnimation.begin().thenLoop("animation.frisbee.stopped");
    protected final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final boolean DEFAULT_DEALT_DAMAGE = false;
    protected boolean dealtDamage = false;
    protected boolean isSpinning = true;
    private int life;
    public boolean isCapturing;
    public boolean isExploding;
    public boolean isDispensed = false;

    public FrisbeeEntity(class_1299<? extends class_1665> entityType, class_1937 world) {
        super(entityType, world);
        this.constructFrisbee(true);
    }

    public FrisbeeEntity(class_1937 world, class_1309 owner, class_1799 stack) {
        super(FlyingFrisbeesEntities.FRISBEE, owner, world, stack, (class_1799)null);
        this.constructFrisbee(true);
    }

    public FrisbeeEntity(class_1937 world, double x, double y, double z, class_1799 stack) {
        super(FlyingFrisbeesEntities.FRISBEE, x, y, z, world, stack, stack);
        this.constructFrisbee(true);
    }

    public void constructFrisbee() {
        this.isSpinning = true;
        this.onSetItemStack(this.method_54759());
        class_1792 item = this.method_54759().method_7909();
        this.isCapturing = item instanceof YoinkFrisbee;
        this.isExploding = item instanceof Frisboomerang;
    }

    public void constructFrisbee(boolean pickupable) {
        this.field_7572 = pickupable ? class_1665.class_1666.field_7593 : class_1665.class_1666.field_7592;
        this.constructFrisbee();
    }

    protected double method_7490() {
        return 0.01;
    }

    protected class_1799 method_57314() {
        return new class_1799((class_1935)FlyingFrisbeesItems.FRISBEE);
    }

    private void onSetItemStack(class_1799 itemStack) {
        String path = ((class_5321)itemStack.method_41409().method_40230().get()).method_29177().method_12832();
        this.setAttached(FlyingFrisbeesRegistry.FRISBEE_TEXTURE_ATTACHMENT, path);
    }

    @Deprecated(forRemoval=true)
    public void setItem(class_1799 itemStack) {
        this.method_57313(itemStack);
    }

    public void method_57313(class_1799 itemStack) {
        super.method_57313(itemStack);
        this.onSetItemStack(itemStack);
    }

    @Nullable
    protected class_3966 method_7434(class_243 currentPosition, class_243 nextPosition) {
        return this.dealtDamage ? null : super.method_7434(currentPosition, nextPosition);
    }

    protected void method_7454(class_3966 entityHitResult) {
        boolean facing;
        if (this.method_37908().field_9236) {
            return;
        }
        class_1297 entity = entityHitResult.method_17782();
        boolean bl = facing = this.method_18798().method_1026(entity.method_5720()) < 0.0;
        if (!entity.method_5864().method_20210(FlyingFrisbees.Tags.FRISBEE_BLACKLIST) && !this.method_5782() && (entity.method_5864().method_20210(FlyingFrisbees.Tags.FRISBEE_WHITELIST) || entity instanceof class_1308 || entity instanceof class_1657 || entity.method_5864() == class_1299.field_6078) && (this.isCapturing || entity.method_5864() == class_1299.field_6078 || !entity.method_24828() && this.method_23318() - entity.method_23318() < 0.75 + (double)entity.method_18377(this.method_18376()).comp_2186() * 0.25)) {
            entity.method_5804((class_1297)this);
            this.method_18799(this.method_18798().method_1031(this.method_18798().method_10216() * 1.5, this.method_18798().method_10214() + 0.1, this.method_18798().method_10215() * 1.5));
            return;
        }
        if (!this.isCapturing && facing && entity instanceof class_1657) {
            class_1304 slot;
            class_1657 living = (class_1657)entity;
            Object object = entityHitResult.method_17784().method_1022(entity.method_33571()) < 0.5 && living.method_6118(class_1304.field_6173).method_7960() ? class_1304.field_6173 : (living.method_6118(class_1304.field_6171).method_7960() ? class_1304.field_6171 : (slot = living.method_6118(class_1304.field_6169).method_7960() ? class_1304.field_6169 : null));
            if (slot != null) {
                living.method_5673(slot, this.method_54759());
                this.method_31745(class_1297.class_5529.field_26999);
                return;
            }
        }
        float f = 1.0f;
        class_1297 entity2 = this.method_24921();
        class_1937 var7 = this.method_37908();
        int option = 1;
        if (entity2 != null) {
            option += this.method_59922().method_39332(1, 2);
        }
        if (this.isExploding) {
            option += 3;
        }
        this.dealtDamage = true;
        class_3218 serverWorld = (class_3218)var7;
        class_1282 damageSource = switch (option) {
            case 1 -> var7.method_48963().method_48797(FlyingFrisbeesDamageTypes.FRISBEE_KEY, (class_1297)this, (class_1297)(entity2 == null ? this : entity2));
            case 2 -> var7.method_48963().method_48797(FlyingFrisbeesDamageTypes.FRISBEE2_KEY, (class_1297)this, (class_1297)(entity2 == null ? this : entity2));
            case 3 -> var7.method_48963().method_48797(FlyingFrisbeesDamageTypes.FRISBEE3_KEY, (class_1297)this, (class_1297)(entity2 == null ? this : entity2));
            case 4 -> var7.method_48963().method_48797(FlyingFrisbeesDamageTypes.FRISBEE4_KEY, (class_1297)this, (class_1297)(entity2 == null ? this : entity2));
            case 5 -> var7.method_48963().method_48797(FlyingFrisbeesDamageTypes.FRISBEE5_KEY, (class_1297)this, (class_1297)(entity2 == null ? this : entity2));
            case 6 -> var7.method_48963().method_48797(FlyingFrisbeesDamageTypes.FRISBEE6_KEY, (class_1297)this, (class_1297)(entity2 == null ? this : entity2));
            default -> var7.method_48963().method_48797(FlyingFrisbeesDamageTypes.FRISBEE_KEY, (class_1297)this, (class_1297)(entity2 == null ? this : entity2));
        };
        if (this.isExploding) {
            this.explode(serverWorld, damageSource);
            if (this.method_59922().method_43057() < 0.6f) {
                this.method_31472();
                return;
            }
        }
        if (entity.method_64397(serverWorld, damageSource, f)) {
            if (entity.method_5864() == class_1299.field_6091) {
                return;
            }
            var7 = this.method_37908();
            if (var7 instanceof class_3218) {
                class_1890.method_63016((class_3218)serverWorld, (class_1297)entity, (class_1282)damageSource, (class_1799)this.method_59958(), item -> this.method_5768(serverWorld));
            }
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                this.method_59957(livingEntity, damageSource);
                this.method_7450(livingEntity);
            }
        }
        this.method_59859(class_9109.field_48348, entity, this.method_24921(), false);
        this.method_18799(this.method_18798().method_18805(0.2, 0.8, 0.2));
        this.method_5783(class_3417.field_14667, 1.0f, 1.0f);
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_65059()) {
            if (this.isExploding) {
                this.explodeSelf();
            }
            this.isSpinning = false;
        }
    }

    private void explode(class_3218 world, class_1282 source) {
        float damage = this.method_59922().method_43057() * 8.0f + 12.0f;
        Object shooter = this.method_24921();
        if (shooter instanceof class_1309) {
            boolean recoil = false;
            for (int i = 0; i < 2; ++i) {
                class_243 vec3d2 = new class_243(shooter.method_23317(), shooter.method_23323(0.5 * (double)i), shooter.method_23321());
                class_3965 hitResult = this.method_37908().method_17742(new class_3959(this.method_19538(), vec3d2, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
                if (hitResult.method_17783() != class_239.class_240.field_1333) continue;
                recoil = true;
                break;
            }
            if (recoil && this.method_5858((class_1297)shooter) <= 25.0 && shooter.method_64397(world, source, damage * (float)Math.sqrt((5.0 - (double)this.method_5739((class_1297)shooter)) / 5.0))) {
                class_1890.method_63016((class_3218)world, (class_1297)shooter, (class_1282)source, (class_1799)this.method_59958(), item -> this.method_5768(world));
                this.method_59957((class_1309)shooter, source);
                this.method_7450((class_1309)shooter);
            }
            this.method_5783((class_3414)class_3417.field_15152.comp_349(), 1.0f, 1.0f);
            class_243 vec3d = this.method_19538();
            this.method_37908().method_55117((class_1297)this, null, null, vec3d.method_10216(), vec3d.method_10214(), vec3d.method_10215(), 0.0f, false, class_1937.class_7867.field_40891);
            List list2 = this.method_37908().method_18467(class_1309.class, this.method_5829().method_1014(5.0));
            Iterator var8 = list2.iterator();
            while (true) {
                float g;
                if (!var8.hasNext()) {
                    return;
                }
                class_1309 livingEntity = (class_1309)var8.next();
                if (livingEntity == shooter || this.method_5858((class_1297)livingEntity) > 25.0) continue;
                boolean bl = false;
                for (int i = 0; i < 2; ++i) {
                    class_243 vec3d2 = new class_243(livingEntity.method_23317(), livingEntity.method_23323(0.5 * (double)i), livingEntity.method_23321());
                    class_3965 hitResult = this.method_37908().method_17742(new class_3959(vec3d, vec3d2, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
                    if (hitResult.method_17783() != class_239.class_240.field_1333) continue;
                    bl = true;
                    break;
                }
                if (!bl || !livingEntity.method_64397(world, source, g = damage * (float)Math.sqrt((5.0 - (double)this.method_5739((class_1297)livingEntity)) / 5.0))) continue;
                if (livingEntity.method_5864() == class_1299.field_6091) {
                    return;
                }
                class_1890.method_63016((class_3218)world, (class_1297)livingEntity, (class_1282)source, (class_1799)this.method_59958(), item -> this.method_5768(world));
                this.method_59957(livingEntity, source);
                this.method_7450(livingEntity);
            }
        }
        shooter = this;
        this.method_5783((class_3414)class_3417.field_15152.comp_349(), 1.0f, 1.0f);
        class_243 vec3d = this.method_19538();
        this.method_37908().method_55117((class_1297)this, null, null, vec3d.method_10216(), vec3d.method_10214(), vec3d.method_10215(), 0.0f, false, class_1937.class_7867.field_40891);
        List list2 = this.method_37908().method_18467(class_1309.class, this.method_5829().method_1014(5.0));
        Iterator var8 = list2.iterator();
        while (var8.hasNext()) {
            float g;
            class_1309 livingEntity = (class_1309)var8.next();
            if (livingEntity == shooter || this.method_5858((class_1297)livingEntity) > 25.0) continue;
            boolean bl = false;
            for (int i = 0; i < 2; ++i) {
                class_243 vec3d2 = new class_243(livingEntity.method_23317(), livingEntity.method_23323(0.5 * (double)i), livingEntity.method_23321());
                class_3965 hitResult = this.method_37908().method_17742(new class_3959(vec3d, vec3d2, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
                if (hitResult.method_17783() != class_239.class_240.field_1333) continue;
                bl = true;
                break;
            }
            if (!bl || !livingEntity.method_64397(world, source, g = damage * (float)Math.sqrt((5.0 - (double)this.method_5739((class_1297)livingEntity)) / 5.0))) continue;
            if (livingEntity.method_5864() == class_1299.field_6091) {
                return;
            }
            class_1890.method_63016((class_3218)world, (class_1297)livingEntity, (class_1282)source, (class_1799)this.method_59958(), item -> this.method_5768(world));
            this.method_59957(livingEntity, source);
            this.method_7450(livingEntity);
        }
        return;
    }

    private void explodeSelf() {
        class_1937 var21 = this.method_37908();
        if (var21 instanceof class_3218) {
            class_3218 serverWorld3 = (class_3218)var21;
            class_1297 entity2 = this.method_24921();
            this.explode(serverWorld3, switch (entity2 != null ? this.method_59922().method_39332(2, 3) : 1) {
                case 1 -> serverWorld3.method_48963().method_48797(FlyingFrisbeesDamageTypes.FRISBEE4_KEY, (class_1297)this, (class_1297)(entity2 == null ? this : entity2));
                case 2 -> serverWorld3.method_48963().method_48797(FlyingFrisbeesDamageTypes.FRISBEE5_KEY, (class_1297)this, (class_1297)(entity2 == null ? this : entity2));
                case 3 -> serverWorld3.method_48963().method_48797(FlyingFrisbeesDamageTypes.FRISBEE6_KEY, (class_1297)this, (class_1297)(entity2 == null ? this : entity2));
                default -> serverWorld3.method_48963().method_48797(FlyingFrisbeesDamageTypes.FRISBEE4_KEY, (class_1297)this, (class_1297)(entity2 == null ? this : entity2));
            });
            if (!(this.method_59922().method_43057() < 0.6f)) {
                this.method_5699(serverWorld3, this.method_7445().method_7972(), 0.1f);
            }
        }
        this.method_31472();
    }

    private boolean isOwnerAlive() {
        class_1297 entity = this.method_24921();
        if (entity != null && entity.method_5805()) {
            return !(entity instanceof class_3222) || !entity.method_7325();
        }
        return false;
    }

    protected void method_7446() {
        ++this.life;
        if (this.life >= 800) {
            class_1937 var21 = this.method_37908();
            if (var21 instanceof class_3218) {
                class_3218 serverWorld3 = (class_3218)var21;
                this.method_5699(serverWorld3, this.method_7445().method_7972(), 0.1f);
            }
            this.method_31472();
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController(1, state -> state.setAndContinue(this.isSpinning ? SPINNING_ANIM : STOPPED_ANIM)));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public double getTick(@Nullable Object object) {
        return 0.0;
    }
}

