/*
 * Decompiled with CFR 0.152.
 */
package ru.stepanyaa.playerManager;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ru.stepanyaa.playerManager.PlayerSearchGUI;
import ru.stepanyaa.playerManager.gson.JsonArray;
import ru.stepanyaa.playerManager.gson.JsonElement;
import ru.stepanyaa.playerManager.gson.JsonParser;

public final class PlayerManager
extends JavaPlugin
implements Listener,
CommandExecutor,
TabCompleter {
    private File playerDataFile;
    private FileConfiguration playerDataConfig;
    private File messagesFile;
    private FileConfiguration messagesConfig;
    private PlayerSearchGUI playerSearchGUI;
    private String language;
    private static final String MODRINTH_API_URL = "https://api.modrinth.com/v2/project/playermanagers/version";
    private static final String CURRENT_VERSION = "1.0.2";
    private String latestVersion = null;
    private final Set<UUID> notifiedAdmins = new HashSet<UUID>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.reloadConfig();
        this.language = this.getConfig().getString("language", "en");
        this.playerDataFile = new File(this.getDataFolder(), "player_data.yml");
        if (!this.playerDataFile.exists()) {
            this.playerDataFile.getParentFile().mkdirs();
            this.saveResource("player_data.yml", false);
        }
        this.playerDataConfig = YamlConfiguration.loadConfiguration((File)this.playerDataFile);
        if (!this.playerDataFile.canWrite()) {
            this.getLogger().severe("Cannot write to player_data.yml! Check file permissions in " + this.playerDataFile.getAbsolutePath());
        }
        if (this.playerDataConfig.getConfigurationSection("players") == null) {
            this.playerDataConfig.createSection("players");
            this.savePlayerDataConfig();
        }
        this.loadMessages();
        this.playerSearchGUI = new PlayerSearchGUI(this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.playerSearchGUI, (Plugin)this);
        PluginCommand command = this.getCommand("playermanager");
        if (command != null) {
            command.setExecutor((CommandExecutor)this);
            command.setTabCompleter((TabCompleter)this);
            command.setPermissionMessage(ChatColor.RED + this.getMessage("error.no-permission", "You don't have permission!"));
        } else {
            this.getLogger().warning("Failed to register command 'playermanager'!");
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.loadPlayerMenuState(player);
            this.updatePlayerDataOnJoin(player);
        }
        this.checkForUpdates();
        this.getLogger().info("PlayerManager enabled with language: " + this.language);
    }

    private void checkForUpdates() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            try {
                URL url = new URL(MODRINTH_API_URL);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setRequestProperty("User-Agent", "PlayerManager/1.0.2");
                conn.connect();
                if (conn.getResponseCode() == 200) {
                    JsonArray versions = JsonParser.parseReader(new InputStreamReader(conn.getInputStream())).getAsJsonArray();
                    String highestVersion = null;
                    for (JsonElement element : versions) {
                        String versionNumber = element.getAsJsonObject().get("version_number").getAsString();
                        String versionType = element.getAsJsonObject().get("version_type").getAsString();
                        if (versionNumber.contains("-SNAPSHOT") && !versionType.equals("release") || highestVersion != null && !this.isNewerVersion(versionNumber, highestVersion)) continue;
                        highestVersion = versionNumber;
                    }
                    if (highestVersion != null && this.isNewerVersion(highestVersion, CURRENT_VERSION)) {
                        String[] currentParts = CURRENT_VERSION.split("\\.");
                        String[] highestParts = highestVersion.split("\\.");
                        if (currentParts.length == 3 && highestParts.length == 3) {
                            int currentMajor = Integer.parseInt(currentParts[0]);
                            int currentMinor = Integer.parseInt(currentParts[1]);
                            int currentPatch = Integer.parseInt(currentParts[2]);
                            int highestMajor = Integer.parseInt(highestParts[0]);
                            int highestMinor = Integer.parseInt(highestParts[1]);
                            int highestPatch = Integer.parseInt(highestParts[2]);
                            if (currentMajor == highestMajor && currentMinor == highestMinor && highestPatch == currentPatch + 1) {
                                this.latestVersion = highestVersion;
                                String consoleMessage = "*** UPDATE AVAILABLE *** A new version of PlayerManager (" + this.latestVersion + ") is available at https://modrinth.com/plugin/playermanagers";
                                this.getLogger().info(consoleMessage);
                            }
                        }
                    }
                }
                conn.disconnect();
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to check for updates: " + e.getMessage());
            }
        });
    }

    private boolean isNewerVersion(String newVersion, String currentVersion) {
        try {
            String cleanNewVersion = newVersion.replace("-SNAPSHOT", "");
            String cleanCurrentVersion = currentVersion.replace("-SNAPSHOT", "");
            String[] newParts = cleanNewVersion.split("\\.");
            String[] currentParts = cleanCurrentVersion.split("\\.");
            int length = Math.max(newParts.length, currentParts.length);
            for (int i = 0; i < length; ++i) {
                int currentPart;
                int newPart = i < newParts.length ? Integer.parseInt(newParts[i]) : 0;
                int n = currentPart = i < currentParts.length ? Integer.parseInt(currentParts[i]) : 0;
                if (newPart > currentPart) {
                    return true;
                }
                if (newPart >= currentPart) continue;
                return false;
            }
            return false;
        }
        catch (NumberFormatException e) {
            this.getLogger().warning("Invalid version format: newVersion=" + newVersion + ", currentVersion=" + currentVersion);
            return false;
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("playermanager.admin") && !this.hasAnyPermission(sender)) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            ArrayList<String> commands = new ArrayList<String>();
            if (sender.hasPermission("playermanager.admin") || sender.hasPermission("playermanager.gui")) {
                commands.add("gui");
            }
            if (sender.hasPermission("playermanager.admin") || sender.hasPermission("playermanager.reload")) {
                commands.add("reload");
            }
            if (sender.hasPermission("playermanager.admin") || sender.hasPermission("playermanager.gui") || sender.hasPermission("playermanager.reset")) {
                commands.add("reset");
            }
            if (sender.hasPermission("playermanager.admin") || sender.hasPermission("playermanager.ban")) {
                commands.add("ban");
            }
            if (sender.hasPermission("playermanager.admin") || sender.hasPermission("playermanager.kick")) {
                commands.add("kick");
            }
            if (sender.hasPermission("playermanager.admin") || sender.hasPermission("playermanager.warn")) {
                commands.add("warn");
            }
            if (sender.hasPermission("playermanager.admin") || sender.hasPermission("playermanager.mute")) {
                commands.add("mute");
            }
            if (sender.hasPermission("playermanager.admin") || sender.hasPermission("playermanager.unban")) {
                commands.add("unban");
            }
            if (sender.hasPermission("playermanager.admin") || sender.hasPermission("playermanager.teleport")) {
                commands.add("teleport");
            }
            if (sender.hasPermission("playermanager.admin") || sender.hasPermission("playermanager.inventory")) {
                commands.add("inventory");
            }
            return commands;
        }
        if (args.length == 2 && Arrays.asList("ban", "kick", "warn", "mute", "unban", "teleport", "inventory").contains(args[0].toLowerCase())) {
            String action = args[0].toLowerCase();
            if (sender.hasPermission("playermanager.admin") || sender.hasPermission("playermanager." + action)) {
                ArrayList<String> playerNames = new ArrayList<String>();
                for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
                    if (offlinePlayer.getName() == null) continue;
                    String uuidStr = offlinePlayer.getUniqueId().toString();
                    boolean isAdmin = this.getPlayerDataConfig().getBoolean("players." + uuidStr + ".isAdmin", false);
                    if (isAdmin) continue;
                    playerNames.add(offlinePlayer.getName());
                }
                return playerNames;
            }
        }
        return Collections.emptyList();
    }

    private boolean hasAnyPermission(CommandSender sender) {
        return sender.hasPermission("playermanager.gui") || sender.hasPermission("playermanager.reload") || sender.hasPermission("playermanager.reset") || sender.hasPermission("playermanager.ban") || sender.hasPermission("playermanager.kick") || sender.hasPermission("playermanager.warn") || sender.hasPermission("playermanager.mute") || sender.hasPermission("playermanager.unban") || sender.hasPermission("playermanager.teleport") || sender.hasPermission("playermanager.inventory");
    }

    public void onDisable() {
        this.saveAllPlayerMenuStates();
        this.notifiedAdmins.clear();
        this.getLogger().info("PlayerManager disabled");
    }

    private void loadMessages() {
        String messagesFileName = "messages_" + this.language + ".yml";
        this.messagesFile = new File(this.getDataFolder(), messagesFileName);
        if (!this.messagesFile.exists()) {
            if (this.getResource(messagesFileName) != null) {
                this.saveResource(messagesFileName, false);
                this.getLogger().info("Saved default messages file: " + messagesFileName);
            } else {
                this.getLogger().warning("Messages file for language '" + this.language + "' not found, falling back to English");
                messagesFileName = "messages_en.yml";
                this.messagesFile = new File(this.getDataFolder(), messagesFileName);
                if (!this.messagesFile.exists() && this.getResource(messagesFileName) != null) {
                    this.saveResource(messagesFileName, false);
                }
            }
        }
        try {
            this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to load messages file: " + e.getMessage());
            this.messagesConfig = new YamlConfiguration();
        }
    }

    public String getMessage(String key, String defaultValue) {
        String message = this.messagesConfig.getString(key, defaultValue);
        if (message == null || message.isEmpty()) {
            return defaultValue;
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public void loadPlayerMenuState(Player player) {
        if (!player.hasPermission("playermanager.admin") && !player.hasPermission("playermanager.gui")) {
            return;
        }
        UUID uuid = player.getUniqueId();
        String lastMenu = this.playerDataConfig.getString("admin." + uuid + ".lastOpenedMenu", "search");
        int lastPage = this.playerDataConfig.getInt("admin." + uuid + ".lastPage", 0);
        String lastTarget = this.playerDataConfig.getString("admin." + uuid + ".lastTarget");
        this.playerSearchGUI.setLastOpenedMenu(uuid, lastMenu);
        this.playerSearchGUI.setLastPage(uuid, lastPage);
        this.playerSearchGUI.setLastTarget(uuid, lastTarget);
    }

    public void savePlayerMenuState(Player player) {
        if (player == null || !player.isOnline() || !player.hasPermission("playermanager.admin") && !player.hasPermission("playermanager.gui")) {
            return;
        }
        UUID uuid = player.getUniqueId();
        String lastMenu = this.playerSearchGUI.getLastOpenedMenu(uuid);
        int lastPage = this.playerSearchGUI.getLastPage(uuid);
        String lastTarget = this.playerSearchGUI.getLastTarget(uuid);
        boolean needsSave = false;
        String currentLastMenu = this.playerDataConfig.getString("admin." + uuid + ".lastOpenedMenu");
        int currentLastPage = this.playerDataConfig.getInt("admin." + uuid + ".lastPage", -1);
        String currentLastTarget = this.playerDataConfig.getString("admin." + uuid + ".lastTarget");
        if (!Objects.equals(currentLastMenu, lastMenu) || currentLastPage != lastPage || !Objects.equals(currentLastTarget, lastTarget)) {
            this.playerDataConfig.set("admin." + uuid + ".lastOpenedMenu", (Object)lastMenu);
            this.playerDataConfig.set("admin." + uuid + ".lastPage", (Object)lastPage);
            this.playerDataConfig.set("admin." + uuid + ".lastTarget", (Object)lastTarget);
            needsSave = true;
        }
        if (needsSave) {
            this.savePlayerDataConfig();
        }
    }

    private void saveAllPlayerMenuStates() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.savePlayerMenuState(player);
        }
    }

    private void updatePlayerDataOnJoin(Player player) {
        String uuidStr = player.getUniqueId().toString();
        String path = "players." + uuidStr + ".";
        boolean needsSave = false;
        if (!this.playerDataConfig.contains(path + "first_played")) {
            this.playerDataConfig.set(path + "first_played", (Object)player.getFirstPlayed());
            needsSave = true;
        }
        this.playerDataConfig.set(path + "last_login", (Object)System.currentTimeMillis());
        this.playerDataConfig.set(path + "name", (Object)player.getName());
        boolean storedBanned = this.playerDataConfig.getBoolean(path + "banned", false);
        boolean isBanned = player.isBanned();
        if (storedBanned != isBanned) {
            this.playerDataConfig.set(path + "banned", (Object)isBanned);
            needsSave = true;
        }
        String storedName = this.playerDataConfig.getString(path + "name", "");
        if (!player.getName().equals(storedName)) {
            this.playerDataConfig.set(path + "name", (Object)player.getName());
            needsSave = true;
        }
        if (needsSave) {
            this.savePlayerDataConfig();
        }
        if (this.latestVersion != null && (player.hasPermission("playermanager.admin") || player.hasPermission("playermanager.updates")) && !this.notifiedAdmins.contains(player.getUniqueId())) {
            String playerMessage = ChatColor.YELLOW + "" + ChatColor.BOLD + this.getMessage("update.available", "A new version of PlayerManager (%version%) is available at https://modrinth.com/plugin/playermanagers").replace("%version%", this.latestVersion);
            this.notifiedAdmins.add(player.getUniqueId());
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> player.sendMessage(playerMessage), 20L);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.updatePlayerDataOnJoin(event.getPlayer());
        this.loadPlayerMenuState(event.getPlayer());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        String uuidStr = player.getUniqueId().toString();
        String path = "players." + uuidStr + ".";
        this.playerDataConfig.set(path + "last_logout", (Object)System.currentTimeMillis());
        this.savePlayerMenuState(player);
        this.savePlayerDataConfig();
    }

    @EventHandler
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        if (event.getMessage().toLowerCase().startsWith("/playermanager reset")) {
            if (!(event.getPlayer().hasPermission("playermanager.admin") || event.getPlayer().hasPermission("playermanager.gui") || event.getPlayer().hasPermission("playermanager.reset"))) {
                event.getPlayer().sendMessage(ChatColor.RED + this.getMessage("error.no-permission", "You don't have permission!"));
                event.setCancelled(true);
                return;
            }
            this.playerSearchGUI.resetSearch(event.getPlayer());
            event.setCancelled(true);
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("playermanager.admin") && !this.hasAnyPermission(sender)) {
            sender.sendMessage(ChatColor.RED + this.getMessage("error.no-permission", "You don't have permission!"));
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + this.getMessage("error.player-only", "This command is for players only!"));
            return true;
        }
        Player admin = (Player)sender;
        if (args.length == 0) {
            sender.sendMessage(ChatColor.RED + this.getMessage("command.usage", "Usage: /playermanager <gui | reload | reset | ban | kick | warn | mute | unban | teleport | inventory>"));
            return true;
        }
        String action = args[0].toLowerCase();
        if (action.equals("gui")) {
            if (!sender.hasPermission("playermanager.admin") && !sender.hasPermission("playermanager.gui")) {
                sender.sendMessage(ChatColor.RED + this.getMessage("error.no-permission", "You don't have permission!"));
                return true;
            }
            if (args.length != 1) {
                sender.sendMessage(ChatColor.RED + this.getMessage("command.usage-gui", "Usage: /playermanager gui"));
                return true;
            }
            this.playerSearchGUI.openLastGUIMenu(admin);
            return true;
        }
        if (action.equals("reload")) {
            if (!sender.hasPermission("playermanager.admin") && !sender.hasPermission("playermanager.reload")) {
                sender.sendMessage(ChatColor.RED + this.getMessage("error.no-permission", "You don't have permission!"));
                return true;
            }
            if (args.length != 1) {
                sender.sendMessage(ChatColor.RED + this.getMessage("command.usage-reload", "Usage: /playermanager reload"));
                return true;
            }
            this.reloadPlugin(admin);
            return true;
        }
        if (action.equals("reset")) {
            if (!(sender.hasPermission("playermanager.admin") || sender.hasPermission("playermanager.gui") || sender.hasPermission("playermanager.reset"))) {
                sender.sendMessage(ChatColor.RED + this.getMessage("error.no-permission", "You don't have permission!"));
                return true;
            }
            if (args.length != 1) {
                sender.sendMessage(ChatColor.RED + this.getMessage("command.usage", "Usage: /playermanager reset"));
                return true;
            }
            this.playerSearchGUI.resetSearch(admin);
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(ChatColor.RED + this.getMessage("command.usage", "Usage: /playermanager <gui | reload | reset | ban | kick | warn | mute | unban | teleport | inventory>"));
            return true;
        }
        String targetName = args[1];
        OfflinePlayer target = Arrays.stream(Bukkit.getOfflinePlayers()).filter(p -> p.getName() != null && p.getName().equalsIgnoreCase(targetName)).findFirst().orElse(null);
        if (target == null) {
            admin.sendMessage(ChatColor.RED + this.getMessage("error.no-player-data", "Player data is not available."));
            return true;
        }
        String targetUUID = target.getUniqueId().toString();
        boolean isTargetAdmin = this.getPlayerDataConfig().getBoolean("players." + targetUUID + ".isAdmin", false);
        if (isTargetAdmin) {
            admin.sendMessage(ChatColor.RED + this.getMessage("error.cannot-target-admin", "You cannot target another admin."));
            return true;
        }
        if (target.getUniqueId().equals(admin.getUniqueId())) {
            if (action.equals("teleport")) {
                admin.sendMessage(ChatColor.RED + this.getMessage("error.self-teleport", "You can't teleport to yourself."));
            } else if (Arrays.asList("ban", "kick", "warn", "mute", "unban").contains(action)) {
                admin.sendMessage(ChatColor.RED + this.getMessage("error.self-punish", "You can't punish yourself."));
            }
            return true;
        }
        if (!sender.hasPermission("playermanager.admin") && !sender.hasPermission("playermanager." + action)) {
            sender.sendMessage(ChatColor.RED + this.getMessage("error.no-permission", "You don't have permission!"));
            return true;
        }
        String path = "players." + targetUUID + ".";
        boolean needsSave = false;
        switch (action) {
            case "ban": {
                if (!this.getConfig().getBoolean("features.punishment-system", true)) {
                    admin.sendMessage(ChatColor.RED + this.getMessage("error.punishment-system-disabled", "Punishment system is disabled!"));
                    return true;
                }
                Bukkit.dispatchCommand((CommandSender)admin, (String)("ban " + targetName));
                if (!this.playerDataConfig.getBoolean(path + "banned", false)) {
                    this.playerDataConfig.set(path + "banned", (Object)true);
                    needsSave = true;
                }
                admin.sendMessage(ChatColor.YELLOW + this.getMessage("action.executed", "Executed: %command% for %player%").replace("%command%", "ban").replace("%player%", targetName));
                break;
            }
            case "kick": {
                if (!this.getConfig().getBoolean("features.punishment-system", true)) {
                    admin.sendMessage(ChatColor.RED + this.getMessage("error.punishment-system-disabled", "Punishment system is disabled!"));
                    return true;
                }
                Player onlinePlayer = Bukkit.getPlayer((String)targetName);
                if (onlinePlayer == null) {
                    admin.sendMessage(ChatColor.RED + this.getMessage("error.player-offline", "Player is offline."));
                    return true;
                }
                Bukkit.dispatchCommand((CommandSender)admin, (String)("kick " + targetName));
                admin.sendMessage(ChatColor.YELLOW + this.getMessage("action.executed", "Executed: %command% for %player%").replace("%command%", "kick").replace("%player%", targetName));
                break;
            }
            case "warn": {
                if (!this.getConfig().getBoolean("features.punishment-system", true)) {
                    admin.sendMessage(ChatColor.RED + this.getMessage("error.punishment-system-disabled", "Punishment system is disabled!"));
                    return true;
                }
                Bukkit.dispatchCommand((CommandSender)admin, (String)("warn " + targetName));
                admin.sendMessage(ChatColor.YELLOW + this.getMessage("action.executed", "Executed: %command% for %player%").replace("%command%", "warn").replace("%player%", targetName));
                break;
            }
            case "mute": {
                if (!this.getConfig().getBoolean("features.punishment-system", true)) {
                    admin.sendMessage(ChatColor.RED + this.getMessage("error.punishment-system-disabled", "Punishment system is disabled!"));
                    return true;
                }
                Bukkit.dispatchCommand((CommandSender)admin, (String)("mute " + targetName));
                admin.sendMessage(ChatColor.YELLOW + this.getMessage("action.executed", "Executed: %command% for %player%").replace("%command%", "mute").replace("%player%", targetName));
                break;
            }
            case "unban": {
                if (!this.getConfig().getBoolean("features.punishment-system", true)) {
                    admin.sendMessage(ChatColor.RED + this.getMessage("error.punishment-system-disabled", "Punishment system is disabled!"));
                    return true;
                }
                if (!target.isBanned()) {
                    admin.sendMessage(ChatColor.RED + this.getMessage("error.not-banned", "This player is not banned!"));
                    return true;
                }
                Bukkit.dispatchCommand((CommandSender)admin, (String)("pardon " + targetName));
                if (this.playerDataConfig.getBoolean(path + "banned", false)) {
                    this.playerDataConfig.set(path + "banned", (Object)false);
                    needsSave = true;
                }
                admin.sendMessage(ChatColor.YELLOW + this.getMessage("action.executed", "Executed: %command% for %player%").replace("%command%", "unban").replace("%player%", targetName));
                break;
            }
            case "teleport": {
                if (!this.getConfig().getBoolean("features.player-teleportation", true)) {
                    admin.sendMessage(ChatColor.RED + this.getMessage("error.teleportation-disabled", "Teleportation is disabled!"));
                    return true;
                }
                Player targetPlayer = Bukkit.getPlayer((String)targetName);
                if (targetPlayer == null) {
                    admin.sendMessage(ChatColor.RED + this.getMessage("error.player-offline", "Player is offline."));
                    return true;
                }
                admin.teleport((Entity)targetPlayer);
                admin.sendMessage(ChatColor.GREEN + this.getMessage("action.teleported", "Teleported to %player%").replace("%player%", targetName));
                break;
            }
            case "inventory": {
                if (!this.getConfig().getBoolean("features.inventory-inspection", true)) {
                    admin.sendMessage(ChatColor.RED + this.getMessage("error.inventory-inspection-disabled", "Inventory inspection is disabled!"));
                    return true;
                }
                Player targetInvPlayer = Bukkit.getPlayer((String)targetName);
                if (targetInvPlayer == null) {
                    admin.sendMessage(ChatColor.RED + this.getMessage("error.player-offline-inventory", "Player is offline, inventory modification is impossible."));
                    return true;
                }
                admin.openInventory((Inventory)targetInvPlayer.getInventory());
                break;
            }
            default: {
                sender.sendMessage(ChatColor.RED + this.getMessage("command.usage", "Usage: /playermanager <gui | reload | reset | ban | kick | warn | mute | unban | teleport | inventory>"));
                return true;
            }
        }
        if (needsSave) {
            this.savePlayerDataConfig();
        }
        this.playerSearchGUI.refreshOpenGUIs();
        return true;
    }

    private void reloadPlugin(Player player) {
        this.reloadConfig();
        this.language = this.getConfig().getString("language", "en");
        this.loadMessages();
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.loadPlayerMenuState(p);
        }
        player.sendMessage(ChatColor.GREEN + this.getMessage("action.config-reloaded", "Configuration reloaded."));
        this.playerSearchGUI.refreshOpenGUIs();
    }

    public FileConfiguration getPlayerDataConfig() {
        return this.playerDataConfig;
    }

    public void savePlayerDataConfig() {
        try {
            this.playerDataConfig.save(this.playerDataFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Failed to save player_data.yml at " + this.playerDataFile.getAbsolutePath() + ": " + e.getMessage());
            e.printStackTrace();
            try {
                if (this.playerDataFile.delete()) {
                    this.getLogger().info("Deleted corrupted player_data.yml, recreating...");
                    this.playerDataFile.createNewFile();
                    this.playerDataConfig = new YamlConfiguration();
                    this.playerDataConfig.createSection("players");
                    this.playerDataConfig.save(this.playerDataFile);
                    this.getLogger().info("Recreated player_data.yml");
                }
            }
            catch (IOException ex) {
                this.getLogger().severe("Failed to recreate player_data.yml: " + ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    public String getLanguage() {
        return this.language;
    }
}

