/*
 * Decompiled with CFR 0.152.
 */
package ru.stepanyaa.playerManager;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import ru.stepanyaa.playerManager.PlayerManager;

public class PlayerSearchGUI
implements Listener,
InventoryHolder {
    private final PlayerManager plugin;
    private Inventory inventory;
    private final Map<Integer, PlayerResult> slotMap = new ConcurrentHashMap<Integer, PlayerResult>();
    private int currentPage = 0;
    private String currentSearch = "";
    private Filter currentFilter = Filter.ALL;
    private final Map<UUID, PlayerResult> playerMenuTargets = new ConcurrentHashMap<UUID, PlayerResult>();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final Set<UUID> playersInGUI;
    private final Map<UUID, ChatAction> pendingActions;
    private final Map<UUID, String> lastOpenedMenu;
    private final Map<UUID, Integer> lastPage;
    private final Map<UUID, String> lastTarget;

    public PlayerSearchGUI(PlayerManager plugin) {
        this.dateFormat.setTimeZone(TimeZone.getDefault() != null ? TimeZone.getDefault() : TimeZone.getTimeZone("UTC"));
        this.playersInGUI = Collections.newSetFromMap(new ConcurrentHashMap());
        this.pendingActions = new ConcurrentHashMap<UUID, ChatAction>();
        this.lastOpenedMenu = new ConcurrentHashMap<UUID, String>();
        this.lastPage = new ConcurrentHashMap<UUID, Integer>();
        this.lastTarget = new ConcurrentHashMap<UUID, String>();
        this.plugin = plugin;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)plugin.getMessage("gui.title", "Player Management"));
    }

    public void openLastGUIMenu(Player admin) {
        PlayerResult result;
        if (!admin.hasPermission("playermanager.admin") && !admin.hasPermission("playermanager.gui")) {
            admin.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission!"));
            return;
        }
        String lastMenu = this.lastOpenedMenu.getOrDefault(admin.getUniqueId(), "search");
        this.currentPage = this.lastPage.getOrDefault(admin.getUniqueId(), 0);
        String lastTargetName = this.lastTarget.get(admin.getUniqueId());
        if (lastMenu.equals("player") && lastTargetName != null) {
            PlayerResult result2 = this.getPlayerResultByName(lastTargetName);
            if (result2 != null) {
                this.openPlayerMenu(admin, result2);
                return;
            }
        } else if (lastMenu.equals("punishment") && lastTargetName != null && (result = this.getPlayerResultByName(lastTargetName)) != null) {
            this.openPunishmentGUI(admin, result);
            return;
        }
        this.openSearchGUI(admin);
    }

    public void openSearchGUI(Player admin) {
        if (!admin.hasPermission("playermanager.admin") && !admin.hasPermission("playermanager.gui")) {
            admin.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission!"));
            return;
        }
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)this.plugin.getMessage("gui.title", "Player Management"));
        this.setupSearchGUI(admin);
        admin.openInventory(this.inventory);
        this.playersInGUI.add(admin.getUniqueId());
        this.setLastOpenedMenu(admin.getUniqueId(), "search");
        this.plugin.savePlayerMenuState(admin);
    }

    private PlayerResult getPlayerResultByName(String name) {
        for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
            String newTexture;
            if (offlinePlayer.getName() == null || !offlinePlayer.getName().equalsIgnoreCase(name)) continue;
            String uuidStr = offlinePlayer.getUniqueId().toString();
            String path = "players." + uuidStr + ".";
            PlayerResult result = new PlayerResult();
            result.uuid = uuidStr;
            result.name = offlinePlayer.getName();
            result.firstPlayed = this.plugin.getPlayerDataConfig().getLong(path + "first_played", offlinePlayer.getFirstPlayed());
            result.lastLogin = this.plugin.getPlayerDataConfig().getLong(path + "last_login", offlinePlayer.getFirstPlayed());
            result.lastLogout = this.plugin.getPlayerDataConfig().getLong(path + "last_logout", offlinePlayer.getLastPlayed());
            result.online = offlinePlayer.isOnline();
            result.banned = offlinePlayer.isBanned();
            boolean needsSave = false;
            boolean storedBanned = this.plugin.getPlayerDataConfig().getBoolean(path + "banned", false);
            if (storedBanned != result.banned) {
                this.plugin.getPlayerDataConfig().set(path + "banned", (Object)result.banned);
                needsSave = true;
            }
            result.headTexture = this.plugin.getPlayerDataConfig().getString(path + "head_texture", "");
            if (result.headTexture.isEmpty() && !(newTexture = this.fetchHeadTexture(offlinePlayer)).isEmpty()) {
                result.headTexture = newTexture;
                this.plugin.getPlayerDataConfig().set(path + "head_texture", (Object)result.headTexture);
                needsSave = true;
            }
            if (needsSave) {
                this.plugin.savePlayerDataConfig();
            }
            return result;
        }
        return null;
    }

    private String fetchHeadTexture(OfflinePlayer player) {
        try {
            ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta meta = (SkullMeta)skull.getItemMeta();
            meta.setOwningPlayer(player);
            skull.setItemMeta((ItemMeta)meta);
            Field profileField = meta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            GameProfile gameProfile = (GameProfile)profileField.get(meta);
            if (gameProfile != null && gameProfile.getProperties().containsKey((Object)"textures")) {
                Property texture = (Property)gameProfile.getProperties().get((Object)"textures").iterator().next();
                return texture.getValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private void setupSearchGUI(Player admin) {
        this.inventory.clear();
        this.slotMap.clear();
        this.inventory.setItem(47, this.createFilterItem(Filter.ALL));
        this.inventory.setItem(48, this.createFilterItem(Filter.ONLINE));
        this.inventory.setItem(50, this.createFilterItem(Filter.OFFLINE));
        this.inventory.setItem(51, this.createFilterItem(Filter.BANNED));
        String searchText = this.plugin.getMessage("gui.search", "Search: %query%").replace("%query%", this.currentSearch.isEmpty() ? this.plugin.getMessage("gui.search-all", "all") : this.currentSearch);
        ItemStack searchItem = new ItemStack(Material.COMPASS);
        ItemMeta searchMeta = searchItem.getItemMeta();
        searchMeta.setDisplayName(ChatColor.YELLOW + searchText);
        ArrayList<String> searchLore = new ArrayList<String>();
        searchLore.add(this.plugin.getMessage("gui.search-hint", "&7Left click: Enter query | Right click: Reset search"));
        searchMeta.setLore(searchLore);
        searchItem.setItemMeta(searchMeta);
        this.inventory.setItem(4, searchItem);
        ItemStack closeItem = new ItemStack(Material.BARRIER);
        ItemMeta closeMeta = closeItem.getItemMeta();
        closeMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.close", "Close"));
        closeItem.setItemMeta(closeMeta);
        this.inventory.setItem(49, closeItem);
        List<PlayerResult> results = this.getSearchResults(admin, this.currentSearch);
        int start = this.currentPage * 36;
        int end = Math.min(start + 36, results.size());
        for (int i = start; i < end; ++i) {
            PlayerResult result = results.get(i);
            ItemStack head = this.createPlayerHead(result);
            this.inventory.setItem(i - start + 9, head);
            this.slotMap.put(i - start + 9, result);
        }
        if (this.currentPage > 0) {
            ItemStack prevPage = new ItemStack(Material.ARROW);
            ItemMeta prevMeta = prevPage.getItemMeta();
            prevMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("gui.previous-page", "Previous page"));
            prevPage.setItemMeta(prevMeta);
            this.inventory.setItem(45, prevPage);
        } else {
            ItemStack noPrev = new ItemStack(Material.RED_STAINED_GLASS_PANE);
            ItemMeta noPrevMeta = noPrev.getItemMeta();
            noPrevMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.no-page", "No page"));
            noPrev.setItemMeta(noPrevMeta);
            this.inventory.setItem(45, noPrev);
        }
        if ((this.currentPage + 1) * 36 < results.size()) {
            ItemStack nextPage = new ItemStack(Material.ARROW);
            ItemMeta nextMeta = nextPage.getItemMeta();
            nextMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("gui.next-page", "Next page"));
            nextPage.setItemMeta(nextMeta);
            this.inventory.setItem(53, nextPage);
        } else {
            ItemStack noNext = new ItemStack(Material.RED_STAINED_GLASS_PANE);
            ItemMeta noNextMeta = noNext.getItemMeta();
            noNextMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.no-page", "No page"));
            noNext.setItemMeta(noNextMeta);
            this.inventory.setItem(53, noNext);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<PlayerResult> getSearchResults(Player admin, String search) {
        ArrayList<PlayerResult> results = new ArrayList<PlayerResult>();
        OfflinePlayer[] offlinePlayerArray = Bukkit.getOfflinePlayers();
        int n = offlinePlayerArray.length;
        int n2 = 0;
        while (true) {
            block10: {
                String newTexture;
                if (n2 >= n) {
                    results.sort(Comparator.comparing(r -> r.name.toLowerCase()));
                    return results;
                }
                OfflinePlayer offlinePlayer = offlinePlayerArray[n2];
                if (offlinePlayer.getName() == null) break block10;
                String name = offlinePlayer.getName();
                String uuidStr = offlinePlayer.getUniqueId().toString();
                if (!search.isEmpty() && !name.toLowerCase().contains(search.toLowerCase())) break block10;
                String path = "players." + uuidStr + ".";
                PlayerResult result = new PlayerResult();
                result.uuid = uuidStr;
                result.name = name;
                result.firstPlayed = this.plugin.getPlayerDataConfig().getLong(path + "first_played", offlinePlayer.getFirstPlayed());
                result.lastLogin = this.plugin.getPlayerDataConfig().getLong(path + "last_login", offlinePlayer.getFirstPlayed());
                result.lastLogout = this.plugin.getPlayerDataConfig().getLong(path + "last_logout", offlinePlayer.getLastPlayed());
                result.online = offlinePlayer.isOnline();
                result.banned = offlinePlayer.isBanned();
                boolean needsSave = false;
                boolean storedBanned = this.plugin.getPlayerDataConfig().getBoolean(path + "banned", false);
                if (storedBanned != result.banned) {
                    this.plugin.getPlayerDataConfig().set(path + "banned", (Object)result.banned);
                    needsSave = true;
                }
                result.headTexture = this.plugin.getPlayerDataConfig().getString(path + "head_texture", "");
                if (result.headTexture.isEmpty() && !(newTexture = this.fetchHeadTexture(offlinePlayer)).isEmpty()) {
                    result.headTexture = newTexture;
                    this.plugin.getPlayerDataConfig().set(path + "head_texture", (Object)result.headTexture);
                    needsSave = true;
                }
                if (needsSave) {
                    this.plugin.savePlayerDataConfig();
                }
                switch (this.currentFilter.ordinal()) {
                    case 1: {
                        if (result.online) break;
                        break block10;
                    }
                    case 2: {
                        if (!result.online) break;
                        break block10;
                    }
                    case 3: {
                        if (!result.banned) break block10;
                    }
                }
                results.add(result);
            }
            ++n2;
        }
    }

    private ItemStack createPlayerHead(PlayerResult result) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        meta.setDisplayName(ChatColor.YELLOW + result.name);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.uuid", "UUID") + ": " + ChatColor.WHITE + result.uuid);
        lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.first-played", "First played") + ": " + ChatColor.WHITE + this.formatDate(result.firstPlayed));
        lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.last-login", "Last login") + ": " + ChatColor.WHITE + this.formatDate(result.lastLogin));
        lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.last-logout", "Last logout") + ": " + ChatColor.WHITE + this.formatDate(result.lastLogout));
        if (!result.online) {
            lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.time-since-logout", "Time since logout") + ": " + ChatColor.WHITE + this.formatTimeAgo(result.lastLogout));
        }
        lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.status", "Status") + ": " + (result.online ? ChatColor.GREEN + this.plugin.getMessage("status.online", "Online") : ChatColor.RED + this.plugin.getMessage("status.offline", "Offline")));
        lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.ban-status", "Ban status") + ": " + (result.banned ? ChatColor.RED + this.plugin.getMessage("status.banned", "Banned") : ChatColor.GREEN + this.plugin.getMessage("status.not-banned", "Not banned")));
        lore.add("");
        lore.add(this.plugin.getMessage("gui.actions", "&7Left click: Menu | Right click: Teleport | Shift+Right click: Punishments"));
        meta.setLore(lore);
        if (!result.headTexture.isEmpty()) {
            try {
                GameProfile profile = new GameProfile(UUID.fromString(result.uuid), null);
                profile.getProperties().put((Object)"textures", (Object)new Property("textures", result.headTexture));
                Field profileField = meta.getClass().getDeclaredField("profile");
                profileField.setAccessible(true);
                profileField.set(meta, profile);
            }
            catch (Exception profile) {}
        } else {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(result.uuid));
            meta.setOwningPlayer(offlinePlayer);
        }
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    private ItemStack createFilterItem(Filter filter) {
        ItemStack item = new ItemStack(filter.getMaterial());
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(filter.getColor() + filter.getDisplayName(this.plugin));
        if (this.currentFilter == filter) {
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(ChatColor.GREEN + this.plugin.getMessage("gui.filter-active", "Active filter"));
            meta.setLore(lore);
        }
        item.setItemMeta(meta);
        return item;
    }

    public void openPlayerMenu(Player player, PlayerResult result) {
        if (!player.hasPermission("playermanager.admin") && !player.hasPermission("playermanager.gui")) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission!"));
            return;
        }
        Inventory playerMenu = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)(this.plugin.getMessage("gui.player-menu-prefix", "Player Menu: ") + ChatColor.YELLOW + result.name));
        ItemStack headItem = this.createPlayerHead(result);
        playerMenu.setItem(4, headItem);
        ItemStack infoItem = new ItemStack(Material.BOOK);
        ItemMeta infoMeta = infoItem.getItemMeta();
        infoMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("gui.info", "Information"));
        ArrayList<String> infoLore = new ArrayList<String>();
        infoLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.uuid", "UUID") + ": " + ChatColor.WHITE + result.uuid);
        infoLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.first-played", "First played") + ": " + ChatColor.WHITE + this.formatDate(result.firstPlayed));
        infoLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.last-login", "Last login") + ": " + ChatColor.WHITE + this.formatDate(result.lastLogin));
        infoLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.last-logout", "Last logout") + ": " + ChatColor.WHITE + this.formatDate(result.lastLogout));
        if (!result.online) {
            infoLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.time-since-logout", "Time since logout") + ": " + ChatColor.WHITE + this.formatTimeAgo(result.lastLogout));
        }
        infoLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.status", "Status") + ": " + (result.online ? ChatColor.GREEN + this.plugin.getMessage("status.online", "Online") : ChatColor.RED + this.plugin.getMessage("status.offline", "Offline")));
        infoLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.ban-status", "Ban status") + ": " + (result.banned ? ChatColor.RED + this.plugin.getMessage("status.banned", "Banned") : ChatColor.GREEN + this.plugin.getMessage("status.not-banned", "Not banned")));
        infoMeta.setLore(infoLore);
        infoItem.setItemMeta(infoMeta);
        playerMenu.setItem(10, infoItem);
        if (this.getConfigValue("features.player-teleportation")) {
            ItemStack teleportItem = new ItemStack(Material.ENDER_PEARL);
            ItemMeta teleportMeta = teleportItem.getItemMeta();
            teleportMeta.setDisplayName(ChatColor.GREEN + this.plugin.getMessage("gui.teleport", "Teleport"));
            teleportItem.setItemMeta(teleportMeta);
            playerMenu.setItem(12, teleportItem);
        }
        if (this.getConfigValue("features.inventory-inspection")) {
            ItemStack inventoryItem = new ItemStack(Material.CHEST);
            ItemMeta inventoryMeta = inventoryItem.getItemMeta();
            inventoryMeta.setDisplayName(ChatColor.AQUA + this.plugin.getMessage("gui.inspect-inventory", "Inspect Inventory"));
            inventoryItem.setItemMeta(inventoryMeta);
            playerMenu.setItem(14, inventoryItem);
        }
        if (this.getConfigValue("features.punishment-system")) {
            ItemStack punishmentsItem = new ItemStack(Material.IRON_SWORD);
            ItemMeta punishmentsMeta = punishmentsItem.getItemMeta();
            punishmentsMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.punishments", "Punishments"));
            punishmentsItem.setItemMeta(punishmentsMeta);
            playerMenu.setItem(16, punishmentsItem);
        }
        ItemStack backItem = new ItemStack(Material.ARROW);
        ItemMeta backMeta = backItem.getItemMeta();
        backMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.back", "Back"));
        backItem.setItemMeta(backMeta);
        playerMenu.setItem(22, backItem);
        player.openInventory(playerMenu);
        this.setPlayerMenuTarget(player.getUniqueId(), result);
        this.setLastOpenedMenu(player.getUniqueId(), "player");
        this.setLastTarget(player.getUniqueId(), result.name);
        this.plugin.savePlayerMenuState(player);
    }

    private boolean getConfigValue(String key) {
        return this.plugin.getConfig().getBoolean(key, true);
    }

    public void openPunishmentGUI(Player player, PlayerResult result) {
        if (!player.hasPermission("playermanager.admin") && !player.hasPermission("playermanager.gui")) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission!"));
            return;
        }
        if (!this.getConfigValue("features.punishment-system")) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.punishment-disabled", "Punishment system is disabled in config!"));
            return;
        }
        Inventory punishmentGUI = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)(this.plugin.getMessage("gui.punishment-prefix", "Punishments: ") + ChatColor.YELLOW + result.name));
        ItemStack headItem = this.createPlayerHead(result);
        punishmentGUI.setItem(4, headItem);
        Material[] materials = new Material[]{Material.NETHERITE_SWORD, Material.BLAZE_ROD, Material.BOOK, Material.PAPER, Material.GREEN_DYE};
        String[] displayKeys = new String[]{"ban", "kick", "warn", "mute", "unban"};
        ChatColor[] colors = new ChatColor[]{ChatColor.RED, ChatColor.GOLD, ChatColor.YELLOW, ChatColor.GREEN, ChatColor.DARK_GREEN};
        int[] slots = new int[]{10, 11, 13, 15, 16};
        for (int i = 0; i < 5; ++i) {
            ItemStack item = new ItemStack(materials[i]);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(colors[i] + this.plugin.getMessage("gui.punishment." + displayKeys[i], displayKeys[i].substring(0, 1).toUpperCase() + displayKeys[i].substring(1)));
            item.setItemMeta(meta);
            punishmentGUI.setItem(slots[i], item);
        }
        ItemStack backItem = new ItemStack(Material.ARROW);
        ItemMeta backMeta = backItem.getItemMeta();
        backMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.back", "Back"));
        backItem.setItemMeta(backMeta);
        punishmentGUI.setItem(22, backItem);
        player.openInventory(punishmentGUI);
        this.setPlayerMenuTarget(player.getUniqueId(), result);
        this.setLastOpenedMenu(player.getUniqueId(), "punishment");
        this.setLastTarget(player.getUniqueId(), result.name);
        this.plugin.savePlayerMenuState(player);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (event.getInventory().getHolder() != this) {
            return;
        }
        event.setCancelled(true);
        if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        int slot = event.getRawSlot();
        String currentMenu = this.lastOpenedMenu.getOrDefault(player.getUniqueId(), "search");
        if (currentMenu.equals("search")) {
            this.handleSearchClick(event, player, slot);
        } else if (currentMenu.equals("player")) {
            this.handlePlayerMenuClick(event, player, slot);
        } else if (currentMenu.equals("punishment")) {
            this.handlePunishmentClick(event, player, slot);
        }
    }

    private void handleSearchClick(InventoryClickEvent event, Player player, int slot) {
        if (slot == 4) {
            if (event.getClick() == ClickType.LEFT) {
                player.closeInventory();
                String cancelText = this.plugin.getMessage("gui.cancel", "[Cancel]");
                TextComponent message = new TextComponent(ChatColor.YELLOW + this.plugin.getMessage("gui.enter-search", "Enter name to search: ") + " ");
                TextComponent cancel = new TextComponent(ChatColor.RED + cancelText);
                cancel.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/playermanager reset"));
                message.addExtra((BaseComponent)cancel);
                player.spigot().sendMessage((BaseComponent)message);
                this.pendingActions.put(player.getUniqueId(), (msg, p) -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    String input = ChatColor.stripColor((String)msg.trim());
                    String cancelTextRu = ChatColor.stripColor((String)this.plugin.getMessage("gui.cancel", "[Cancel]").replaceAll("[\\[\\]]", ""));
                    String cancelTextEn = "Cancel";
                    if (input.equalsIgnoreCase(cancelTextRu) || input.equalsIgnoreCase(cancelTextEn)) {
                        this.resetSearch(p);
                        return;
                    }
                    this.currentSearch = input;
                    this.currentPage = 0;
                    this.lastPage.put(p.getUniqueId(), 0);
                    this.setupSearchGUI(p);
                    p.openInventory(this.inventory);
                    this.pendingActions.remove(p.getUniqueId());
                }));
            } else if (event.getClick() == ClickType.RIGHT) {
                this.resetSearch(player);
            }
            return;
        }
        if (slot == 49) {
            player.closeInventory();
            this.pendingActions.remove(player.getUniqueId());
            return;
        }
        if (slot == 45 && this.currentPage > 0) {
            --this.currentPage;
            this.lastPage.put(player.getUniqueId(), this.currentPage);
            this.setupSearchGUI(player);
            this.plugin.savePlayerMenuState(player);
            return;
        }
        if (slot == 53 && (this.currentPage + 1) * 36 < this.getSearchResults(player, this.currentSearch).size()) {
            ++this.currentPage;
            this.lastPage.put(player.getUniqueId(), this.currentPage);
            this.setupSearchGUI(player);
            this.plugin.savePlayerMenuState(player);
            return;
        }
        if (slot >= 47 && slot <= 51) {
            Filter newFilter = null;
            switch (slot) {
                case 47: {
                    newFilter = Filter.ALL;
                    break;
                }
                case 48: {
                    newFilter = Filter.ONLINE;
                    break;
                }
                case 50: {
                    newFilter = Filter.OFFLINE;
                    break;
                }
                case 51: {
                    newFilter = Filter.BANNED;
                }
            }
            if (newFilter != null && newFilter != this.currentFilter) {
                this.currentFilter = newFilter;
                this.currentPage = 0;
                this.lastPage.put(player.getUniqueId(), 0);
                this.setupSearchGUI(player);
            }
            return;
        }
        PlayerResult result = this.slotMap.get(slot);
        if (result == null) {
            return;
        }
        if (event.getClick() == ClickType.LEFT) {
            this.openPlayerMenu(player, result);
        } else if (event.getClick() == ClickType.RIGHT) {
            if (!this.getConfigValue("features.player-teleportation")) {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.teleportation-disabled", "Teleportation is disabled!"));
                return;
            }
            Player target = Bukkit.getPlayer((String)result.name);
            if (target == null) {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.player-offline", "Player is offline."));
                return;
            }
            player.teleport((Entity)target);
            player.sendMessage(ChatColor.GREEN + this.plugin.getMessage("action.teleported", "Teleported to %player%").replace("%player%", result.name));
        } else if (event.getClick() == ClickType.SHIFT_RIGHT) {
            if (!this.getConfigValue("features.punishment-system")) {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.punishment-disabled", "Punishment system is disabled in config!"));
                return;
            }
            this.openPunishmentGUI(player, result);
        }
    }

    private void handlePlayerMenuClick(InventoryClickEvent event, Player player, int slot) {
        PlayerResult result = this.playerMenuTargets.get(player.getUniqueId());
        if (result == null) {
            return;
        }
        if (slot == 22) {
            this.openSearchGUI(player);
            return;
        }
        if (slot == 12 && this.getConfigValue("features.player-teleportation")) {
            Player target = Bukkit.getPlayer((String)result.name);
            if (target == null) {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.player-offline", "Player is offline."));
                return;
            }
            if (target == player) {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.self-teleport", "You can't teleport to yourself."));
                return;
            }
            player.teleport((Entity)target);
            player.sendMessage(ChatColor.GREEN + this.plugin.getMessage("action.teleported", "Teleported to %player%").replace("%player%", result.name));
            return;
        }
        if (slot == 14 && this.getConfigValue("features.inventory-inspection")) {
            Player target = Bukkit.getPlayer((String)result.name);
            if (target == null) {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.player-offline-inventory", "Player is offline, inventory modification is impossible."));
                return;
            }
            player.openInventory((Inventory)target.getInventory());
            return;
        }
        if (slot == 16 && this.getConfigValue("features.punishment-system")) {
            this.openPunishmentGUI(player, result);
            return;
        }
    }

    private void handlePunishmentClick(InventoryClickEvent event, Player player, int slot) {
        PlayerResult result = this.playerMenuTargets.get(player.getUniqueId());
        if (result == null) {
            return;
        }
        if (slot == 22) {
            this.openPlayerMenu(player, result);
            return;
        }
        String path = "players." + result.uuid + ".";
        String[] commands = new String[]{"ban", "kick", "warn", "mute", "pardon"};
        int[] slots = new int[]{10, 11, 13, 15, 16};
        int index = -1;
        for (int i = 0; i < slots.length; ++i) {
            if (slot != slots[i]) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return;
        }
        if (!(index != 1 && index != 2 && index != 3 || result.online)) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.player-offline", "Player is offline."));
            return;
        }
        if (index == 0 && result.banned) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.already-banned", "This player is already banned!"));
            return;
        }
        if (index == 4 && !result.banned) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.not-banned", "This player is not banned!"));
            return;
        }
        if (player.getUniqueId().toString().equals(result.uuid)) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.self-punish", "You can't punish yourself."));
            return;
        }
        Bukkit.dispatchCommand((CommandSender)player, (String)(commands[index] + " " + result.name));
        player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.executed", "Executed: %command% for %player%").replace("%command%", commands[index].equals("pardon") ? "unban" : commands[index]).replace("%player%", result.name));
        boolean needsSave = false;
        if (index == 0) {
            result.banned = true;
            if (!this.plugin.getPlayerDataConfig().getBoolean(path + "banned", false)) {
                this.plugin.getPlayerDataConfig().set(path + "banned", (Object)true);
                needsSave = true;
            }
        } else if (index == 4) {
            result.banned = false;
            if (this.plugin.getPlayerDataConfig().getBoolean(path + "banned", false)) {
                this.plugin.getPlayerDataConfig().set(path + "banned", (Object)false);
                needsSave = true;
            }
        }
        if (needsSave) {
            this.plugin.savePlayerDataConfig();
        }
        this.openPunishmentGUI(player, result);
        this.refreshOpenGUIs();
        event.setCancelled(true);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        boolean allFeaturesDisabled;
        Player player = event.getPlayer();
        if (!player.hasPermission("playermanager.admin") && !player.hasPermission("playermanager.gui")) {
            return;
        }
        boolean punishmentEnabled = this.getConfigValue("features.punishment-system");
        boolean teleportEnabled = this.getConfigValue("features.player-teleportation");
        boolean inventoryEnabled = this.getConfigValue("features.inventory-inspection");
        boolean bl = allFeaturesDisabled = !punishmentEnabled && !teleportEnabled && !inventoryEnabled;
        if (event.getAction().toString().contains("RIGHT_CLICK") && player.isSneaking()) {
            if (allFeaturesDisabled) {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.all-features-disabled", "All features are disabled in config!"));
                return;
            }
            this.openLastGUIMenu(player);
            event.setCancelled(true);
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void refreshOpenGUIs() {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            Iterator<UUID> iterator = this.playersInGUI.iterator();
            while (iterator.hasNext()) {
                UUID playerId = iterator.next();
                Player player = Bukkit.getPlayer((UUID)playerId);
                if (player == null || !player.isOnline() || !player.hasPermission("playermanager.admin") && !player.hasPermission("playermanager.gui")) {
                    iterator.remove();
                    continue;
                }
                if (player.getOpenInventory().getTopInventory().getHolder() instanceof PlayerSearchGUI) {
                    PlayerResult result;
                    String currentMenu = this.lastOpenedMenu.getOrDefault(player.getUniqueId(), "search");
                    if (currentMenu.equals("search")) {
                        this.setupSearchGUI(player);
                        player.updateInventory();
                        continue;
                    }
                    if (currentMenu.equals("player")) {
                        result = this.playerMenuTargets.get(player.getUniqueId());
                        if (result != null) {
                            this.openPlayerMenu(player, result);
                            continue;
                        }
                        this.openSearchGUI(player);
                        continue;
                    }
                    if (!currentMenu.equals("punishment")) continue;
                    result = this.playerMenuTargets.get(player.getUniqueId());
                    if (result != null) {
                        this.openPunishmentGUI(player, result);
                        continue;
                    }
                    this.openSearchGUI(player);
                    continue;
                }
                iterator.remove();
            }
        });
    }

    public void resetSearch(Player player) {
        if (!player.hasPermission("playermanager.admin") && !player.hasPermission("playermanager.gui")) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission!"));
            return;
        }
        this.currentSearch = "";
        this.currentFilter = Filter.ALL;
        this.currentPage = 0;
        this.lastPage.put(player.getUniqueId(), 0);
        this.lastTarget.remove(player.getUniqueId());
        this.setLastOpenedMenu(player.getUniqueId(), "search");
        this.setupSearchGUI(player);
        player.openInventory(this.inventory);
        player.updateInventory();
        player.sendMessage(ChatColor.GREEN + this.plugin.getMessage("action.search-cancelled", "Search cancelled"));
        this.pendingActions.remove(player.getUniqueId());
        this.plugin.savePlayerMenuState(player);
    }

    public void setPlayerMenuTarget(UUID playerId, PlayerResult result) {
        this.playerMenuTargets.put(playerId, result);
    }

    public String getLastOpenedMenu(UUID playerId) {
        return this.lastOpenedMenu.getOrDefault(playerId, "search");
    }

    public void setLastOpenedMenu(UUID playerId, String menu) {
        this.lastOpenedMenu.put(playerId, menu);
    }

    public int getLastPage(UUID playerId) {
        return this.lastPage.getOrDefault(playerId, 0);
    }

    public void setLastPage(UUID playerId, int page) {
        this.lastPage.put(playerId, page);
    }

    public String getLastTarget(UUID playerId) {
        return this.lastTarget.get(playerId);
    }

    public void setLastTarget(UUID playerId, String target) {
        if (target != null) {
            this.lastTarget.put(playerId, target);
        } else {
            this.lastTarget.remove(playerId);
        }
    }

    private String formatDate(long timestamp) {
        if (timestamp == 0L) {
            return "-";
        }
        return this.dateFormat.format(new Date(timestamp));
    }

    private String formatTimeAgo(long timestamp) {
        if (timestamp == 0L) {
            return "-";
        }
        long seconds = (System.currentTimeMillis() - timestamp) / 1000L;
        if (seconds < 60L) {
            return seconds + " " + this.plugin.getMessage("time.seconds-ago", "seconds ago");
        }
        if (seconds < 3600L) {
            return seconds / 60L + " " + this.plugin.getMessage("time.minutes-ago", "minutes ago");
        }
        return seconds < 86400L ? seconds / 3600L + " " + this.plugin.getMessage("time.hours-ago", "hours ago") : seconds / 86400L + " " + this.plugin.getMessage("time.days-ago", "days ago");
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        ChatAction action = this.pendingActions.get(player.getUniqueId());
        if (action != null) {
            event.setCancelled(true);
            action.execute(event.getMessage(), player);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getPlayer() instanceof Player) {
            Player player = (Player)event.getPlayer();
            if (event.getInventory().getHolder() instanceof PlayerSearchGUI) {
                this.playersInGUI.remove(player.getUniqueId());
                this.pendingActions.remove(player.getUniqueId());
            }
        }
    }

    static enum Filter {
        ALL("COMPASS", ChatColor.YELLOW, "filter.all"),
        ONLINE("LIME_DYE", ChatColor.GREEN, "filter.online"),
        OFFLINE("GRAY_DYE", ChatColor.RED, "filter.offline"),
        BANNED("REDSTONE", ChatColor.DARK_RED, "filter.banned");

        private final String material;
        private final ChatColor color;
        private final String messageKey;

        private Filter(String material, ChatColor color, String messageKey) {
            this.material = material;
            this.color = color;
            this.messageKey = messageKey;
        }

        public Material getMaterial() {
            try {
                return Material.valueOf((String)this.material);
            }
            catch (IllegalArgumentException e) {
                return Material.STONE;
            }
        }

        public ChatColor getColor() {
            return this.color;
        }

        public String getDisplayName(PlayerManager plugin) {
            return plugin.getMessage(this.messageKey, this.name());
        }
    }

    static class PlayerResult {
        String uuid;
        String name;
        long firstPlayed;
        long lastLogin;
        long lastLogout;
        boolean online;
        boolean banned;
        String headTexture;

        PlayerResult() {
        }
    }

    @FunctionalInterface
    static interface ChatAction {
        public void execute(String var1, Player var2);
    }
}

