/*
 * Decompiled with CFR 0.152.
 */
package ru.stepanyaa.playerManager;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ru.stepanyaa.playerManager.PlayerSearchGUI;
import ru.stepanyaa.playerManager.gson.JsonArray;
import ru.stepanyaa.playerManager.gson.JsonElement;
import ru.stepanyaa.playerManager.gson.JsonParser;

public class PlayerManager
extends JavaPlugin
implements Listener,
CommandExecutor,
TabCompleter {
    private File playerDataFile;
    private FileConfiguration playerDataConfig;
    private File messagesFile;
    private FileConfiguration messagesConfig;
    private PlayerSearchGUI playerSearchGUI;
    private String language;
    private static final String MODRINTH_API_URL = "https://api.modrinth.com/v2/project/playermanagers/version";
    private static final String CURRENT_VERSION = "1.0.7";
    private String latestVersion = null;
    private final Set<UUID> notifiedAdmins = new HashSet<UUID>();
    private static final String[] SUPPORTED_LANGUAGES = new String[]{"en", "ru"};
    private final List<String> cachedPlayerNames = new ArrayList<String>();
    private final Set<String> adminUUIDs = new HashSet<String>();
    public final Map<UUID, BiConsumer<String, Player>> pendingActions = new HashMap<UUID, BiConsumer<String, Player>>();
    private boolean isFirstEnable = true;

    public void onEnable() {
        this.saveDefaultConfig();
        this.reloadConfig();
        this.language = this.getConfig().getString("language", "en");
        if (!Arrays.asList(SUPPORTED_LANGUAGES).contains(this.language)) {
            this.getLogger().warning("Unsupported language '" + this.language + "' in config.yml, defaulting to 'en'");
            this.language = "en";
        }
        this.playerDataFile = new File(this.getDataFolder(), "player_data.yml");
        if (!this.playerDataFile.exists()) {
            this.playerDataFile.getParentFile().mkdirs();
            this.saveResource("player_data.yml", false);
        }
        this.playerDataConfig = YamlConfiguration.loadConfiguration((File)this.playerDataFile);
        if (!this.playerDataFile.canWrite()) {
            this.getLogger().severe("Cannot write to player_data.yml! Check file permissions in " + this.playerDataFile.getAbsolutePath());
        }
        if (this.playerDataConfig.getConfigurationSection("players") == null) {
            this.playerDataConfig.createSection("players");
            this.savePlayerDataConfig();
        }
        this.loadMessages();
        this.updateMessagesFiles();
        this.updateConfigFile();
        this.playerSearchGUI = new PlayerSearchGUI(this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.playerSearchGUI, (Plugin)this);
        PluginCommand command = this.getCommand("playermanager");
        if (command != null) {
            command.setExecutor((CommandExecutor)this);
            command.setTabCompleter((TabCompleter)this);
            command.setPermissionMessage(ChatColor.RED + this.getMessage("error.no-permission", "You don't have permission!"));
        } else {
            this.getLogger().warning(this.getMessage("warning.command-register-fail", "Failed to register command 'playermanager'!"));
        }
        this.cachedPlayerNames.clear();
        for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
            String name = offlinePlayer.getName();
            if (name == null || name.isEmpty()) continue;
            this.cachedPlayerNames.add(name.toLowerCase());
        }
        this.cachedPlayerNames.sort(String.CASE_INSENSITIVE_ORDER);
        this.getLogger().info("Initialized player name cache: " + this.cachedPlayerNames.size() + " players");
        this.adminUUIDs.clear();
        this.adminUUIDs.addAll(this.getConfig().getStringList("admin-uuids"));
        Logger authlibLogger = Logger.getLogger("com.mojang.authlib");
        authlibLogger.setLevel(Level.WARNING);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.loadPlayerMenuState(player);
            this.updatePlayerDataOnJoin(player);
        }
        this.checkForUpdates();
        this.checkConfigInactivityPeriod();
        this.schedulePlayerDataCleanup();
        this.getLogger().info(this.getMessage("warning.plugin-enabled", "PlayerManager enabled with language: %lang%").replace("%lang%", this.language));
        this.isFirstEnable = false;
    }

    private void schedulePlayerDataCleanup() {
    }

    private void checkConfigInactivityPeriod() {
        long maxInactivityDays = this.getConfig().getLong("max-inactivity-days", 30L);
        if (maxInactivityDays > 365L) {
            this.getLogger().severe(ChatColor.RED + this.getMessage("warning.max-inactivity-too-high", "Warning: max-inactivity-days (%days%) is set too high! Recommended maximum is 365 days.").replace("%days%", String.valueOf(maxInactivityDays)));
        }
    }

    private void checkForUpdates() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            try {
                URL url = new URL(MODRINTH_API_URL);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setRequestProperty("User-Agent", "PlayerManager/1.0.7");
                conn.connect();
                if (conn.getResponseCode() == 200) {
                    JsonArray versions = JsonParser.parseReader(new InputStreamReader(conn.getInputStream())).getAsJsonArray();
                    String highestVersion = null;
                    for (JsonElement element : versions) {
                        String versionNumber = element.getAsJsonObject().get("version_number").getAsString();
                        String versionType = element.getAsJsonObject().get("version_type").getAsString();
                        if (versionNumber.contains("-SNAPSHOT") && !versionType.equals("release") || highestVersion != null && !this.isNewerVersion(versionNumber, highestVersion)) continue;
                        highestVersion = versionNumber;
                    }
                    if (highestVersion != null && this.isNewerVersion(highestVersion, CURRENT_VERSION)) {
                        String[] currentParts = CURRENT_VERSION.split("\\.");
                        String[] highestParts = highestVersion.split("\\.");
                        if (currentParts.length == 3 && highestParts.length == 3) {
                            int currentMajor = Integer.parseInt(currentParts[0]);
                            int currentMinor = Integer.parseInt(currentParts[1]);
                            int currentPatch = Integer.parseInt(currentParts[2]);
                            int highestMajor = Integer.parseInt(highestParts[0]);
                            int highestMinor = Integer.parseInt(highestParts[1]);
                            int highestPatch = Integer.parseInt(highestParts[2]);
                            if (currentMajor == highestMajor && currentMinor == highestMinor && highestPatch == currentPatch + 1) {
                                this.latestVersion = highestVersion;
                                String consoleMessage = "*** UPDATE AVAILABLE *** A new version of PlayerManager (" + this.latestVersion + ") is available at https://modrinth.com/plugin/playermanagers/versions";
                                this.getLogger().info(consoleMessage);
                            }
                        }
                    }
                }
                conn.disconnect();
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to check for updates: " + e.getMessage());
            }
        });
    }

    private void updateMessagesFiles() {
        for (String lang : SUPPORTED_LANGUAGES) {
            YamlConfiguration existingConfig;
            String currentFileVersion;
            String fileName = "messages_" + lang + ".yml";
            File messageFile = new File(this.getDataFolder(), fileName);
            if (!messageFile.exists()) {
                if (this.getResource(fileName) != null) {
                    this.saveResource(fileName, false);
                    this.getLogger().info(this.getMessage("warning.messages-file-create", "Created messages file: %file%").replace("%file%", fileName));
                } else {
                    this.getLogger().warning(this.getMessage("warning.messages-file-not-found", "Messages file %file% not found in plugin!").replace("%file%", fileName));
                    continue;
                }
            }
            if ((currentFileVersion = (existingConfig = YamlConfiguration.loadConfiguration((File)messageFile)).getString("version", "0.0.0")).equals(CURRENT_VERSION)) {
                if (!this.isFirstEnable) continue;
                this.getLogger().info(this.getMessage("warning.messages-file-up-to-date", "Messages file %file% is up-to-date (version %version%).").replace("%file%", fileName).replace("%version%", CURRENT_VERSION));
                continue;
            }
            if (this.getResource(fileName) != null) {
                try {
                    this.saveResource(fileName, true);
                    this.getLogger().info(this.getMessage("warning.messages-file-updated", "Updated messages file %file% to version %version%.").replace("%file%", fileName).replace("%version%", CURRENT_VERSION));
                    YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((File)messageFile);
                    newConfig.set("version", (Object)CURRENT_VERSION);
                    newConfig.save(messageFile);
                }
                catch (Exception e) {
                    this.getLogger().warning("Failed to update messages file " + fileName + ": " + e.getMessage());
                }
                continue;
            }
            this.getLogger().warning(this.getMessage("warning.messages-file-not-found", "Messages file %file% not found in plugin!").replace("%file%", fileName));
        }
    }

    private void updateConfigFile() {
        YamlConfiguration existingConfig;
        String currentFileVersion;
        File configFile = new File(this.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            this.saveResource("config.yml", false);
            this.getLogger().info(this.getMessage("warning.config-file-create", "Created config file: config.yml"));
        }
        if ((currentFileVersion = (existingConfig = YamlConfiguration.loadConfiguration((File)configFile)).getString("config-version", "0.0.0")).equals(CURRENT_VERSION)) {
            if (this.isFirstEnable) {
                this.getLogger().info(this.getMessage("warning.config-file-up-to-date", "Config file config.yml is up-to-date (version %version%).").replace("%version%", CURRENT_VERSION));
            }
            return;
        }
        if (this.getResource("config.yml") != null) {
            try {
                this.saveResource("config.yml", true);
                this.getLogger().info(this.getMessage("warning.config-file-updated", "Updated config.yml to version %version%.").replace("%version%", CURRENT_VERSION));
                YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((File)configFile);
                newConfig.set("config-version", (Object)CURRENT_VERSION);
                newConfig.save(configFile);
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to update config.yml: " + e.getMessage());
            }
        } else {
            this.getLogger().warning(this.getMessage("warning.config-file-not-found", "Resource config.yml not found in plugin!"));
        }
    }

    private boolean isNewerVersion(String newVersion, String currentVersion) {
        try {
            String cleanNewVersion = newVersion.replace("-SNAPSHOT", "");
            String cleanCurrentVersion = currentVersion.replace("-SNAPSHOT", "");
            String[] newParts = cleanNewVersion.split("\\.");
            String[] currentParts = cleanCurrentVersion.split("\\.");
            int length = Math.max(newParts.length, currentParts.length);
            for (int i = 0; i < length; ++i) {
                int currentPart;
                int newPart = i < newParts.length ? Integer.parseInt(newParts[i]) : 0;
                int n = currentPart = i < currentParts.length ? Integer.parseInt(currentParts[i]) : 0;
                if (newPart > currentPart) {
                    return true;
                }
                if (newPart >= currentPart) continue;
                return false;
            }
            return false;
        }
        catch (NumberFormatException e) {
            this.getLogger().warning("Invalid version format: newVersion=" + newVersion + ", currentVersion=" + currentVersion);
            return false;
        }
    }

    public boolean isAdminPlayer(Player player) {
        return player.hasPermission("playermanager.admin") || player.hasPermission("playermanager.gui");
    }

    public boolean isAdminPlayer(OfflinePlayer offlinePlayer) {
        if (offlinePlayer.isOnline()) {
            return offlinePlayer.getPlayer().hasPermission("playermanager.admin") || offlinePlayer.getPlayer().hasPermission("playermanager.gui");
        }
        return this.adminUUIDs.contains(offlinePlayer.getUniqueId().toString());
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("playermanager.admin") && !this.hasAnyPermission(sender)) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            ArrayList<String> commands = new ArrayList<String>();
            if (sender.hasPermission("playermanager.admin") || sender.hasPermission("playermanager.gui")) {
                commands.add("gui");
            }
            if (sender.hasPermission("playermanager.admin") || sender.hasPermission("playermanager.reload")) {
                commands.add("reload");
            }
            if (sender.hasPermission("playermanager.admin") || sender.hasPermission("playermanager.gui") || sender.hasPermission("playermanager.reset")) {
                commands.add("reset");
            }
            if (sender.hasPermission("playermanager.admin") || sender.hasPermission("playermanager.ban")) {
                commands.add("ban");
            }
            if (sender.hasPermission("playermanager.admin") || sender.hasPermission("playermanager.kick")) {
                commands.add("kick");
            }
            if (sender.hasPermission("playermanager.admin") || sender.hasPermission("playermanager.warn")) {
                commands.add("warn");
            }
            if (sender.hasPermission("playermanager.admin") || sender.hasPermission("playermanager.mute")) {
                commands.add("mute");
            }
            if (sender.hasPermission("playermanager.admin") || sender.hasPermission("playermanager.unban")) {
                commands.add("unban");
            }
            if (sender.hasPermission("playermanager.admin") || sender.hasPermission("playermanager.teleport")) {
                commands.add("teleport");
            }
            if (sender.hasPermission("playermanager.admin") || sender.hasPermission("playermanager.inventory")) {
                commands.add("inventory");
            }
            return commands.stream().filter(cmd -> cmd.toLowerCase().startsWith(args[0].toLowerCase())).sorted().collect(Collectors.toList());
        }
        if (args.length == 2 && Arrays.asList("ban", "kick", "warn", "mute", "unban", "teleport", "inventory").contains(args[0].toLowerCase())) {
            String action = args[0].toLowerCase();
            if (sender.hasPermission("playermanager.admin") || sender.hasPermission("playermanager." + action)) {
                String partialName = args[1].toLowerCase();
                List<String> matches = new ArrayList<String>();
                if (action.equals("ban")) {
                    for (String name : this.cachedPlayerNames) {
                        if (!name.startsWith(partialName) || this.adminUUIDs.contains(this.getUUIDForName(name))) continue;
                        matches.add(name.substring(0, 1).toUpperCase() + name.substring(1));
                    }
                } else if (action.equals("unban")) {
                    ConfigurationSection playersSection = this.playerDataConfig.getConfigurationSection("players");
                    if (playersSection != null) {
                        for (String uuid : playersSection.getKeys(false)) {
                            String name;
                            if (!this.playerDataConfig.getBoolean("players." + uuid + ".banned", false) || (name = this.playerDataConfig.getString("players." + uuid + ".name", "")).isEmpty() || !name.toLowerCase().startsWith(partialName) || this.adminUUIDs.contains(uuid)) continue;
                            matches.add(name.substring(0, 1).toUpperCase() + name.substring(1));
                        }
                    }
                } else {
                    for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                        String name = onlinePlayer.getName().toLowerCase();
                        if (!name.startsWith(partialName) || this.adminUUIDs.contains(onlinePlayer.getUniqueId().toString())) continue;
                        matches.add(onlinePlayer.getName());
                    }
                }
                if (matches.size() > 50) {
                    matches = matches.subList(0, 50);
                }
                return matches;
            }
        } else if (args.length == 3 && Arrays.asList("ban", "warn", "mute").contains(args[0].toLowerCase())) {
            return Collections.singletonList("<reason>");
        }
        return Collections.emptyList();
    }

    private String getUUIDForName(String name) {
        String path = "players.";
        ConfigurationSection playersSection = this.playerDataConfig.getConfigurationSection("players");
        if (playersSection != null) {
            for (String uuid : playersSection.getKeys(false)) {
                if (!name.equalsIgnoreCase(this.playerDataConfig.getString(path + uuid + ".name"))) continue;
                return uuid;
            }
        }
        return null;
    }

    private boolean hasAnyPermission(CommandSender sender) {
        return sender.hasPermission("playermanager.gui") || sender.hasPermission("playermanager.reload") || sender.hasPermission("playermanager.reset") || sender.hasPermission("playermanager.ban") || sender.hasPermission("playermanager.kick") || sender.hasPermission("playermanager.warn") || sender.hasPermission("playermanager.mute") || sender.hasPermission("playermanager.unban") || sender.hasPermission("playermanager.teleport") || sender.hasPermission("playermanager.inventory");
    }

    private void loadMessages() {
        String messagesFileName = "messages_" + this.language + ".yml";
        this.messagesFile = new File(this.getDataFolder(), messagesFileName);
        try {
            if (!this.messagesFile.exists()) {
                if (this.getResource(messagesFileName) != null) {
                    this.saveResource(messagesFileName, false);
                    this.getLogger().info("Created messages file: " + messagesFileName);
                } else {
                    this.getLogger().warning("Messages file " + messagesFileName + " not found in plugin!");
                    this.messagesConfig = new YamlConfiguration();
                    return;
                }
            }
            this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
            String currentFileVersion = this.messagesConfig.getString("version", "0.0.0");
            if (!currentFileVersion.equals(CURRENT_VERSION)) {
                if (this.getResource(messagesFileName) != null) {
                    File backupFile = new File(this.getDataFolder(), messagesFileName + ".backup");
                    if (this.messagesFile.renameTo(backupFile)) {
                        this.getLogger().info("Backed up old messages file to: " + messagesFileName + ".backup");
                    }
                    this.saveResource(messagesFileName, true);
                    this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
                    this.messagesConfig.set("version", (Object)CURRENT_VERSION);
                    this.messagesConfig.save(this.messagesFile);
                    this.getLogger().info("Updated messages file " + messagesFileName + " to version " + CURRENT_VERSION);
                } else {
                    this.getLogger().warning("Resource " + messagesFileName + " not found in plugin!");
                }
            } else if (this.isFirstEnable) {
                this.getLogger().info("Messages file " + messagesFileName + " is up-to-date (version " + CURRENT_VERSION + ").");
            }
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to load messages file: " + e.getMessage());
            this.messagesConfig = new YamlConfiguration();
        }
    }

    public String getMessage(String key, String defaultValue) {
        String message = this.messagesConfig.getString(key, defaultValue);
        if (message == null || message.isEmpty()) {
            return defaultValue;
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public void loadPlayerMenuState(Player player) {
        if (!player.hasPermission("playermanager.admin") && !player.hasPermission("playermanager.gui")) {
            return;
        }
        UUID uuid = player.getUniqueId();
        String lastMenu = this.playerDataConfig.getString("admin." + uuid + ".lastOpenedMenu", "search");
        int lastPage = this.playerDataConfig.getInt("admin." + uuid + ".lastPage", 0);
        String lastTarget = this.playerDataConfig.getString("admin." + uuid + ".lastTarget");
        this.playerSearchGUI.setLastOpenedMenu(uuid, lastMenu);
        this.playerSearchGUI.setLastPage(uuid, lastPage);
        this.playerSearchGUI.setLastTarget(uuid, lastTarget);
    }

    public void savePlayerMenuState(Player player) {
        if (player == null || !player.isOnline() || !player.hasPermission("playermanager.admin") && !player.hasPermission("playermanager.gui")) {
            return;
        }
        UUID uuid = player.getUniqueId();
        String lastMenu = this.playerSearchGUI.getLastOpenedMenu(uuid);
        int lastPage = this.playerSearchGUI.getLastPage(uuid);
        String lastTarget = this.playerSearchGUI.getLastTarget(uuid);
        boolean needsSave = false;
        String currentLastMenu = this.playerDataConfig.getString("admin." + uuid + ".lastOpenedMenu");
        int currentLastPage = this.playerDataConfig.getInt("admin." + uuid + ".lastPage", -1);
        String currentLastTarget = this.playerDataConfig.getString("admin." + uuid + ".lastTarget");
        if (!Objects.equals(currentLastMenu, lastMenu) || currentLastPage != lastPage || !Objects.equals(currentLastTarget, lastTarget)) {
            this.playerDataConfig.set("admin." + uuid + ".lastOpenedMenu", (Object)lastMenu);
            this.playerDataConfig.set("admin." + uuid + ".lastPage", (Object)lastPage);
            this.playerDataConfig.set("admin." + uuid + ".lastTarget", (Object)lastTarget);
            needsSave = true;
        }
        if (needsSave) {
            this.savePlayerDataConfig();
        }
    }

    private void saveAllPlayerMenuStates() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.savePlayerMenuState(player);
        }
    }

    private void updatePlayerDataOnJoin(Player player) {
        String uuidStr = player.getUniqueId().toString();
        String path = "players." + uuidStr + ".";
        boolean needsSave = false;
        boolean isAdmin = this.isAdminPlayer(player);
        boolean storedAdmin = this.playerDataConfig.getBoolean(path + "isAdmin", false);
        if (storedAdmin != isAdmin) {
            this.playerDataConfig.set(path + "isAdmin", (Object)isAdmin);
            needsSave = true;
        }
        if (!this.playerDataConfig.contains(path + "first_played")) {
            this.playerDataConfig.set(path + "first_played", (Object)player.getFirstPlayed());
            needsSave = true;
        }
        this.playerDataConfig.set(path + "last_login", (Object)System.currentTimeMillis());
        this.playerDataConfig.set(path + "name", (Object)player.getName());
        this.playerDataConfig.set(path + "ip", (Object)player.getAddress().getAddress().getHostAddress());
        boolean storedBanned = this.playerDataConfig.getBoolean(path + "banned", false);
        boolean isBanned = player.isBanned();
        if (storedBanned != isBanned) {
            this.playerDataConfig.set(path + "banned", (Object)isBanned);
            needsSave = true;
        }
        String storedName = this.playerDataConfig.getString(path + "name", "");
        if (!player.getName().equals(storedName)) {
            this.playerDataConfig.set(path + "name", (Object)player.getName());
            needsSave = true;
        }
        if (needsSave) {
            this.savePlayerDataConfig();
        }
        if (this.latestVersion != null && (player.hasPermission("playermanager.admin") || player.hasPermission("playermanager.updates")) && !this.notifiedAdmins.contains(player.getUniqueId())) {
            String playerMessage = ChatColor.YELLOW + "" + ChatColor.BOLD + this.getMessage("update.available", "A new version of PlayerManager (%version%) is available at https://modrinth.com/plugin/playermanagers/versions").replace("%version%", this.latestVersion);
            this.notifiedAdmins.add(player.getUniqueId());
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> player.sendMessage(playerMessage), 20L);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.updatePlayerDataOnJoin(event.getPlayer());
        this.loadPlayerMenuState(event.getPlayer());
        String name = event.getPlayer().getName().toLowerCase();
        if (!this.cachedPlayerNames.contains(name)) {
            this.cachedPlayerNames.add(name);
            this.cachedPlayerNames.sort(String.CASE_INSENSITIVE_ORDER);
            this.getLogger().info("Added " + name + " to player name cache");
        }
        if (this.isAdminPlayer(event.getPlayer())) {
            this.adminUUIDs.add(event.getPlayer().getUniqueId().toString());
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        String uuidStr = player.getUniqueId().toString();
        String path = "players." + uuidStr + ".";
        long currentTime = System.currentTimeMillis();
        this.playerDataConfig.set(path + "last_logout", (Object)currentTime);
        this.playerDataConfig.set(path + "name", (Object)player.getName());
        this.savePlayerMenuState(player);
        try {
            this.playerDataConfig.save(this.playerDataFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Failed to save player_data.yml for " + player.getName() + ": " + e.getMessage());
            e.printStackTrace();
        }
        if (!this.isAdminPlayer(player)) {
            this.adminUUIDs.remove(uuidStr);
        }
    }

    @EventHandler
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        if (event.getMessage().toLowerCase().startsWith("/playermanager reset")) {
            if (!(event.getPlayer().hasPermission("playermanager.admin") || event.getPlayer().hasPermission("playermanager.gui") || event.getPlayer().hasPermission("playermanager.reset"))) {
                event.getPlayer().sendMessage(ChatColor.RED + this.getMessage("error.no-permission", "You don't have permission!"));
                event.setCancelled(true);
                return;
            }
            this.playerSearchGUI.resetSearch(event.getPlayer());
            event.setCancelled(true);
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("playermanager.admin") && !this.hasAnyPermission(sender)) {
            sender.sendMessage(ChatColor.RED + this.getMessage("error.no-permission", "You don't have permission!"));
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + this.getMessage("error.player-only", "This command is for players only!"));
            return true;
        }
        Player admin = (Player)sender;
        if (args.length == 0) {
            sender.sendMessage(ChatColor.RED + this.getMessage("command.usage", "Usage: /playermanager <gui | reload | reset | ban | kick | warn | mute | unban | teleport | inventory>"));
            return true;
        }
        String action = args[0].toLowerCase();
        if (action.equals("gui")) {
            if (!sender.hasPermission("playermanager.admin") && !sender.hasPermission("playermanager.gui")) {
                sender.sendMessage(ChatColor.RED + this.getMessage("error.no-permission", "You don't have permission!"));
                return true;
            }
            if (args.length != 1) {
                sender.sendMessage(ChatColor.RED + this.getMessage("command.usage-gui", "Usage: /playermanager gui"));
                return true;
            }
            this.playerSearchGUI.openLastGUIMenu(admin);
            return true;
        }
        if (action.equals("reload")) {
            if (!sender.hasPermission("playermanager.admin") && !sender.hasPermission("playermanager.reload")) {
                sender.sendMessage(ChatColor.RED + this.getMessage("error.no-permission", "You don't have permission!"));
                return true;
            }
            if (args.length != 1) {
                sender.sendMessage(ChatColor.RED + this.getMessage("command.usage-reload", "Usage: /playermanager reload"));
                return true;
            }
            this.reloadPlugin(admin);
            return true;
        }
        if (action.equals("reset")) {
            if (!(sender.hasPermission("playermanager.admin") || sender.hasPermission("playermanager.gui") || sender.hasPermission("playermanager.reset"))) {
                sender.sendMessage(ChatColor.RED + this.getMessage("error.no-permission", "You don't have permission!"));
                return true;
            }
            if (args.length != 1) {
                sender.sendMessage(ChatColor.RED + this.getMessage("command.usage", "Usage: /playermanager reset"));
                return true;
            }
            this.playerSearchGUI.resetSearch(admin);
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(ChatColor.RED + this.getMessage("command.usage", "Usage: /playermanager <gui | reload | reset | ban | kick | warn | mute | unban | teleport | inventory>"));
            return true;
        }
        String targetName = args[1];
        OfflinePlayer target = Arrays.stream(Bukkit.getOfflinePlayers()).filter(p -> p.getName() != null && p.getName().equalsIgnoreCase(targetName)).findFirst().orElse(null);
        if (target == null) {
            admin.sendMessage(ChatColor.RED + this.getMessage("error.no-player-data", "Player data is not available."));
            return true;
        }
        if (this.isAdminPlayer(target)) {
            admin.sendMessage(ChatColor.RED + this.getMessage("error.cannot-target-admin", "You cannot target another admin."));
            return true;
        }
        if (target.getUniqueId().equals(admin.getUniqueId())) {
            if (action.equals("teleport")) {
                admin.sendMessage(ChatColor.RED + this.getMessage("error.self-teleport", "You can't teleport to yourself."));
            } else if (Arrays.asList("ban", "kick", "warn", "mute", "unban").contains(action)) {
                admin.sendMessage(ChatColor.RED + this.getMessage("error.self-punish", "You can't punish yourself."));
            }
            return true;
        }
        if (!sender.hasPermission("playermanager.admin") && !sender.hasPermission("playermanager." + action)) {
            sender.sendMessage(ChatColor.RED + this.getMessage("error.no-permission", "You don't have permission!"));
            return true;
        }
        String path = "players." + target.getUniqueId().toString() + ".";
        boolean needsSave = false;
        switch (action) {
            case "ban": {
                if (!this.getConfig().getBoolean("features.punishment-system", true)) {
                    admin.sendMessage(ChatColor.RED + this.getMessage("error.punishment-system-disabled", "Punishment system is disabled!"));
                    return true;
                }
                if (this.playerDataConfig.getBoolean(path + "banned", false)) {
                    admin.sendMessage(ChatColor.RED + this.getMessage("error.already-banned", "This player is already banned!"));
                    return true;
                }
                String banReason = args.length > 2 ? String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length)) : "Banned by admin";
                Bukkit.dispatchCommand((CommandSender)admin, (String)("ban " + targetName + " " + banReason));
                if (!this.playerDataConfig.getBoolean(path + "banned", false)) {
                    this.playerDataConfig.set(path + "banned", (Object)true);
                    needsSave = true;
                }
                admin.sendMessage(ChatColor.YELLOW + this.getMessage("action.executed", "Executed: %command% for %player%").replace("%command%", "ban").replace("%player%", targetName));
                break;
            }
            case "kick": {
                if (!this.getConfig().getBoolean("features.punishment-system", true)) {
                    admin.sendMessage(ChatColor.RED + this.getMessage("error.punishment-system-disabled", "Punishment system is disabled!"));
                    return true;
                }
                Player onlinePlayer = Bukkit.getPlayer((String)targetName);
                if (onlinePlayer == null) {
                    admin.sendMessage(ChatColor.RED + this.getMessage("error.player-offline", "Player is offline."));
                    return true;
                }
                String kickReason = args.length > 2 ? String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length)) : "Kicked by admin";
                Bukkit.dispatchCommand((CommandSender)admin, (String)("kick " + targetName + " " + kickReason));
                admin.sendMessage(ChatColor.YELLOW + this.getMessage("action.executed", "Executed: %command% for %player%").replace("%command%", "kick").replace("%player%", targetName));
                break;
            }
            case "warn": {
                if (!this.getConfig().getBoolean("features.punishment-system", true)) {
                    admin.sendMessage(ChatColor.RED + this.getMessage("error.punishment-system-disabled", "Punishment system is disabled!"));
                    return true;
                }
                Player onlinePlayer = Bukkit.getPlayer((String)targetName);
                if (onlinePlayer == null) {
                    admin.sendMessage(ChatColor.RED + this.getMessage("error.player-offline", "Player is offline."));
                    return true;
                }
                String warnReason = args.length > 2 ? String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length)) : "Warned by admin";
                Bukkit.dispatchCommand((CommandSender)admin, (String)("warn " + targetName + " " + warnReason));
                admin.sendMessage(ChatColor.YELLOW + this.getMessage("action.executed", "Executed: %command% for %player%").replace("%command%", "warn").replace("%player%", targetName));
                break;
            }
            case "mute": {
                if (!this.getConfig().getBoolean("features.punishment-system", true)) {
                    admin.sendMessage(ChatColor.RED + this.getMessage("error.punishment-system-disabled", "Punishment system is disabled!"));
                    return true;
                }
                Player onlinePlayer = Bukkit.getPlayer((String)targetName);
                if (onlinePlayer == null) {
                    admin.sendMessage(ChatColor.RED + this.getMessage("error.player-offline", "Player is offline."));
                    return true;
                }
                String muteReason = args.length > 2 ? String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length)) : "Muted by admin";
                Bukkit.dispatchCommand((CommandSender)admin, (String)("mute " + targetName + " " + muteReason));
                admin.sendMessage(ChatColor.YELLOW + this.getMessage("action.executed", "Executed: %command% for %player%").replace("%command%", "mute").replace("%player%", targetName));
                break;
            }
            case "unban": {
                if (!this.getConfig().getBoolean("features.punishment-system", true)) {
                    admin.sendMessage(ChatColor.RED + this.getMessage("error.punishment-system-disabled", "Punishment system is disabled!"));
                    return true;
                }
                if (!this.playerDataConfig.getBoolean(path + "banned", false)) {
                    admin.sendMessage(ChatColor.RED + this.getMessage("error.not-banned", "This player is not banned!"));
                    return true;
                }
                Bukkit.dispatchCommand((CommandSender)admin, (String)("pardon " + targetName));
                if (this.playerDataConfig.getBoolean(path + "banned", false)) {
                    this.playerDataConfig.set(path + "banned", (Object)false);
                    needsSave = true;
                }
                admin.sendMessage(ChatColor.YELLOW + this.getMessage("action.executed", "Executed: %command% for %player%").replace("%command%", "unban").replace("%player%", targetName));
                break;
            }
            case "teleport": {
                if (!this.getConfig().getBoolean("features.player-teleportation", true)) {
                    admin.sendMessage(ChatColor.RED + this.getMessage("error.teleportation-disabled", "Teleportation is disabled!"));
                    return true;
                }
                Player targetPlayer = Bukkit.getPlayer((String)targetName);
                if (targetPlayer == null) {
                    admin.sendMessage(ChatColor.RED + this.getMessage("error.player-offline", "Player is offline."));
                    return true;
                }
                admin.teleport((Entity)targetPlayer);
                admin.sendMessage(ChatColor.GREEN + this.getMessage("action.teleported", "Teleported to %player%").replace("%player%", targetName));
                break;
            }
            case "inventory": {
                if (!this.getConfig().getBoolean("features.inventory-inspection", true)) {
                    admin.sendMessage(ChatColor.RED + this.getMessage("error.inventory-inspection-disabled", "Inventory inspection is disabled!"));
                    return true;
                }
                Player targetInvPlayer = Bukkit.getPlayer((String)targetName);
                if (targetInvPlayer == null) {
                    admin.sendMessage(ChatColor.RED + this.getMessage("error.player-offline-inventory", "Player is offline, inventory modification is impossible."));
                    return true;
                }
                admin.openInventory((Inventory)targetInvPlayer.getInventory());
                break;
            }
            default: {
                sender.sendMessage(ChatColor.RED + this.getMessage("command.usage", "Usage: /playermanager <gui | reload | reset | ban | kick | warn | mute | unban | teleport | inventory>"));
                return true;
            }
        }
        if (needsSave) {
            this.savePlayerDataConfig();
        }
        this.playerSearchGUI.refreshOpenGUIs();
        return true;
    }

    private void reloadPlugin(Player player) {
        this.reloadConfig();
        this.language = this.getConfig().getString("language", "en");
        if (!Arrays.asList(SUPPORTED_LANGUAGES).contains(this.language)) {
            this.getLogger().warning("Unsupported language '" + this.language + "' in config.yml, defaulting to 'en'");
            this.language = "en";
        }
        this.updateConfigFile();
        this.updateMessagesFiles();
        this.loadMessages();
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.loadPlayerMenuState(p);
        }
        player.sendMessage(ChatColor.GREEN + this.getMessage("action.config-reloaded", "Configuration reloaded."));
        this.playerSearchGUI.refreshOpenGUIs();
    }

    public FileConfiguration getPlayerDataConfig() {
        return this.playerDataConfig;
    }

    public void savePlayerDataConfig() {
        try {
            this.playerDataConfig.save(this.playerDataFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Failed to save player_data.yml at " + this.playerDataFile.getAbsolutePath() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public void updatePlayerBanStatus(String uuid, boolean banned) {
        String path = "players." + uuid + ".banned";
        this.playerDataConfig.set(path, (Object)banned);
        this.savePlayerDataConfig();
    }
}

