/*
 * Decompiled with CFR 0.152.
 */
package ru.stepanyaa.playerManager;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import ru.stepanyaa.playerManager.PlayerManager;
import ru.stepanyaa.playerManager.PlayerSearchGUI;

public class PlayerManagerIpGUI
implements InventoryHolder,
Listener {
    private final PlayerManager plugin;
    private final Inventory inventory;
    private final Map<Integer, IPResult> slotMap = new HashMap<Integer, IPResult>();
    private final Set<UUID> playersInGUI = new HashSet<UUID>();
    private final Map<UUID, String> lastOpenedMenu = new HashMap<UUID, String>();
    private final Map<UUID, String> lastTarget = new HashMap<UUID, String>();
    private final PlayerSearchGUI searchGUI;
    private List<IPResult> cachedIPResults = new ArrayList<IPResult>();
    private final Map<String, List<PlayerSearchGUI.PlayerResult>> cachedSearchByIPResults = new HashMap<String, List<PlayerSearchGUI.PlayerResult>>();
    private int currentPage = 0;
    private final Map<UUID, Integer> lastPage = new HashMap<UUID, Integer>();
    private final Map<UUID, List<String>> pendingBanAllUsers = new HashMap<UUID, List<String>>();

    public PlayerManagerIpGUI(PlayerManager plugin, PlayerSearchGUI searchGUI) {
        this.plugin = plugin;
        this.searchGUI = searchGUI;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)(ChatColor.DARK_GRAY + plugin.getMessage("gui.ip-search-title", "IP Search")));
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void openIPSearchGUI(Player player) {
        if (!player.hasPermission("playermanager.ip-search")) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission!"));
            return;
        }
        if (!player.isOnline()) {
            return;
        }
        if (!this.plugin.getConfig().getBoolean("features.ip-search", true)) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.ip-search-disabled", "IP search is disabled in config!"));
            return;
        }
        ItemStack loadingItem = new ItemStack(Material.REDSTONE);
        ItemMeta loadingMeta = loadingItem.getItemMeta();
        if (loadingMeta != null) {
            loadingMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("gui.loading", "Loading..."));
            loadingItem.setItemMeta(loadingMeta);
        }
        this.inventory.clear();
        this.inventory.setItem(4, loadingItem);
        player.openInventory(this.inventory);
        this.playersInGUI.add(player.getUniqueId());
        this.setLastOpenedMenu(player.getUniqueId(), "ip_search");
        this.plugin.savePlayerMenuState(player);
        if (!this.cachedIPResults.isEmpty()) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                if (player.isOnline() && this.playersInGUI.contains(player.getUniqueId())) {
                    this.setupIPSearchGUI(player, this.cachedIPResults);
                    player.updateInventory();
                }
            });
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                long startTime = System.currentTimeMillis();
                List<IPResult> ipResults = this.getIPResults();
                this.cachedIPResults = ipResults;
                if (ipResults.isEmpty()) {
                    this.plugin.getLogger().warning("No IP results found for IP search GUI");
                }
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (player.isOnline() && this.playersInGUI.contains(player.getUniqueId())) {
                        this.setupIPSearchGUI(player, ipResults);
                        player.updateInventory();
                    } else {
                        this.plugin.getLogger().warning("Player " + player.getName() + " went offline before IP search GUI setup");
                    }
                });
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to load IP results for " + player.getName() + ": " + e.getMessage());
                e.printStackTrace();
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (player.isOnline()) {
                        player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.loading-failed", "Failed to load IP search data."));
                        player.closeInventory();
                    }
                });
            }
        });
    }

    private List<IPResult> getIPResults() {
        String ip;
        ArrayList<IPResult> ipResults = new ArrayList<IPResult>();
        ConfigurationSection playersSection = this.plugin.getPlayerDataConfig().getConfigurationSection("players");
        if (playersSection == null) {
            this.plugin.getLogger().warning("No players section found in player_data.yml");
            return ipResults;
        }
        HashMap<String, Integer> ipCount = new HashMap<String, Integer>();
        HashMap<String, Integer> bannedCount = new HashMap<String, Integer>();
        HashMap<String, Long> lastActivityMap = new HashMap<String, Long>();
        int totalPlayers = 0;
        long currentTime = System.currentTimeMillis();
        long maxInactivityDays = this.plugin.getConfig().getLong("max-inactivity-days", 30L);
        long maxInactivityMillis = maxInactivityDays * 24L * 60L * 60L * 1000L;
        for (String string : playersSection.getKeys(false)) {
            try {
                ip = this.plugin.getPlayerDataConfig().getString("players." + string + ".ip", "");
                if (ip == null || ip.trim().isEmpty() || ip.equals("Unknown")) {
                    this.plugin.getLogger().warning("Invalid or missing IP for UUID " + string);
                    continue;
                }
                String name = this.plugin.getPlayerDataConfig().getString("players." + string + ".name", "");
                long lastActivity = Math.max(this.plugin.getPlayerDataConfig().getLong("players." + string + ".last_login", 0L), this.plugin.getPlayerDataConfig().getLong("players." + string + ".last_logout", 0L));
                if (lastActivity > 0L && currentTime - lastActivity > maxInactivityMillis) continue;
                ++totalPlayers;
                boolean banned = Bukkit.getBanList((BanList.Type)BanList.Type.NAME).isBanned(name);
                this.plugin.updatePlayerBanStatus(string, banned);
                ipCount.put(ip, ipCount.getOrDefault(ip, 0) + 1);
                if (banned) {
                    bannedCount.put(ip, bannedCount.getOrDefault(ip, 0) + 1);
                }
                lastActivityMap.put(ip, Math.max(lastActivityMap.getOrDefault(ip, 0L), lastActivity));
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid UUID " + string + " in player_data.yml");
            }
        }
        for (Map.Entry entry : ipCount.entrySet()) {
            ip = (String)entry.getKey();
            IPResult ipResult = new IPResult();
            ipResult.ip = ip;
            ipResult.accountCount = (Integer)entry.getValue();
            ipResult.bannedPlayers = bannedCount.getOrDefault(ip, 0);
            ipResult.ipBanned = Bukkit.getBanList((BanList.Type)BanList.Type.IP).isBanned(ip);
            ipResult.lastActivity = lastActivityMap.getOrDefault(ip, 0L);
            ipResults.add(ipResult);
        }
        ipResults.sort(Comparator.comparing(r -> r.ip));
        return ipResults;
    }

    public void setupIPSearchGUI(Player player, List<IPResult> ipResults) {
        this.inventory.clear();
        this.slotMap.clear();
        ItemStack searchItem = new ItemStack(Material.COMPASS);
        ItemMeta searchMeta = searchItem.getItemMeta();
        if (searchMeta != null) {
            searchMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("gui.ip-search", "IP Search"));
            ArrayList<String> searchLore = new ArrayList<String>();
            searchLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.enter-ip", "Click to enter IP"));
            searchMeta.setLore(searchLore);
            searchItem.setItemMeta(searchMeta);
        }
        this.inventory.setItem(4, searchItem);
        int totalPages = (int)Math.ceil((double)ipResults.size() / 36.0);
        String pageInfo = this.plugin.getMessage("gui.page-info", "Page %current%/%total%").replace("%current%", String.valueOf(this.currentPage + 1)).replace("%total%", String.valueOf(totalPages));
        int start = this.currentPage * 36;
        int end = Math.min(start + 36, ipResults.size());
        for (int i = start; i < end; ++i) {
            IPResult result = ipResults.get(i);
            ItemStack item = new ItemStack(Material.PAPER);
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(ChatColor.YELLOW + result.ip);
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.accounts", "Accounts: %count%").replace("%count%", String.valueOf(result.accountCount)));
                lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.banned-accounts", "Banned Accounts: %count%").replace("%count%", String.valueOf(result.bannedPlayers)));
                lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.ip-banned", "IP Banned: %status%").replace("%status%", result.ipBanned ? "Yes" : "No"));
                lore.add(ChatColor.YELLOW + this.plugin.getMessage("gui.click-for-details", "Click for details"));
                meta.setLore(lore);
                item.setItemMeta(meta);
            }
            this.inventory.setItem(i - start + 9, item);
            this.slotMap.put(i - start + 9, result);
        }
        ItemStack closeItem = new ItemStack(Material.BARRIER);
        ItemMeta closeMeta = closeItem.getItemMeta();
        if (closeMeta != null) {
            closeMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.close", "Close"));
            closeItem.setItemMeta(closeMeta);
        }
        this.inventory.setItem(49, closeItem);
        if (this.currentPage > 0) {
            ItemStack prevPage = new ItemStack(Material.ARROW);
            ItemMeta prevMeta = prevPage.getItemMeta();
            if (prevMeta != null) {
                prevMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("gui.previous-page", "Previous page"));
                ArrayList<String> prevLore = new ArrayList<String>();
                prevLore.add(ChatColor.GRAY + pageInfo);
                prevMeta.setLore(prevLore);
                prevPage.setItemMeta(prevMeta);
            }
            this.inventory.setItem(45, prevPage);
        } else {
            ItemStack noPrev = new ItemStack(Material.RED_STAINED_GLASS_PANE);
            ItemMeta noPrevMeta = noPrev.getItemMeta();
            if (noPrevMeta != null) {
                noPrevMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.no-page", "No page"));
                ArrayList<String> noPrevLore = new ArrayList<String>();
                noPrevLore.add(ChatColor.GRAY + pageInfo);
                noPrevMeta.setLore(noPrevLore);
                noPrev.setItemMeta(noPrevMeta);
            }
            this.inventory.setItem(45, noPrev);
        }
        if ((this.currentPage + 1) * 36 < ipResults.size()) {
            ItemStack nextPage = new ItemStack(Material.ARROW);
            ItemMeta nextMeta = nextPage.getItemMeta();
            if (nextMeta != null) {
                nextMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("gui.next-page", "Next page"));
                ArrayList<String> nextLore = new ArrayList<String>();
                nextLore.add(ChatColor.GRAY + pageInfo);
                nextMeta.setLore(nextLore);
                nextPage.setItemMeta(nextMeta);
            }
            this.inventory.setItem(53, nextPage);
        } else {
            ItemStack noNext = new ItemStack(Material.RED_STAINED_GLASS_PANE);
            ItemMeta noNextMeta = noNext.getItemMeta();
            if (noNextMeta != null) {
                noNextMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.no-page", "No page"));
                ArrayList<String> noNextLore = new ArrayList<String>();
                noNextLore.add(ChatColor.GRAY + pageInfo);
                noNextMeta.setLore(noNextLore);
                noNext.setItemMeta(noNextMeta);
            }
            this.inventory.setItem(53, noNext);
        }
        player.updateInventory();
    }

    public void openSearchGUIByIP(Player player, String ip) {
        if (!player.hasPermission("playermanager.ip-search")) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission!"));
            return;
        }
        ItemStack loadingItem = new ItemStack(Material.REDSTONE);
        ItemMeta loadingMeta = loadingItem.getItemMeta();
        if (loadingMeta != null) {
            loadingMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("gui.loading", "Loading..."));
            loadingItem.setItemMeta(loadingMeta);
        }
        this.inventory.clear();
        this.inventory.setItem(4, loadingItem);
        player.openInventory(this.inventory);
        this.setLastOpenedMenu(player.getUniqueId(), "ip_search");
        List<PlayerSearchGUI.PlayerResult> cachedResults = this.cachedSearchByIPResults.get(ip);
        if (cachedResults != null && !cachedResults.isEmpty()) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                if (player.isOnline() && this.playersInGUI.contains(player.getUniqueId())) {
                    this.searchGUI.setCurrentSearch("IP: " + ip);
                    this.searchGUI.setCurrentPage(0);
                    this.searchGUI.setLastPage(player.getUniqueId(), 0);
                    this.searchGUI.setCachedResults(cachedResults);
                    this.searchGUI.setupSearchGUI(player, cachedResults);
                    player.closeInventory();
                    player.openInventory(this.searchGUI.getInventory());
                    this.searchGUI.getPlayersInGUI().add(player.getUniqueId());
                    this.searchGUI.setLastOpenedMenu(player.getUniqueId(), "search");
                    player.updateInventory();
                }
            });
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                long startTime = System.currentTimeMillis();
                List<PlayerSearchGUI.PlayerResult> results = this.getSearchResultsByIP(ip);
                this.cachedSearchByIPResults.put(ip, results);
                if (results.isEmpty()) {
                    this.plugin.getLogger().warning("No accounts found for IP: " + ip);
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        if (player.isOnline()) {
                            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-accounts-for-ip", "No accounts found for IP: %ip%").replace("%ip%", ip));
                            this.openIPSearchGUI(player);
                        }
                    });
                    return;
                }
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (player.isOnline() && this.playersInGUI.contains(player.getUniqueId())) {
                        this.searchGUI.setCurrentSearch("IP: " + ip);
                        this.searchGUI.setCurrentPage(0);
                        this.searchGUI.setLastPage(player.getUniqueId(), 0);
                        this.searchGUI.setCachedResults(results);
                        this.searchGUI.setupSearchGUI(player, results);
                        player.closeInventory();
                        player.openInventory(this.searchGUI.getInventory());
                        this.searchGUI.getPlayersInGUI().add(player.getUniqueId());
                        this.searchGUI.setLastOpenedMenu(player.getUniqueId(), "search");
                        player.updateInventory();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (player.isOnline()) {
                        player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.loading-failed", "Failed to load IP search data."));
                        this.openIPSearchGUI(player);
                    }
                });
            }
        });
    }

    private List<PlayerSearchGUI.PlayerResult> getSearchResultsByIP(String ip) {
        ArrayList<PlayerSearchGUI.PlayerResult> results = new ArrayList<PlayerSearchGUI.PlayerResult>();
        ConfigurationSection playersSection = this.plugin.getPlayerDataConfig().getConfigurationSection("players");
        if (playersSection == null) {
            this.plugin.getLogger().warning("No players section found in player_data.yml for IP search: " + ip);
            return results;
        }
        long currentTime = System.currentTimeMillis();
        long maxInactivityDays = this.plugin.getConfig().getLong("max-inactivity-days", 30L);
        long maxInactivityMillis = maxInactivityDays * 24L * 60L * 60L * 1000L;
        for (String uuid : playersSection.getKeys(false)) {
            try {
                if (!ip.equals(this.plugin.getPlayerDataConfig().getString("players." + uuid + ".ip", ""))) continue;
                String name = this.plugin.getPlayerDataConfig().getString("players." + uuid + ".name", "");
                long lastActivity = Math.max(this.plugin.getPlayerDataConfig().getLong("players." + uuid + ".last_login", 0L), this.plugin.getPlayerDataConfig().getLong("players." + uuid + ".last_logout", 0L));
                if (lastActivity > 0L && currentTime - lastActivity > maxInactivityMillis || name.isEmpty()) continue;
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(uuid));
                String path = "players." + uuid + ".";
                PlayerSearchGUI.PlayerResult result = new PlayerSearchGUI.PlayerResult();
                result.uuid = uuid;
                result.name = name;
                result.firstPlayed = this.plugin.getPlayerDataConfig().getLong(path + "first_played", offlinePlayer.getFirstPlayed());
                result.lastLogin = this.plugin.getPlayerDataConfig().getLong(path + "last_login", offlinePlayer.getLastPlayed());
                result.lastLogout = this.plugin.getPlayerDataConfig().getLong(path + "last_logout", offlinePlayer.getLastPlayed());
                result.online = offlinePlayer.isOnline();
                result.banned = Bukkit.getBanList((BanList.Type)BanList.Type.NAME).isBanned(name);
                this.plugin.updatePlayerBanStatus(uuid, result.banned);
                result.headTexture = this.plugin.getPlayerDataConfig().getString(path + "head_texture", "");
                results.add(result);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        results.sort(Comparator.comparing(r -> r.name.toLowerCase(), String.CASE_INSENSITIVE_ORDER));
        return results;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!(event.getInventory().getHolder() instanceof PlayerManagerIpGUI)) {
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        String currentMenu = this.lastOpenedMenu.getOrDefault(player.getUniqueId(), "ip_search");
        int slot = event.getSlot();
        if (currentMenu.equals("ip_search")) {
            if (slot == 4) {
                if (!player.hasPermission("playermanager.ip-search")) {
                    player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission!"));
                    return;
                }
                player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.enter-ip", "Enter IP address in chat"));
                this.plugin.getPlayerDataConfig().set("admin." + player.getUniqueId() + ".pending_action", (Object)"ip_search");
                this.plugin.savePlayerDataConfig();
                player.closeInventory();
                this.searchGUI.addPendingAction(player.getUniqueId(), (message, p) -> {
                    String ip = message.trim();
                    this.openSearchGUIByIP(p, ip);
                });
            } else if (slot >= 9 && slot < 45) {
                IPResult result = this.slotMap.get(slot);
                if (result != null) {
                    this.setLastTarget(player.getUniqueId(), result.ip);
                    this.openIPDetails(player, result);
                }
            } else if (slot == 45 && this.currentPage > 0) {
                --this.currentPage;
                this.setupIPSearchGUI(player, this.cachedIPResults);
                player.updateInventory();
            } else if (slot == 53 && (this.currentPage + 1) * 36 < this.cachedIPResults.size()) {
                ++this.currentPage;
                this.setupIPSearchGUI(player, this.cachedIPResults);
                player.updateInventory();
            } else if (slot == 49) {
                player.closeInventory();
                this.playersInGUI.remove(player.getUniqueId());
                this.searchGUI.openSearchGUI(player);
            }
        } else if (currentMenu.equals("ip_details")) {
            this.handleIPDetailsClick(player, slot, event);
        } else if (currentMenu.equals("ban_all_confirm")) {
            this.handleBanAllConfirmClick(player, slot, event);
        }
    }

    public void openIPDetails(Player player, IPResult ipResult) {
        this.inventory.clear();
        this.slotMap.clear();
        this.setLastOpenedMenu(player.getUniqueId(), "ip_details");
        ItemStack banIpItem = new ItemStack(Material.REDSTONE_BLOCK);
        ItemMeta banIpMeta = banIpItem.getItemMeta();
        if (banIpMeta != null) {
            banIpMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.ban-ip", "Ban IP"));
            ArrayList<String> banIpLore = new ArrayList<String>();
            banIpLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.ban-ip-hint", "Click to ban this IP"));
            banIpMeta.setLore(banIpLore);
            banIpItem.setItemMeta(banIpMeta);
        }
        this.inventory.setItem(10, banIpItem);
        ItemStack banUsersItem = new ItemStack(Material.DIAMOND_SWORD);
        ItemMeta banUsersMeta = banUsersItem.getItemMeta();
        if (banUsersMeta != null) {
            banUsersMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.ban-users", "Ban All Users"));
            ArrayList<String> banUsersLore = new ArrayList<String>();
            banUsersLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.ban-users-hint", "Click to ban all non-admin users on this IP"));
            banUsersMeta.setLore(banUsersLore);
            banUsersItem.setItemMeta(banUsersMeta);
        }
        this.inventory.setItem(12, banUsersItem);
        ItemStack unbanUsersItem = new ItemStack(Material.EMERALD);
        ItemMeta unbanUsersMeta = unbanUsersItem.getItemMeta();
        if (unbanUsersMeta != null) {
            unbanUsersMeta.setDisplayName(ChatColor.GREEN + this.plugin.getMessage("gui.unban-users", "Unban All Users"));
            ArrayList<String> unbanUsersLore = new ArrayList<String>();
            unbanUsersLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.unban-users-hint", "Click to unban all users on this IP"));
            unbanUsersMeta.setLore(unbanUsersLore);
            unbanUsersItem.setItemMeta(unbanUsersMeta);
        }
        this.inventory.setItem(16, unbanUsersItem);
        ItemStack showUsersItem = new ItemStack(Material.BOOK);
        ItemMeta showUsersMeta = showUsersItem.getItemMeta();
        if (showUsersMeta != null) {
            showUsersMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("gui.show-users", "Show All Users"));
            ArrayList<String> showUsersLore = new ArrayList<String>();
            showUsersLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.show-users-hint", "Click to view all users on this IP"));
            showUsersMeta.setLore(showUsersLore);
            showUsersItem.setItemMeta(showUsersMeta);
        }
        this.inventory.setItem(14, showUsersItem);
        ItemStack backItem = new ItemStack(Material.ARROW);
        ItemMeta backMeta = backItem.getItemMeta();
        if (backMeta != null) {
            backMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("gui.back", "Back"));
            backItem.setItemMeta(backMeta);
        }
        this.inventory.setItem(22, backItem);
        ItemStack infoItem = new ItemStack(Material.PAPER);
        ItemMeta infoMeta = infoItem.getItemMeta();
        if (infoMeta != null) {
            infoMeta.setDisplayName(ChatColor.YELLOW + ipResult.ip);
            ArrayList<String> infoLore = new ArrayList<String>();
            infoLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.accounts", "Accounts: %count%").replace("%count%", String.valueOf(ipResult.accountCount)));
            infoLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.banned-accounts", "Banned Accounts: %count%").replace("%count%", String.valueOf(ipResult.bannedPlayers)));
            infoLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.ip-banned", "IP Banned: %status%").replace("%status%", ipResult.ipBanned ? "Yes" : "No"));
            infoMeta.setLore(infoLore);
            infoItem.setItemMeta(infoMeta);
        }
        this.inventory.setItem(4, infoItem);
        player.updateInventory();
    }

    public void handleIPDetailsClick(Player player, int slot, InventoryClickEvent event) {
        if (!player.hasPermission("playermanager.ip-search")) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission!"));
            event.setCancelled(true);
            return;
        }
        String ip = this.lastTarget.get(player.getUniqueId());
        if (ip == null) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-ip", "No IP selected!"));
            event.setCancelled(true);
            return;
        }
        if (slot == 22) {
            this.openIPSearchGUI(player);
            event.setCancelled(true);
            return;
        }
        if (!this.plugin.getConfig().getBoolean("features.punishment-system", true)) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.punishment-system-disabled", "Punishment system is disabled!"));
            event.setCancelled(true);
            return;
        }
        try {
            if (slot == 10) {
                if (!player.hasPermission("playermanager.ban")) {
                    player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission!"));
                    return;
                }
                Bukkit.dispatchCommand((CommandSender)player, (String)("ban-ip " + ip));
                player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.ban-ip", "Banned IP: %ip%").replace("%ip%", ip));
                this.cachedSearchByIPResults.remove(ip);
                this.openIPSearchGUI(player);
                event.setCancelled(true);
            } else if (slot == 12) {
                if (!player.hasPermission("playermanager.ban")) {
                    player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission!"));
                    return;
                }
                List<String> users = this.getUsersByIP(ip);
                if (users.isEmpty()) {
                    player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-users", "No users found on this IP."));
                    return;
                }
                this.openBanAllUsersConfirmGUI(player, ip, users);
                event.setCancelled(true);
            } else if (slot == 16) {
                if (!player.hasPermission("playermanager.ban")) {
                    player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission!"));
                    return;
                }
                List<String> users = this.getUsersByIP(ip);
                int unbannedCount = 0;
                for (String user : users) {
                    OfflinePlayer offline = Bukkit.getOfflinePlayer((String)user);
                    if (offline == null || !this.plugin.getPlayerDataConfig().getBoolean("players." + offline.getUniqueId() + ".banned", false)) continue;
                    Bukkit.dispatchCommand((CommandSender)player, (String)("pardon " + user));
                    this.plugin.updatePlayerBanStatus(offline.getUniqueId().toString(), false);
                    ++unbannedCount;
                }
                player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.unban-users", "Unbanned %count% users on IP: %ip%").replace("%count%", String.valueOf(unbannedCount)).replace("%ip%", ip));
                this.cachedSearchByIPResults.remove(ip);
                this.openIPSearchGUI(player);
                event.setCancelled(true);
            } else if (slot == 14) {
                this.openSearchGUIByIP(player, ip);
                event.setCancelled(true);
            }
        }
        catch (Exception e) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.command-failed", "Failed to execute command: %error%").replace("%error%", e.getMessage()));
            this.plugin.getLogger().warning("Error in handleIPDetailsClick for IP " + ip + ": " + e.getMessage());
            event.setCancelled(true);
        }
    }

    private List<String> getUsersByIP(String ip) {
        ArrayList<String> users = new ArrayList<String>();
        ConfigurationSection playersSection = this.plugin.getPlayerDataConfig().getConfigurationSection("players");
        if (playersSection == null) {
            return users;
        }
        for (String uuid : playersSection.getKeys(false)) {
            String name;
            if (!ip.equals(this.plugin.getPlayerDataConfig().getString("players." + uuid + ".ip", "")) || (name = this.plugin.getPlayerDataConfig().getString("players." + uuid + ".name", "")).isEmpty()) continue;
            users.add(name);
        }
        return users;
    }

    public void openBanAllUsersConfirmGUI(Player player, String ip, List<String> users) {
        if (!player.hasPermission("playermanager.ban")) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission!"));
            return;
        }
        if (users.isEmpty()) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-users", "No users found on this IP."));
            return;
        }
        Inventory confirmInventory = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)(ChatColor.DARK_RED + this.plugin.getMessage("gui.confirm-ban-all-title", "Confirm Ban All Users on IP: ") + ChatColor.YELLOW + ip));
        this.setLastOpenedMenu(player.getUniqueId(), "ban_all_confirm");
        this.setLastTarget(player.getUniqueId(), ip);
        this.pendingBanAllUsers.put(player.getUniqueId(), new ArrayList<String>(users));
        this.plugin.savePlayerMenuState(player);
        ItemStack infoItem = new ItemStack(Material.PAPER);
        ItemMeta infoMeta = infoItem.getItemMeta();
        if (infoMeta != null) {
            infoMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("gui.confirm-info", "Users to ban (%count%):").replace("%count%", String.valueOf(users.size())));
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(ChatColor.GRAY + "Users:");
            for (int i = 0; i < Math.min(10, users.size()); ++i) {
                lore.add(ChatColor.WHITE + users.get(i));
            }
            if (users.size() > 10) {
                lore.add(ChatColor.GRAY + "... and " + (users.size() - 10) + " more");
            }
            lore.add("");
            lore.add(ChatColor.RED + this.plugin.getMessage("gui.confirm-warning", "This will ban ALL users on this IP!"));
            infoMeta.setLore(lore);
            infoItem.setItemMeta(infoMeta);
        }
        confirmInventory.setItem(4, infoItem);
        ItemStack confirmItem = new ItemStack(Material.REDSTONE_BLOCK);
        ItemMeta confirmMeta = confirmItem.getItemMeta();
        if (confirmMeta != null) {
            confirmMeta.setDisplayName(ChatColor.GREEN + this.plugin.getMessage("gui.confirm", "Confirm Ban All"));
            ArrayList<String> confirmLore = new ArrayList<String>();
            confirmLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.click-to-confirm", "Click to confirm"));
            confirmMeta.setLore(confirmLore);
            confirmItem.setItemMeta(confirmMeta);
        }
        confirmInventory.setItem(12, confirmItem);
        ItemStack cancelItem = new ItemStack(Material.EMERALD);
        ItemMeta cancelMeta = cancelItem.getItemMeta();
        if (cancelMeta != null) {
            cancelMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.cancel", "Cancel"));
            ArrayList<String> cancelLore = new ArrayList<String>();
            cancelLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.click-to-cancel", "Click to cancel"));
            cancelMeta.setLore(cancelLore);
            cancelItem.setItemMeta(cancelMeta);
        }
        confirmInventory.setItem(14, cancelItem);
        ItemStack backItem = new ItemStack(Material.ARROW);
        ItemMeta backMeta = backItem.getItemMeta();
        if (backMeta != null) {
            backMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("gui.back", "Back"));
            backItem.setItemMeta(backMeta);
        }
        confirmInventory.setItem(22, backItem);
        this.playersInGUI.add(player.getUniqueId());
        player.openInventory(confirmInventory);
        player.updateInventory();
    }

    private void handleBanAllConfirmClick(Player player, int slot, InventoryClickEvent event) {
        if (!player.hasPermission("playermanager.ban")) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission!"));
            event.setCancelled(true);
            return;
        }
        List<String> users = this.pendingBanAllUsers.get(player.getUniqueId());
        String ip = this.lastTarget.get(player.getUniqueId());
        if (users == null || users.isEmpty() || ip == null) {
            this.plugin.getLogger().warning("Invalid session for player " + player.getName() + ": users=" + (users == null ? "null" : Integer.valueOf(users.size())) + ", ip=" + ip);
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-session", "Invalid confirmation session."));
            event.setCancelled(true);
            player.closeInventory();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.openIPSearchGUI(player));
            return;
        }
        event.setCancelled(true);
        if (slot == 12) {
            int bannedCount = 0;
            for (String user : users) {
                OfflinePlayer offline = Bukkit.getOfflinePlayer((String)user);
                if (offline == null || this.plugin.getPlayerDataConfig().getBoolean("players." + offline.getUniqueId() + ".banned", false) || this.plugin.isAdminPlayer(offline)) continue;
                Bukkit.dispatchCommand((CommandSender)player, (String)("ban " + user));
                this.plugin.updatePlayerBanStatus(offline.getUniqueId().toString(), true);
                ++bannedCount;
            }
            player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.ban-users", "Banned %count% users on IP: %ip%").replace("%count%", String.valueOf(bannedCount)).replace("%ip%", ip));
            this.cachedSearchByIPResults.remove(ip);
            this.pendingBanAllUsers.remove(player.getUniqueId());
            player.closeInventory();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.openIPSearchGUI(player));
        } else if (slot == 14) {
            player.sendMessage(ChatColor.GREEN + this.plugin.getMessage("action.cancelled", "Action cancelled."));
            this.pendingBanAllUsers.remove(player.getUniqueId());
            IPResult ipResult = this.getIPResultByIP(ip);
            player.closeInventory();
            if (ipResult != null) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.openIPDetails(player, ipResult));
            } else {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-ip", "IP data not found."));
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.openIPSearchGUI(player));
            }
        } else if (slot == 22) {
            this.pendingBanAllUsers.remove(player.getUniqueId());
            IPResult ipResult = this.getIPResultByIP(ip);
            player.closeInventory();
            if (ipResult != null) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.openIPDetails(player, ipResult));
            } else {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-ip", "IP data not found."));
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.openIPSearchGUI(player));
            }
        }
    }

    private void setLastOpenedMenu(UUID playerUUID, String menu) {
        this.lastOpenedMenu.put(playerUUID, menu);
    }

    public void setLastTarget(UUID playerUUID, String target) {
        this.lastTarget.put(playerUUID, target);
    }

    private String getLastTarget(UUID playerUUID) {
        return this.lastTarget.get(playerUUID);
    }

    public void setLastPage(UUID playerUUID, int page) {
        this.lastPage.put(playerUUID, page);
    }

    public Set<UUID> getPlayersInGUI() {
        return this.playersInGUI;
    }

    public void clearCache() {
        this.cachedIPResults.clear();
        this.cachedSearchByIPResults.clear();
    }

    private IPResult getIPResultByIP(String ip) {
        IPResult result = this.cachedIPResults.stream().filter(r -> r.ip.equals(ip)).findFirst().orElse(null);
        if (result == null) {
            // empty if block
        }
        return result;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public static class IPResult {
        public String ip;
        public int accountCount;
        public int bannedPlayers;
        public boolean ipBanned;
        public long lastActivity;
    }
}

