/*
 * Decompiled with CFR 0.152.
 */
package ru.stepanyaa.playerManager;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import ru.stepanyaa.playerManager.PlayerManager;
import ru.stepanyaa.playerManager.PlayerManagerIpGUI;

public class PlayerSearchGUI
implements Listener,
InventoryHolder {
    private final PlayerManager plugin;
    private final PlayerManagerIpGUI ipGUI;
    private Inventory inventory;
    private final Map<Integer, PlayerResult> slotMap = new ConcurrentHashMap<Integer, PlayerResult>();
    private int currentPage = 0;
    private String currentSearch = "";
    private Filter currentFilter;
    private final Map<UUID, PlayerResult> playerMenuTargets;
    private final SimpleDateFormat dateFormat;
    private final Set<UUID> playersInGUI;
    private final Map<UUID, ChatAction> pendingActions;
    private final Map<UUID, String> lastOpenedMenu;
    private final Map<UUID, Integer> lastPage;
    private final Map<UUID, String> lastTarget;
    private final Map<UUID, Long> lastFilterClick = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Long> lastRefreshClick = new ConcurrentHashMap<UUID, Long>();
    private List<PlayerResult> cachedResults = new ArrayList<PlayerResult>();
    private List<PlayerResult> unfilteredResults = new ArrayList<PlayerResult>();
    private long lastTextureRequestTime = 100000L;
    private final Map<UUID, Long> lastPageChangeTime = new HashMap<UUID, Long>();

    public PlayerSearchGUI(PlayerManager plugin) {
        this.currentFilter = Filter.ALL;
        this.playerMenuTargets = new ConcurrentHashMap<UUID, PlayerResult>();
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.dateFormat.setTimeZone(TimeZone.getDefault() != null ? TimeZone.getDefault() : TimeZone.getTimeZone("UTC"));
        this.playersInGUI = Collections.newSetFromMap(new ConcurrentHashMap());
        this.pendingActions = new ConcurrentHashMap<UUID, ChatAction>();
        this.lastOpenedMenu = new ConcurrentHashMap<UUID, String>();
        this.lastPage = new ConcurrentHashMap<UUID, Integer>();
        this.lastTarget = new ConcurrentHashMap<UUID, String>();
        this.plugin = plugin;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)plugin.getMessage("gui.title", "Player Management"));
        this.ipGUI = new PlayerManagerIpGUI(plugin, this);
    }

    public void openLastGUIMenu(Player admin) {
        PlayerResult result;
        if (!admin.hasPermission("playermanager.admin") && !admin.hasPermission("playermanager.gui")) {
            admin.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission!"));
            return;
        }
        String lastMenu = this.lastOpenedMenu.getOrDefault(admin.getUniqueId(), "search");
        this.currentPage = this.lastPage.getOrDefault(admin.getUniqueId(), 0);
        String lastTargetName = this.lastTarget.get(admin.getUniqueId());
        if (lastMenu.equals("player") && lastTargetName != null) {
            PlayerResult result2 = this.getPlayerResultByName(lastTargetName);
            if (result2 != null) {
                this.openPlayerMenu(admin, result2);
                return;
            }
        } else if (lastMenu.equals("punishment") && lastTargetName != null) {
            PlayerResult result3 = this.getPlayerResultByName(lastTargetName);
            if (result3 != null) {
                this.openPunishmentGUI(admin, result3);
                return;
            }
        } else if (lastMenu.equals("player_info") && lastTargetName != null) {
            PlayerResult result4 = this.getPlayerResultByName(lastTargetName);
            if (result4 != null) {
                this.openPlayerInfoGUI(admin, result4);
                return;
            }
        } else if (lastMenu.equals("gamemode") && lastTargetName != null) {
            PlayerResult result5 = this.getPlayerResultByName(lastTargetName);
            if (result5 != null) {
                this.openGamemodeGUI(admin, result5);
                return;
            }
        } else if (lastMenu.equals("gamemode_confirm") && lastTargetName != null) {
            PlayerResult result6 = this.getPlayerResultByName(lastTargetName);
            if (result6 != null) {
                this.openGamemodeConfirmGUI(admin, result6);
                return;
            }
            this.openSearchGUI(admin);
        } else if (lastMenu.equals("ban_type") && lastTargetName != null) {
            PlayerResult result7 = this.getPlayerResultByName(lastTargetName);
            if (result7 != null) {
                this.openBanTypeGUI(admin, result7);
                return;
            }
        } else if (lastMenu.equals("ban_duration") && lastTargetName != null) {
            PlayerResult result8 = this.getPlayerResultByName(lastTargetName);
            if (result8 != null) {
                this.openBanDurationGUI(admin, result8);
                return;
            }
        } else if (lastMenu.equals("ban_reason") && lastTargetName != null && (result = this.getPlayerResultByName(lastTargetName)) != null) {
            String duration = this.plugin.getPlayerDataConfig().getString("players." + result.uuid + ".pending_ban_duration", "permanent");
            this.openBanReasonGUI(admin, result, duration);
            return;
        }
        this.openSearchGUI(admin);
    }

    public void openSearchGUI(Player admin) {
        if (!admin.hasPermission("playermanager.admin") && !admin.hasPermission("playermanager.gui")) {
            admin.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission!"));
            return;
        }
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)this.plugin.getMessage("gui.title", "Player Management"));
        ItemStack loadingItem = new ItemStack(Material.REDSTONE);
        ItemMeta loadingMeta = loadingItem.getItemMeta();
        if (loadingMeta != null) {
            loadingMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("gui.loading", "Loading..."));
            loadingItem.setItemMeta(loadingMeta);
        }
        this.inventory.setItem(4, loadingItem);
        admin.openInventory(this.inventory);
        this.playersInGUI.add(admin.getUniqueId());
        this.setLastOpenedMenu(admin.getUniqueId(), "search");
        this.plugin.savePlayerMenuState(admin);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            List<PlayerResult> results = this.getSearchResults(admin, this.currentSearch);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                if (admin.isOnline() && this.playersInGUI.contains(admin.getUniqueId())) {
                    this.setupSearchGUI(admin, results);
                    admin.updateInventory();
                }
            });
        });
    }

    private PlayerResult getPlayerResultByName(String name) {
        for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
            String newTexture;
            if (offlinePlayer.getName() == null || !offlinePlayer.getName().equalsIgnoreCase(name)) continue;
            String uuidStr = offlinePlayer.getUniqueId().toString();
            String path = "players." + uuidStr + ".";
            PlayerResult result = new PlayerResult();
            result.uuid = uuidStr;
            result.name = offlinePlayer.getName();
            result.firstPlayed = this.plugin.getPlayerDataConfig().getLong(path + "first_played", offlinePlayer.getFirstPlayed());
            result.lastLogin = this.plugin.getPlayerDataConfig().getLong(path + "last_login", offlinePlayer.getFirstPlayed());
            result.lastLogout = this.plugin.getPlayerDataConfig().getLong(path + "last_logout", offlinePlayer.getLastPlayed());
            result.online = offlinePlayer.isOnline();
            result.banned = offlinePlayer.isBanned();
            boolean needsSave = false;
            boolean storedBanned = this.plugin.getPlayerDataConfig().getBoolean(path + "banned", false);
            if (storedBanned != result.banned) {
                this.plugin.getPlayerDataConfig().set(path + "banned", (Object)result.banned);
                needsSave = true;
            }
            result.headTexture = this.plugin.getPlayerDataConfig().getString(path + "head_texture", "");
            if (result.headTexture.isEmpty() && !(newTexture = this.fetchHeadTexture(offlinePlayer)).isEmpty()) {
                result.headTexture = newTexture;
                this.plugin.getPlayerDataConfig().set(path + "head_texture", (Object)result.headTexture);
                needsSave = true;
            }
            if (needsSave) {
                this.plugin.savePlayerDataConfig();
            }
            return result;
        }
        return null;
    }

    private String fetchHeadTexture(OfflinePlayer player) {
        String uuidStr = player.getUniqueId().toString();
        String cachedTexture = this.plugin.getPlayerDataConfig().getString("players." + uuidStr + ".head_texture", "");
        if (!cachedTexture.isEmpty()) {
            return cachedTexture;
        }
        try {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastTextureRequestTime < 100000L) {
                return "";
            }
            ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta meta = (SkullMeta)skull.getItemMeta();
            if (meta != null) {
                meta.setOwningPlayer(player);
                skull.setItemMeta((ItemMeta)meta);
                Field profileField = meta.getClass().getDeclaredField("profile");
                profileField.setAccessible(true);
                GameProfile gameProfile = (GameProfile)profileField.get(meta);
                if (gameProfile != null && gameProfile.getProperties().containsKey((Object)"textures")) {
                    Property texture = (Property)gameProfile.getProperties().get((Object)"textures").iterator().next();
                    this.plugin.getPlayerDataConfig().set("players." + uuidStr + ".head_texture", (Object)texture.getValue());
                    this.plugin.savePlayerDataConfig();
                    this.lastTextureRequestTime = System.currentTimeMillis();
                    return texture.getValue();
                }
            }
        }
        catch (Exception e) {
            this.lastTextureRequestTime = System.currentTimeMillis() + 100000L;
        }
        return "";
    }

    public void setupSearchGUI(Player player, List<PlayerResult> results) {
        this.inventory.clear();
        this.slotMap.clear();
        ItemStack refreshItem = new ItemStack(Material.CLOCK);
        ItemMeta refreshMeta = refreshItem.getItemMeta();
        if (refreshMeta != null) {
            refreshMeta.setDisplayName(ChatColor.GREEN + this.plugin.getMessage("gui.refresh", "Refresh List"));
            ArrayList<String> refreshLore = new ArrayList<String>();
            refreshLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.refresh-hint", "Click to refresh player list"));
            refreshMeta.setLore(refreshLore);
            refreshItem.setItemMeta(refreshMeta);
        }
        this.inventory.setItem(0, refreshItem);
        if (results.isEmpty()) {
            ItemStack noResultsItem = new ItemStack(Material.BARRIER);
            ItemMeta meta = noResultsItem.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.no-results", "No players found"));
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(ChatColor.GRAY + "Try changing the search query or filter");
                meta.setLore(lore);
                noResultsItem.setItemMeta(meta);
            }
            this.inventory.setItem(22, noResultsItem);
        }
        if (player.hasPermission("playermanager.ip-search")) {
            if (this.plugin.getConfig().getBoolean("features.ip-search", true)) {
                ItemStack ipSearchItem = new ItemStack(Material.PAPER);
                ItemMeta ipSearchMeta = ipSearchItem.getItemMeta();
                if (ipSearchMeta != null) {
                    ipSearchMeta.setDisplayName(ChatColor.GREEN + this.plugin.getMessage("gui.ip-search", "IP Search"));
                    ArrayList<String> ipSearchLore = new ArrayList<String>();
                    ipSearchLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.ip-search-hint", "Left click: Search by IP"));
                    ipSearchMeta.setLore(ipSearchLore);
                    ipSearchItem.setItemMeta(ipSearchMeta);
                }
                this.inventory.setItem(1, ipSearchItem);
            } else {
                this.plugin.getLogger().info("IP search feature is disabled in config.");
            }
        }
        this.inventory.setItem(47, this.createFilterItem(Filter.ALL));
        this.inventory.setItem(48, this.createFilterItem(Filter.ONLINE));
        this.inventory.setItem(50, this.createFilterItem(Filter.OFFLINE));
        this.inventory.setItem(51, this.createFilterItem(Filter.BANNED));
        String searchText = this.plugin.getMessage("gui.search", "Search: %query%").replace("%query%", this.currentSearch.isEmpty() ? this.plugin.getMessage("gui.search-all", "all") : this.currentSearch);
        ItemStack searchItem = new ItemStack(Material.COMPASS);
        ItemMeta searchMeta = searchItem.getItemMeta();
        if (searchMeta != null) {
            searchMeta.setDisplayName(ChatColor.YELLOW + searchText);
            ArrayList<String> searchLore = new ArrayList<String>();
            searchLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.search-hint", "Left click: Enter query | Right click: Reset search"));
            searchMeta.setLore(searchLore);
            searchItem.setItemMeta(searchMeta);
        }
        this.inventory.setItem(4, searchItem);
        ItemStack closeItem = new ItemStack(Material.BARRIER);
        ItemMeta closeMeta = closeItem.getItemMeta();
        if (closeMeta != null) {
            closeMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.close", "Close"));
            closeItem.setItemMeta(closeMeta);
        }
        this.inventory.setItem(49, closeItem);
        int totalPages = (int)Math.ceil((double)results.size() / 36.0);
        String pageInfo = this.plugin.getMessage("gui.page-info", "Page %current%/%total%").replace("%current%", String.valueOf(this.currentPage + 1)).replace("%total%", String.valueOf(totalPages));
        int start = this.currentPage * 36;
        int end = Math.min(start + 36, results.size());
        for (int i = start; i < end; ++i) {
            PlayerResult result = results.get(i);
            ItemStack head = this.createPlayerHead(result);
            if (head == null) continue;
            this.inventory.setItem(i - start + 9, head);
            this.slotMap.put(i - start + 9, result);
        }
        if (this.currentPage > 0) {
            ItemStack prevPage = new ItemStack(Material.ARROW);
            ItemMeta prevMeta = prevPage.getItemMeta();
            if (prevMeta != null) {
                prevMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("gui.previous-page", "Previous page"));
                ArrayList<String> prevLore = new ArrayList<String>();
                prevLore.add(ChatColor.GRAY + pageInfo);
                prevLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.shift-rmb-page", "Shift+RMB: Skip 5 pages"));
                prevMeta.setLore(prevLore);
                prevPage.setItemMeta(prevMeta);
            }
            this.inventory.setItem(45, prevPage);
        } else {
            ItemStack noPrev = new ItemStack(Material.RED_STAINED_GLASS_PANE);
            ItemMeta noPrevMeta = noPrev.getItemMeta();
            if (noPrevMeta != null) {
                noPrevMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.no-page", "No page"));
                ArrayList<String> noPrevLore = new ArrayList<String>();
                noPrevLore.add(ChatColor.GRAY + pageInfo);
                noPrevMeta.setLore(noPrevLore);
                noPrev.setItemMeta(noPrevMeta);
            }
            this.inventory.setItem(45, noPrev);
        }
        if ((this.currentPage + 1) * 36 < results.size()) {
            ItemStack nextPage = new ItemStack(Material.ARROW);
            ItemMeta nextMeta = nextPage.getItemMeta();
            if (nextMeta != null) {
                nextMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("gui.next-page", "Next page"));
                ArrayList<String> nextLore = new ArrayList<String>();
                nextLore.add(ChatColor.GRAY + pageInfo);
                nextLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.shift-rmb-page", "Shift+RMB: Skip 5 pages"));
                nextMeta.setLore(nextLore);
                nextPage.setItemMeta(nextMeta);
            }
            this.inventory.setItem(53, nextPage);
        } else {
            ItemStack noNext = new ItemStack(Material.RED_STAINED_GLASS_PANE);
            ItemMeta noNextMeta = noNext.getItemMeta();
            if (noNextMeta != null) {
                noNextMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.no-page", "No page"));
                ArrayList<String> noNextLore = new ArrayList<String>();
                noNextLore.add(ChatColor.GRAY + pageInfo);
                noNextMeta.setLore(noNextLore);
                noNext.setItemMeta(noNextMeta);
            }
            this.inventory.setItem(53, noNext);
        }
    }

    public void setCurrentSearch(String search) {
        this.currentSearch = search;
    }

    public void setCurrentPage(int page) {
        this.currentPage = page;
    }

    public void setLastPage(UUID playerId, int page) {
        this.lastPage.put(playerId, page);
    }

    public void setCachedResults(List<PlayerResult> results) {
        this.cachedResults = new ArrayList<PlayerResult>(results);
        this.unfilteredResults = new ArrayList<PlayerResult>(results);
    }

    private List<PlayerResult> getSearchResults(Player admin, String search) {
        String name;
        String searchLower = search.toLowerCase().trim();
        if (!searchLower.equalsIgnoreCase(this.currentSearch)) {
            this.cachedResults.clear();
            this.unfilteredResults.clear();
            this.currentSearch = searchLower;
        }
        if (!this.cachedResults.isEmpty()) {
            return this.applyFilter(this.cachedResults);
        }
        ArrayList<PlayerResult> results = new ArrayList<PlayerResult>();
        HashSet<String> processedUUIDs = new HashSet<String>();
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            String newTexture;
            String uuid = onlinePlayer.getUniqueId().toString();
            name = onlinePlayer.getName();
            processedUUIDs.add(uuid);
            if (!searchLower.isEmpty() && !name.toLowerCase().contains(searchLower) || this.plugin.isAdminPlayer(onlinePlayer)) continue;
            String path = "players." + uuid + ".";
            PlayerResult result = new PlayerResult();
            result.uuid = uuid;
            result.name = name;
            result.firstPlayed = this.plugin.getPlayerDataConfig().getLong(path + "first_played", onlinePlayer.getFirstPlayed());
            result.lastLogin = this.plugin.getPlayerDataConfig().getLong(path + "last_login", onlinePlayer.getLastPlayed());
            result.lastLogout = this.plugin.getPlayerDataConfig().getLong(path + "last_logout", onlinePlayer.getLastPlayed());
            result.online = true;
            result.banned = Bukkit.getBanList((BanList.Type)BanList.Type.NAME).isBanned(name);
            this.plugin.updatePlayerBanStatus(uuid, result.banned);
            result.headTexture = this.plugin.getPlayerDataConfig().getString(path + "head_texture", "");
            if (result.headTexture.isEmpty() && !(newTexture = this.fetchHeadTexture((OfflinePlayer)onlinePlayer)).isEmpty()) {
                result.headTexture = newTexture;
                this.plugin.getPlayerDataConfig().set(path + "head_texture", (Object)newTexture);
                this.plugin.savePlayerDataConfig();
            }
            results.add(result);
        }
        ConfigurationSection playersSection = this.plugin.getPlayerDataConfig().getConfigurationSection("players");
        if (playersSection != null) {
            for (String uuid : playersSection.getKeys(false)) {
                if (processedUUIDs.contains(uuid)) continue;
                try {
                    String newTexture;
                    OfflinePlayer offlinePlayer;
                    name = this.plugin.getPlayerDataConfig().getString("players." + uuid + ".name", "");
                    if (name.isEmpty()) {
                        this.plugin.getLogger().warning("Skipping UUID " + uuid + ": empty name");
                        continue;
                    }
                    if (!searchLower.isEmpty() && !name.toLowerCase().contains(searchLower) || this.plugin.isAdminPlayer(offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(uuid)))) continue;
                    String path = "players." + uuid + ".";
                    PlayerResult result = new PlayerResult();
                    result.uuid = uuid;
                    result.name = name;
                    result.firstPlayed = this.plugin.getPlayerDataConfig().getLong(path + "first_played", offlinePlayer.getFirstPlayed());
                    result.lastLogin = this.plugin.getPlayerDataConfig().getLong(path + "last_login", offlinePlayer.getLastPlayed());
                    result.lastLogout = this.plugin.getPlayerDataConfig().getLong(path + "last_logout", offlinePlayer.getLastPlayed());
                    result.online = Bukkit.getPlayer((UUID)UUID.fromString(uuid)) != null;
                    result.banned = Bukkit.getBanList((BanList.Type)BanList.Type.NAME).isBanned(name);
                    this.plugin.updatePlayerBanStatus(uuid, result.banned);
                    result.headTexture = this.plugin.getPlayerDataConfig().getString(path + "head_texture", "");
                    if (result.headTexture.isEmpty() && !(newTexture = this.fetchHeadTexture(offlinePlayer)).isEmpty()) {
                        result.headTexture = newTexture;
                        this.plugin.getPlayerDataConfig().set(path + "head_texture", (Object)newTexture);
                        this.plugin.savePlayerDataConfig();
                    }
                    results.add(result);
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Error processing player UUID " + uuid + ": " + e.getMessage());
                }
            }
        } else {
            this.plugin.getLogger().warning("No players section in player_data.yml, creating new section");
            this.plugin.getPlayerDataConfig().createSection("players");
            this.plugin.savePlayerDataConfig();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                if (admin.isOnline() && this.playersInGUI.contains(admin.getUniqueId())) {
                    admin.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-players-data", "No player data available!"));
                    ItemStack noResultsItem = new ItemStack(Material.BARRIER);
                    ItemMeta meta = noResultsItem.getItemMeta();
                    if (meta != null) {
                        meta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.no-results", "No players found"));
                        noResultsItem.setItemMeta(meta);
                    }
                    this.inventory.setItem(22, noResultsItem);
                    admin.updateInventory();
                }
            });
        }
        results.sort(Comparator.comparing(r -> r.name.toLowerCase()));
        this.unfilteredResults = new ArrayList<PlayerResult>(results);
        this.cachedResults = new ArrayList<PlayerResult>(results);
        return this.applyFilter(results);
    }

    private ItemStack createPlayerHead(PlayerResult result) {
        UUID playerUUID = UUID.fromString(result.uuid);
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)playerUUID);
        if (this.plugin.isAdminPlayer(offlinePlayer)) {
            return null;
        }
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        meta.setDisplayName(ChatColor.YELLOW + result.name);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.uuid", "UUID") + ": " + ChatColor.WHITE + result.uuid);
        lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.first-played", "First played") + ": " + ChatColor.WHITE + this.formatDate(result.firstPlayed));
        lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.last-login", "Last login") + ": " + ChatColor.WHITE + this.formatDate(result.lastLogin));
        lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.last-logout", "Last logout") + ": " + ChatColor.WHITE + this.formatDate(result.lastLogout));
        if (!result.online) {
            lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.time-since-logout", "Time since logout") + ": " + ChatColor.WHITE + this.formatTimeAgo(result.lastLogout));
        }
        lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.status", "Status") + ": " + (result.online ? ChatColor.GREEN + this.plugin.getMessage("status.online", "Online") : ChatColor.RED + this.plugin.getMessage("status.offline", "Offline")));
        lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.ban-status", "Ban status") + ": " + (result.banned ? ChatColor.RED + this.plugin.getMessage("status.banned", "Banned") : ChatColor.GREEN + this.plugin.getMessage("status.not-banned", "Not banned")));
        lore.add("");
        lore.add(this.plugin.getMessage("gui.actions", "&7Left click: Menu | Right click: Teleport | Shift+Right click: Punishments"));
        meta.setLore(lore);
        if (!result.headTexture.isEmpty()) {
            try {
                GameProfile profile = new GameProfile(UUID.fromString(result.uuid), null);
                profile.getProperties().put((Object)"textures", (Object)new Property("textures", result.headTexture));
                Field profileField = meta.getClass().getDeclaredField("profile");
                profileField.setAccessible(true);
                profileField.set(meta, profile);
            }
            catch (Exception exception) {}
        } else {
            meta.setOwningPlayer(offlinePlayer);
        }
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    private ItemStack createFilterItem(Filter filter) {
        ItemStack item = new ItemStack(filter.getMaterial());
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(filter.getColor() + filter.getDisplayName(this.plugin));
        if (this.currentFilter == filter) {
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(ChatColor.GREEN + this.plugin.getMessage("gui.filter-active", "Active filter"));
            meta.setLore(lore);
        }
        item.setItemMeta(meta);
        return item;
    }

    private List<PlayerResult> applyFilter(List<PlayerResult> results) {
        ArrayList<PlayerResult> filteredResults = new ArrayList<PlayerResult>();
        block5: for (PlayerResult result : results) {
            switch (this.currentFilter.ordinal()) {
                case 1: {
                    if (result.online) break;
                    continue block5;
                }
                case 2: {
                    if (!result.online) break;
                    continue block5;
                }
                case 3: {
                    if (result.banned) break;
                    continue block5;
                }
            }
            filteredResults.add(result);
        }
        return filteredResults;
    }

    public void openPlayerMenu(Player player, PlayerResult result) {
        if (!player.hasPermission("playermanager.admin") && !player.hasPermission("playermanager.gui")) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission!"));
            return;
        }
        Inventory playerMenu = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)(this.plugin.getMessage("gui.player-menu-prefix", "Player Menu: ") + ChatColor.YELLOW + result.name));
        ItemStack headItem = this.createPlayerHead(result);
        playerMenu.setItem(4, headItem);
        ItemStack infoItem = new ItemStack(Material.BOOK);
        ItemMeta infoMeta = infoItem.getItemMeta();
        infoMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("gui.info", "Information"));
        ArrayList<String> infoLore = new ArrayList<String>();
        infoLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.uuid", "UUID") + ": " + ChatColor.WHITE + result.uuid);
        infoLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.first-played", "First played") + ": " + ChatColor.WHITE + this.formatDate(result.firstPlayed));
        infoLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.last-login", "Last login") + ": " + ChatColor.WHITE + this.formatDate(result.lastLogin));
        infoLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.last-logout", "Last logout") + ": " + ChatColor.WHITE + this.formatDate(result.lastLogout));
        if (!result.online) {
            infoLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.time-since-logout", "Time since logout") + ": " + ChatColor.WHITE + this.formatTimeAgo(result.lastLogout));
        }
        infoLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.status", "Status") + ": " + (result.online ? ChatColor.GREEN + this.plugin.getMessage("status.online", "Online") : ChatColor.RED + this.plugin.getMessage("status.offline", "Offline")));
        infoLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.ban-status", "Ban status") + ": " + (result.banned ? ChatColor.RED + this.plugin.getMessage("status.banned", "Banned") : ChatColor.GREEN + this.plugin.getMessage("status.not-banned", "Not banned")));
        infoMeta.setLore(infoLore);
        infoItem.setItemMeta(infoMeta);
        playerMenu.setItem(10, infoItem);
        if (this.getConfigValue("features.player-teleportation")) {
            ItemStack teleportItem = new ItemStack(Material.ENDER_PEARL);
            ItemMeta teleportMeta = teleportItem.getItemMeta();
            teleportMeta.setDisplayName(ChatColor.GREEN + this.plugin.getMessage("gui.teleport", "Teleport"));
            teleportItem.setItemMeta(teleportMeta);
            playerMenu.setItem(11, teleportItem);
        }
        if (this.getConfigValue("features.inventory-inspection")) {
            ItemStack inventoryItem = new ItemStack(Material.CHEST);
            ItemMeta inventoryMeta = inventoryItem.getItemMeta();
            inventoryMeta.setDisplayName(ChatColor.AQUA + this.plugin.getMessage("gui.inspect-inventory", "Inspect Inventory"));
            inventoryItem.setItemMeta(inventoryMeta);
            playerMenu.setItem(14, inventoryItem);
        }
        if (this.getConfigValue("features.ender-chest-inspection")) {
            ItemStack enderChestItem = new ItemStack(Material.ENDER_CHEST);
            ItemMeta enderChestMeta = enderChestItem.getItemMeta();
            enderChestMeta.setDisplayName(ChatColor.DARK_PURPLE + this.plugin.getMessage("gui.ender-chest", "Inspect Ender Chest"));
            enderChestItem.setItemMeta(enderChestMeta);
            playerMenu.setItem(15, enderChestItem);
        }
        if (this.getConfigValue("features.punishment-system")) {
            ItemStack punishmentsItem = new ItemStack(Material.IRON_SWORD);
            ItemMeta punishmentsMeta = punishmentsItem.getItemMeta();
            punishmentsMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.punishments", "Punishments"));
            punishmentsItem.setItemMeta(punishmentsMeta);
            playerMenu.setItem(12, punishmentsItem);
        }
        if (this.getConfigValue("features.player-info-actions")) {
            ItemStack playerInfoItem = new ItemStack(Material.NAME_TAG);
            ItemMeta playerInfoMeta = playerInfoItem.getItemMeta();
            playerInfoMeta.setDisplayName(ChatColor.BLUE + this.plugin.getMessage("gui.player-info", "Player Info & Actions"));
            playerInfoItem.setItemMeta(playerInfoMeta);
            playerMenu.setItem(16, playerInfoItem);
        }
        ItemStack backItem = new ItemStack(Material.ARROW);
        ItemMeta backMeta = backItem.getItemMeta();
        backMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.back", "Back"));
        backItem.setItemMeta(backMeta);
        playerMenu.setItem(22, backItem);
        player.openInventory(playerMenu);
        this.setPlayerMenuTarget(player.getUniqueId(), result);
        this.setLastOpenedMenu(player.getUniqueId(), "player");
        this.setLastTarget(player.getUniqueId(), result.name);
        this.plugin.savePlayerMenuState(player);
    }

    public void openPlayerInfoGUI(Player player, PlayerResult result) {
        if (!player.hasPermission("playermanager.admin") && !player.hasPermission("playermanager.gui")) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission!"));
            return;
        }
        if (!this.getConfigValue("features.player-info-actions")) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.player-info-actions-disabled", "Player Info & Actions is disabled in config!"));
            return;
        }
        Inventory playerInfoGUI = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)(this.plugin.getMessage("gui.player-info-prefix", "Player Info: ") + ChatColor.YELLOW + result.name));
        ItemStack headItem = this.createPlayerHead(result);
        playerInfoGUI.setItem(4, headItem);
        if (result.online) {
            Player target = Bukkit.getPlayer((String)result.name);
            ItemStack healthItem = new ItemStack(Material.APPLE);
            ItemMeta healthMeta = healthItem.getItemMeta();
            healthMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.health", "Health"));
            ArrayList<String> healthLore = new ArrayList<String>();
            healthLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.current-health", "Current Health") + ": " + ChatColor.WHITE + String.format("%.1f/%.1f", target.getHealth(), target.getMaxHealth()));
            healthMeta.setLore(healthLore);
            healthItem.setItemMeta(healthMeta);
            playerInfoGUI.setItem(10, healthItem);
            ItemStack healItem = new ItemStack(Material.GOLDEN_APPLE);
            ItemMeta healMeta = healItem.getItemMeta();
            healMeta.setDisplayName(ChatColor.GREEN + this.plugin.getMessage("gui.heal", "Heal"));
            healItem.setItemMeta(healMeta);
            playerInfoGUI.setItem(12, healItem);
            ItemStack killItem = new ItemStack(Material.SKELETON_SKULL);
            ItemMeta killMeta = killItem.getItemMeta();
            killMeta.setDisplayName(ChatColor.DARK_RED + this.plugin.getMessage("gui.kill", "Kill"));
            killItem.setItemMeta(killMeta);
            playerInfoGUI.setItem(14, killItem);
            ItemStack statsItem = new ItemStack(Material.PAPER);
            ItemMeta statsMeta = statsItem.getItemMeta();
            statsMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("gui.stats", "Player Stats"));
            ArrayList<String> statsLore = new ArrayList<String>();
            statsLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.level", "Level") + ": " + ChatColor.WHITE + target.getLevel());
            statsLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.hunger", "Hunger") + ": " + ChatColor.WHITE + target.getFoodLevel() + "/20");
            statsLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.health", "Health") + ": " + ChatColor.WHITE + String.format("%.1f/%.1f", target.getHealth(), target.getMaxHealth()));
            statsLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.location", "Location") + ": " + ChatColor.WHITE + String.format("X: %.1f, Y: %.1f, Z: %.1f", target.getLocation().getX(), target.getLocation().getY(), target.getLocation().getZ()));
            statsLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.gamemode-gui", "Gamemode") + ": " + ChatColor.WHITE + target.getGameMode().toString());
            statsMeta.setLore(statsLore);
            statsItem.setItemMeta(statsMeta);
            playerInfoGUI.setItem(16, statsItem);
        }
        ItemStack gamemodeItem = new ItemStack(Material.COMMAND_BLOCK);
        ItemMeta gamemodeMeta = gamemodeItem.getItemMeta();
        gamemodeMeta.setDisplayName(ChatColor.BLUE + this.plugin.getMessage("gui.gamemode", "Change Gamemode"));
        gamemodeItem.setItemMeta(gamemodeMeta);
        playerInfoGUI.setItem(18, gamemodeItem);
        ItemStack backItem = new ItemStack(Material.ARROW);
        ItemMeta backMeta = backItem.getItemMeta();
        backMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.back", "Back"));
        backItem.setItemMeta(backMeta);
        playerInfoGUI.setItem(22, backItem);
        player.openInventory(playerInfoGUI);
        this.setPlayerMenuTarget(player.getUniqueId(), result);
        this.setLastOpenedMenu(player.getUniqueId(), "player_info");
        this.setLastTarget(player.getUniqueId(), result.name);
        this.plugin.savePlayerMenuState(player);
    }

    public void openGamemodeGUI(Player player, PlayerResult result) {
        if (!(player.hasPermission("playermanager.admin") || player.hasPermission("playermanager.gui") || player.hasPermission("playermanager.gamemode"))) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission!"));
            return;
        }
        Inventory gamemodeGUI = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)(this.plugin.getMessage("gui.gamemode-prefix", "Change Gamemode: ") + ChatColor.YELLOW + result.name));
        ItemStack headItem = this.createPlayerHead(result);
        gamemodeGUI.setItem(4, headItem);
        ItemStack survivalItem = new ItemStack(Material.GRASS_BLOCK);
        ItemMeta survivalMeta = survivalItem.getItemMeta();
        survivalMeta.setDisplayName(ChatColor.GREEN + this.plugin.getMessage("gui.survival", "Survival"));
        survivalItem.setItemMeta(survivalMeta);
        gamemodeGUI.setItem(10, survivalItem);
        ItemStack creativeItem = new ItemStack(Material.DIAMOND);
        ItemMeta creativeMeta = creativeItem.getItemMeta();
        creativeMeta.setDisplayName(ChatColor.AQUA + this.plugin.getMessage("gui.creative", "Creative"));
        creativeItem.setItemMeta(creativeMeta);
        gamemodeGUI.setItem(12, creativeItem);
        ItemStack adventureItem = new ItemStack(Material.MAP);
        ItemMeta adventureMeta = adventureItem.getItemMeta();
        adventureMeta.setDisplayName(ChatColor.BLUE + this.plugin.getMessage("gui.adventure", "Adventure"));
        adventureItem.setItemMeta(adventureMeta);
        gamemodeGUI.setItem(14, adventureItem);
        ItemStack spectatorItem = new ItemStack(Material.FEATHER);
        ItemMeta spectatorMeta = spectatorItem.getItemMeta();
        spectatorMeta.setDisplayName(ChatColor.GRAY + this.plugin.getMessage("gui.spectator", "Spectator"));
        spectatorItem.setItemMeta(spectatorMeta);
        gamemodeGUI.setItem(16, spectatorItem);
        ItemStack backItem = new ItemStack(Material.ARROW);
        ItemMeta backMeta = backItem.getItemMeta();
        backMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.back", "Back"));
        backItem.setItemMeta(backMeta);
        gamemodeGUI.setItem(22, backItem);
        player.openInventory(gamemodeGUI);
        this.setPlayerMenuTarget(player.getUniqueId(), result);
        this.setLastOpenedMenu(player.getUniqueId(), "gamemode");
        this.setLastTarget(player.getUniqueId(), result.name);
        this.plugin.savePlayerMenuState(player);
    }

    public void openGamemodeConfirmGUI(Player player, PlayerResult result) {
        if (!(player.hasPermission("playermanager.admin") || player.hasPermission("playermanager.gui") || player.hasPermission("playermanager.gamemode"))) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission!"));
            return;
        }
        Inventory confirmGUI = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)(this.plugin.getMessage("gui.confirm-prefix", "Confirm Creative: ") + ChatColor.YELLOW + result.name));
        ItemStack headItem = this.createPlayerHead(result);
        confirmGUI.setItem(4, headItem);
        ItemStack confirmItem = new ItemStack(Material.GREEN_STAINED_GLASS_PANE);
        ItemMeta confirmMeta = confirmItem.getItemMeta();
        confirmMeta.setDisplayName(ChatColor.GREEN + this.plugin.getMessage("gui.confirm", "Confirm"));
        confirmItem.setItemMeta(confirmMeta);
        confirmGUI.setItem(11, confirmItem);
        ItemStack cancelItem = new ItemStack(Material.RED_STAINED_GLASS_PANE);
        ItemMeta cancelMeta = cancelItem.getItemMeta();
        cancelMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.cancel", "Cancel"));
        cancelItem.setItemMeta(cancelMeta);
        confirmGUI.setItem(15, cancelItem);
        ItemStack backItem = new ItemStack(Material.ARROW);
        ItemMeta backMeta = backItem.getItemMeta();
        backMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.back", "Back"));
        backItem.setItemMeta(backMeta);
        confirmGUI.setItem(22, backItem);
        player.openInventory(confirmGUI);
        this.setPlayerMenuTarget(player.getUniqueId(), result);
        this.setLastOpenedMenu(player.getUniqueId(), "gamemode_confirm");
        this.setLastTarget(player.getUniqueId(), result.name);
        this.plugin.savePlayerMenuState(player);
    }

    private boolean getConfigValue(String key) {
        return this.plugin.getConfig().getBoolean(key, true);
    }

    private void openPunishmentGUI(Player player, PlayerResult result) {
        if (!(player.hasPermission("playermanager.admin") || player.hasPermission("playermanager.gui") || player.hasPermission("playermanager.punishment"))) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission!"));
            return;
        }
        if (!this.getConfigValue("features.punishment-system")) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.punishment-system-disabled", "Punishment system is disabled in config!"));
            return;
        }
        if (player.getUniqueId().toString().equals(result.uuid)) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.self-punish", "You can't punish yourself."));
            return;
        }
        if (this.plugin.isAdminPlayer(Bukkit.getOfflinePlayer((UUID)UUID.fromString(result.uuid)))) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.cannot-target-admin", "You cannot target another admin."));
            return;
        }
        Inventory punishmentGUI = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)(this.plugin.getMessage("gui.punishment-prefix", "Punishments: ") + ChatColor.YELLOW + result.name));
        ItemStack headItem = this.createPlayerHead(result);
        punishmentGUI.setItem(4, headItem);
        ItemStack banItem = new ItemStack(Material.NETHERITE_SWORD);
        ItemMeta banMeta = banItem.getItemMeta();
        banMeta.setDisplayName(ChatColor.DARK_RED + this.plugin.getMessage("gui.ban", "Ban"));
        ArrayList<String> banLore = new ArrayList<String>();
        banLore.add(ChatColor.RED + (result.banned ? this.plugin.getMessage("status.already-banned", "Already banned") : this.plugin.getMessage("gui.click-to-ban", "Click to ban")));
        banLore.add(ChatColor.YELLOW + this.plugin.getMessage("gui.actions-shift-rmb", "Shift+RMB: Quick action"));
        banMeta.setLore(banLore);
        banItem.setItemMeta(banMeta);
        punishmentGUI.setItem(10, banItem);
        ItemStack kickItem = new ItemStack(Material.BLAZE_ROD);
        ItemMeta kickMeta = kickItem.getItemMeta();
        kickMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.kick", "Kick"));
        ArrayList<String> kickLore = new ArrayList<String>();
        kickLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.click-to-kick", "Click to kick"));
        if (!result.online) {
            kickLore.add(ChatColor.DARK_GRAY + this.plugin.getMessage("gui.actions-shift-rmb", "Shift+RMB: Quick action"));
        }
        kickMeta.setLore(kickLore);
        kickItem.setItemMeta(kickMeta);
        punishmentGUI.setItem(11, kickItem);
        if (this.getConfigValue("features.jail-system")) {
            ItemStack jailItem = new ItemStack(Material.IRON_BARS);
            ItemMeta jailMeta = jailItem.getItemMeta();
            jailMeta.setDisplayName(ChatColor.GRAY + this.plugin.getMessage("gui.jail", "Jail"));
            ArrayList<String> jailLore = new ArrayList<String>();
            jailLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.click-to-jail", "Click to jail"));
            if (!result.online) {
                jailLore.add(ChatColor.DARK_GRAY + this.plugin.getMessage("gui.actions-shift-rmb", "Shift+RMB: Quick action"));
            }
            jailMeta.setLore(jailLore);
            jailItem.setItemMeta(jailMeta);
            punishmentGUI.setItem(12, jailItem);
        }
        ItemStack warnItem = new ItemStack(Material.PAPER);
        ItemMeta warnMeta = warnItem.getItemMeta();
        warnMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("gui.warn", "Warn"));
        ArrayList<String> warnLore = new ArrayList<String>();
        warnLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.click-to-warn", "Click to warn"));
        if (!result.online) {
            warnLore.add(ChatColor.DARK_GRAY + this.plugin.getMessage("gui.actions-shift-rmb", "Shift+RMB: Quick action"));
        }
        warnMeta.setLore(warnLore);
        warnItem.setItemMeta(warnMeta);
        punishmentGUI.setItem(14, warnItem);
        ItemStack muteItem = new ItemStack(Material.BOOK);
        ItemMeta muteMeta = muteItem.getItemMeta();
        muteMeta.setDisplayName(ChatColor.GRAY + this.plugin.getMessage("gui.mute", "Mute"));
        ArrayList<String> muteLore = new ArrayList<String>();
        muteLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.click-to-mute", "Click to mute"));
        if (!result.online) {
            muteLore.add(ChatColor.DARK_GRAY + this.plugin.getMessage("gui.actions-shift-rmb", "Shift+RMB: Quick action"));
        }
        muteMeta.setLore(muteLore);
        muteItem.setItemMeta(muteMeta);
        punishmentGUI.setItem(15, muteItem);
        ItemStack unbanItem = new ItemStack(Material.EMERALD);
        ItemMeta unbanMeta = unbanItem.getItemMeta();
        unbanMeta.setDisplayName(ChatColor.GREEN + this.plugin.getMessage("gui.unban", "Unban"));
        ArrayList<String> unbanLore = new ArrayList<String>();
        unbanLore.add(ChatColor.GREEN + (result.banned ? this.plugin.getMessage("gui.click-to-unban", "Click to unban") : this.plugin.getMessage("status.not-banned", "Not banned")));
        unbanLore.add(ChatColor.YELLOW + this.plugin.getMessage("gui.actions-shift-rmb", "Shift+RMB: Quick action"));
        unbanMeta.setLore(unbanLore);
        unbanItem.setItemMeta(unbanMeta);
        punishmentGUI.setItem(16, unbanItem);
        ItemStack backItem = new ItemStack(Material.ARROW);
        ItemMeta backMeta = backItem.getItemMeta();
        backMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.back", "Back"));
        backItem.setItemMeta(backMeta);
        punishmentGUI.setItem(22, backItem);
        player.openInventory(punishmentGUI);
        this.setPlayerMenuTarget(player.getUniqueId(), result);
        this.setLastOpenedMenu(player.getUniqueId(), "punishment");
        this.setLastTarget(player.getUniqueId(), result.name);
        this.plugin.savePlayerMenuState(player);
    }

    private void openJailGUI(Player player, PlayerResult result) {
        if (!this.getConfigValue("features.punishment-system")) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.punishment-system-disabled", "Punishment system is disabled!"));
            return;
        }
        if (!player.hasPermission("playermanager.admin") && !player.hasPermission("playermanager.gui")) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission!"));
            return;
        }
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)(this.plugin.getMessage("gui.jail-prefix", "Jail: ") + result.name));
        ItemStack headItem = this.createPlayerHead(result);
        this.inventory.setItem(4, headItem);
        ItemStack jail = new ItemStack(Material.IRON_BARS);
        ItemMeta jailMeta = jail.getItemMeta();
        if (jailMeta != null) {
            jailMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getMessage("punishment.jail", "Jail")));
            ArrayList<String> jailLore = new ArrayList<String>();
            jailLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.actions-lmb", "LMB: Reason"));
            jailLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.actions-shift-rmb", "Shift+RMB: Quick jail"));
            jailMeta.setLore(jailLore);
            jail.setItemMeta(jailMeta);
        }
        this.inventory.setItem(12, jail);
        ItemStack unjail = new ItemStack(Material.EMERALD);
        ItemMeta unjailMeta = unjail.getItemMeta();
        if (unjailMeta != null) {
            unjailMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getMessage("punishment.unjail", "Unjail")));
            ArrayList<String> unjailLore = new ArrayList<String>();
            unjailLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.actions-lmb-unjail", "LMB: Quick unjail"));
            unjailMeta.setLore(unjailLore);
            unjail.setItemMeta(unjailMeta);
        }
        this.inventory.setItem(14, unjail);
        ItemStack back = new ItemStack(Material.ARROW);
        ItemMeta backMeta = back.getItemMeta();
        if (backMeta != null) {
            backMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getMessage("gui.back", "Back")));
            back.setItemMeta(backMeta);
        }
        this.inventory.setItem(22, back);
        player.openInventory(this.inventory);
        this.setLastOpenedMenu(player.getUniqueId(), "jail");
        this.setPlayerMenuTarget(player.getUniqueId(), result);
        this.setLastTarget(player.getUniqueId(), result.name);
        this.plugin.savePlayerMenuState(player);
    }

    private void openMuteDurationGUI(Player player, PlayerResult result) {
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)(this.plugin.getMessage("gui.mute-duration-title", "Mute Duration: ") + result.name));
        ItemStack[] durations = new ItemStack[8];
        String[] durationKeys = new String[]{"1h", "12h", "1d", "3d", "7d", "14d", "permanent", "custom"};
        String[] materials = new String[]{"CLOCK", "CLOCK", "CLOCK", "CLOCK", "CLOCK", "CLOCK", "CLOCK", "PAPER"};
        int[] slots = new int[]{10, 11, 12, 13, 14, 15, 16, 17};
        for (int i = 0; i < durations.length; ++i) {
            durations[i] = new ItemStack(Material.valueOf((String)materials[i]));
            ItemMeta meta = durations[i].getItemMeta();
            if (meta != null) {
                meta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("mute.duration." + durationKeys[i], durationKeys[i]));
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.actions-lmb-duration", "LMB: Select duration"));
                meta.setLore(lore);
                durations[i].setItemMeta(meta);
            }
            this.inventory.setItem(slots[i], durations[i]);
        }
        ItemStack back = new ItemStack(Material.ARROW);
        ItemMeta backMeta = back.getItemMeta();
        if (backMeta != null) {
            backMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getMessage("gui.back", "Back")));
            back.setItemMeta(backMeta);
        }
        this.inventory.setItem(22, back);
        player.openInventory(this.inventory);
        this.setLastOpenedMenu(player.getUniqueId(), "mute_duration");
        this.setPlayerMenuTarget(player.getUniqueId(), result);
        this.setLastTarget(player.getUniqueId(), result.name);
        this.plugin.savePlayerMenuState(player);
    }

    private void openWarnDurationGUI(Player player, PlayerResult result) {
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)(this.plugin.getMessage("gui.warn-duration-title", "Warn Duration: ") + result.name));
        ItemStack[] durations = new ItemStack[8];
        String[] durationKeys = new String[]{"1h", "12h", "1d", "3d", "7d", "14d", "permanent", "custom"};
        String[] materials = new String[]{"CLOCK", "CLOCK", "CLOCK", "CLOCK", "CLOCK", "CLOCK", "CLOCK", "PAPER"};
        int[] slots = new int[]{10, 11, 12, 13, 14, 15, 16, 17};
        for (int i = 0; i < durations.length; ++i) {
            durations[i] = new ItemStack(Material.valueOf((String)materials[i]));
            ItemMeta meta = durations[i].getItemMeta();
            if (meta != null) {
                meta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("warn.duration." + durationKeys[i], durationKeys[i]));
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.actions-lmb-duration", "LMB: Select duration"));
                meta.setLore(lore);
                durations[i].setItemMeta(meta);
            }
            this.inventory.setItem(slots[i], durations[i]);
        }
        ItemStack back = new ItemStack(Material.ARROW);
        ItemMeta backMeta = back.getItemMeta();
        if (backMeta != null) {
            backMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getMessage("gui.back", "Back")));
            back.setItemMeta(backMeta);
        }
        this.inventory.setItem(22, back);
        player.openInventory(this.inventory);
        this.setLastOpenedMenu(player.getUniqueId(), "warn_duration");
        this.setPlayerMenuTarget(player.getUniqueId(), result);
        this.setLastTarget(player.getUniqueId(), result.name);
        this.plugin.savePlayerMenuState(player);
    }

    private void openBanDurationGUI(Player player, PlayerResult result) {
        Inventory banDurationGUI = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)(this.plugin.getMessage("gui.ban-duration-title", "Ban Duration: ") + ChatColor.YELLOW + result.name));
        ItemStack[] durations = new ItemStack[8];
        String[] durationKeys = new String[]{"1h", "12h", "1d", "3d", "7d", "14d", "permanent", "custom"};
        String[] materials = new String[]{"CLOCK", "CLOCK", "CLOCK", "CLOCK", "CLOCK", "CLOCK", "BARRIER", "PAPER"};
        int[] slots = new int[]{10, 11, 12, 13, 14, 15, 16, 17};
        for (int i = 0; i < durations.length; ++i) {
            durations[i] = new ItemStack(Material.valueOf((String)materials[i]));
            ItemMeta meta = durations[i].getItemMeta();
            if (meta != null) {
                meta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("ban.duration." + durationKeys[i], durationKeys[i]));
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.actions-lmb-duration", "LMB: Select duration"));
                if (durationKeys[i].equals("custom") && !this.isTempPunishPluginInstalled()) {
                    lore.add(ChatColor.RED + this.plugin.getMessage("error.temp-plugin-missing", "Temp ban plugin not installed! Install AdvancedBan or LiteBans."));
                }
                meta.setLore(lore);
                durations[i].setItemMeta(meta);
            }
            banDurationGUI.setItem(slots[i], durations[i]);
        }
        ItemStack back = new ItemStack(Material.ARROW);
        ItemMeta backMeta = back.getItemMeta();
        if (backMeta != null) {
            backMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.back", "Back"));
            back.setItemMeta(backMeta);
        }
        banDurationGUI.setItem(22, back);
        player.openInventory(banDurationGUI);
        this.setPlayerMenuTarget(player.getUniqueId(), result);
        this.setLastOpenedMenu(player.getUniqueId(), "ban_duration");
        this.setLastTarget(player.getUniqueId(), result.name);
        this.plugin.savePlayerDataConfig();
        this.plugin.savePlayerMenuState(player);
    }

    private void handleBanDurationClick(Player player, int slot, InventoryClickEvent event) {
        PlayerResult result = this.playerMenuTargets.get(player.getUniqueId());
        if (result == null) {
            this.plugin.getLogger().warning("No PlayerResult found for player " + player.getName());
            return;
        }
        if (player.getUniqueId().toString().equals(result.uuid)) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.self-punish", "You can't punish yourself."));
            return;
        }
        if (slot == 22) {
            this.openBanTypeGUI(player, result);
            return;
        }
        String duration = null;
        if (slot == 10) {
            duration = "1h";
        } else if (slot == 11) {
            duration = "12h";
        } else if (slot == 12) {
            duration = "1d";
        } else if (slot == 13) {
            duration = "3d";
        } else if (slot == 14) {
            duration = "7d";
        } else if (slot == 15) {
            duration = "14d";
        } else if (slot == 16) {
            duration = "permanent";
        } else if (slot == 17) {
            if (!this.isTempPunishPluginInstalled()) {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.temp-plugin-missing", "Temp ban plugin not installed! Install AdvancedBan or LiteBans."));
                return;
            }
            player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.enter-duration", "Enter ban duration (e.g., 1d, 1w, 1m):"));
            this.plugin.getPlayerDataConfig().set("admin." + player.getUniqueId() + ".pending_action", (Object)"ban_duration");
            this.plugin.savePlayerDataConfig();
            player.closeInventory();
            this.plugin.pendingActions.put(player.getUniqueId(), (message, p) -> {
                String customDuration = message.trim();
                if (!customDuration.matches("\\d+[smhdwMy]")) {
                    p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-duration", "Invalid duration format! Use e.g., 1d, 1w, 1m."));
                    return;
                }
                this.plugin.getPlayerDataConfig().set("admin." + p.getUniqueId() + ".pending_ban_duration", (Object)customDuration);
                this.plugin.getPlayerDataConfig().set("admin." + p.getUniqueId() + ".pending_action", null);
                this.plugin.savePlayerDataConfig();
                this.openTemporaryBanReason((Player)p, result, customDuration);
            });
            return;
        }
        if (duration != null) {
            this.plugin.getPlayerDataConfig().set("admin." + player.getUniqueId() + ".pending_ban_duration", (Object)duration);
            this.plugin.savePlayerDataConfig();
            this.openTemporaryBanReason(player, result, duration);
        }
    }

    public void openBanReasonGUI(Player player, PlayerResult result, String duration) {
        Player targetPlayer;
        if (!player.hasPermission("playermanager.ban")) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission!"));
            return;
        }
        if (player.getUniqueId().toString().equals(result.uuid)) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.self-punish", "You can't punish yourself."));
            return;
        }
        Player player2 = targetPlayer = result.online ? Bukkit.getPlayer((String)result.uuid) : null;
        if (targetPlayer != null && targetPlayer.hasPermission("playermanager.admin")) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.cannot-target-admin", "You cannot target another admin."));
            return;
        }
        if (!this.plugin.getConfig().getBoolean("features.punishment-system", true)) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.punishment-system-disabled", "Punishment system is disabled!"));
            return;
        }
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)this.plugin.getMessage("gui.ban-reason-title", "Select Ban Reason"));
        this.setLastOpenedMenu(player.getUniqueId(), "ban_reason");
        this.setLastTarget(player.getUniqueId(), result.name);
        this.setPlayerMenuTarget(player.getUniqueId(), result);
        ItemStack griefingItem = new ItemStack(Material.TNT);
        ItemMeta griefingMeta = griefingItem.getItemMeta();
        if (griefingMeta != null) {
            griefingMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.reason.griefing", "Griefing"));
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.click-to-ban", "Click to ban for griefing"));
            griefingMeta.setLore(lore);
            griefingItem.setItemMeta(griefingMeta);
        }
        this.inventory.setItem(10, griefingItem);
        ItemStack cheatingItem = new ItemStack(Material.DIAMOND_SWORD);
        ItemMeta cheatingMeta = cheatingItem.getItemMeta();
        if (cheatingMeta != null) {
            cheatingMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.reason.cheating", "Cheating"));
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.click-to-ban", "Click to ban for cheating"));
            cheatingMeta.setLore(lore);
            cheatingItem.setItemMeta(cheatingMeta);
        }
        this.inventory.setItem(11, cheatingItem);
        ItemStack spamItem = new ItemStack(Material.BOOK);
        ItemMeta spamMeta = spamItem.getItemMeta();
        if (spamMeta != null) {
            spamMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.reason.spam", "Spam"));
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.click-to-ban", "Click to ban for spam"));
            spamMeta.setLore(lore);
            spamItem.setItemMeta(spamMeta);
        }
        this.inventory.setItem(12, spamItem);
        ItemStack customItem = new ItemStack(Material.WRITABLE_BOOK);
        ItemMeta customMeta = customItem.getItemMeta();
        if (customMeta != null) {
            customMeta.setDisplayName(ChatColor.GREEN + this.plugin.getMessage("gui.reason.custom", "Custom Reason"));
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.enter-custom-reason", "Enter custom reason in chat"));
            customMeta.setLore(lore);
            customItem.setItemMeta(customMeta);
        }
        this.inventory.setItem(14, customItem);
        ItemStack backItem = new ItemStack(Material.ARROW);
        ItemMeta backMeta = backItem.getItemMeta();
        if (backMeta != null) {
            backMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("gui.back", "Back"));
            backItem.setItemMeta(backMeta);
        }
        this.inventory.setItem(22, backItem);
        this.playersInGUI.add(player.getUniqueId());
        player.openInventory(this.inventory);
        player.updateInventory();
    }

    private void handleBanReasonClick(Player player, int slot, InventoryClickEvent event) {
        PlayerResult result = this.playerMenuTargets.get(player.getUniqueId());
        if (result == null) {
            this.plugin.getLogger().warning("No PlayerResult found for player " + player.getName());
            return;
        }
        if (player.getUniqueId().toString().equals(result.uuid)) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.self-punish", "You can't punish yourself."));
            return;
        }
        if (slot == 22) {
            this.openBanTypeGUI(player, result);
            return;
        }
        String reason = null;
        if (slot == 10) {
            reason = "griefing";
        } else if (slot == 11) {
            reason = "cheating";
        } else if (slot == 12) {
            reason = "spam";
        } else if (slot == 14) {
            reason = "custom";
        }
        if (reason == null) {
            return;
        }
        if (reason.equals("custom")) {
            player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.enter-reason", "Enter reason in chat"));
            this.plugin.getPlayerDataConfig().set("admin." + player.getUniqueId() + ".pending_action", (Object)"ban");
            this.plugin.savePlayerDataConfig();
            player.closeInventory();
            this.plugin.pendingActions.put(player.getUniqueId(), (message, p) -> {
                String customReason = message.trim();
                String command = "ban " + result.name + " " + customReason;
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    Bukkit.dispatchCommand((CommandSender)p, (String)command);
                    p.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.executed", "Executed: %command% for %player%").replace("%command%", "ban").replace("%player%", result.name));
                    this.updatePlayerBanStatus(result.uuid, true);
                    this.plugin.getPlayerDataConfig().set("admin." + p.getUniqueId() + ".pending_action", null);
                    this.plugin.getPlayerDataConfig().set("admin." + p.getUniqueId() + ".ban_type", null);
                    this.plugin.savePlayerDataConfig();
                    this.openPunishmentGUI((Player)p, result);
                });
            });
        } else {
            String command = "ban " + result.name + " " + reason;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                Bukkit.dispatchCommand((CommandSender)player, (String)command);
                player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.executed", "Executed: %command% for %player%").replace("%command%", "ban").replace("%player%", result.name));
                this.updatePlayerBanStatus(result.uuid, true);
                this.plugin.getPlayerDataConfig().set("admin." + player.getUniqueId() + ".ban_type", null);
                this.plugin.savePlayerDataConfig();
                this.openPunishmentGUI(player, result);
            });
        }
        this.refreshOpenGUIs();
    }

    private void openMuteReasonGUI(Player player, PlayerResult result, String duration) {
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)(this.plugin.getMessage("gui.mute-reason-title", "Mute Reason: ") + result.name));
        ItemStack[] reasons = new ItemStack[6];
        String[] reasonKeys = new String[]{"insult", "spam_flood", "advertising", "conflict_incitement", "cyberbullying", "custom"};
        String[] materials = new String[]{"REDSTONE", "SLIME_BALL", "OAK_SIGN", "BLAZE_POWDER", "GHAST_TEAR", "PAPER"};
        int[] slots = new int[]{10, 11, 12, 14, 15, 16};
        for (int i = 0; i < reasons.length; ++i) {
            reasons[i] = new ItemStack(Material.valueOf((String)materials[i]));
            ItemMeta meta = reasons[i].getItemMeta();
            if (meta != null) {
                meta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("mute.reason." + reasonKeys[i], reasonKeys[i]));
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.actions-lmb", "LMB: Select reason"));
                meta.setLore(lore);
                reasons[i].setItemMeta(meta);
            }
            this.inventory.setItem(slots[i], reasons[i]);
        }
        ItemStack back = new ItemStack(Material.ARROW);
        ItemMeta backMeta = back.getItemMeta();
        if (backMeta != null) {
            backMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getMessage("gui.back", "Back")));
            back.setItemMeta(backMeta);
        }
        this.inventory.setItem(22, back);
        player.openInventory(this.inventory);
        this.setLastOpenedMenu(player.getUniqueId(), "mute_reason");
        this.setPlayerMenuTarget(player.getUniqueId(), result);
        this.setLastTarget(player.getUniqueId(), result.name);
        this.plugin.getPlayerDataConfig().set("players." + result.uuid + ".pending_mute_duration", (Object)duration);
        this.plugin.savePlayerMenuState(player);
    }

    private void openWarnReasonGUI(Player player, PlayerResult result, String duration) {
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)(this.plugin.getMessage("gui.warn-reason-title", "Warn Reason: ") + result.name));
        ItemStack[] reasons = new ItemStack[5];
        String[] reasonKeys = new String[]{"griefing", "disrespect_staff", "chat_rule_violation", "private_message_advertising", "custom"};
        String[] materials = new String[]{"TNT", "IRON_SWORD", "PAPER", "BOOK", "PAPER"};
        int[] slots = new int[]{10, 11, 12, 14, 15};
        for (int i = 0; i < reasons.length; ++i) {
            reasons[i] = new ItemStack(Material.valueOf((String)materials[i]));
            ItemMeta meta = reasons[i].getItemMeta();
            if (meta != null) {
                meta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("warn.reason." + reasonKeys[i], reasonKeys[i]));
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.actions-lmb", "LMB: Select reason"));
                meta.setLore(lore);
                reasons[i].setItemMeta(meta);
            }
            this.inventory.setItem(slots[i], reasons[i]);
        }
        ItemStack back = new ItemStack(Material.ARROW);
        ItemMeta backMeta = back.getItemMeta();
        if (backMeta != null) {
            backMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getMessage("gui.back", "Back")));
            back.setItemMeta(backMeta);
        }
        this.inventory.setItem(22, back);
        player.openInventory(this.inventory);
        this.setLastOpenedMenu(player.getUniqueId(), "warn_reason");
        this.setPlayerMenuTarget(player.getUniqueId(), result);
        this.setLastTarget(player.getUniqueId(), result.name);
        this.plugin.getPlayerDataConfig().set("players." + result.uuid + ".pending_warn_duration", (Object)duration);
        this.plugin.savePlayerMenuState(player);
    }

    private void openKickReasonGUI(Player player, PlayerResult result) {
        if (!result.online) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.player-offline", "Player is offline. Kick requires online player."));
            return;
        }
        Inventory kickReasonGUI = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)(this.plugin.getMessage("gui.kick-reason-prefix", "Kick Reason: ") + ChatColor.YELLOW + result.name));
        ItemStack headItem = this.createPlayerHead(result);
        kickReasonGUI.setItem(4, headItem);
        ItemStack spamItem = new ItemStack(Material.PAPER);
        ItemMeta spamMeta = spamItem.getItemMeta();
        spamMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.reason-spam", "Spam/Advertising"));
        spamItem.setItemMeta(spamMeta);
        kickReasonGUI.setItem(10, spamItem);
        ItemStack disrespectItem = new ItemStack(Material.ROTTEN_FLESH);
        ItemMeta disrespectMeta = disrespectItem.getItemMeta();
        disrespectMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.reason-disrespect", "Disrespect Staff"));
        disrespectItem.setItemMeta(disrespectMeta);
        kickReasonGUI.setItem(11, disrespectItem);
        ItemStack griefingItem = new ItemStack(Material.TNT);
        ItemMeta griefingMeta = griefingItem.getItemMeta();
        griefingMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.reason-griefing", "Griefing"));
        griefingItem.setItemMeta(griefingMeta);
        kickReasonGUI.setItem(12, griefingItem);
        ItemStack customReasonItem = new ItemStack(Material.PAPER);
        ItemMeta customReasonMeta = customReasonItem.getItemMeta();
        customReasonMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("gui.custom-reason", "Custom Reason"));
        ArrayList<String> customLore = new ArrayList<String>();
        customLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.enter-in-chat", "Enter in chat"));
        customReasonMeta.setLore(customLore);
        customReasonItem.setItemMeta(customReasonMeta);
        kickReasonGUI.setItem(14, customReasonItem);
        ItemStack backItem = new ItemStack(Material.ARROW);
        ItemMeta backMeta = backItem.getItemMeta();
        backMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.back", "Back"));
        backItem.setItemMeta(backMeta);
        kickReasonGUI.setItem(22, backItem);
        player.openInventory(kickReasonGUI);
        this.setPlayerMenuTarget(player.getUniqueId(), result);
        this.setLastOpenedMenu(player.getUniqueId(), "kick_reason");
        this.setLastTarget(player.getUniqueId(), result.name);
        this.plugin.savePlayerMenuState(player);
    }

    private void handleKickReasonClick(Player player, int slot, InventoryClickEvent event) {
        PlayerResult result = this.playerMenuTargets.get(player.getUniqueId());
        if (result == null) {
            this.plugin.getLogger().warning("No PlayerResult found for player " + player.getName());
            return;
        }
        if (player.getUniqueId().toString().equals(result.uuid)) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.self-punish", "You can't punish yourself."));
            return;
        }
        if (!result.online) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.player-offline", "Player is offline. Kick requires online player."));
            return;
        }
        if (slot == 22) {
            this.openPunishmentGUI(player, result);
            return;
        }
        String reason = null;
        if (slot == 10) {
            reason = "spam_advertising";
        } else if (slot == 11) {
            reason = "disrespect_staff";
        } else if (slot == 12) {
            reason = "griefing";
        } else if (slot == 14) {
            reason = "custom";
        }
        if (reason == null) {
            return;
        }
        if ("custom".equals(reason)) {
            player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.enter-reason", "Enter kick reason in chat"));
            this.plugin.getPlayerDataConfig().set("players." + result.uuid + ".pending_action", (Object)"kick_reason");
            this.plugin.savePlayerDataConfig();
            player.closeInventory();
            this.plugin.pendingActions.put(player.getUniqueId(), (message, p) -> {
                String customReason = message.trim();
                if (customReason.isEmpty()) {
                    p.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-reason", "Reason cannot be empty!"));
                    return;
                }
                this.executeKick((Player)p, result, customReason);
            });
            return;
        }
        this.executeKick(player, result, reason);
    }

    private void executeKick(Player player, PlayerResult result, String reason) {
        String command = "kick " + result.name + " " + reason;
        Bukkit.dispatchCommand((CommandSender)player, (String)command);
        player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.executed", "Executed: %command% for %player%").replace("%command%", "kick").replace("%player%", result.name));
        this.plugin.getPlayerDataConfig().set("players." + result.uuid + ".pending_action", null);
        this.plugin.savePlayerDataConfig();
        this.openPunishmentGUI(player, result);
        this.refreshOpenGUIs();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!(event.getInventory().getHolder() instanceof PlayerSearchGUI)) {
            return;
        }
        event.setCancelled(true);
        if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        String currentMenu = this.lastOpenedMenu.getOrDefault(player.getUniqueId(), "search");
        int slot = event.getSlot();
        if (currentMenu.equals("search")) {
            PlayerResult result;
            Long lastClick;
            long currentTime = System.currentTimeMillis();
            if (currentTime - (lastClick = this.lastFilterClick.getOrDefault(player.getUniqueId(), 0L)) < 500L && (slot == 47 || slot == 48 || slot == 50 || slot == 51)) {
                player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.wait", "Please wait before switching filters again!"));
                return;
            }
            this.lastFilterClick.put(player.getUniqueId(), currentTime);
            if (slot == 0) {
                Long lastRefresh = this.lastRefreshClick.getOrDefault(player.getUniqueId(), 0L);
                if (currentTime - lastRefresh < 1000L) {
                    player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.wait", "Please wait before updating again!"));
                    return;
                }
                this.lastRefreshClick.put(player.getUniqueId(), currentTime);
                player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("gui.refreshing", "Updating player list..."));
                this.cachedResults.clear();
                this.unfilteredResults.clear();
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                    List<PlayerResult> results = this.getSearchResults(player, this.currentSearch);
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        if (player.isOnline() && this.playersInGUI.contains(player.getUniqueId())) {
                            this.setupSearchGUI(player, results);
                            player.updateInventory();
                            player.sendMessage(ChatColor.GREEN + this.plugin.getMessage("gui.refreshed", "List updated"));
                        }
                    });
                });
                return;
            }
            if (slot == 1 && player.hasPermission("playermanager.ip-search")) {
                player.closeInventory();
                this.ipGUI.openIPSearchGUI(player);
                return;
            }
            if (slot == 4) {
                if (event.getClick() == ClickType.LEFT) {
                    player.closeInventory();
                    String cancelText = this.plugin.getMessage("gui.cancel", "[Cancel]");
                    TextComponent message = new TextComponent(ChatColor.YELLOW + this.plugin.getMessage("gui.enter-search", "Enter name to search: ") + " ");
                    TextComponent cancel = new TextComponent(ChatColor.RED + cancelText);
                    cancel.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/playermanager reset"));
                    message.addExtra((BaseComponent)cancel);
                    player.spigot().sendMessage((BaseComponent)message);
                    this.pendingActions.put(player.getUniqueId(), (msg, p) -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        String input = ChatColor.stripColor((String)msg.trim());
                        String cancelTextRu = ChatColor.stripColor((String)this.plugin.getMessage("gui.cancel", "[Cancel]").replaceAll("[\\[\\]]", ""));
                        String cancelTextEn = "Cancel";
                        if (input.equalsIgnoreCase(cancelTextRu) || input.equalsIgnoreCase(cancelTextEn)) {
                            this.resetSearch(p);
                            return;
                        }
                        this.currentSearch = input;
                        this.currentPage = 0;
                        this.lastPage.put(p.getUniqueId(), 0);
                        this.cachedResults.clear();
                        p.openInventory(this.inventory);
                        this.playersInGUI.add(p.getUniqueId());
                        this.setLastOpenedMenu(p.getUniqueId(), "search");
                        this.plugin.savePlayerMenuState(p);
                        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                            List<PlayerResult> results = this.getSearchResults(p, this.currentSearch);
                            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                                if (p.isOnline() && this.playersInGUI.contains(p.getUniqueId())) {
                                    this.setupSearchGUI(p, results);
                                    p.updateInventory();
                                    this.pendingActions.remove(p.getUniqueId());
                                }
                            });
                        });
                    }));
                } else if (event.getClick() == ClickType.RIGHT) {
                    this.resetSearch(player);
                }
                return;
            }
            if (slot == 45 && this.currentPage > 0) {
                this.currentPage = event.getClick() == ClickType.SHIFT_RIGHT ? Math.max(0, this.currentPage - 5) : --this.currentPage;
                this.lastPage.put(player.getUniqueId(), this.currentPage);
                this.setupSearchGUI(player, this.applyFilter(this.unfilteredResults));
                player.updateInventory();
            } else if (slot == 53 && (this.currentPage + 1) * 36 < this.unfilteredResults.size()) {
                this.currentPage = event.getClick() == ClickType.SHIFT_RIGHT ? Math.min((int)Math.ceil((double)this.unfilteredResults.size() / 36.0) - 1, this.currentPage + 5) : ++this.currentPage;
                this.lastPage.put(player.getUniqueId(), this.currentPage);
                this.setupSearchGUI(player, this.applyFilter(this.unfilteredResults));
                player.updateInventory();
            } else if (slot == 47) {
                this.currentFilter = Filter.ALL;
                this.setupSearchGUI(player, this.applyFilter(this.unfilteredResults));
                player.updateInventory();
            } else if (slot == 48) {
                this.currentFilter = Filter.ONLINE;
                this.setupSearchGUI(player, this.applyFilter(this.unfilteredResults));
                player.updateInventory();
            } else if (slot == 50) {
                this.currentFilter = Filter.OFFLINE;
                this.setupSearchGUI(player, this.applyFilter(this.unfilteredResults));
                player.updateInventory();
            } else if (slot == 51) {
                this.currentFilter = Filter.BANNED;
                this.setupSearchGUI(player, this.applyFilter(this.unfilteredResults));
                player.updateInventory();
            } else if (slot == 49) {
                player.closeInventory();
                this.playersInGUI.remove(player.getUniqueId());
            } else if (slot >= 9 && slot < 45 && (result = this.slotMap.get(slot)) != null) {
                if (event.getClick() == ClickType.LEFT) {
                    this.openPlayerMenu(player, result);
                } else if (event.getClick() == ClickType.RIGHT) {
                    Player target;
                    if (result.online && this.getConfigValue("features.player-teleportation") && (target = Bukkit.getPlayer((UUID)UUID.fromString(result.uuid))) != null) {
                        player.teleport(target.getLocation());
                        player.sendMessage(ChatColor.GREEN + this.plugin.getMessage("action.teleported", "Teleport to %player%").replace("%player%", result.name));
                    }
                } else if (event.getClick() == ClickType.SHIFT_RIGHT) {
                    this.openPunishmentGUI(player, result);
                }
            }
        } else if (currentMenu.equals("player")) {
            this.handlePlayerMenuClick(player, slot, event);
        } else if (currentMenu.equals("punishment")) {
            this.handlePunishmentClick(player, slot, event);
        } else if (currentMenu.equals("player_info")) {
            this.handlePlayerInfoClick(player, slot, event);
        } else if (currentMenu.equals("gamemode")) {
            this.handleGamemodeClick(player, slot, event);
        } else if (currentMenu.equals("gamemode_confirm")) {
            this.handleGamemodeConfirmClick(player, slot, event);
        } else if (currentMenu.equals("ban_type")) {
            this.handleBanTypeClick(player, slot, event);
        } else if (currentMenu.equals("ban_duration")) {
            this.handleBanDurationClick(player, slot, event);
        } else if (currentMenu.equals("ban_reason")) {
            this.handleTemporaryBanReasonClick(player, slot, event);
        }
    }

    private void handleSearchClick(Player player, int slot, InventoryClickEvent event) {
        if (!player.hasPermission("playermanager.admin") && !player.hasPermission("playermanager.gui")) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission!"));
            return;
        }
        if (slot == 1) {
            if (!this.getConfigValue("features.ip-search")) {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.ip-search-disabled", "IP search is disabled!"));
                return;
            }
            this.ipGUI.openIPSearchGUI(player);
            return;
        }
        if (slot == 4) {
            if (event.getClick() == ClickType.LEFT) {
                player.closeInventory();
                String cancelText = this.plugin.getMessage("gui.cancel", "[Cancel]");
                TextComponent message = new TextComponent(ChatColor.YELLOW + this.plugin.getMessage("gui.enter-search", "Enter name to search: ") + " ");
                TextComponent cancel = new TextComponent(ChatColor.RED + cancelText);
                cancel.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/pm reset"));
                message.addExtra((BaseComponent)cancel);
                player.spigot().sendMessage((BaseComponent)message);
                this.pendingActions.put(player.getUniqueId(), (msg, p) -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    String input = ChatColor.stripColor((String)msg.trim());
                    String cancelTextRu = ChatColor.stripColor((String)this.plugin.getMessage("gui.cancel", "[Cancel]").replaceAll("[\\[\\]]", ""));
                    String cancelTextEn = "Cancel";
                    if (input.equalsIgnoreCase(cancelTextRu) || input.equalsIgnoreCase(cancelTextEn)) {
                        this.resetSearch(p);
                        return;
                    }
                    this.currentSearch = input;
                    this.currentPage = 0;
                    this.lastPage.put(p.getUniqueId(), 0);
                    this.cachedResults.clear();
                    this.unfilteredResults.clear();
                    this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)this.plugin.getMessage("gui.title", "Player Management"));
                    final ItemStack loadingItem = new ItemStack(Material.REDSTONE);
                    ItemMeta loadingMeta = loadingItem.getItemMeta();
                    if (loadingMeta != null) {
                        loadingMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("gui.loading", "Loading..."));
                        ArrayList<String> lore = new ArrayList<String>();
                        lore.add(ChatColor.GRAY + "Please wait...");
                        loadingMeta.setLore(lore);
                        loadingItem.setItemMeta(loadingMeta);
                    }
                    this.inventory.setItem(4, loadingItem);
                    p.openInventory(this.inventory);
                    this.playersInGUI.add(p.getUniqueId());
                    this.setLastOpenedMenu(p.getUniqueId(), "search");
                    this.plugin.savePlayerMenuState(p);
                    BukkitRunnable loadingAnimation = new BukkitRunnable(){
                        int dots = 0;

                        public void run() {
                            if (!p.isOnline() || !PlayerSearchGUI.this.playersInGUI.contains(p.getUniqueId())) {
                                this.cancel();
                                return;
                            }
                            this.dots = (this.dots + 1) % 4;
                            StringBuilder dotString = new StringBuilder(ChatColor.YELLOW + PlayerSearchGUI.this.plugin.getMessage("gui.loading", "Loading"));
                            for (int i = 0; i < this.dots; ++i) {
                                dotString.append(".");
                            }
                            ItemMeta meta = loadingItem.getItemMeta();
                            if (meta != null) {
                                meta.setDisplayName(dotString.toString());
                                loadingItem.setItemMeta(meta);
                            }
                            PlayerSearchGUI.this.inventory.setItem(4, loadingItem);
                            p.updateInventory();
                        }
                    };
                    loadingAnimation.runTaskTimer((Plugin)this.plugin, 0L, 10L);
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                        List<PlayerResult> results = this.getSearchResults(p, this.currentSearch);
                        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                            if (p.isOnline() && this.playersInGUI.contains(p.getUniqueId())) {
                                loadingAnimation.cancel();
                                this.setupSearchGUI(p, results);
                                p.updateInventory();
                                this.pendingActions.remove(p.getUniqueId());
                                if (results.isEmpty()) {
                                    p.sendMessage(ChatColor.RED + this.plugin.getMessage("gui.no-results", "No players found for query: " + input));
                                }
                            } else {
                                loadingAnimation.cancel();
                            }
                        });
                    });
                }));
            } else if (event.getClick() == ClickType.RIGHT) {
                this.resetSearch(player);
            }
            return;
        }
        if (slot == 0) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                List<PlayerResult> results = this.getSearchResults(player, this.currentSearch);
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (player.isOnline() && this.playersInGUI.contains(player.getUniqueId())) {
                        this.setupSearchGUI(player, results);
                        player.updateInventory();
                    }
                });
            });
        } else {
            PlayerResult result;
            if (slot == 45 && this.currentPage > 0) {
                long lastChange;
                long currentTime = System.currentTimeMillis();
                if (currentTime - (lastChange = this.lastPageChangeTime.getOrDefault(player.getUniqueId(), 0L).longValue()) < 1000L) {
                    return;
                }
                this.lastPageChangeTime.put(player.getUniqueId(), currentTime);
                this.currentPage = event.getClick() == ClickType.SHIFT_RIGHT ? Math.max(0, this.currentPage - 5) : --this.currentPage;
                this.lastPage.put(player.getUniqueId(), this.currentPage);
                List<PlayerResult> results = this.cachedResults.isEmpty() ? this.getSearchResults(player, this.currentSearch) : this.cachedResults;
                this.setupSearchGUI(player, results);
                player.updateInventory();
                this.plugin.savePlayerMenuState(player);
                return;
            }
            if (slot == 53) {
                boolean hasNextPage;
                long lastChange;
                long currentTime = System.currentTimeMillis();
                if (currentTime - (lastChange = this.lastPageChangeTime.getOrDefault(player.getUniqueId(), 0L).longValue()) < 1000L) {
                    return;
                }
                this.lastPageChangeTime.put(player.getUniqueId(), currentTime);
                List<PlayerResult> results = this.cachedResults.isEmpty() ? this.getSearchResults(player, this.currentSearch) : this.cachedResults;
                boolean bl = hasNextPage = (this.currentPage + 1) * 36 < results.size();
                if (hasNextPage) {
                    this.currentPage = event.getClick() == ClickType.SHIFT_RIGHT ? Math.min(this.currentPage + 5, (int)Math.ceil((double)results.size() / 36.0) - 1) : ++this.currentPage;
                    this.lastPage.put(player.getUniqueId(), this.currentPage);
                    this.setupSearchGUI(player, results);
                    player.updateInventory();
                    this.plugin.savePlayerMenuState(player);
                }
                return;
            }
            if (slot == 47) {
                this.currentFilter = Filter.ALL;
                this.currentPage = 0;
                this.lastPage.put(player.getUniqueId(), 0);
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                    List<PlayerResult> results = this.getSearchResults(player, this.currentSearch);
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        if (player.isOnline() && this.playersInGUI.contains(player.getUniqueId())) {
                            this.setupSearchGUI(player, results);
                            player.updateInventory();
                        }
                    });
                });
            } else if (slot == 48) {
                this.currentFilter = Filter.ONLINE;
                this.currentPage = 0;
                this.lastPage.put(player.getUniqueId(), 0);
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                    List<PlayerResult> results = this.getSearchResults(player, this.currentSearch);
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        if (player.isOnline() && this.playersInGUI.contains(player.getUniqueId())) {
                            this.setupSearchGUI(player, results);
                            player.updateInventory();
                        }
                    });
                });
            } else if (slot == 50) {
                this.currentFilter = Filter.OFFLINE;
                this.currentPage = 0;
                this.lastPage.put(player.getUniqueId(), 0);
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                    List<PlayerResult> results = this.getSearchResults(player, this.currentSearch);
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        if (player.isOnline() && this.playersInGUI.contains(player.getUniqueId())) {
                            this.setupSearchGUI(player, results);
                            player.updateInventory();
                        }
                    });
                });
            } else if (slot == 51) {
                this.currentFilter = Filter.BANNED;
                this.currentPage = 0;
                this.lastPage.put(player.getUniqueId(), 0);
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                    List<PlayerResult> results = this.getSearchResults(player, this.currentSearch);
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        if (player.isOnline() && this.playersInGUI.contains(player.getUniqueId())) {
                            this.setupSearchGUI(player, results);
                            player.updateInventory();
                        }
                    });
                });
            } else if (slot == 49) {
                player.closeInventory();
                this.playersInGUI.remove(player.getUniqueId());
                this.pendingActions.remove(player.getUniqueId());
            } else if (slot >= 9 && slot <= 44 && (result = this.slotMap.get(slot)) != null) {
                if (event.getClick() == ClickType.LEFT) {
                    this.openPlayerMenu(player, result);
                } else if (event.getClick() == ClickType.RIGHT) {
                    Player target;
                    if (result.online && this.getConfigValue("features.player-teleportation") && (target = Bukkit.getPlayer((UUID)UUID.fromString(result.uuid))) != null) {
                        player.teleport(target.getLocation());
                        player.sendMessage(ChatColor.GREEN + this.plugin.getMessage("action.teleported", "Teleported to %player%").replace("%player%", result.name));
                    }
                } else if (event.getClick() == ClickType.SHIFT_RIGHT) {
                    this.openPunishmentGUI(player, result);
                }
            }
        }
    }

    private void handlePlayerMenuClick(Player player, int slot, InventoryClickEvent event) {
        PlayerResult result = this.playerMenuTargets.get(player.getUniqueId());
        if (result == null) {
            this.plugin.getLogger().warning("No PlayerResult found for player " + player.getName());
            return;
        }
        if (player.getUniqueId().toString().equals(result.uuid)) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.self-punish", "You can't punish yourself."));
            return;
        }
        if (slot == 22) {
            this.openSearchGUI(player);
            return;
        }
        if (slot == 10) {
            return;
        }
        if (slot == 11) {
            if (!this.getConfigValue("features.player-teleportation")) {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.teleport-disabled", "Teleportation is disabled!"));
                return;
            }
            if (!result.online) {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.player-offline", "Player is offline."));
                return;
            }
            Bukkit.dispatchCommand((CommandSender)player, (String)("tp " + result.name));
            player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.executed", "Executed: %command% for %player%").replace("%command%", "tp").replace("%player%", result.name));
            player.closeInventory();
        } else if (slot == 12) {
            if (!this.getConfigValue("features.punishment-system")) {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.punishment-system-disabled", "Punishment system is disabled!"));
                return;
            }
            this.openPunishmentGUI(player, result);
        } else if (slot == 14) {
            if (!this.getConfigValue("features.inventory-inspection")) {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.inventory-inspection-disabled", "Inventory inspection is disabled!"));
                return;
            }
            if (!result.online) {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.player-offline", "Player is offline."));
                return;
            }
            Player target = Bukkit.getPlayer((String)result.name);
            if (target != null) {
                player.openInventory((Inventory)target.getInventory());
            }
        } else if (slot == 15) {
            if (!this.getConfigValue("features.ender-chest-inspection")) {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.ender-chest-inspection-disabled", "Ender chest inspection is disabled!"));
                return;
            }
            if (!result.online) {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.player-offline", "Player is offline."));
                return;
            }
            Player target = Bukkit.getPlayer((String)result.name);
            if (target != null) {
                player.openInventory(target.getEnderChest());
            }
        } else if (slot == 16) {
            if (!this.getConfigValue("features.player-info-actions")) {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.player-info-disabled", "Player info actions are disabled!"));
                return;
            }
            if (!result.online) {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.player-offline", "Player is offline."));
                return;
            }
            this.openPlayerInfoGUI(player, result);
        }
        this.refreshOpenGUIs();
    }

    private void handlePunishmentClick(Player player, int slot, InventoryClickEvent event) {
        PlayerResult result = this.playerMenuTargets.get(player.getUniqueId());
        if (result == null) {
            this.plugin.getLogger().warning("No PlayerResult found for player " + player.getName());
            return;
        }
        if (player.getUniqueId().toString().equals(result.uuid)) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.self-punish", "You can't punish yourself."));
            return;
        }
        if (slot == 22) {
            this.openPlayerMenu(player, result);
            return;
        }
        int index = -1;
        if (slot == 10) {
            index = 0;
        } else if (slot == 11) {
            index = 1;
        } else if (slot == 12) {
            index = 2;
        } else if (slot == 14) {
            index = 3;
        } else if (slot == 15) {
            index = 4;
        } else if (slot == 16) {
            index = 5;
        }
        if (index == -1) {
            return;
        }
        String command = null;
        switch (index) {
            case 0: {
                command = "ban";
                break;
            }
            case 1: {
                command = "kick";
                break;
            }
            case 2: {
                command = "jail";
                break;
            }
            case 3: {
                command = "warn";
                break;
            }
            case 4: {
                command = "mute";
                break;
            }
            case 5: {
                command = "unban";
            }
        }
        boolean needsSave = false;
        String path = "players." + result.uuid + ".";
        if (event.getClick() == ClickType.LEFT) {
            if (index == 5) {
                Bukkit.dispatchCommand((CommandSender)player, (String)(command + " " + result.name));
                player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.executed", "Executed: %command% for %player%").replace("%command%", command).replace("%player%", result.name));
                result.banned = false;
                this.plugin.getPlayerDataConfig().set(path + "banned", (Object)false);
                needsSave = true;
                this.openPunishmentGUI(player, result);
            } else if (index == 0) {
                if (result.banned) {
                    player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.already-banned", "This player is already banned!"));
                    return;
                }
                this.openBanTypeGUI(player, result);
            } else if (index == 1) {
                if (!result.online) {
                    player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.player-offline", "Player is offline."));
                    return;
                }
                this.openKickReasonGUI(player, result);
            } else if (index == 2) {
                if (!result.online) {
                    player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.player-offline", "Player is offline."));
                    return;
                }
                this.openJailGUI(player, result);
            } else if (index == 3) {
                if (!result.online) {
                    player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.player-offline", "Player is offline."));
                    return;
                }
                this.openWarnDurationGUI(player, result);
            } else if (index == 4) {
                if (!result.online) {
                    player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.player-offline", "Player is offline."));
                    return;
                }
                this.openMuteDurationGUI(player, result);
            }
        } else if (event.getClick() == ClickType.SHIFT_RIGHT && index != 5) {
            if (!result.online && index != 0) {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.player-offline", "Player is offline."));
                return;
            }
            if (index == 0 && result.banned) {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.already-banned", "This player is already banned!"));
                return;
            }
            String reason = "Punished by admin";
            String fullCommand = command + " " + result.name + (index == 0 || index == 1 ? " " + reason : "");
            if (index == 0 && !this.isTempPunishPluginInstalled()) {
                fullCommand = "ban " + result.name + " " + reason;
            } else if (index == 0) {
                fullCommand = "tempban " + result.name + " 1d " + reason;
            }
            Bukkit.dispatchCommand((CommandSender)player, (String)fullCommand);
            player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.executed-quick", "Quick %command% executed for %player%").replace("%command%", command).replace("%player%", result.name));
            if (index == 0) {
                result.banned = true;
                this.plugin.getPlayerDataConfig().set(path + "banned", (Object)true);
                needsSave = true;
            }
            this.openPunishmentGUI(player, result);
        }
        if (needsSave) {
            this.plugin.savePlayerDataConfig();
        }
        this.refreshOpenGUIs();
    }

    private void handleJailClick(Player player, int slot, InventoryClickEvent event) {
        PlayerResult result = this.playerMenuTargets.get(player.getUniqueId());
        if (result == null) {
            this.plugin.getLogger().warning("No PlayerResult found for player " + player.getName());
            return;
        }
        if (player.getUniqueId().toString().equals(result.uuid)) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.self-punish", "You can't punish yourself."));
            return;
        }
        if (slot == 22) {
            this.openPunishmentGUI(player, result);
            return;
        }
        String command = null;
        if (slot == 12) {
            command = "jail";
        } else if (slot == 14) {
            command = "unjail";
            return;
        }
        if (event.getClick() == ClickType.LEFT) {
            if (slot == 14) {
                Player target = Bukkit.getPlayer((String)result.name);
                if (target == null) {
                    player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.player-offline", "Player is offline."));
                    return;
                }
                Bukkit.dispatchCommand((CommandSender)player, (String)(command + " " + result.name));
                player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.executed", "Executed: %command% for %player%").replace("%command%", command).replace("%player%", result.name));
            } else {
                if (!result.online) {
                    player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.player-offline", "Player is offline."));
                    return;
                }
                TextComponent msg = new TextComponent(ChatColor.YELLOW + "/" + command + " " + result.name + " ");
                msg.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/" + command + " " + result.name + " "));
                player.spigot().sendMessage((BaseComponent)msg);
                player.sendMessage(ChatColor.GRAY + this.plugin.getMessage("action.click-to-copy", "Click to copy"));
                player.closeInventory();
            }
        } else if (event.getClick() == ClickType.SHIFT_RIGHT && slot == 12) {
            if (!result.online) {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.player-offline", "Player is offline."));
                return;
            }
            Bukkit.dispatchCommand((CommandSender)player, (String)(command + " " + result.name));
            player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.executed", "Executed: %command% for %player%").replace("%command%", command).replace("%player%", result.name));
            player.closeInventory();
            return;
        }
        if (slot != 14) {
            this.openJailGUI(player, result);
        }
        this.refreshOpenGUIs();
    }

    private void handlePlayerInfoClick(Player player, int slot, InventoryClickEvent event) {
        PlayerResult result = this.playerMenuTargets.get(player.getUniqueId());
        if (result == null) {
            this.plugin.getLogger().warning("No PlayerResult found for player " + player.getName());
            return;
        }
        if (player.getUniqueId().toString().equals(result.uuid)) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.self-punish", "You can't punish yourself."));
            return;
        }
        if (slot == 22) {
            this.openPlayerMenu(player, result);
            return;
        }
        if (!(result.online || slot != 10 && slot != 12 && slot != 14 && slot != 16)) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.player-offline", "Player is offline."));
            return;
        }
        if (slot == 12) {
            Player target = Bukkit.getPlayer((String)result.name);
            if (target == null) {
                return;
            }
            Bukkit.dispatchCommand((CommandSender)player, (String)("heal " + result.name));
            player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.executed", "Executed: %command% for %player%").replace("%command%", "heal").replace("%player%", result.name));
            this.openPlayerInfoGUI(player, result);
            return;
        }
        if (slot == 14) {
            Player target = Bukkit.getPlayer((String)result.name);
            if (target == null) {
                return;
            }
            Bukkit.dispatchCommand((CommandSender)player, (String)("kill " + result.name));
            player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.executed", "Executed: %command% for %player%").replace("%command%", "kill").replace("%player%", result.name));
            this.openPlayerInfoGUI(player, result);
            return;
        }
        if (slot == 18) {
            this.openGamemodeGUI(player, result);
            return;
        }
    }

    private void handleGamemodeClick(Player player, int slot, InventoryClickEvent event) {
        PlayerResult result = this.playerMenuTargets.get(player.getUniqueId());
        if (result == null) {
            this.plugin.getLogger().warning("No PlayerResult found for player " + player.getName());
            return;
        }
        if (player.getUniqueId().toString().equals(result.uuid)) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.self-punish", "You can't punish yourself."));
            return;
        }
        if (slot == 22) {
            this.openPlayerInfoGUI(player, result);
            return;
        }
        if (!result.online) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.player-offline", "Player is offline."));
            return;
        }
        String gamemode = null;
        if (slot == 10) {
            gamemode = "survival";
        } else {
            if (slot == 12) {
                this.openGamemodeConfirmGUI(player, result);
                return;
            }
            if (slot == 14) {
                gamemode = "adventure";
            } else if (slot == 16) {
                gamemode = "spectator";
            }
        }
        if (gamemode != null) {
            Bukkit.dispatchCommand((CommandSender)player, (String)("gamemode " + gamemode + " " + result.name));
            player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.executed", "Executed: %command% for %player%").replace("%command%", "gamemode " + gamemode).replace("%player%", result.name));
            this.openPlayerInfoGUI(player, result);
        }
    }

    private void handleGamemodeConfirmClick(Player player, int slot, InventoryClickEvent event) {
        PlayerResult result = this.playerMenuTargets.get(player.getUniqueId());
        if (result == null) {
            this.plugin.getLogger().warning("No PlayerResult found for player " + player.getName());
            return;
        }
        if (player.getUniqueId().toString().equals(result.uuid)) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.self-punish", "You can't punish yourself."));
            return;
        }
        if (slot == 22) {
            this.openGamemodeGUI(player, result);
            return;
        }
        if (slot == 11) {
            if (!result.online) {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.player-offline", "Player is offline."));
                return;
            }
            Bukkit.dispatchCommand((CommandSender)player, (String)("gamemode creative " + result.name));
            player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.executed", "Executed: %command% for %player%").replace("%command%", "gamemode creative").replace("%player%", result.name));
            this.openPlayerInfoGUI(player, result);
            return;
        }
        if (slot == 15) {
            this.openGamemodeGUI(player, result);
            return;
        }
    }

    private void handleMuteDurationClick(final Player player, int slot, InventoryClickEvent event) {
        final PlayerResult result = this.playerMenuTargets.get(player.getUniqueId());
        if (result == null) {
            this.plugin.getLogger().warning("No PlayerResult found for player " + player.getName());
            return;
        }
        if (player.getUniqueId().toString().equals(result.uuid)) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.self-punish", "You can't punish yourself."));
            return;
        }
        if (slot == 22) {
            this.openPunishmentGUI(player, result);
            return;
        }
        String duration = null;
        if (slot == 10) {
            duration = "1h";
        } else if (slot == 11) {
            duration = "12h";
        } else if (slot == 12) {
            duration = "1d";
        } else if (slot == 13) {
            duration = "3d";
        } else if (slot == 14) {
            duration = "7d";
        } else if (slot == 15) {
            duration = "14d";
        } else if (slot == 16) {
            duration = "permanent";
        } else if (slot == 17) {
            duration = "custom";
        }
        if (duration == null) {
            return;
        }
        if (duration.equals("custom")) {
            player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.enter-duration", "Enter duration in chat (e.g., 2d, 5h, permanent)"));
            this.plugin.getPlayerDataConfig().set("players." + result.uuid + ".pending_action", (Object)"mute_duration");
            this.plugin.savePlayerDataConfig();
            player.closeInventory();
            new BukkitRunnable(){

                public void run() {
                    Bukkit.getPluginManager().registerEvents(new Listener(){

                        @EventHandler
                        public void onPlayerChat(AsyncPlayerChatEvent chatEvent) {
                            if (chatEvent.getPlayer().equals((Object)player)) {
                                String customDuration = chatEvent.getMessage();
                                chatEvent.setCancelled(true);
                                if (!customDuration.matches("\\d+[smhdw]|permanent")) {
                                    player.sendMessage(ChatColor.RED + PlayerSearchGUI.this.plugin.getMessage("error.invalid-duration", "Invalid duration format! Use e.g., 1h, 2d, permanent"));
                                    PlayerSearchGUI.this.plugin.getPlayerDataConfig().set("players." + result.uuid + ".pending_action", null);
                                    PlayerSearchGUI.this.plugin.savePlayerDataConfig();
                                    HandlerList.unregisterAll((Listener)this);
                                    PlayerSearchGUI.this.openMuteDurationGUI(player, result);
                                    return;
                                }
                                Bukkit.getScheduler().runTask((Plugin)PlayerSearchGUI.this.plugin, () -> {
                                    PlayerSearchGUI.this.plugin.getPlayerDataConfig().set("players." + result.uuid + ".pending_mute_duration", (Object)customDuration);
                                    PlayerSearchGUI.this.plugin.getPlayerDataConfig().set("players." + result.uuid + ".pending_action", null);
                                    PlayerSearchGUI.this.plugin.savePlayerDataConfig();
                                    PlayerSearchGUI.this.openMuteReasonGUI(player, result, customDuration);
                                });
                                HandlerList.unregisterAll((Listener)this);
                            }
                        }
                    }, (Plugin)PlayerSearchGUI.this.plugin);
                }
            }.runTaskLater((Plugin)this.plugin, 1L);
        } else {
            this.plugin.getPlayerDataConfig().set("players." + result.uuid + ".pending_mute_duration", (Object)duration);
            this.plugin.savePlayerDataConfig();
            this.openMuteReasonGUI(player, result, duration);
        }
        this.refreshOpenGUIs();
    }

    private void handleWarnDurationClick(final Player player, int slot, InventoryClickEvent event) {
        final PlayerResult result = this.playerMenuTargets.get(player.getUniqueId());
        if (result == null) {
            this.plugin.getLogger().warning("No PlayerResult found for player " + player.getName());
            return;
        }
        if (player.getUniqueId().toString().equals(result.uuid)) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.self-punish", "You can't punish yourself."));
            return;
        }
        if (slot == 22) {
            this.openPunishmentGUI(player, result);
            return;
        }
        String duration = null;
        if (slot == 10) {
            duration = "1h";
        } else if (slot == 11) {
            duration = "12h";
        } else if (slot == 12) {
            duration = "1d";
        } else if (slot == 13) {
            duration = "3d";
        } else if (slot == 14) {
            duration = "7d";
        } else if (slot == 15) {
            duration = "14d";
        } else if (slot == 16) {
            duration = "permanent";
        } else if (slot == 17) {
            duration = "custom";
        }
        if (duration == null) {
            return;
        }
        if (duration.equals("custom")) {
            player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.enter-duration", "Enter duration in chat (e.g., 2d, 5h, permanent)"));
            this.plugin.getPlayerDataConfig().set("players." + result.uuid + ".pending_action", (Object)"warn_duration");
            this.plugin.savePlayerDataConfig();
            player.closeInventory();
            new BukkitRunnable(){

                public void run() {
                    Bukkit.getPluginManager().registerEvents(new Listener(){

                        @EventHandler
                        public void onPlayerChat(AsyncPlayerChatEvent chatEvent) {
                            if (chatEvent.getPlayer().equals((Object)player)) {
                                String customDuration = chatEvent.getMessage();
                                chatEvent.setCancelled(true);
                                if (!customDuration.matches("\\d+[smhdw]|permanent")) {
                                    player.sendMessage(ChatColor.RED + PlayerSearchGUI.this.plugin.getMessage("error.invalid-duration", "Invalid duration format! Use e.g., 1h, 2d, permanent"));
                                    PlayerSearchGUI.this.plugin.getPlayerDataConfig().set("players." + result.uuid + ".pending_action", null);
                                    PlayerSearchGUI.this.plugin.savePlayerDataConfig();
                                    HandlerList.unregisterAll((Listener)this);
                                    PlayerSearchGUI.this.openWarnDurationGUI(player, result);
                                    return;
                                }
                                Bukkit.getScheduler().runTask((Plugin)PlayerSearchGUI.this.plugin, () -> {
                                    PlayerSearchGUI.this.plugin.getPlayerDataConfig().set("players." + result.uuid + ".pending_warn_duration", (Object)customDuration);
                                    PlayerSearchGUI.this.plugin.getPlayerDataConfig().set("players." + result.uuid + ".pending_action", null);
                                    PlayerSearchGUI.this.plugin.savePlayerDataConfig();
                                    PlayerSearchGUI.this.openWarnReasonGUI(player, result, customDuration);
                                });
                                HandlerList.unregisterAll((Listener)this);
                            }
                        }
                    }, (Plugin)PlayerSearchGUI.this.plugin);
                }
            }.runTaskLater((Plugin)this.plugin, 1L);
        } else {
            this.plugin.getPlayerDataConfig().set("players." + result.uuid + ".pending_warn_duration", (Object)duration);
            this.plugin.savePlayerDataConfig();
            this.openWarnReasonGUI(player, result, duration);
        }
        this.refreshOpenGUIs();
    }

    private void handleMuteReasonClick(final Player player, int slot, InventoryClickEvent event) {
        final PlayerResult result = this.playerMenuTargets.get(player.getUniqueId());
        if (result == null) {
            this.plugin.getLogger().warning("No PlayerResult found for player " + player.getName());
            return;
        }
        if (player.getUniqueId().toString().equals(result.uuid)) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.self-punish", "You can't punish yourself."));
            return;
        }
        if (slot == 22) {
            String duration = this.plugin.getPlayerDataConfig().getString("players." + result.uuid + ".pending_mute_duration", "permanent");
            this.openMuteDurationGUI(player, result);
            return;
        }
        String reason = null;
        if (slot == 10) {
            reason = "insult";
        } else if (slot == 11) {
            reason = "spam_flood";
        } else if (slot == 12) {
            reason = "advertising";
        } else if (slot == 14) {
            reason = "conflict_incitement";
        } else if (slot == 15) {
            reason = "cyberbullying";
        } else if (slot == 16) {
            reason = "custom";
        }
        if (reason == null) {
            return;
        }
        final String duration = this.plugin.getPlayerDataConfig().getString("players." + result.uuid + ".pending_mute_duration", "permanent");
        if (reason.equals("custom")) {
            player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.enter-reason", "Enter reason in chat"));
            this.plugin.getPlayerDataConfig().set("players." + result.uuid + ".pending_action", (Object)"mute");
            this.plugin.savePlayerDataConfig();
            player.closeInventory();
            new BukkitRunnable(){

                public void run() {
                    Bukkit.getPluginManager().registerEvents(new Listener(){

                        @EventHandler
                        public void onPlayerChat(AsyncPlayerChatEvent chatEvent) {
                            if (chatEvent.getPlayer().equals((Object)player)) {
                                String customReason = chatEvent.getMessage();
                                chatEvent.setCancelled(true);
                                String command = "mute " + result.name + " " + duration + " " + customReason;
                                Bukkit.getScheduler().runTask((Plugin)PlayerSearchGUI.this.plugin, () -> {
                                    Bukkit.dispatchCommand((CommandSender)player, (String)command);
                                    player.sendMessage(ChatColor.YELLOW + PlayerSearchGUI.this.plugin.getMessage("action.executed", "Executed: %command% for %player%").replace("%command%", "mute").replace("%player%", result.name));
                                    PlayerSearchGUI.this.plugin.getPlayerDataConfig().set("players." + result.uuid + ".pending_action", null);
                                    PlayerSearchGUI.this.plugin.getPlayerDataConfig().set("players." + result.uuid + ".pending_mute_duration", null);
                                    PlayerSearchGUI.this.plugin.savePlayerDataConfig();
                                    PlayerSearchGUI.this.openPunishmentGUI(player, result);
                                });
                                HandlerList.unregisterAll((Listener)this);
                            }
                        }
                    }, (Plugin)PlayerSearchGUI.this.plugin);
                }
            }.runTaskLater((Plugin)this.plugin, 1L);
        } else {
            String command = "mute " + result.name + " " + duration + " " + reason;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                Bukkit.dispatchCommand((CommandSender)player, (String)command);
                player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.executed", "Executed: %command% for %player%").replace("%command%", "mute").replace("%player%", result.name));
                this.plugin.getPlayerDataConfig().set("players." + result.uuid + ".pending_mute_duration", null);
                this.plugin.savePlayerDataConfig();
                this.openPunishmentGUI(player, result);
            });
        }
        this.refreshOpenGUIs();
    }

    private void handleWarnReasonClick(final Player player, int slot, InventoryClickEvent event) {
        final PlayerResult result = this.playerMenuTargets.get(player.getUniqueId());
        if (result == null) {
            this.plugin.getLogger().warning("No PlayerResult found for player " + player.getName());
            return;
        }
        if (player.getUniqueId().toString().equals(result.uuid)) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.self-punish", "You can't punish yourself."));
            return;
        }
        if (slot == 22) {
            String duration = this.plugin.getPlayerDataConfig().getString("players." + result.uuid + ".pending_warn_duration", "permanent");
            this.openWarnDurationGUI(player, result);
            return;
        }
        String reason = null;
        if (slot == 10) {
            reason = "griefing";
        } else if (slot == 11) {
            reason = "disrespect_staff";
        } else if (slot == 12) {
            reason = "chat_rule_violation";
        } else if (slot == 14) {
            reason = "private_message_advertising";
        } else if (slot == 15) {
            reason = "custom";
        }
        if (reason == null) {
            return;
        }
        final String duration = this.plugin.getPlayerDataConfig().getString("players." + result.uuid + ".pending_warn_duration", "permanent");
        if (reason.equals("custom")) {
            player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.enter-reason", "Enter reason in chat"));
            this.plugin.getPlayerDataConfig().set("players." + result.uuid + ".pending_action", (Object)"warn");
            this.plugin.savePlayerDataConfig();
            player.closeInventory();
            new BukkitRunnable(){

                public void run() {
                    Bukkit.getPluginManager().registerEvents(new Listener(){

                        @EventHandler
                        public void onPlayerChat(AsyncPlayerChatEvent chatEvent) {
                            if (chatEvent.getPlayer().equals((Object)player)) {
                                String customReason = chatEvent.getMessage();
                                chatEvent.setCancelled(true);
                                String command = "warn " + result.name + " " + duration + " " + customReason;
                                Bukkit.getScheduler().runTask((Plugin)PlayerSearchGUI.this.plugin, () -> {
                                    Bukkit.dispatchCommand((CommandSender)player, (String)command);
                                    player.sendMessage(ChatColor.YELLOW + PlayerSearchGUI.this.plugin.getMessage("action.executed", "Executed: %command% for %player%").replace("%command%", "warn").replace("%player%", result.name));
                                    PlayerSearchGUI.this.plugin.getPlayerDataConfig().set("players." + result.uuid + ".pending_action", null);
                                    PlayerSearchGUI.this.plugin.getPlayerDataConfig().set("players." + result.uuid + ".pending_warn_duration", null);
                                    PlayerSearchGUI.this.plugin.savePlayerDataConfig();
                                    PlayerSearchGUI.this.openPunishmentGUI(player, result);
                                });
                                HandlerList.unregisterAll((Listener)this);
                            }
                        }
                    }, (Plugin)PlayerSearchGUI.this.plugin);
                }
            }.runTaskLater((Plugin)this.plugin, 1L);
        } else {
            String command = "warn " + result.name + " " + duration + " " + reason;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                Bukkit.dispatchCommand((CommandSender)player, (String)command);
                player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.executed", "Executed: %command% for %player%").replace("%command%", "warn").replace("%player%", result.name));
                this.plugin.getPlayerDataConfig().set("players." + result.uuid + ".pending_warn_duration", null);
                this.plugin.savePlayerDataConfig();
                this.openPunishmentGUI(player, result);
            });
        }
        this.refreshOpenGUIs();
    }

    public void openBanTypeGUI(Player player, PlayerResult result) {
        Player targetPlayer;
        if (!player.hasPermission("playermanager.ban")) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission!"));
            return;
        }
        if (player.getUniqueId().toString().equals(result.uuid)) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.self-punish", "You can't punish yourself."));
            return;
        }
        Player player2 = targetPlayer = result.online ? Bukkit.getPlayer((String)result.uuid) : null;
        if (targetPlayer != null && targetPlayer.hasPermission("playermanager.admin")) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.cannot-target-admin", "You cannot target another admin."));
            return;
        }
        if (!this.plugin.getConfig().getBoolean("features.punishment-system", true)) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.punishment-system-disabled", "Punishment system is disabled!"));
            return;
        }
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)this.plugin.getMessage("gui.ban-type-title", "Select Ban Type"));
        this.setLastOpenedMenu(player.getUniqueId(), "ban_type");
        this.setLastTarget(player.getUniqueId(), result.name);
        this.setPlayerMenuTarget(player.getUniqueId(), result);
        ItemStack permanentItem = new ItemStack(Material.BEDROCK);
        ItemMeta permMeta = permanentItem.getItemMeta();
        if (permMeta != null) {
            permMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.permanent-ban", "Permanent Ban"));
            ArrayList<String> permLore = new ArrayList<String>();
            permLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.click-to-select", "Click to select"));
            permMeta.setLore(permLore);
            permanentItem.setItemMeta(permMeta);
        }
        this.inventory.setItem(11, permanentItem);
        ItemStack tempItem = new ItemStack(Material.CLOCK);
        ItemMeta tempMeta = tempItem.getItemMeta();
        if (tempMeta != null) {
            tempMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("gui.temporary-ban", "Temporary Ban"));
            ArrayList<String> tempLore = new ArrayList<String>();
            tempLore.add(ChatColor.GRAY + this.plugin.getMessage("gui.click-to-select", "Click to select"));
            tempMeta.setLore(tempLore);
            tempItem.setItemMeta(tempMeta);
        }
        this.inventory.setItem(15, tempItem);
        ItemStack backItem = new ItemStack(Material.ARROW);
        ItemMeta backMeta = backItem.getItemMeta();
        if (backMeta != null) {
            backMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("gui.back", "Back"));
            backItem.setItemMeta(backMeta);
        }
        this.inventory.setItem(22, backItem);
        this.playersInGUI.add(player.getUniqueId());
        player.openInventory(this.inventory);
        player.updateInventory();
    }

    private void handleBanTypeClick(Player player, int slot, InventoryClickEvent event) {
        PlayerResult result = this.playerMenuTargets.get(player.getUniqueId());
        if (result == null) {
            return;
        }
        if (slot == 11) {
            this.plugin.getPlayerDataConfig().set("admin." + player.getUniqueId() + ".ban_type", (Object)"permanent");
            this.plugin.savePlayerDataConfig();
            this.openBanReasonGUI(player, result, "permanent");
        } else if (slot == 15) {
            if (!this.isTempPunishPluginInstalled()) {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-temp-plugin", "No temporary punishment plugin installed! \u00abAdvancedBan,Litebans\u00bb"));
                return;
            }
            this.plugin.getPlayerDataConfig().set("admin." + player.getUniqueId() + ".ban_type", (Object)"temporary");
            this.plugin.savePlayerDataConfig();
            this.openBanDurationGUI(player, result);
        } else if (slot == 22) {
            this.openPunishmentGUI(player, result);
        }
    }

    public void openTemporaryBanReason(Player player, PlayerResult result, String duration) {
        Player targetPlayer;
        this.plugin.getPlayerDataConfig().set("admin." + player.getUniqueId() + ".pending_ban_duration", (Object)duration);
        this.plugin.savePlayerDataConfig();
        if (!player.hasPermission("playermanager.ban")) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission!"));
            return;
        }
        if (player.getUniqueId().toString().equals(result.uuid)) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.self-punish", "You can't punish yourself."));
            return;
        }
        Player player2 = targetPlayer = result.online ? Bukkit.getPlayer((String)result.uuid) : null;
        if (targetPlayer != null && targetPlayer.hasPermission("playermanager.admin")) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.cannot-target-admin", "You cannot target another admin."));
            return;
        }
        if (!this.plugin.getConfig().getBoolean("features.punishment-system", true)) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.punishment-system-disabled", "Punishment system is disabled!"));
            return;
        }
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)this.plugin.getMessage("gui.ban-reason-title", "Select Ban Reason"));
        this.setLastOpenedMenu(player.getUniqueId(), "ban_reason");
        this.setLastTarget(player.getUniqueId(), result.name);
        this.setPlayerMenuTarget(player.getUniqueId(), result);
        ItemStack griefingItem = new ItemStack(Material.TNT);
        ItemMeta griefingMeta = griefingItem.getItemMeta();
        if (griefingMeta != null) {
            griefingMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.reason.griefing", "Griefing"));
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.click-to-ban", "Click to ban for griefing"));
            griefingMeta.setLore(lore);
            griefingItem.setItemMeta(griefingMeta);
        }
        this.inventory.setItem(10, griefingItem);
        ItemStack cheatingItem = new ItemStack(Material.DIAMOND_SWORD);
        ItemMeta cheatingMeta = cheatingItem.getItemMeta();
        if (cheatingMeta != null) {
            cheatingMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.reason.cheating", "Cheating"));
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.click-to-ban", "Click to ban for cheating"));
            cheatingMeta.setLore(lore);
            cheatingItem.setItemMeta(cheatingMeta);
        }
        this.inventory.setItem(11, cheatingItem);
        ItemStack spamItem = new ItemStack(Material.BOOK);
        ItemMeta spamMeta = spamItem.getItemMeta();
        if (spamMeta != null) {
            spamMeta.setDisplayName(ChatColor.RED + this.plugin.getMessage("gui.reason.spam", "Spam"));
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.click-to-ban", "Click to ban for spam"));
            spamMeta.setLore(lore);
            spamItem.setItemMeta(spamMeta);
        }
        this.inventory.setItem(12, spamItem);
        ItemStack customItem = new ItemStack(Material.WRITABLE_BOOK);
        ItemMeta customMeta = customItem.getItemMeta();
        if (customMeta != null) {
            customMeta.setDisplayName(ChatColor.GREEN + this.plugin.getMessage("gui.reason.custom", "Custom Reason"));
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(ChatColor.GRAY + this.plugin.getMessage("gui.enter-custom-reason", "Enter custom reason in chat"));
            customMeta.setLore(lore);
            customItem.setItemMeta(customMeta);
        }
        this.inventory.setItem(14, customItem);
        ItemStack backItem = new ItemStack(Material.ARROW);
        ItemMeta backMeta = backItem.getItemMeta();
        if (backMeta != null) {
            backMeta.setDisplayName(ChatColor.YELLOW + this.plugin.getMessage("gui.back", "Back"));
            backItem.setItemMeta(backMeta);
        }
        this.inventory.setItem(22, backItem);
        this.playersInGUI.add(player.getUniqueId());
        player.openInventory(this.inventory);
        player.updateInventory();
    }

    private void handleTemporaryBanReasonClick(Player player, int slot, InventoryClickEvent event) {
        PlayerResult result = this.playerMenuTargets.get(player.getUniqueId());
        if (result == null) {
            this.plugin.getLogger().warning("No PlayerResult found for player " + player.getName());
            return;
        }
        if (player.getUniqueId().toString().equals(result.uuid)) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.self-punish", "You can't punish yourself."));
            return;
        }
        if (slot == 22) {
            this.openBanDurationGUI(player, result);
            return;
        }
        String reason = null;
        if (slot == 10) {
            reason = "griefing";
        } else if (slot == 11) {
            reason = "cheating";
        } else if (slot == 12) {
            reason = "spam";
        } else if (slot == 14) {
            reason = "custom";
        }
        if (reason == null) {
            return;
        }
        String duration = this.plugin.getPlayerDataConfig().getString("admin." + player.getUniqueId() + ".pending_ban_duration", "1d");
        String tempbanCommand = "tempban";
        if (reason.equals("custom")) {
            player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.enter-reason", "Enter reason in chat"));
            this.plugin.getPlayerDataConfig().set("admin." + player.getUniqueId() + ".pending_action", (Object)"tempban");
            this.plugin.savePlayerDataConfig();
            player.closeInventory();
            this.plugin.pendingActions.put(player.getUniqueId(), (message, p) -> {
                String customReason = message.trim();
                String command = tempbanCommand + " " + result.name + " " + duration + " " + customReason;
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    Bukkit.dispatchCommand((CommandSender)p, (String)command);
                    p.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.executed", "Executed: %command% for %player%").replace("%command%", tempbanCommand).replace("%player%", result.name));
                    this.updatePlayerBanStatus(result.uuid, true);
                    this.plugin.getPlayerDataConfig().set("admin." + p.getUniqueId() + ".pending_action", null);
                    this.plugin.getPlayerDataConfig().set("admin." + p.getUniqueId() + ".pending_ban_duration", null);
                    this.plugin.savePlayerDataConfig();
                    this.openPunishmentGUI((Player)p, result);
                });
            });
        } else {
            String command = tempbanCommand + " " + result.name + " " + duration + " " + reason;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                Bukkit.dispatchCommand((CommandSender)player, (String)command);
                player.sendMessage(ChatColor.YELLOW + this.plugin.getMessage("action.executed", "Executed: %command% for %player%").replace("%command%", tempbanCommand).replace("%player%", result.name));
                this.updatePlayerBanStatus(result.uuid, true);
                this.plugin.getPlayerDataConfig().set("admin." + player.getUniqueId() + ".pending_action", null);
                this.plugin.getPlayerDataConfig().set("admin." + player.getUniqueId() + ".pending_ban_duration", null);
                this.plugin.savePlayerDataConfig();
                this.openPunishmentGUI(player, result);
            });
        }
        this.refreshOpenGUIs();
    }

    private void updatePlayerBanStatus(String uuid, boolean banned) {
        PlayerResult result = this.playerMenuTargets.values().stream().filter(r -> r.uuid.equals(uuid)).findFirst().orElse(null);
        if (result != null) {
            result.banned = banned;
        }
        this.plugin.getPlayerDataConfig().set("players." + uuid + ".banned", (Object)banned);
        this.plugin.savePlayerDataConfig();
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        boolean allFeaturesDisabled;
        Player player = event.getPlayer();
        if (!player.hasPermission("playermanager.admin") && !player.hasPermission("playermanager.gui")) {
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK || event.getItem() != null) {
            return;
        }
        boolean punishmentEnabled = this.getConfigValue("features.punishment-system");
        boolean teleportEnabled = this.getConfigValue("features.player-teleportation");
        boolean inventoryEnabled = this.getConfigValue("features.inventory-inspection");
        boolean enderChestEnabled = this.getConfigValue("features.ender-chest-inspection");
        boolean playerInfoEnabled = this.getConfigValue("features.player-info-actions");
        boolean bl = allFeaturesDisabled = !punishmentEnabled && !teleportEnabled && !inventoryEnabled && !enderChestEnabled && !playerInfoEnabled;
        if (event.getAction() == Action.RIGHT_CLICK_AIR && player.isSneaking()) {
            if (allFeaturesDisabled) {
                player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.all-features-disabled", "All features are disabled in config!"));
                return;
            }
            this.openLastGUIMenu(player);
            event.setCancelled(true);
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void refreshOpenGUIs() {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            Iterator<UUID> iterator = this.playersInGUI.iterator();
            while (iterator.hasNext()) {
                UUID playerId = iterator.next();
                Player player = Bukkit.getPlayer((UUID)playerId);
                if (player == null || !player.isOnline() || !player.hasPermission("playermanager.admin") && !player.hasPermission("playermanager.gui")) {
                    iterator.remove();
                    continue;
                }
                if (player.getOpenInventory().getTopInventory().getHolder() instanceof PlayerSearchGUI) {
                    String duration;
                    List<PlayerResult> results;
                    String currentMenu = this.lastOpenedMenu.getOrDefault(player.getUniqueId(), "search");
                    PlayerResult result = this.playerMenuTargets.get(player.getUniqueId());
                    if (currentMenu.equals("search")) {
                        results = this.cachedResults.isEmpty() ? this.getSearchResults(player, this.currentSearch) : this.cachedResults;
                        this.setupSearchGUI(player, results);
                    } else if (currentMenu.equals("player") && result != null) {
                        this.openPlayerMenu(player, result);
                    } else if (currentMenu.equals("punishment") && result != null) {
                        this.openPunishmentGUI(player, result);
                    } else if (currentMenu.equals("jail") && result != null) {
                        this.openJailGUI(player, result);
                    } else if (currentMenu.equals("player_info") && result != null) {
                        this.openPlayerInfoGUI(player, result);
                    } else if (currentMenu.equals("gamemode") && result != null) {
                        this.openGamemodeGUI(player, result);
                    } else if (currentMenu.equals("gamemode_confirm") && result != null) {
                        this.openGamemodeConfirmGUI(player, result);
                    } else if (currentMenu.equals("mute_duration") && result != null) {
                        this.openMuteDurationGUI(player, result);
                    } else if (currentMenu.equals("warn_duration") && result != null) {
                        this.openWarnDurationGUI(player, result);
                    } else if (currentMenu.equals("mute_reason") && result != null) {
                        duration = this.plugin.getPlayerDataConfig().getString("players." + result.uuid + ".pending_mute_duration", "permanent");
                        this.openMuteReasonGUI(player, result, duration);
                    } else if (currentMenu.equals("warn_reason") && result != null) {
                        duration = this.plugin.getPlayerDataConfig().getString("players." + result.uuid + ".pending_warn_duration", "permanent");
                        this.openWarnReasonGUI(player, result, duration);
                    } else if (currentMenu.equals("ban_duration") && result != null) {
                        this.openBanDurationGUI(player, result);
                    } else if (currentMenu.equals("ban_reason") && result != null) {
                        duration = this.plugin.getPlayerDataConfig().getString("players." + result.uuid + ".pending_ban_duration", "permanent");
                        this.openBanReasonGUI(player, result, duration);
                    } else if (currentMenu.equals("kick_reason") && result != null) {
                        this.openKickReasonGUI(player, result);
                    } else if (currentMenu.equals("ban_type") && result != null) {
                        this.openBanTypeGUI(player, result);
                    } else {
                        this.plugin.getLogger().warning("Invalid menu state for " + player.getName() + ": " + currentMenu + ", resetting to search");
                        results = this.cachedResults.isEmpty() ? this.getSearchResults(player, this.currentSearch) : this.cachedResults;
                        this.setupSearchGUI(player, results);
                    }
                    player.updateInventory();
                    continue;
                }
                iterator.remove();
            }
        }, 1L);
    }

    public void resetSearch(Player player) {
        if (!player.hasPermission("playermanager.admin") && !player.hasPermission("playermanager.gui")) {
            player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.no-permission", "You don't have permission!"));
            return;
        }
        this.currentSearch = "";
        this.currentFilter = Filter.ALL;
        this.currentPage = 0;
        this.cachedResults.clear();
        this.unfilteredResults.clear();
        this.lastPage.put(player.getUniqueId(), 0);
        this.lastTarget.remove(player.getUniqueId());
        this.setLastOpenedMenu(player.getUniqueId(), "search");
        player.closeInventory();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            List<PlayerResult> results = this.getSearchResults(player, "");
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                if (player.isOnline()) {
                    this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)this.plugin.getMessage("gui.title", "Player Management"));
                    this.setupSearchGUI(player, results);
                    player.openInventory(this.inventory);
                    this.playersInGUI.add(player.getUniqueId());
                    player.updateInventory();
                    player.sendMessage(ChatColor.GREEN + this.plugin.getMessage("action.search-cancelled", "Search cancelled"));
                    this.pendingActions.remove(player.getUniqueId());
                    this.plugin.savePlayerMenuState(player);
                }
            });
        });
    }

    public void setPlayerMenuTarget(UUID playerId, PlayerResult result) {
        this.playerMenuTargets.put(playerId, result);
    }

    public String getLastOpenedMenu(UUID playerId) {
        return this.lastOpenedMenu.getOrDefault(playerId, "search");
    }

    public void setLastOpenedMenu(UUID playerId, String menu) {
        this.lastOpenedMenu.put(playerId, menu);
    }

    public int getLastPage(UUID playerId) {
        return this.lastPage.getOrDefault(playerId, 0);
    }

    public String getLastTarget(UUID playerId) {
        return this.lastTarget.get(playerId);
    }

    public void setLastTarget(UUID playerId, String target) {
        if (target != null) {
            this.lastTarget.put(playerId, target);
        } else {
            this.lastTarget.remove(playerId);
        }
    }

    private String formatDate(long timestamp) {
        if (timestamp == 0L) {
            return "-";
        }
        return this.dateFormat.format(new Date(timestamp));
    }

    private String formatTimeAgo(long timestamp) {
        if (timestamp == 0L) {
            return "-";
        }
        long seconds = (System.currentTimeMillis() - timestamp) / 1000L;
        if (seconds < 60L) {
            return seconds + " " + this.plugin.getMessage("time.seconds-ago", "seconds ago");
        }
        if (seconds < 3600L) {
            return seconds / 60L + " " + this.plugin.getMessage("time.minutes-ago", "minutes ago");
        }
        return seconds < 86400L ? seconds / 3600L + " " + this.plugin.getMessage("time.hours-ago", "hours ago") : seconds / 86400L + " " + this.plugin.getMessage("time.days-ago", "days ago");
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (!this.pendingActions.containsKey(playerId)) {
            return;
        }
        event.setCancelled(true);
        String message = event.getMessage().trim();
        if (message.isEmpty()) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage(ChatColor.RED + this.plugin.getMessage("error.invalid-input", "Input cannot be empty!")));
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (this.pendingActions.containsKey(playerId)) {
                this.pendingActions.get(playerId).execute(message, player);
                this.pendingActions.remove(playerId);
            } else {
                this.plugin.getLogger().warning("No pending action found for " + player.getName() + " after chat input");
            }
        });
    }

    private boolean isTempPunishPluginInstalled() {
        String[] tempPlugins = new String[]{"AdvancedBan", "LiteBans", "TempBan", "PunishmentManager", "EssentialsX"};
        boolean installed = false;
        for (String pluginName : tempPlugins) {
            if (Bukkit.getPluginManager().getPlugin(pluginName) == null) continue;
            this.plugin.getLogger().info("Temp plugin detected: " + pluginName);
            installed = true;
        }
        if (!installed) {
            this.plugin.getLogger().warning("No temp punishment plugin installed!");
        }
        return installed;
    }

    public void addPendingAction(UUID uuid, ChatAction action) {
        this.pendingActions.put(uuid, action);
    }

    public Set<UUID> getPlayersInGUI() {
        return this.playersInGUI;
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getPlayer() instanceof Player) {
            Player player = (Player)event.getPlayer();
            if (event.getInventory().getHolder() instanceof PlayerSearchGUI) {
                this.playersInGUI.remove(player.getUniqueId());
                this.pendingActions.remove(player.getUniqueId());
            }
        }
    }

    static class PlayerResult {
        String uuid;
        String name;
        long firstPlayed;
        long lastLogin;
        long lastLogout;
        boolean online;
        boolean banned;
        String headTexture;

        PlayerResult() {
        }
    }

    static enum Filter {
        ALL("COMPASS", ChatColor.YELLOW, "filter.all"),
        ONLINE("LIME_DYE", ChatColor.GREEN, "filter.online"),
        OFFLINE("GRAY_DYE", ChatColor.RED, "filter.offline"),
        BANNED("REDSTONE", ChatColor.DARK_RED, "filter.banned");

        private final String material;
        private final ChatColor color;
        private final String messageKey;

        private Filter(String material, ChatColor color, String messageKey) {
            this.material = material;
            this.color = color;
            this.messageKey = messageKey;
        }

        public Material getMaterial() {
            try {
                return Material.valueOf((String)this.material);
            }
            catch (IllegalArgumentException e) {
                return Material.STONE;
            }
        }

        public ChatColor getColor() {
            return this.color;
        }

        public String getDisplayName(PlayerManager plugin) {
            return plugin.getMessage(this.messageKey, this.name());
        }
    }

    @FunctionalInterface
    static interface ChatAction {
        public void execute(String var1, Player var2);
    }
}

