/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.data.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class ReplaceToSingleItemLootModifier
extends LootModifier {
    public static final Supplier<MapCodec<ReplaceToSingleItemLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> ReplaceToSingleItemLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)Codec.STRING.fieldOf("loot_table").forGetter(m -> m.lootTable.toString())).apply((Applicative)inst, ReplaceToSingleItemLootModifier::new)));
    private final ResourceLocation lootTable;

    public ReplaceToSingleItemLootModifier(LootItemCondition[] conditionsIn, ResourceLocation lootTable) {
        super(conditionsIn);
        this.lootTable = lootTable;
    }

    private ReplaceToSingleItemLootModifier(LootItemCondition[] conditionsIn, String lootTablePath) {
        this(conditionsIn, ResourceLocation.tryParse((String)lootTablePath));
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(@NotNull ObjectArrayList<ItemStack> generatedLoot, @NotNull LootContext context) {
        for (LootItemCondition condition : this.conditions) {
            if (condition.test((Object)context)) continue;
            return generatedLoot;
        }
        Optional lootTable1 = context.getResolver().get(Registries.LOOT_TABLE, ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)this.lootTable));
        ArrayList newLoot = new ArrayList();
        lootTable1.ifPresent(lootTableReference -> ((LootTable)lootTableReference.value()).getRandomItemsRaw(context, newLoot::add));
        if (newLoot.isEmpty()) {
            return generatedLoot;
        }
        generatedLoot.clear();
        ItemStack lootItem = (ItemStack)newLoot.get(0);
        lootItem.setCount(1);
        generatedLoot.add((Object)lootItem);
        return generatedLoot;
    }

    @NotNull
    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

