/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.voxelutopia.ultramarine.world.block.AxialBlock;
import com.voxelutopia.ultramarine.world.block.BaseBlock;
import com.voxelutopia.ultramarine.world.block.BaseBlockProperty;
import com.voxelutopia.ultramarine.world.block.BaseBlockPropertyHolder;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class BaseAxialBlock
extends Block
implements AxialBlock,
BaseBlockPropertyHolder {
    protected final BaseBlockProperty property;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;

    public BaseAxialBlock(BaseBlock block) {
        this(block.getProperty());
    }

    public BaseAxialBlock(BaseBlockProperty property) {
        super(property.properties);
        this.property = property;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)Direction.Axis.X));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{AXIS});
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)pContext.getHorizontalDirection().getAxis());
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        BlockState newState = pState;
        if (pRot == Rotation.CLOCKWISE_90 || pRot == Rotation.COUNTERCLOCKWISE_90) {
            newState = switch ((Direction.Axis)pState.getValue(AXIS)) {
                case Direction.Axis.X -> (BlockState)pState.setValue(AXIS, (Comparable)Direction.Axis.Z);
                case Direction.Axis.Z -> (BlockState)pState.setValue(AXIS, (Comparable)Direction.Axis.X);
                default -> newState;
            };
        }
        return newState;
    }

    @Override
    public BaseBlockProperty getProperty() {
        return this.property;
    }
}

