/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.mojang.serialization.MapCodec;
import com.voxelutopia.ultramarine.world.block.BaseBlock;
import com.voxelutopia.ultramarine.world.block.BaseBlockProperty;
import com.voxelutopia.ultramarine.world.block.BaseBlockPropertyHolder;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class BaseHorizontalDirectionalBlock
extends HorizontalDirectionalBlock
implements BaseBlockPropertyHolder {
    private static final MapCodec<BaseHorizontalDirectionalBlock> CODEC = BaseHorizontalDirectionalBlock.simpleCodec(BaseHorizontalDirectionalBlock::new);
    protected final BaseBlockProperty property;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public BaseHorizontalDirectionalBlock(BaseBlock block) {
        this(block.getProperty());
    }

    public BaseHorizontalDirectionalBlock(BaseBlockProperty property) {
        super(property.properties);
        this.property = property;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    private BaseHorizontalDirectionalBlock(BlockBehaviour.Properties properties) {
        this(new BaseBlockProperty(properties, BaseBlockProperty.BlockMaterial.STONE));
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING});
    }

    @Override
    public BaseBlockProperty getProperty() {
        return this.property;
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

