/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.voxelutopia.ultramarine.data.registry.BlockEntityRegistry;
import com.voxelutopia.ultramarine.data.registry.ItemRegistry;
import com.voxelutopia.ultramarine.world.block.DecorativeBlock;
import com.voxelutopia.ultramarine.world.block.entity.BlockEntityHelper;
import com.voxelutopia.ultramarine.world.block.entity.CenserBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Censer
extends DecorativeBlock
implements EntityBlock {
    private final Vec3 smokeOffset;

    public Censer(DecorativeBlock.Builder builder, Vec3 smokeOffset) {
        super(builder);
        this.smokeOffset = smokeOffset;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (stack.is((Item)ItemRegistry.INCENSE.get())) {
            if (!pPlayer.getAbilities().instabuild) {
                stack.shrink(1);
            }
            pLevel.getBlockEntity(pPos, (BlockEntityType)BlockEntityRegistry.CENSER.get()).ifPresent(entity -> entity.lightIncense(pLevel, pPos, pState));
            return ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new CenserBlockEntity(pPos, pState);
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        super.animateTick(pState, pLevel, pPos, pRandom);
        if (!pState.hasProperty((Property)LIT) || !((Boolean)pState.getValue((Property)LIT)).booleanValue()) {
            return;
        }
        if (pLevel.getGameTime() % (long)(3 - pRandom.nextInt(1)) == 0L) {
            for (int i = 0; i < 5; ++i) {
                pLevel.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (double)pPos.getX() + this.smokeOffset.x + (double)(pRandom.nextFloat() * 0.4f) - 0.2, (double)pPos.getY() + this.smokeOffset.y + (double)(pRandom.nextFloat() * 0.1f), (double)pPos.getZ() + this.smokeOffset.z + (double)(pRandom.nextFloat() * 0.4f) - 0.2, 0.0, pRandom.nextDouble() * 0.01, 0.0);
            }
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.isClientSide ? null : BlockEntityHelper.createTickerHelper(pBlockEntityType, (BlockEntityType)BlockEntityRegistry.CENSER.get(), CenserBlockEntity::tick);
    }

    @Override
    @NotNull
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState state = super.getStateForPlacement(pContext);
        return this.isLuminous() ? (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)) : state;
    }

    @Override
    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        if (this.isLuminous()) {
            return (Boolean)state.getValue((Property)LIT) != false ? 4 : 0;
        }
        return 0;
    }
}

