/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.voxelutopia.ultramarine.world.block.BaseBlockProperty;
import com.voxelutopia.ultramarine.world.block.BaseBlockPropertyHolder;
import com.voxelutopia.ultramarine.world.block.BaseDirectionalBlock;
import com.voxelutopia.ultramarine.world.block.state.ChiralBlockType;
import com.voxelutopia.ultramarine.world.block.state.ModBlockStateProperties;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class ChiralDirectionalBlock
extends BaseDirectionalBlock
implements BaseBlockPropertyHolder {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final EnumProperty<ChiralBlockType> TYPE = ModBlockStateProperties.CHIRAL_BLOCK_TYPE;
    private final BaseBlockProperty property;

    public ChiralDirectionalBlock(BaseBlockProperty property) {
        super(property);
        this.property = property;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue(TYPE, (Comparable)((Object)ChiralBlockType.LEFT)));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Direction direction = pContext.getNearestLookingDirection().getOpposite();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue(TYPE, (Comparable)((Object)this.getChiralityFromDirection(direction)));
    }

    private ChiralBlockType getChiralityFromDirection(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH, Direction.WEST -> ChiralBlockType.TOP;
            case Direction.SOUTH, Direction.EAST -> ChiralBlockType.BOTTOM;
            case Direction.UP -> ChiralBlockType.LEFT;
            case Direction.DOWN -> ChiralBlockType.RIGHT;
        };
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING});
        pBuilder.add(new Property[]{TYPE});
    }

    @Override
    public BaseBlockProperty getProperty() {
        return this.property;
    }
}

