/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.voxelutopia.ultramarine.data.registry.ItemRegistry;
import com.voxelutopia.ultramarine.data.shape.RawVoxelShape;
import com.voxelutopia.ultramarine.data.shape.ShapeFunction;
import com.voxelutopia.ultramarine.world.block.BaseBlockProperty;
import com.voxelutopia.ultramarine.world.block.DecorativeBlock;
import com.voxelutopia.ultramarine.world.block.state.ModBlockStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class HangingLantern
extends DecorativeBlock {
    public static final IntegerProperty LANTERNS = ModBlockStateProperties.LANTERNS;
    private static final RawVoxelShape POLE_NORTH_RAW = new RawVoxelShape(7.0, -16.0, 1.0, 9.0, 32.0, 3.0);
    private static final RawVoxelShape POLE_HANGING_X_RAW = new RawVoxelShape(0.0, 28.0, 7.0, 16.0, 30.0, 9.0);
    private static final VoxelShape HANGING_INTERACTION = Block.box((double)4.0, (double)-8.0, (double)4.0, (double)12.0, (double)24.0, (double)12.0);
    private static final VoxelShape POLE_NORTH = POLE_NORTH_RAW.copy().toVoxelShape();
    private static final VoxelShape POLE_WEST = POLE_NORTH_RAW.copy().rotateY(90.0f).toVoxelShape();
    private static final VoxelShape POLE_SOUTH = POLE_NORTH_RAW.copy().rotateY(180.0f).toVoxelShape();
    private static final VoxelShape POLE_EAST = POLE_NORTH_RAW.copy().rotateY(270.0f).toVoxelShape();
    private static final VoxelShape POLE_HANGING_X = POLE_HANGING_X_RAW.copy().toVoxelShape();
    private static final VoxelShape POLE_HANGING_Z = POLE_HANGING_X_RAW.copy().rotateY(90.0f).toVoxelShape();
    private static final VoxelShape HANGING_INTERACTION_X = Shapes.or((VoxelShape)HANGING_INTERACTION, (VoxelShape)POLE_HANGING_X);
    private static final VoxelShape HANGING_INTERACTION_Z = Shapes.or((VoxelShape)HANGING_INTERACTION, (VoxelShape)POLE_HANGING_Z);
    public static final ShapeFunction POLE_ONLY = ShapeFunction.cardinalRotations(new RawVoxelShape(7.0, 0.0, 1.0, 9.0, 32.0, 3.0));
    private final HangingLanternType type;

    public HangingLantern(HangingLanternType type) {
        super(DecorativeBlock.with(BaseBlockProperty.WOOD).directional().luminous());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LANTERNS, (Comparable)Integer.valueOf(1)));
        this.type = type;
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch (this.type.ordinal()) {
            case 0: {
                return switch ((Direction)pState.getValue((Property)FACING)) {
                    default -> throw new MatchException(null, null);
                    case Direction.DOWN, Direction.UP, Direction.NORTH -> POLE_NORTH;
                    case Direction.SOUTH -> POLE_SOUTH;
                    case Direction.WEST -> POLE_WEST;
                    case Direction.EAST -> POLE_EAST;
                };
            }
            case 1: {
                return switch ((Direction)pState.getValue((Property)FACING)) {
                    default -> throw new MatchException(null, null);
                    case Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH -> POLE_HANGING_X;
                    case Direction.WEST, Direction.EAST -> POLE_HANGING_Z;
                };
            }
        }
        return Shapes.empty();
    }

    public VoxelShape getInteractionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        switch (this.type.ordinal()) {
            case 0: {
                this.getShape(pState, pLevel, pPos, CollisionContext.empty());
                break;
            }
            case 1: {
                return switch ((Direction)pState.getValue((Property)FACING)) {
                    default -> throw new MatchException(null, null);
                    case Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH -> HANGING_INTERACTION_X;
                    case Direction.WEST, Direction.EAST -> HANGING_INTERACTION_Z;
                };
            }
        }
        return super.getInteractionShape(pState, pLevel, pPos);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        int lanterns = (Integer)pState.getValue((Property)LANTERNS);
        if (stack.is((Item)ItemRegistry.SMALL_RED_LANTERN.get()) && lanterns < 3) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)LANTERNS, (Comparable)Integer.valueOf(lanterns + 1)), 3);
            if (!pPlayer.isCreative()) {
                stack.shrink(1);
            }
            return ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide());
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    @NotNull
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState state = super.getStateForPlacement(pContext);
        return (BlockState)((BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)LANTERNS, (Comparable)Integer.valueOf(1));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{LANTERNS});
    }

    public static enum HangingLanternType {
        POLE,
        HANGING;

    }
}

