/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.google.common.collect.ImmutableMap;
import com.voxelutopia.ultramarine.world.block.state.ModBlockStateProperties;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public interface SnowRoofRidge {
    public static final IntegerProperty SNOW_LAYERS = ModBlockStateProperties.SNOW_LAYERS;
    public static final ImmutableMap<Integer, Integer> SNOW_STAGES = ImmutableMap.ofEntries((Map.Entry[])new Map.Entry[]{Map.entry(0, 0), Map.entry(1, 0), Map.entry(2, 1), Map.entry(3, 1), Map.entry(4, 1), Map.entry(5, 2), Map.entry(6, 2), Map.entry(7, 2), Map.entry(8, 3), Map.entry(9, 3), Map.entry(10, 3), Map.entry(11, 4), Map.entry(12, 4), Map.entry(13, 4), Map.entry(14, 5), Map.entry(15, 5)});
    public static final int MAX_SNOW_STAGES = 5;

    default public void handleSnow(BlockState pState, Level pLevel, BlockPos pPos) {
        if (!pLevel.isClientSide()) {
            int snow = (Integer)pState.getValue((Property)SNOW_LAYERS);
            BlockState newState = (BlockState)pState.setValue((Property)SNOW_LAYERS, (Comparable)Integer.valueOf(Math.min(15, ++snow)));
            pLevel.setBlockAndUpdate(pPos, newState);
        }
    }

    default public void handleSnow(BlockState pState, LevelAccessor pLevel, BlockPos pPos) {
        if (!pLevel.isClientSide()) {
            int snow = (Integer)pState.getValue((Property)SNOW_LAYERS);
            BlockState newState = (BlockState)pState.setValue((Property)SNOW_LAYERS, (Comparable)Integer.valueOf(Math.min(15, ++snow)));
            pLevel.setBlock(pPos, newState, 3);
        }
    }

    default public void removeSnow(BlockState pState, Level pLevel, BlockPos pPos) {
        if (!pLevel.isClientSide()) {
            int snow = (Integer)pState.getValue((Property)SNOW_LAYERS);
            BlockState newState = (BlockState)pState.setValue((Property)SNOW_LAYERS, (Comparable)Integer.valueOf(Math.max(0, --snow)));
            pLevel.setBlockAndUpdate(pPos, newState);
        }
    }

    default public InteractionResult use(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack item = pPlayer.getItemInHand(pHand);
        if (item.is(Items.SNOWBALL)) {
            this.handleSnow(pState, pLevel, pPos);
            if (!pPlayer.isCreative()) {
                item.shrink(1);
            }
            return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
        }
        if (item.getItem() instanceof ShovelItem) {
            this.removeSnow(pState, pLevel, pPos);
            if (!pPlayer.isCreative()) {
                item.hurtAndBreak(1, (LivingEntity)pPlayer, LivingEntity.getSlotForHand((InteractionHand)pHand));
            }
            return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public DyeColor getColor();

    public RoofRidgeType getType();

    public static enum RoofRidgeType implements StringRepresentable
    {
        UPPER("roof_ridge_upper"),
        LOWER("roof_ridge_lower"),
        CONNECTION("roof_ridge_connection"),
        MAIN_CONNECTION("main_roof_ridge_connection");

        String name;

        private RoofRidgeType(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

