/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.client.integration.jade;

import com.voxelutopia.ultramarine.world.block.entity.BrickKilnBlockEntity;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.ui.ProgressArrowElement;

public enum BrickKilnComponent implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;

    public static final ResourceLocation BRICK_KILN;

    public void appendTooltip(ITooltip tooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        CompoundTag data = blockAccessor.getServerData();
        if (data.m_128441_("CookTime")) {
            int progress = data.m_128451_("CookTime");
            ListTag items = data.m_128437_("Items", 10);
            NonNullList inventory = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
            for (int i = 0; i < items.size(); ++i) {
                inventory.set(i, (Object)ItemStack.m_41712_((CompoundTag)items.m_128728_(i)));
            }
            IElementHelper helper = IElementHelper.get();
            int total = data.m_128451_("CookTimeTotal");
            tooltip.add(helper.item((ItemStack)inventory.get(0)));
            tooltip.append(helper.item((ItemStack)inventory.get(1)));
            tooltip.append(helper.item((ItemStack)inventory.get(2)));
            tooltip.append((IElement)new ProgressArrowElement((float)progress / (float)total));
            tooltip.append(helper.item((ItemStack)inventory.get(3)));
        }
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
        BrickKilnBlockEntity kiln = (BrickKilnBlockEntity)blockAccessor.getBlockEntity();
        CombinedInvWrapper inv = kiln.wrapHandlers();
        ItemStack primary = inv.getStackInSlot(0);
        ItemStack secondary = inv.getStackInSlot(1);
        ItemStack fuel = inv.getStackInSlot(2);
        ItemStack result = inv.getStackInSlot(3);
        if (primary.m_41619_() && secondary.m_41619_() && fuel.m_41619_() && result.m_41619_()) {
            return;
        }
        ListTag items = new ListTag();
        items.add((Object)primary.m_41739_(new CompoundTag()));
        items.add((Object)secondary.m_41739_(new CompoundTag()));
        items.add((Object)fuel.m_41739_(new CompoundTag()));
        items.add((Object)result.m_41739_(new CompoundTag()));
        compoundTag.m_128365_("Items", (Tag)items);
        CompoundTag kilnTag = kiln.m_187482_();
        compoundTag.m_128405_("CookTime", kilnTag.m_128451_("CookTime"));
        compoundTag.m_128405_("CookTimeTotal", kilnTag.m_128451_("CookTimeTotal"));
    }

    public ResourceLocation getUid() {
        return BRICK_KILN;
    }

    static {
        BRICK_KILN = new ResourceLocation("ultramarine", "brick_kiln");
    }
}

