/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.client.integration.jei;

import com.voxelutopia.ultramarine.Ultramarine;
import com.voxelutopia.ultramarine.client.integration.jei.ChiselTableRecipeCategory;
import com.voxelutopia.ultramarine.client.integration.jei.CompositeSmeltingRecipeCategory;
import com.voxelutopia.ultramarine.client.integration.jei.TravellingMerchantCategory;
import com.voxelutopia.ultramarine.client.integration.jei.TravellingMerchantWrapper;
import com.voxelutopia.ultramarine.client.integration.jei.WoodworkingRecipeCategory;
import com.voxelutopia.ultramarine.client.screen.BrickKilnScreen;
import com.voxelutopia.ultramarine.client.screen.ChiselTableScreen;
import com.voxelutopia.ultramarine.data.registry.BlockRegistry;
import com.voxelutopia.ultramarine.data.registry.RecipeTypeRegistry;
import com.voxelutopia.ultramarine.world.entity.TravellingMerchant;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.slf4j.Logger;

@JeiPlugin
public class UltramarineJEIPlugin
implements IModPlugin {
    public static final ResourceLocation JEI_GUI_VANILLA = new ResourceLocation("jei", "textures/gui/gui_vanilla.png");
    private static final Logger LOGGER = Ultramarine.getLogger();

    public UltramarineJEIPlugin() {
        LOGGER.info("JEI Integration Loaded");
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("ultramarine", "jei_plugin");
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(BrickKilnScreen.class, 78, 32, 28, 23, new RecipeType[]{CompositeSmeltingRecipeCategory.COMPOSITE_SMELTING_RECIPE_TYPE});
        registration.addRecipeClickArea(ChiselTableScreen.class, 79, 24, 18, 30, new RecipeType[]{ChiselTableRecipeCategory.CHISEL_TABLE_RECIPE_TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new WoodworkingRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CompositeSmeltingRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ChiselTableRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new TravellingMerchantCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        List woodworkingRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.WOODWORKING.get());
        registration.addRecipes(WoodworkingRecipeCategory.WOODWORKING_RECIPE_TYPE, woodworkingRecipes);
        List compositeSmeltingRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.COMPOSITE_SMELTING.get());
        registration.addRecipes(CompositeSmeltingRecipeCategory.COMPOSITE_SMELTING_RECIPE_TYPE, compositeSmeltingRecipes);
        List chiselTableRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.CHISEL_TABLE.get());
        registration.addRecipes(ChiselTableRecipeCategory.CHISEL_TABLE_RECIPE_TYPE, chiselTableRecipes);
        List<TravellingMerchantWrapper> customWanderingTraderTrades = TravellingMerchant.getTradeOptions().stream().map(TravellingMerchantWrapper::new).toList();
        registration.addRecipes(TravellingMerchantCategory.CUSTOM_WANDERING_TRADER_WRAPPER_RECIPE_TYPE, customWanderingTraderTrades);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.WOODWORKING_WORKBENCH.get()), new RecipeType[]{WoodworkingRecipeCategory.WOODWORKING_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.BRICK_KILN.get()), new RecipeType[]{CompositeSmeltingRecipeCategory.COMPOSITE_SMELTING_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.CHISEL_TABLE.get()), new RecipeType[]{ChiselTableRecipeCategory.CHISEL_TABLE_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.TEAHOUSE_FLAG.get()), new RecipeType[]{TravellingMerchantCategory.CUSTOM_WANDERING_TRADER_WRAPPER_RECIPE_TYPE});
    }
}

