/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.voxelutopia.ultramarine.data.recipe.WoodworkingRecipe;
import com.voxelutopia.ultramarine.world.block.menu.WoodworkingWorkbenchMenu;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class WoodworkingWorkbenchScreen
extends AbstractContainerScreen<WoodworkingWorkbenchMenu> {
    private static final ResourceLocation BG_LOCATION = new ResourceLocation("minecraft", "textures/gui/container/stonecutter.png");
    private static final int SCROLLER_WIDTH = 12;
    private static final int SCROLLER_HEIGHT = 15;
    private static final int RECIPES_COLUMNS = 4;
    private static final int RECIPES_ROWS = 3;
    private static final int RECIPES_IMAGE_SIZE_WIDTH = 16;
    private static final int RECIPES_IMAGE_SIZE_HEIGHT = 18;
    private static final int SCROLLER_FULL_HEIGHT = 54;
    private static final int RECIPES_X = 52;
    private static final int RECIPES_Y = 14;
    private float scrollOffs;
    private boolean scrolling;
    private int startIndex;
    private boolean displayRecipes;

    public WoodworkingWorkbenchScreen(WoodworkingWorkbenchMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        pMenu.registerUpdateListener(this::containerChanged);
        --this.f_97729_;
    }

    public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
        this.m_280072_(guiGraphics, pMouseX, pMouseY);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float pPartialTick, int pX, int pY) {
        this.m_280273_(guiGraphics);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BG_LOCATION);
        int i = this.f_97735_;
        int j = this.f_97736_;
        guiGraphics.m_280218_(BG_LOCATION, i, j, 0, 0, this.f_97726_, this.f_97727_);
        int k = (int)(41.0f * this.scrollOffs);
        guiGraphics.m_280218_(BG_LOCATION, i + 119, j + 15 + k, 176 + (this.isScrollBarActive() ? 0 : 12), 0, 12, 15);
        int l = this.f_97735_ + 52;
        int i1 = this.f_97736_ + 14;
        int j1 = this.startIndex + 12;
        this.renderButtons(guiGraphics, pX, pY, l, i1, j1);
        this.renderRecipes(guiGraphics, l, i1, j1);
    }

    protected void m_280072_(GuiGraphics guiGraphics, int pX, int pY) {
        super.m_280072_(guiGraphics, pX, pY);
        if (this.displayRecipes) {
            int i = this.f_97735_ + 52;
            int j = this.f_97736_ + 14;
            int k = this.startIndex + 12;
            List<WoodworkingRecipe> list = ((WoodworkingWorkbenchMenu)this.f_97732_).getRecipes();
            for (int l = this.startIndex; l < k && l < ((WoodworkingWorkbenchMenu)this.f_97732_).getNumRecipes(); ++l) {
                int i1 = l - this.startIndex;
                int j1 = i + i1 % 4 * 16;
                int k1 = j + i1 / 4 * 18 + 2;
                if (pX < j1 || pX >= j1 + 16 || pY < k1 || pY >= k1 + 18) continue;
                guiGraphics.m_280153_(this.f_96547_, list.get(l).m_8043_(this.f_96541_.f_91073_.m_9598_()), pX, pY);
            }
        }
    }

    private void renderButtons(GuiGraphics guiGraphics, int pMouseX, int pMouseY, int pX, int pY, int pLastVisibleElementIndex) {
        for (int i = this.startIndex; i < pLastVisibleElementIndex && i < ((WoodworkingWorkbenchMenu)this.f_97732_).getNumRecipes(); ++i) {
            int j = i - this.startIndex;
            int k = pX + j % 4 * 16;
            int l = j / 4;
            int i1 = pY + l * 18 + 2;
            int j1 = this.f_97727_;
            if (i == ((WoodworkingWorkbenchMenu)this.f_97732_).getSelectedRecipeIndex()) {
                j1 += 18;
            } else if (pMouseX >= k && pMouseY >= i1 && pMouseX < k + 16 && pMouseY < i1 + 18) {
                j1 += 36;
            }
            guiGraphics.m_280218_(BG_LOCATION, k, i1 - 1, 0, j1, 16, 18);
        }
    }

    private void renderRecipes(GuiGraphics guiGraphics, int pLeft, int pTop, int pRecipeIndexOffsetMax) {
        List<WoodworkingRecipe> list = ((WoodworkingWorkbenchMenu)this.f_97732_).getRecipes();
        for (int i = this.startIndex; i < pRecipeIndexOffsetMax && i < ((WoodworkingWorkbenchMenu)this.f_97732_).getNumRecipes(); ++i) {
            int j = i - this.startIndex;
            int k = pLeft + j % 4 * 16;
            int l = j / 4;
            int i1 = pTop + l * 18 + 2;
            guiGraphics.m_280480_(list.get(i).m_8043_(this.f_96541_.f_91073_.m_9598_()), k, i1);
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        this.scrolling = false;
        if (this.displayRecipes) {
            int i = this.f_97735_ + 52;
            int j = this.f_97736_ + 14;
            int k = this.startIndex + 12;
            for (int l = this.startIndex; l < k; ++l) {
                int i1 = l - this.startIndex;
                double d0 = pMouseX - (double)(i + i1 % 4 * 16);
                double d1 = pMouseY - (double)(j + i1 / 4 * 18);
                if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 16.0) || !(d1 < 18.0) || !((WoodworkingWorkbenchMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, l)) continue;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                this.f_96541_.f_91072_.m_105208_(((WoodworkingWorkbenchMenu)this.f_97732_).f_38840_, l);
                return true;
            }
            i = this.f_97735_ + 119;
            j = this.f_97736_ + 9;
            if (pMouseX >= (double)i && pMouseX < (double)(i + 12) && pMouseY >= (double)j && pMouseY < (double)(j + 54)) {
                this.scrolling = true;
            }
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.f_97736_ + 14;
            int j = i + 54;
            this.scrollOffs = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 4;
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            float f = (float)pDelta / (float)i;
            this.scrollOffs = Mth.m_14036_((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.displayRecipes && ((WoodworkingWorkbenchMenu)this.f_97732_).getNumRecipes() > 12;
    }

    protected int getOffscreenRows() {
        return (((WoodworkingWorkbenchMenu)this.f_97732_).getNumRecipes() + 4 - 1) / 4 - 3;
    }

    private void containerChanged() {
        this.displayRecipes = ((WoodworkingWorkbenchMenu)this.f_97732_).hasInputItem();
        if (!this.displayRecipes) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
    }
}

