/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.data.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class ReplaceToSingleItemLootModifier
extends LootModifier {
    public static final Supplier<Codec<ReplaceToSingleItemLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> ReplaceToSingleItemLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)Codec.STRING.fieldOf("loot_table").forGetter(m -> m.lootTable.toString())).apply((Applicative)inst, ReplaceToSingleItemLootModifier::new)));
    private final ResourceLocation lootTable;

    public ReplaceToSingleItemLootModifier(LootItemCondition[] conditionsIn, ResourceLocation lootTable) {
        super(conditionsIn);
        this.lootTable = lootTable;
    }

    private ReplaceToSingleItemLootModifier(LootItemCondition[] conditionsIn, String lootTablePath) {
        this(conditionsIn, ResourceLocation.m_135820_((String)lootTablePath));
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        for (LootItemCondition condition : this.conditions) {
            if (condition.test((Object)context)) continue;
            return generatedLoot;
        }
        LootTable lootTable1 = context.m_278643_().m_278676_(this.lootTable);
        ArrayList newLoot = new ArrayList();
        lootTable1.m_79131_(context, newLoot::add);
        if (newLoot.isEmpty()) {
            return generatedLoot;
        }
        generatedLoot.clear();
        ItemStack lootItem = (ItemStack)newLoot.get(0);
        lootItem.m_41764_(1);
        generatedLoot.add((Object)lootItem);
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

