/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.data.shape;

import com.google.common.collect.Maps;
import com.voxelutopia.ultramarine.data.shape.RawVoxelShape;
import com.voxelutopia.ultramarine.world.block.state.ModBlockStateProperties;
import com.voxelutopia.ultramarine.world.block.state.OrientableBlockType;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;

public class ShapeFunction
implements Function<BlockState, VoxelShape> {
    private static final Map<Pair<Direction, Direction>, Integer> ROTATIONS = Map.of(Pair.of((Object)Direction.NORTH, (Object)Direction.EAST), 135, Pair.of((Object)Direction.EAST, (Object)Direction.NORTH), 135, Pair.of((Object)Direction.EAST, (Object)Direction.SOUTH), 45, Pair.of((Object)Direction.SOUTH, (Object)Direction.EAST), 45, Pair.of((Object)Direction.SOUTH, (Object)Direction.WEST), 315, Pair.of((Object)Direction.WEST, (Object)Direction.SOUTH), 315, Pair.of((Object)Direction.WEST, (Object)Direction.NORTH), 225, Pair.of((Object)Direction.NORTH, (Object)Direction.WEST), 225);
    private final Function<BlockState, VoxelShape> processFunction;
    private final Map<BlockState, VoxelShape> cache = Maps.newConcurrentMap();

    private ShapeFunction(Function<BlockState, VoxelShape> processFunction) {
        this.processFunction = processFunction;
    }

    @Override
    public VoxelShape apply(BlockState state) {
        return this.cache.computeIfAbsent(state, this.processFunction);
    }

    public static ShapeFunction of(Function<BlockState, VoxelShape> processFunction) {
        return new ShapeFunction(processFunction);
    }

    public static ShapeFunction or(ShapeFunction a, ShapeFunction b) {
        return new ShapeFunction(state -> Shapes.m_83110_((VoxelShape)a.apply((BlockState)state), (VoxelShape)b.apply((BlockState)state)));
    }

    public static ShapeFunction or(ShapeFunction a, ShapeFunction ... b) {
        return Arrays.stream(b).reduce(a, ShapeFunction::or);
    }

    public static ShapeFunction exclude(ShapeFunction a, ShapeFunction b) {
        return new ShapeFunction(state -> Shapes.m_83113_((VoxelShape)a.apply((BlockState)state), (VoxelShape)b.apply((BlockState)state), (BooleanOp)BooleanOp.f_82685_));
    }

    public static ShapeFunction eightRotations(RawVoxelShape northShape) {
        return ShapeFunction.eightRotations(northShape, 0.0f);
    }

    public static ShapeFunction eightRotations(RawVoxelShape northShape, float diagonalRotationOffset) {
        return new ShapeFunction(state -> {
            Direction shiftDir;
            Direction primaryDir = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            if (primaryDir == (shiftDir = (Direction)state.m_61143_((Property)ModBlockStateProperties.HORIZONTAL_FACING_SHIFT))) {
                return switch (primaryDir) {
                    default -> throw new IncompatibleClassChangeError();
                    case Direction.UP, Direction.DOWN -> Shapes.m_83040_();
                    case Direction.NORTH -> northShape.copy().toVoxelShape();
                    case Direction.SOUTH -> northShape.copy().rotateY(180.0f).toVoxelShape();
                    case Direction.WEST -> northShape.copy().rotateY(90.0f).toVoxelShape();
                    case Direction.EAST -> northShape.copy().rotateY(270.0f).toVoxelShape();
                };
            }
            if (ROTATIONS.containsKey(Pair.of((Object)primaryDir, (Object)shiftDir))) {
                return northShape.copy().rotateY((float)ROTATIONS.get(Pair.of((Object)primaryDir, (Object)shiftDir)).intValue() + diagonalRotationOffset).toVoxelShape();
            }
            return northShape.copy().toVoxelShape();
        });
    }

    public static ShapeFunction cardinalRotations(RawVoxelShape northShape) {
        return new ShapeFunction(state -> {
            Direction direction = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            return switch (direction) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.UP, Direction.DOWN -> Shapes.m_83040_();
                case Direction.NORTH -> northShape.copy().toVoxelShape();
                case Direction.SOUTH -> northShape.copy().rotateY(180.0f).toVoxelShape();
                case Direction.WEST -> northShape.copy().rotateY(90.0f).toVoxelShape();
                case Direction.EAST -> northShape.copy().rotateY(270.0f).toVoxelShape();
            };
        });
    }

    public static ShapeFunction axialRotations(RawVoxelShape xShape) {
        return new ShapeFunction(state -> {
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61364_);
            return switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> xShape.copy().toVoxelShape();
                case Direction.Axis.Y -> Shapes.m_83040_();
                case Direction.Axis.Z -> xShape.copy().rotateY(90.0f).toVoxelShape();
            };
        });
    }

    public static ShapeFunction centeredSquare(float side, float height) {
        float d = (16.0f - side) / 2.0f;
        return ShapeFunction.simpleShape(Block.m_49796_((double)d, (double)0.0, (double)d, (double)(16.0f - d), (double)height, (double)(16.0f - d)));
    }

    public static ShapeFunction centeredSquare(int side, int height) {
        return ShapeFunction.centeredSquare((float)side, (float)height);
    }

    public static ShapeFunction diagonalSquare(float side, float height) {
        return new ShapeFunction(state -> {
            boolean diagonal = (Boolean)state.m_61143_((Property)ModBlockStateProperties.DIAGONAL);
            float s = diagonal ? side * Mth.f_13994_ : side;
            float d = (16.0f - s) / 2.0f;
            return Block.m_49796_((double)d, (double)0.0, (double)d, (double)(16.0f - d), (double)height, (double)(16.0f - d));
        });
    }

    public static ShapeFunction diagonalSquare(int side, int height) {
        return ShapeFunction.diagonalSquare((float)side, (float)height);
    }

    public static ShapeFunction diagonal(RawVoxelShape normalShape) {
        return new ShapeFunction(state -> {
            boolean diagonal = (Boolean)state.m_61143_((Property)ModBlockStateProperties.DIAGONAL);
            return diagonal ? normalShape.copy().rotateY(45.0f).toVoxelShape() : normalShape.copy().toVoxelShape();
        });
    }

    public static ShapeFunction sideShape(int thickness) {
        return ShapeFunction.cardinalRotations(new RawVoxelShape(0.0, 0.0, 16 - thickness, 16.0, 16.0, 16.0));
    }

    public static ShapeFunction sixSideShape(int thickness) {
        return ShapeFunction.sixSideShape(new RawVoxelShape(0.0, 0.0, 16 - thickness, 16.0, 16.0, 16.0), new RawVoxelShape(0.0, 0.0, 0.0, 16.0, thickness, 16.0));
    }

    public static ShapeFunction sideOrientedShape(RawVoxelShape northLeftShape) {
        return new ShapeFunction(state -> {
            Direction facing = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            OrientableBlockType direction = (OrientableBlockType)((Object)((Object)state.m_61143_(ModBlockStateProperties.ORIENTABLE_BLOCK_TYPE)));
            RawVoxelShape northRightShape = northLeftShape.copy().mirrorZ();
            RawVoxelShape shape = switch (direction) {
                default -> throw new IncompatibleClassChangeError();
                case OrientableBlockType.LEFT -> northLeftShape.copy();
                case OrientableBlockType.RIGHT -> northRightShape.copy();
            };
            return switch (facing) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.UP, Direction.DOWN -> Shapes.m_83040_();
                case Direction.NORTH -> shape.copy().toVoxelShape();
                case Direction.SOUTH -> shape.copy().rotateY(180.0f).toVoxelShape();
                case Direction.WEST -> shape.copy().rotateY(90.0f).toVoxelShape();
                case Direction.EAST -> shape.copy().rotateY(270.0f).toVoxelShape();
            };
        });
    }

    public static ShapeFunction sixSideShape(RawVoxelShape northShape, RawVoxelShape topShape) {
        return new ShapeFunction(state -> {
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            return switch (facing) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.UP -> topShape.copy().toVoxelShape();
                case Direction.DOWN -> topShape.copy().mirrorY().toVoxelShape();
                case Direction.NORTH -> northShape.copy().toVoxelShape();
                case Direction.SOUTH -> northShape.copy().rotateY(180.0f).toVoxelShape();
                case Direction.WEST -> northShape.copy().rotateY(90.0f).toVoxelShape();
                case Direction.EAST -> northShape.copy().rotateY(270.0f).toVoxelShape();
            };
        });
    }

    public static ShapeFunction orientedSixSideShape(RawVoxelShape northUpShape, RawVoxelShape topNorthShape) {
        return new ShapeFunction(state -> {
            RawVoxelShape shape;
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            Direction direction = (Direction)state.m_61143_((Property)ModBlockStateProperties.ON_FACE_DIRECTION);
            if (facing == Direction.UP || facing == Direction.DOWN) {
                shape = topNorthShape.copy();
                if (facing == Direction.DOWN) {
                    shape = topNorthShape.copy().mirrorY();
                }
                switch (direction) {
                    case NORTH: {
                        shape = shape.copy();
                        break;
                    }
                    case SOUTH: {
                        shape = shape.copy().rotateY(180.0f);
                        break;
                    }
                    case WEST: {
                        shape = shape.copy().rotateY(90.0f);
                        break;
                    }
                    case EAST: {
                        shape = shape.copy().rotateY(270.0f);
                    }
                }
            } else {
                shape = northUpShape.copy();
                if (facing.m_122427_() == direction) {
                    shape = shape.copy().rotateZ(-90.0f);
                } else if (facing.m_122428_() == direction) {
                    shape = shape.copy().rotateZ(90.0f);
                } else if (direction == Direction.DOWN) {
                    shape = shape.copy().mirrorY();
                }
                switch (facing) {
                    case NORTH: {
                        shape = shape.copy();
                        break;
                    }
                    case SOUTH: {
                        shape = shape.copy().rotateY(180.0f);
                        break;
                    }
                    case WEST: {
                        shape = shape.copy().rotateY(90.0f);
                        break;
                    }
                    case EAST: {
                        shape = shape.copy().rotateY(270.0f);
                    }
                }
            }
            return shape.toVoxelShape();
        });
    }

    public static ShapeFunction simpleShape(VoxelShape shape) {
        return new ShapeFunction(state -> shape);
    }

    public static ShapeFunction simpleShape(RawVoxelShape shape) {
        return new ShapeFunction(state -> shape.toVoxelShape());
    }
}

